/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class ConvertPacket {
    private Logger logger = Globals.getLogger();
    Hashtable consumer_to_interest = new Hashtable();
    Hashtable interest_to_consumer = new Hashtable();
    Hashtable consumer_to_deliver = new Hashtable();
    IMQConnection con = null;
    int oldversion = 0;
    int targetVersion = 0;
    static final int OLD_ACK_BLOCK_SIZE = 36;

    public ConvertPacket(IMQConnection iMQConnection, int n, int n2) {
        this.con = iMQConnection;
        this.oldversion = n;
        this.targetVersion = n2;
    }

    public void handleReadPacket(Packet packet) {
        if (this.oldversion == 200) {
            return;
        }
        packet.setVersion(this.targetVersion);
        int n = packet.getPacketType();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.handleDataRead(packet);
                break;
            }
            case 16: {
                this.removeConsumerRequest(packet);
                break;
            }
            case 24: 
            case 32: {
                this.handleAcknowledgeRead(packet);
                break;
            }
            case 42: {
                this.handleDeliverRead(packet);
            }
        }
    }

    public void handleWritePacket(Packet packet) {
        packet.setVersion(this.oldversion);
        if (this.oldversion == 200) {
            return;
        }
        int n = packet.getPacketType();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.handleDataWrite(packet);
                break;
            }
            case 15: {
                this.handleConsumerResponse(packet);
                break;
            }
        }
    }

    private void handleAcknowledgeRead(Packet packet) {
        if (packet.getTransactionID() != 0L) {
            TransactionHandler.convertPacketTid(this.con, packet);
        }
        DataInputStream dataInputStream = new DataInputStream(packet.getMessageBodyStream());
        int n = packet.getMessageBodySize();
        int n2 = n / 36;
        int[] nArray = new int[n2];
        SysMessageID[] sysMessageIDArray = new SysMessageID[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                nArray[i] = dataInputStream.readInt();
                sysMessageIDArray[i] = new SysMessageID();
                sysMessageIDArray[i].readID(dataInputStream);
            }
        }
        catch (IOException iOException) {
            this.logger.log(8, "Internal Error, bad sysmessageid ", iOException);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            for (int i = 0; i < n2; ++i) {
                Long l = (Long)this.interest_to_consumer.get(new Integer(nArray[i]));
                if (l == null) continue;
                dataOutputStream.writeLong(l);
                sysMessageIDArray[i].writeID(dataOutputStream);
            }
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            this.logger.log(8, "Internal Error, unable to convert  old packet ", iOException);
        }
        packet.setMessageBody(byteArrayOutputStream.toByteArray());
    }

    private void handleDataRead(Packet packet) {
        if (packet.getTransactionID() != 0L) {
            TransactionHandler.convertPacketTid(this.con, packet);
        }
    }

    private void handleDataWrite(Packet packet) {
        Long l = new Long(packet.getConsumerID());
        Integer n = (Integer)this.consumer_to_interest.get(l);
        if (n == null && (n = (Integer)this.consumer_to_deliver.get(l)) != null && packet.getIsLast()) {
            this.consumer_to_deliver.remove(l);
        }
        if (n == null) {
            Globals.getLogger().log(4, "Throwing out packet, could not find old consumer id for new id " + l);
            return;
        }
        packet.setConsumerID(n.intValue());
    }

    private void handleConsumerResponse(Packet packet) {
        Hashtable hashtable;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error, bad propertis ", exception);
            return;
        }
        Integer n = (Integer)hashtable.remove("JMQOldConsumerID");
        Long l = (Long)hashtable.get("JMQConsumerID");
        if (l != null && n != null) {
            this.consumer_to_interest.put(l, n);
            this.interest_to_consumer.put(n, l);
        }
    }

    private void handleDeliverRead(Packet packet) {
        Hashtable hashtable;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error, bad propertis ", exception);
            return;
        }
        Integer n = (Integer)hashtable.get("JMQConsumerID");
        if (n != null) {
            ConsumerUID consumerUID = new ConsumerUID();
            Long l = new Long(consumerUID.longValue());
            hashtable.put("JMQConsumerID", l);
            this.consumer_to_deliver.put(l, n);
        }
    }

    private void removeConsumerRequest(Packet packet) {
        Hashtable hashtable;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error, bad propertis ", exception);
            return;
        }
        Integer n = (Integer)hashtable.get("JMQConsumerID");
        if (n != null) {
            Long l = (Long)this.interest_to_consumer.get(n);
            hashtable.put("JMQConsumerID", l);
            this.consumer_to_interest.remove(l);
            this.interest_to_consumer.remove(n);
        }
    }
}

