/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConsumerStateDAOImpl
extends BaseDAOImpl
implements ConsumerStateDAO {
    protected String tableName;
    protected String insertSQL;
    protected String updateTransactionSQL;
    protected String updateStateSQL;
    protected String updateState2SQL;
    protected String clearTxnSQL;
    protected String deleteByTxnSQL;
    protected String deleteByDstSQL;
    protected String deleteByStateSQL;
    protected String deleteByMsgSQL;
    protected String selectStateSQL;
    protected String selectStatesByMsgSQL;
    protected String selectTransactionSQL;
    protected String selectCountByMsgSQL;
    protected String selectConsumerIDsByMsgSQL;
    protected String selectTransactionAcksSQL;
    protected String selectAllTransactionAcksSQL;

    ConsumerStateDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        String string = Globals.getHAEnabled() ? " AND NOT EXISTS (" + ((BrokerDAOImpl)dBManager.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")" : "";
        this.tableName = dBManager.getTableName("MQCONSTATE41");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("MESSAGE_ID").append(", ").append("CONSUMER_ID").append(", ").append("STATE").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ? )").toString();
        this.updateTransactionSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("TRANSACTION_ID").append(" IS NULL").append(string).toString();
        this.updateStateSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.updateState2SQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("STATE").append(" = ?").append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").append(" AND ").append("STATE").append(" = ?").toString();
        this.clearTxnSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("TRANSACTION_ID").append(" = NULL").append(" WHERE ").append("TRANSACTION_ID").append(" = ?").append(string).toString();
        this.deleteByTxnSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.deleteByDstSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" IN ").append("(SELECT msgTbl.").append("ID").append(" FROM ").append(dBManager.getTableName("MQMSG41")).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = ?").append(" AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(" AND ").append("DESTINATION_ID").append(" = ?)").toString();
        this.deleteByMsgSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.deleteByStateSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("STATE").append(" = ?").toString();
        this.selectStateSQL = new StringBuffer(128).append("SELECT ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectStatesByMsgSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("STATE").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectTransactionSQL = new StringBuffer(128).append("SELECT ").append("TRANSACTION_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").append(" AND ").append("CONSUMER_ID").append(" = ?").toString();
        this.selectCountByMsgSQL = new StringBuffer(128).append("SELECT COUNT(*) FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ?").toString();
        this.selectConsumerIDsByMsgSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("MESSAGE_ID").append(" = ? ").append(" AND ").append("STATE").append(" <> ").append(2).toString();
        this.selectTransactionAcksSQL = new StringBuffer(128).append("SELECT ").append("CONSUMER_ID").append(", ").append("MESSAGE_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" = ?").toString();
        this.selectAllTransactionAcksSQL = new StringBuffer(128).append("SELECT ").append("TRANSACTION_ID").append(", ").append("CONSUMER_ID").append(", ").append("MESSAGE_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("TRANSACTION_ID").append(" IS NOT NULL").toString();
    }

    public final String getTableNamePrefix() {
        return "MQCONSTATE41";
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Connection connection, String string, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws BrokerException {
        PreparedStatement preparedStatement;
        block21: {
            String string2 = sysMessageID.getUniqueName();
            int n = 0;
            boolean bl2 = false;
            preparedStatement = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    if (bl) {
                        if (this.getConsumerCount(connection, string2) > 0) {
                            throw new BrokerException(this.br.getKString("B3084", string2));
                        }
                        dBManager.getDAOFactory().getMessageDAO().checkMessage(connection, string, string2);
                    }
                    boolean bl3 = dBManager.supportsBatchUpdates();
                    preparedStatement = connection.prepareStatement(this.insertSQL);
                    int n2 = consumerUIDArray.length;
                    while (n < n2) {
                        preparedStatement.setString(1, string2);
                        preparedStatement.setLong(2, consumerUIDArray[n].longValue());
                        preparedStatement.setInt(3, nArray[n]);
                        preparedStatement.setLong(4, System.currentTimeMillis());
                        if (bl3) {
                            preparedStatement.addBatch();
                        } else {
                            preparedStatement.executeUpdate();
                        }
                        ++n;
                    }
                    if (bl3) {
                        preparedStatement.executeBatch();
                    }
                    if (bl2) {
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (Store.getDEBUG() && n < consumerUIDArray.length) {
                        this.logger.log(4, "Failed to persist interest: " + consumerUIDArray[n].toString() + "(" + consumerUIDArray[n].getUniqueName() + ")");
                    }
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof IOException) {
                        exception2 = DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception);
                        throw new BrokerException(this.br.getKString("B4105", string2), exception2);
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4105", string2), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4105", string2), exception2);
                }
                Object var15_17 = null;
                if (!bl2) break block21;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (bl2) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateState(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n) throws BrokerException {
        PreparedStatement preparedStatement;
        block14: {
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    String string2 = dBManager.getDAOFactory().getMessageDAO().getBroker(connection, destinationUID, string);
                    if (Globals.getHAEnabled() && !dBManager.getBrokerID().equals(string2)) {
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), 405);
                    }
                    preparedStatement = connection.prepareStatement(this.updateStateSQL);
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                    }
                    Object var12_14 = null;
                    if (!bl) break block14;
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.updateStateSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateState(Connection connection, DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, int n2) throws BrokerException {
        PreparedStatement preparedStatement;
        block13: {
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.updateState2SQL);
                    preparedStatement.setInt(1, n);
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    preparedStatement.setInt(4, n2);
                    if (preparedStatement.executeUpdate() == 0) {
                        int n3 = this.getState(connection, sysMessageID, consumerUID);
                        if (n3 == n2) throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                        Object[] objectArray = new String[]{consumerUID.toString(), sysMessageID.toString(), String.valueOf(n2), String.valueOf(n3)};
                        throw new BrokerException(this.br.getKString("B3180", objectArray), 412);
                    }
                    Object var13_15 = null;
                    if (!bl) break block13;
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.updateState2SQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTransaction(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID, TransactionUID transactionUID) throws BrokerException {
        PreparedStatement preparedStatement;
        block18: {
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    dBManager.getDAOFactory().getTransactionDAO().checkTransaction(connection, transactionUID.longValue());
                    preparedStatement = connection.prepareStatement(this.updateTransactionSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    preparedStatement.setString(2, string);
                    preparedStatement.setLong(3, consumerUID.longValue());
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(4, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0) {
                        long l;
                        if (Globals.getHAEnabled()) {
                            String string2 = dBManager.getBrokerID();
                            BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                            if (brokerDAO.isBeingTakenOver(connection, string2)) {
                                StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                                try {
                                    HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string2);
                                    this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                    throw storeBeingTakenOverException;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                throw storeBeingTakenOverException;
                            }
                        }
                        if ((l = this.getTransaction(connection, sysMessageID, consumerUID)) <= 0L) throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                        String string3 = "[" + sysMessageID + "]" + consumerUID;
                        throw new TransactionAckExistException(this.br.getKString("B4056", string3, transactionUID) + " : " + this.br.getKString("B3062", string3, String.valueOf(l)), 409);
                    }
                    Object var14_19 = null;
                    if (!bl) break block18;
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.updateTransactionSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4015", consumerUID.toString(), sysMessageID.toString()), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearTransaction(Connection connection, TransactionUID transactionUID) throws BrokerException {
        PreparedStatement preparedStatement;
        block17: {
            long l = transactionUID.longValue();
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.clearTxnSQL);
                    preparedStatement.setLong(1, l);
                    if (Globals.getHAEnabled()) {
                        preparedStatement.setString(2, dBManager.getBrokerID());
                    }
                    if (preparedStatement.executeUpdate() == 0 && Globals.getHAEnabled()) {
                        String string = dBManager.getBrokerID();
                        BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
                        if (brokerDAO.isBeingTakenOver(connection, string)) {
                            StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(this.br.getKString("B3223"));
                            try {
                                HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string);
                                this.logger.log(32, this.br.getKString("B4117", hABrokerInfo.toString()), storeBeingTakenOverException);
                                throw storeBeingTakenOverException;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw storeBeingTakenOverException;
                        }
                    }
                    Object var13_15 = null;
                    if (!bl) break block17;
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.clearTxnSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4225", transactionUID), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4225", transactionUID), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteByMessageID(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        PreparedStatement preparedStatement;
        block12: {
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByMsgSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.deleteByMsgSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4037", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4037", string), exception2);
                }
                Object var9_6 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteByTransaction(Connection connection, TransactionUID transactionUID) throws BrokerException {
        PreparedStatement preparedStatement;
        block12: {
            long l = transactionUID.longValue();
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByTxnSQL);
                    preparedStatement.setLong(1, l);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.deleteByTxnSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4240", transactionUID), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4240", transactionUID), exception2);
                }
                Object var10_6 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteByDestination(Connection connection, DestinationUID destinationUID) throws BrokerException {
        PreparedStatement preparedStatement;
        block12: {
            String string = destinationUID.toString();
            boolean bl = false;
            preparedStatement = null;
            try {
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.deleteByDstSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    preparedStatement.setString(2, string);
                    preparedStatement.executeUpdate();
                }
                catch (Exception exception) {
                    Exception exception2;
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.deleteByDstSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4227", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4227", string), exception2);
                }
                Object var9_8 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (bl) {
                    Util.close(null, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
            Util.close(null, preparedStatement, connection);
            return;
        }
        Util.close(null, preparedStatement, null);
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            DBManager dBManager = DBManager.getDBManager();
            string = new StringBuffer(128).append("MESSAGE_ID").append(" IN (SELECT msgTbl.").append("ID").append(" FROM ").append(dBManager.getTableName("MQMSG41")).append(" msgTbl, ").append(dBManager.getTableName("MQSES41")).append(" sesTbl").append(" WHERE sesTbl.").append("BROKER_ID").append(" = '").append(dBManager.getBrokerID()).append("' AND sesTbl.").append("ID").append(" = msgTbl.").append("STORE_SESSION_ID").append(")").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getState(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        int n;
        block9: {
            n = -1;
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStateSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) throw new BrokerException(this.br.getKString("B3014", consumerUID.toString(), string), 404);
                    n = resultSet.getInt(1);
                    Object var12_9 = null;
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectStateSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4036", consumerUID.toString(), string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4036", consumerUID.toString(), string), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return n;
        }
        Util.close(resultSet, preparedStatement, null);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getStates(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        HashMap<ConsumerUID, Integer> hashMap;
        block10: {
            hashMap = new HashMap<ConsumerUID, Integer>();
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectStatesByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        int n = resultSet.getInt(2);
                        hashMap.put(consumerUID, n);
                    }
                    Object var11_12 = null;
                    if (!bl) break block10;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectStatesByMsgSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4228", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4228", string), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return hashMap;
        }
        Util.close(resultSet, preparedStatement, null);
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTransaction(Connection connection, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        long l;
        block10: {
            l = -1L;
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTransactionSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.setLong(2, consumerUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectTransactionSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4013", consumerUID.toString()), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4013", consumerUID.toString()), exception2);
                }
                Object var13_9 = null;
                if (!bl) break block10;
            }
            catch (Throwable throwable) {
                Object var13_10 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return l;
        }
        Util.close(resultSet, preparedStatement, null);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getConsumerUIDs(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<ConsumerUID> arrayList;
        block10: {
            arrayList = new ArrayList<ConsumerUID>();
            String string = sysMessageID.getUniqueName();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectConsumerIDsByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        arrayList.add(consumerUID);
                    }
                    Object var11_10 = null;
                    if (!bl) break block10;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectConsumerIDsByMsgSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4228", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4228", string), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getTransactionAcks(Connection connection, TransactionUID transactionUID) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        ArrayList<TransactionAcknowledgement> arrayList;
        block12: {
            arrayList = new ArrayList<TransactionAcknowledgement>();
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectTransactionAcksSQL);
                    preparedStatement.setLong(1, transactionUID.longValue());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        ConsumerUID consumerUID = new ConsumerUID(resultSet.getLong(1));
                        try {
                            SysMessageID sysMessageID = SysMessageID.get(resultSet.getString(2));
                            arrayList.add(new TransactionAcknowledgement(sysMessageID, consumerUID, consumerUID));
                        }
                        catch (Exception exception) {
                            this.logger.logStack(32, "B4129", transactionUID, (Throwable)exception);
                        }
                    }
                    Object var10_12 = null;
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectTransactionAcksSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4229", transactionUID), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4229", transactionUID), exception2);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return arrayList;
        }
        Util.close(resultSet, preparedStatement, null);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap getAllTransactionAcks(Connection connection) throws BrokerException {
        List list;
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, Object> hashMap;
        block15: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block13: {
                hashMap = new HashMap<Object, Object>(100);
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    try {
                        if (connection == null) {
                            connection = DBManager.getDBManager().getConnection(true);
                            bl = true;
                        }
                        preparedStatement = connection.prepareStatement(this.selectAllTransactionAcksSQL);
                        resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            object3 = new TransactionUID(resultSet.getLong(1));
                            object2 = new ConsumerUID(resultSet.getLong(2));
                            try {
                                object = SysMessageID.get(resultSet.getString(3));
                                list = (ArrayList<TransactionAcknowledgement>)hashMap.get(object3);
                                if (list == null) {
                                    list = new ArrayList<TransactionAcknowledgement>(25);
                                    hashMap.put(object3, list);
                                }
                                list.add(new TransactionAcknowledgement((SysMessageID)object, (ConsumerUID)object2, (ConsumerUID)object2));
                            }
                            catch (Exception exception) {
                                this.logger.logStack(32, "B4129", object3, (Throwable)exception);
                            }
                        }
                        Object var11_13 = null;
                        if (!bl) break block13;
                    }
                    catch (Exception exception) {
                        Exception exception2;
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        if (exception instanceof SQLException) {
                            exception2 = DBManager.wrapSQLException("[" + this.selectAllTransactionAcksSQL + "]", (SQLException)exception);
                            throw new BrokerException(this.br.getKString("B4054"), exception2);
                        }
                        exception2 = exception;
                        throw new BrokerException(this.br.getKString("B4054"), exception2);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection);
                        throw throwable;
                    }
                    Util.close(resultSet, preparedStatement, null);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, connection);
                break block15;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        object3 = hashMap.keySet();
        if (object3.isEmpty()) return hashMap;
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (TransactionUID)object2.next();
            list = (List)hashMap.get(object);
            hashMap.put(object, list.toArray(new TransactionAcknowledgement[0]));
        }
        return hashMap;
    }

    public HashMap getDebugInfo(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = -1;
        try {
            n = this.getRowCount(null, null);
        }
        catch (Exception exception) {
            this.logger.log(32, exception.getMessage(), exception.getCause());
        }
        hashMap.put("Message/Consumer states(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getConsumerCount(Connection connection, String string) throws BrokerException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        int n;
        block10: {
            n = -1;
            boolean bl = false;
            preparedStatement = null;
            resultSet = null;
            try {
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByMsgSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
                catch (Exception exception) {
                    Exception exception2;
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    if (exception instanceof SQLException) {
                        exception2 = DBManager.wrapSQLException("[" + this.selectCountByMsgSQL + "]", (SQLException)exception);
                        throw new BrokerException(this.br.getKString("B4228", string), exception2);
                    }
                    exception2 = exception;
                    throw new BrokerException(this.br.getKString("B4228", string), exception2);
                }
                Object var10_7 = null;
                if (!bl) break block10;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    throw throwable;
                }
                Util.close(resultSet, preparedStatement, null);
                throw throwable;
            }
            Util.close(resultSet, preparedStatement, connection);
            return n;
        }
        Util.close(resultSet, preparedStatement, null);
        return n;
    }
}

