/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.client.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.handlers.BasicAuthenticationHandler;
import com.sun.messaging.jmq.auth.handlers.DigestAuthenticationHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.security.auth.login.LoginException;

public class MQAuthenticator {
    private static boolean DEBUG = false;
    private String serviceName = null;
    private int serviceType;
    private String serviceTypeStr = null;
    private Hashtable handlers = new Hashtable();
    private AuthCacheData authCacheData = new AuthCacheData();
    private AccessController ac = null;
    public static final String CMDUSER_PROPERTY = "imq.imqcmd.user";
    public static final String CMDUSER_PWD_PROPERTY = "imq.imqcmd.password";
    public static final String CMDUSER_SVC_PROPERTY = "imq.imqcmd.service";

    public MQAuthenticator(String string, int n) throws BrokerException {
        this.serviceName = string;
        this.serviceType = n;
        this.serviceTypeStr = ServiceType.getServiceTypeString(n);
        this.ac = AccessController.getInstance(string, n);
    }

    public void authenticate(String string, String string2) throws BrokerException, LoginException, AccessControlException {
        this.authenticate(string, string2, true);
    }

    public void authenticate(String string, String string2, boolean bl) throws BrokerException, LoginException, AccessControlException {
        String string3 = this.ac.getAuthType();
        AuthenticationProtocolHandler authenticationProtocolHandler = this.getClientAuthHandler(string3);
        if (!authenticationProtocolHandler.getType().equals(string3)) {
            Object[] objectArray = new String[]{string3, authenticationProtocolHandler.getType(), authenticationProtocolHandler.getClass().getName()};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4078", objectArray));
        }
        authenticationProtocolHandler.init(string, string2, null);
        int n = 0;
        byte[] byArray = this.ac.getChallenge(n, new Properties(), this.getAuthCacheData().getCacheData(), null);
        while ((byArray = this.ac.handleResponse(authenticationProtocolHandler.handleRequest(byArray, n++), n)) != null) {
        }
        this.authCacheData.setCacheData(this.ac.getCacheData());
        this.ac.checkConnectionPermission(this.serviceName, this.serviceTypeStr);
        if (bl) {
            this.ac.logout();
        }
    }

    public void logout() {
        if (this.ac != null) {
            this.ac.logout();
        }
    }

    public AuthCacheData getAuthCacheData() {
        return this.authCacheData;
    }

    public AccessController getAccessController() {
        return this.ac;
    }

    private AuthenticationProtocolHandler getClientAuthHandler(String string) throws BrokerException {
        AuthenticationProtocolHandler authenticationProtocolHandler = (AuthenticationProtocolHandler)this.handlers.get(string);
        if (authenticationProtocolHandler != null) {
            return authenticationProtocolHandler;
        }
        if (string.equals("basic")) {
            authenticationProtocolHandler = new BasicAuthenticationHandler();
            this.handlers.put(string, authenticationProtocolHandler);
        } else if (string.equals("digest")) {
            authenticationProtocolHandler = new DigestAuthenticationHandler();
            this.handlers.put(string, authenticationProtocolHandler);
        } else {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4040", string));
        }
        return authenticationProtocolHandler;
    }

    public static boolean authenticateCMDUserIfset() {
        List list;
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = brokerConfig.getProperty(CMDUSER_PROPERTY);
        if (string == null) {
            return true;
        }
        Logger logger = Globals.getLogger();
        BrokerResources brokerResources = Globals.getBrokerResources();
        if (string.trim().length() == 0) {
            logger.log(64, "B4027", "imq.imqcmd.user=" + string);
            return false;
        }
        String string2 = brokerConfig.getProperty(CMDUSER_PWD_PROPERTY);
        if (string2 == null) {
            logger.log(64, "B4066", "imq.imqcmd.user=" + string);
            return false;
        }
        String string3 = brokerConfig.getProperty(CMDUSER_SVC_PROPERTY);
        if (string3 == null) {
            string3 = "admin";
        }
        if ((list = ServiceManager.getAllActiveServiceNames()) == null || !list.contains(string3)) {
            logger.log(64, "B3214", (Object)string3, "imq.imqcmd.user=" + string);
            return false;
        }
        String string4 = ServiceManager.getServiceTypeString(string3);
        if (string4 == null || ServiceType.getServiceType(string4) != 1) {
            Object[] objectArray = new String[]{string3, string4, "imq.imqcmd.user=" + string};
            logger.log(64, "B3215", objectArray);
            return false;
        }
        try {
            MQAuthenticator mQAuthenticator = new MQAuthenticator(string3, 1);
            mQAuthenticator.authenticate(string, string2);
            if (DEBUG) {
                logger.log(64, "B1243", (Object)("imq.imqcmd.user=" + string), string3);
            }
            return true;
        }
        catch (Exception exception) {
            if (DEBUG) {
                logger.logStack(64, "B2000", string, string3, exception);
            } else {
                logger.log(64, "B2000", (Object)string, string3);
            }
            return false;
        }
    }
}

