/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.osgiweb.OSGiDeploymentContextImpl;
import org.glassfish.osgiweb.OSGiWebContainer;
import org.glassfish.server.ServerEnvironmentImpl;

public class JavaEEUndeploymentRequest {
    private static final Logger logger = Logger.getLogger(JavaEEUndeploymentRequest.class.getPackage().getName());
    private Deployment deployer;
    private ServerEnvironmentImpl env;
    private ActionReport reporter;
    private OSGiWebContainer.OSGiApplicationInfo osgiAppInfo;
    private OSGiDeploymentContextImpl dc;

    public JavaEEUndeploymentRequest(Deployment deployer, ServerEnvironmentImpl env, ActionReport reporter, OSGiWebContainer.OSGiApplicationInfo osgiAppInfo) {
        this.deployer = deployer;
        this.env = env;
        this.reporter = reporter;
        this.osgiAppInfo = osgiAppInfo;
    }

    public void execute() {
        try {
            this.dc = new OSGiDeploymentContextImpl(this.reporter, logger, this.osgiAppInfo.appInfo.getSource(), (OpsParams)this.getUndeployParams(this.osgiAppInfo), (ServerEnvironment)this.env, this.osgiAppInfo.bundle);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.deployer.undeploy(this.osgiAppInfo.appInfo.getName(), (ExtendedDeploymentContext)this.dc);
        if (!this.osgiAppInfo.isDirectoryDeployment) {
            this.cleanup(this.dc.getSourceDir());
        }
        logger.logp(Level.INFO, "JavaEEUndeploymentRequest", "undeploy", "Undeployed bundle {0} from {1}", new Object[]{this.osgiAppInfo.bundle, this.dc.getSource().getURI()});
    }

    private void cleanup(File dir) {
        assert (dir.isDirectory() && dir.exists());
        FileUtils.whack((File)dir);
        logger.logp(Level.INFO, "JavaEEUndeploymentRequest", "cleanup", "Deleted {0}", new Object[]{dir});
    }

    private UndeployCommandParameters getUndeployParams(OSGiWebContainer.OSGiApplicationInfo osgiAppInfo) {
        UndeployCommandParameters parameters = new UndeployCommandParameters();
        parameters.name = osgiAppInfo.appInfo.getName();
        parameters.origin = OpsParams.Origin.undeploy;
        return parameters;
    }
}

