/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.activation;

import com.sun.corba.ee.impl.activation.CommandHandler;
import com.sun.corba.ee.impl.activation.ServerTool;
import com.sun.corba.ee.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.ee.spi.activation.EndPointInfo;
import com.sun.corba.ee.spi.activation.InvalidORBid;
import com.sun.corba.ee.spi.activation.Locator;
import com.sun.corba.ee.spi.activation.LocatorHelper;
import com.sun.corba.ee.spi.activation.LocatorPackage.ServerLocationPerORB;
import com.sun.corba.ee.spi.activation.ServerHeldDown;
import com.sun.corba.ee.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;

class LocateServerForORB
implements CommandHandler {
    static final int illegalServerId = -1;

    LocateServerForORB() {
    }

    @Override
    public String getCommandName() {
        return "locateperorb";
    }

    @Override
    public void printCommandHelp(PrintStream out, boolean helpType) {
        if (!helpType) {
            out.println(CorbaResourceUtil.getText("servertool.locateorb"));
        } else {
            out.println(CorbaResourceUtil.getText("servertool.locateorb1"));
        }
    }

    @Override
    public boolean processCommand(String[] cmdArgs, ORB orb, PrintStream out) {
        int serverId = -1;
        String orbId = "";
        try {
            int i = 0;
            while (i < cmdArgs.length) {
                String arg;
                if ((arg = cmdArgs[i++]).equals("-serverid")) {
                    if (i < cmdArgs.length) {
                        serverId = Integer.valueOf(cmdArgs[i++]);
                        continue;
                    }
                    return true;
                }
                if (arg.equals("-applicationName")) {
                    if (i < cmdArgs.length) {
                        serverId = ServerTool.getServerIdForAlias(orb, cmdArgs[i++]);
                        continue;
                    }
                    return true;
                }
                if (!arg.equals("-orbid") || i >= cmdArgs.length) continue;
                orbId = cmdArgs[i++];
            }
            if (serverId == -1) {
                return true;
            }
            Locator locator = LocatorHelper.narrow(orb.resolve_initial_references("ServerLocator"));
            ServerLocationPerORB location = locator.locateServerForORB(serverId, orbId);
            out.println(CorbaResourceUtil.getText("servertool.locateorb2", location.hostname));
            for (EndPointInfo Port : location.ports) {
                out.println("\t\t" + Port.port + "\t\t" + Port.endpointType + "\t\t" + orbId);
            }
        }
        catch (InvalidORBid ex) {
            out.println(CorbaResourceUtil.getText("servertool.nosuchorb"));
        }
        catch (ServerHeldDown ex) {
            out.println(CorbaResourceUtil.getText("servertool.helddown"));
        }
        catch (ServerNotRegistered ex) {
            out.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

