/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.ThreadPool;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-threadpool")
@Scoped(value=PerLookup.class)
@I18n(value="create.threadpool")
public class CreateThreadpool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateThreadpool.class);
    @Param(name="maxthreadpoolsize", optional=true)
    String maxthreadpoolsize;
    @Param(name="minthreadpoolsize", optional=true)
    String minthreadpoolsize;
    @Param(name="idletimeout", optional=true)
    String idletimeout;
    @Param(name="workqueues", optional=true)
    String workqueues;
    @Param(name="maxqueuesize", optional=true)
    String maxQueueSize;
    @Param(optional=true)
    String target = "server";
    @Param(name="threadpool_id", primary=true)
    String threadpool_id;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        ThreadPools threadPools = config.getThreadPools();
        for (ThreadPool pool : threadPools.getThreadPool()) {
            if (!pool.getName().equals(this.threadpool_id)) continue;
            report.setMessage(localStrings.getLocalString("create.threadpool.duplicate", "Thread Pool named {0} already exists.", new Object[]{this.threadpool_id}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.workqueues != null) {
            report.setMessage(localStrings.getLocalString("create.threadpool.deprecated.workqueues", "Deprecated Syntax: --workqueues option is deprecated for create-threadpool command."));
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<ThreadPools>(){

                @Override
                public Object run(ThreadPools param) throws PropertyVetoException, TransactionFailure {
                    ThreadPool newPool = (ThreadPool)param.createChild(ThreadPool.class);
                    newPool.setName(CreateThreadpool.this.threadpool_id);
                    newPool.setMaxThreadPoolSize(CreateThreadpool.this.maxthreadpoolsize);
                    newPool.setMinThreadPoolSize(CreateThreadpool.this.minthreadpoolsize);
                    newPool.setMaxQueueSize(CreateThreadpool.this.maxQueueSize);
                    newPool.setIdleThreadTimeoutSeconds(CreateThreadpool.this.idletimeout);
                    param.getThreadPool().add(newPool);
                    return newPool;
                }
            }, threadPools);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            String str = e.getMessage();
            String def = "Creation of: " + this.threadpool_id + "failed because of: " + str;
            String msg = localStrings.getLocalString("create.threadpool.failed", def, new Object[]{this.threadpool_id, str});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }
}

