/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.proxy;

import com.sun.enterprise.admin.util.proxy.Call;
import com.sun.enterprise.admin.util.proxy.CallStack;
import com.sun.enterprise.admin.util.proxy.CallState;
import com.sun.enterprise.admin.util.proxy.Interceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyClass
implements InvocationHandler {
    private static InheritableThreadLocal callStackHolder = new InheritableThreadLocal(){

        protected synchronized Object initialValue() {
            return new CallStack();
        }
    };
    private static Logger _logger = ProxyClass.getLogger();
    private Object delegate;
    private Interceptor interceptor;

    public ProxyClass(Object handler, Interceptor interceptor) {
        this.delegate = handler;
        this.interceptor = interceptor;
    }

    /*
     * Loose catch block
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        CallStack callStack;
        block14: {
            Throwable failReason;
            boolean success;
            Call call;
            block13: {
                call = new Call(method, args);
                callStack = (CallStack)callStackHolder.get();
                callStack.beginCall(call);
                try {
                    this.interceptor.preInvoke(callStack);
                }
                catch (Throwable t) {
                    _logger.log(Level.FINE, "core.interceptor_preinvoke_fail", t.getMessage());
                    _logger.log(Level.FINEST, "core.interceptor_preinvoke_exception", t);
                }
                result = null;
                success = true;
                failReason = null;
                result = method.invoke(this.delegate, args);
                Object var11_10 = null;
                if (!success) {
                    call.setState(CallState.FAILED);
                    call.setFailureReason(failReason);
                }
                call.setResult(result);
                if (call.getState().isFailed()) break block13;
                call.setState(CallState.SUCCESS);
            }
            try {
                this.interceptor.postInvoke(callStack);
                break block14;
            }
            catch (Throwable t) {
                _logger.log(Level.FINE, "core.interceptor_postinvoke_fail", t.getMessage());
                _logger.log(Level.FINEST, "core.interceptor_postinvoke_exception", t);
            }
            {
                break block14;
                catch (InvocationTargetException ite) {
                    success = false;
                    failReason = ite.getTargetException();
                    throw failReason;
                }
                catch (Throwable t) {
                    success = false;
                    failReason = t;
                    throw failReason;
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (!success) {
                    call.setState(CallState.FAILED);
                    call.setFailureReason(failReason);
                }
                call.setResult(result);
                if (!call.getState().isFailed()) {
                    call.setState(CallState.SUCCESS);
                }
                try {
                    this.interceptor.postInvoke(callStack);
                }
                catch (Throwable t) {
                    _logger.log(Level.FINE, "core.interceptor_postinvoke_fail", t.getMessage());
                    _logger.log(Level.FINEST, "core.interceptor_postinvoke_exception", t);
                }
                callStack.endCall();
                throw throwable;
            }
        }
        callStack.endCall();
        return result;
    }

    private static Logger getLogger() {
        String loggerName = System.getProperty("com.sun.aas.admin.logger.name");
        if (loggerName == null) {
            loggerName = "global";
        }
        return Logger.getLogger(loggerName);
    }
}

