/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.validator.engine.GlobalExecutionContext;
import org.hibernate.validator.engine.LocalExecutionContext;
import org.hibernate.validator.engine.NodeImpl;
import org.hibernate.validator.engine.PathImpl;
import org.hibernate.validator.engine.groups.Group;
import org.hibernate.validator.engine.groups.GroupChain;
import org.hibernate.validator.engine.groups.GroupChainGenerator;
import org.hibernate.validator.engine.resolver.SingleThreadCachedTraversableResolver;
import org.hibernate.validator.jtype.TypeUtils;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.BeanMetaDataImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorImpl
implements Validator {
    private static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private final transient GroupChainGenerator groupChainGenerator;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    private final MessageInterpolator messageInterpolator;
    private final TraversableResolver traversableResolver;
    private final ConstraintHelper constraintHelper;
    private final BeanMetaDataCache beanMetaDataCache;

    public ValidatorImpl(ConstraintValidatorFactory constraintValidatorFactory, MessageInterpolator messageInterpolator, TraversableResolver traversableResolver, ConstraintHelper constraintHelper, BeanMetaDataCache beanMetaDataCache) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.messageInterpolator = messageInterpolator;
        this.traversableResolver = traversableResolver;
        this.constraintHelper = constraintHelper;
        this.beanMetaDataCache = beanMetaDataCache;
        this.groupChainGenerator = new GroupChainGenerator();
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validation of a null object");
        }
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        GlobalExecutionContext<T> context = GlobalExecutionContext.getContextForValidate(object, this.messageInterpolator, this.constraintValidatorFactory, this.getCachingTraversableResolver());
        List<ConstraintViolation<T>> list = this.validateInContext(object, context, groupChain, null);
        return new HashSet<ConstraintViolation<T>>(list);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("Validated object cannot be null.");
        }
        this.sanityCheckPropertyPath(propertyName);
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ArrayList<ConstraintViolation<T>> failingConstraintViolations = new ArrayList<ConstraintViolation<T>>();
        this.validateProperty(object, PathImpl.createPathFromString(propertyName), failingConstraintViolations, groupChain);
        return new HashSet<ConstraintViolation<T>>(failingConstraintViolations);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        if (beanType == null) {
            throw new IllegalArgumentException("The bean type cannot be null.");
        }
        this.sanityCheckPropertyPath(propertyName);
        GroupChain groupChain = this.determineGroupExecutionOrder(groups);
        ArrayList<ConstraintViolation<T>> failingConstraintViolations = new ArrayList<ConstraintViolation<T>>();
        this.validateValue(beanType, value, PathImpl.createPathFromString(propertyName), failingConstraintViolations, groupChain);
        return new HashSet<ConstraintViolation<T>>(failingConstraintViolations);
    }

    @Override
    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.getBeanMetaData(clazz).getBeanDescriptor();
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        throw new ValidationException("Type " + type + " not supported");
    }

    private void sanityCheckPropertyPath(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("Invalid property path.");
        }
    }

    private GroupChain determineGroupExecutionOrder(Class<?>[] groups) {
        if (groups == null) {
            throw new IllegalArgumentException("null passed as group name");
        }
        if (groups.length == 0) {
            groups = DEFAULT_GROUP_ARRAY;
        }
        return this.groupChainGenerator.getGroupChainFor(Arrays.asList(groups));
    }

    private <T, U, V> List<ConstraintViolation<T>> validateInContext(U value, GlobalExecutionContext<T> context, GroupChain groupChain, PathImpl path) {
        Group group;
        if (value == null) {
            return Collections.emptyList();
        }
        path = PathImpl.createShallowCopy(path);
        LocalExecutionContext localExecutionContext = LocalExecutionContext.getLocalExecutionContext(value);
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(localExecutionContext.getCurrentBeanType());
        if (beanMetaData.defaultGroupSequenceIsRedefined()) {
            groupChain.assertDefaultGroupSequenceIsExpandable(beanMetaData.getDefaultGroupSequence());
        }
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            localExecutionContext.setCurrentGroup(group.getGroup());
            this.validateConstraintsForCurrentGroup(context, localExecutionContext, path);
        }
        groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            group = groupIterator.next();
            localExecutionContext.setCurrentGroup(group.getGroup());
            this.validateCascadedConstraints(context, localExecutionContext, path);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block2: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            for (Group group2 : sequence) {
                int numberOfViolations = context.getFailingConstraints().size();
                localExecutionContext.setCurrentGroup(group2.getGroup());
                this.validateConstraintsForCurrentGroup(context, localExecutionContext, path);
                this.validateCascadedConstraints(context, localExecutionContext, path);
                if (context.getFailingConstraints().size() <= numberOfViolations) continue;
                continue block2;
            }
        }
        return context.getFailingConstraints();
    }

    private <T, U, V> void validateConstraintsForCurrentGroup(GlobalExecutionContext<T> globalExecutionContext, LocalExecutionContext<U, V> localExecutionContext, PathImpl path) {
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(localExecutionContext.getCurrentBeanType());
        boolean validatingDefault = localExecutionContext.validatingDefault();
        boolean validatedBeanRedefinesDefault = beanMetaData.defaultGroupSequenceIsRedefined();
        if (!validatingDefault) {
            this.validateConstraintsForNonDefaultGroup(globalExecutionContext, localExecutionContext, path);
            return;
        }
        if (validatedBeanRedefinesDefault) {
            this.validateConstraintsForRedefinedDefaultGroupOnMainEntity(globalExecutionContext, localExecutionContext, path, beanMetaData);
        } else {
            this.validateConstraintsForRedefinedDefaultGroup(globalExecutionContext, localExecutionContext, path, beanMetaData);
        }
    }

    private <T, U, V> void validateConstraintsForRedefinedDefaultGroup(GlobalExecutionContext<T> globalExecutionContext, LocalExecutionContext<U, V> localExecutionContext, PathImpl path, BeanMetaData<U> beanMetaData) {
        block0: for (Map.Entry<Class<?>, List<MetaConstraint<U, Annotation>>> entry : beanMetaData.getMetaConstraintsAsMap().entrySet()) {
            Class<?> hostingBeanClass = entry.getKey();
            List<MetaConstraint<U, Annotation>> constraints = entry.getValue();
            List<Class<?>> defaultGroupSequence = this.getBeanMetaData(hostingBeanClass).getDefaultGroupSequence();
            for (Class<?> defaultSequenceMember : defaultGroupSequence) {
                localExecutionContext.setCurrentGroup(defaultSequenceMember);
                boolean validationSuccessful = true;
                for (MetaConstraint<U, Annotation> metaConstraint : constraints) {
                    boolean tmp = this.validateConstraint(globalExecutionContext, localExecutionContext, metaConstraint, path);
                    validationSuccessful = validationSuccessful && tmp;
                }
                if (validationSuccessful) continue;
                continue block0;
            }
        }
    }

    private <T, U, V> void validateConstraintsForRedefinedDefaultGroupOnMainEntity(GlobalExecutionContext<T> globalExecutionContext, LocalExecutionContext<U, V> localExecutionContext, PathImpl path, BeanMetaData<U> beanMetaData) {
        List<Class<?>> defaultGroupSequence = beanMetaData.getDefaultGroupSequence();
        for (Class<?> defaultSequenceMember : defaultGroupSequence) {
            localExecutionContext.setCurrentGroup(defaultSequenceMember);
            boolean validationSuccessful = true;
            for (MetaConstraint<U, Annotation> metaConstraint : beanMetaData.getMetaConstraintsAsList()) {
                boolean tmp = this.validateConstraint(globalExecutionContext, localExecutionContext, metaConstraint, path);
                validationSuccessful = validationSuccessful && tmp;
            }
            if (validationSuccessful) continue;
            break;
        }
    }

    private <T, U, V> void validateConstraintsForNonDefaultGroup(GlobalExecutionContext<T> globalExecutionContext, LocalExecutionContext<U, V> localExecutionContext, PathImpl path) {
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(localExecutionContext.getCurrentBeanType());
        for (MetaConstraint<U, Annotation> metaConstraint : beanMetaData.getMetaConstraintsAsList()) {
            this.validateConstraint(globalExecutionContext, localExecutionContext, metaConstraint, path);
        }
    }

    private <T, U, V> boolean validateConstraint(GlobalExecutionContext<T> globalExecutionContext, LocalExecutionContext<U, V> localExecutionContext, MetaConstraint<U, ?> metaConstraint, PathImpl path) {
        PathImpl newPath;
        boolean validationSuccessful = true;
        if (path == null) {
            newPath = PathImpl.createNewPath(metaConstraint.getPropertyName());
        } else {
            newPath = PathImpl.createShallowCopy(path);
            if (metaConstraint.getElementType() != ElementType.TYPE) {
                newPath.addNode(new NodeImpl(metaConstraint.getPropertyName()));
            }
        }
        localExecutionContext.setPropertyPath(newPath);
        if (this.isValidationRequired(globalExecutionContext, localExecutionContext, metaConstraint)) {
            Object valueToValidate = metaConstraint.getValue(localExecutionContext.getCurrentBean());
            localExecutionContext.setCurrentValidatedValue(valueToValidate);
            validationSuccessful = metaConstraint.validateConstraint(globalExecutionContext, localExecutionContext);
        }
        globalExecutionContext.markProcessed(localExecutionContext.getCurrentBean(), localExecutionContext.getCurrentGroup(), localExecutionContext.getPropertyPath());
        return validationSuccessful;
    }

    private <T, U, V> void validateCascadedConstraints(GlobalExecutionContext<T> globalExecutionContext, LocalExecutionContext<U, V> localExecutionContext, PathImpl path) {
        List<Member> cascadedMembers = this.getBeanMetaData(localExecutionContext.getCurrentBeanType()).getCascadedMembers();
        for (Member member : cascadedMembers) {
            Object value;
            PathImpl newPath;
            Type type = ReflectionHelper.typeOf(member);
            if (path == null) {
                newPath = PathImpl.createNewPath(ReflectionHelper.getPropertyName(member));
            } else {
                newPath = PathImpl.createShallowCopy(path);
                newPath.addNode(new NodeImpl(ReflectionHelper.getPropertyName(member)));
            }
            localExecutionContext.setPropertyPath(newPath);
            if (!this.isCascadeRequired(globalExecutionContext, localExecutionContext, member) || (value = ReflectionHelper.getValue(member, localExecutionContext.getCurrentBean())) == null) continue;
            Iterator<?> iter = this.createIteratorForCascadedValue(localExecutionContext, type, value);
            boolean isIndexable = this.isIndexable(type);
            this.validateCascadedConstraint(globalExecutionContext, iter, isIndexable, localExecutionContext.getCurrentGroup(), localExecutionContext.getPropertyPath());
        }
    }

    private <U, V> Iterator<?> createIteratorForCascadedValue(LocalExecutionContext<U, V> context, Type type, Object value) {
        Iterator<Object> iter;
        if (ReflectionHelper.isIterable(type)) {
            iter = ((Iterable)value).iterator();
            context.markCurrentPropertyAsIterable();
        } else if (ReflectionHelper.isMap(type)) {
            Map map = (Map)value;
            iter = map.entrySet().iterator();
            context.markCurrentPropertyAsIterable();
        } else if (TypeUtils.isArray(type)) {
            List<Object> arrayList = Arrays.asList((Object[])value);
            iter = arrayList.iterator();
            context.markCurrentPropertyAsIterable();
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            iter = list.iterator();
        }
        return iter;
    }

    private boolean isIndexable(Type type) {
        boolean isIndexable = false;
        if (ReflectionHelper.isList(type)) {
            isIndexable = true;
        } else if (ReflectionHelper.isMap(type)) {
            isIndexable = true;
        } else if (TypeUtils.isArray(type)) {
            isIndexable = true;
        }
        return isIndexable;
    }

    private <T> void validateCascadedConstraint(GlobalExecutionContext<T> context, Iterator<?> iter, boolean isIndexable, Class<?> currentGroup, PathImpl currentPath) {
        int i = 0;
        while (iter.hasNext()) {
            Object value = iter.next();
            Integer index = i;
            if (value instanceof Map.Entry) {
                Object mapKey = ((Map.Entry)value).getKey();
                value = ((Map.Entry)value).getValue();
                currentPath.getLeafNode().setKey(mapKey);
            } else if (isIndexable) {
                currentPath.getLeafNode().setIndex(index);
            }
            if (!context.isAlreadyValidated(value, currentGroup, currentPath)) {
                GroupChain groupChain = this.groupChainGenerator.getGroupChainFor(Arrays.asList(currentGroup));
                this.validateInContext(value, context, groupChain, currentPath);
            }
            ++i;
        }
    }

    private <T> void validateProperty(T object, PathImpl propertyPath, List<ConstraintViolation<T>> failingConstraintViolations, GroupChain groupChain) {
        Class<?> beanType = object.getClass();
        HashSet metaConstraints = new HashSet();
        Object hostingBeanInstance = this.collectMetaConstraintsForPath(beanType, object, propertyPath.iterator(), metaConstraints);
        if (hostingBeanInstance == null) {
            throw new IllegalArgumentException("Invalid property path.");
        }
        if (metaConstraints.size() == 0) {
            return;
        }
        TraversableResolver cachedResolver = this.getCachingTraversableResolver();
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            this.validatePropertyForGroup(object, propertyPath, failingConstraintViolations, metaConstraints, hostingBeanInstance, group, cachedResolver);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            int numberOfConstraintViolationsBefore = failingConstraintViolations.size();
            for (Group group : sequence) {
                this.validatePropertyForGroup(object, propertyPath, failingConstraintViolations, metaConstraints, hostingBeanInstance, group, cachedResolver);
                if (failingConstraintViolations.size() <= numberOfConstraintViolationsBefore) continue;
                continue block1;
            }
        }
    }

    private <T, U, V> void validatePropertyForGroup(T object, PathImpl path, List<ConstraintViolation<T>> failingConstraintViolations, Set<MetaConstraint<T, ?>> metaConstraints, U hostingBeanInstance, Group group, TraversableResolver cachedTraversableResolver) {
        List<Class<?>> groupList;
        int numberOfConstraintViolationsBefore = failingConstraintViolations.size();
        BeanMetaData<T> beanMetaData = this.getBeanMetaData(metaConstraints.iterator().next().getBeanClass());
        if (group.isDefaultGroup()) {
            groupList = beanMetaData.getDefaultGroupSequence();
        } else {
            groupList = new ArrayList();
            groupList.add(group.getGroup());
        }
        for (Class<?> groupClass : groupList) {
            for (MetaConstraint<T, ?> metaConstraint : metaConstraints) {
                GlobalExecutionContext<T> context = GlobalExecutionContext.getContextForValidateProperty(object, this.messageInterpolator, this.constraintValidatorFactory, cachedTraversableResolver);
                LocalExecutionContext<U, Object> localContext = LocalExecutionContext.getLocalExecutionContext(hostingBeanInstance);
                localContext.setPropertyPath(path);
                localContext.setCurrentGroup(groupClass);
                if (!this.isValidationRequired(context, localContext, metaConstraint)) continue;
                Object valueToValidate = metaConstraint.getValue(localContext.getCurrentBean());
                localContext.setCurrentValidatedValue(valueToValidate);
                metaConstraint.validateConstraint(context, localContext);
                failingConstraintViolations.addAll(context.getFailingConstraints());
            }
            if (failingConstraintViolations.size() <= numberOfConstraintViolationsBefore) continue;
            break;
        }
    }

    private <T> void validateValue(Class<T> beanType, Object value, PathImpl propertyPath, List<ConstraintViolation<T>> failingConstraintViolations, GroupChain groupChain) {
        HashSet metaConstraints = new HashSet();
        this.collectMetaConstraintsForPath(beanType, null, propertyPath.iterator(), metaConstraints);
        if (metaConstraints.size() == 0) {
            return;
        }
        TraversableResolver cachedTraversableResolver = this.getCachingTraversableResolver();
        Iterator<Group> groupIterator = groupChain.getGroupIterator();
        while (groupIterator.hasNext()) {
            Group group = groupIterator.next();
            this.validateValueForGroup(beanType, value, propertyPath, failingConstraintViolations, metaConstraints, group, cachedTraversableResolver);
        }
        Iterator<List<Group>> sequenceIterator = groupChain.getSequenceIterator();
        block1: while (sequenceIterator.hasNext()) {
            List<Group> sequence = sequenceIterator.next();
            int numberOfConstraintViolations = failingConstraintViolations.size();
            for (Group group : sequence) {
                this.validateValueForGroup(beanType, value, propertyPath, failingConstraintViolations, metaConstraints, group, cachedTraversableResolver);
                if (failingConstraintViolations.size() <= numberOfConstraintViolations) continue;
                continue block1;
            }
        }
    }

    private <U, V> void validateValueForGroup(Class<U> beanType, V value, PathImpl path, List<ConstraintViolation<U>> failingConstraintViolations, Set<MetaConstraint<U, ?>> metaConstraints, Group group, TraversableResolver cachedTraversableResolver) {
        List<Class<?>> groupList;
        int numberOfConstraintViolations = failingConstraintViolations.size();
        BeanMetaData<U> beanMetaData = this.getBeanMetaData(metaConstraints.iterator().next().getBeanClass());
        if (group.isDefaultGroup()) {
            groupList = beanMetaData.getDefaultGroupSequence();
        } else {
            groupList = new ArrayList();
            groupList.add(group.getGroup());
        }
        for (Class<?> groupClass : groupList) {
            for (MetaConstraint<U, ?> metaConstraint : metaConstraints) {
                GlobalExecutionContext<U> context = GlobalExecutionContext.getContextForValidateValue(beanType, this.messageInterpolator, this.constraintValidatorFactory, cachedTraversableResolver);
                LocalExecutionContext<U, V> localContext = LocalExecutionContext.getLocalExecutionContext(beanType);
                localContext.setPropertyPath(path);
                localContext.setCurrentGroup(groupClass);
                localContext.setCurrentValidatedValue(value);
                if (!this.isValidationRequired(context, localContext, metaConstraint)) continue;
                metaConstraint.validateConstraint(context, localContext);
                failingConstraintViolations.addAll(context.getFailingConstraints());
            }
            if (failingConstraintViolations.size() <= numberOfConstraintViolations) continue;
            break;
        }
    }

    private <T> Object collectMetaConstraintsForPath(Class<T> clazz, Object value, Iterator<Path.Node> propertyIter, Set<MetaConstraint<T, ?>> metaConstraints) {
        Path.Node elem = propertyIter.next();
        BeanMetaData<T> metaData = this.getBeanMetaData(clazz);
        if (!metaData.isPropertyPresent(elem.getName())) {
            throw new IllegalArgumentException("Invalid property path. There is no property " + elem.getName() + " in entity " + metaData.getBeanClass().getName());
        }
        if (!propertyIter.hasNext()) {
            List<MetaConstraint<T, Annotation>> metaConstraintList = metaData.getMetaConstraintsAsList();
            for (MetaConstraint<T, Annotation> metaConstraint : metaConstraintList) {
                if (elem.getName() == null || !elem.getName().equals(metaConstraint.getPropertyName())) continue;
                metaConstraints.add(metaConstraint);
            }
        } else {
            List<Member> cascadedMembers = metaData.getCascadedMembers();
            for (Member m : cascadedMembers) {
                if (!ReflectionHelper.getPropertyName(m).equals(elem.getName())) continue;
                Type type = ReflectionHelper.typeOf(m);
                Object object = value = value == null ? null : ReflectionHelper.getValue(m, value);
                if (elem.isInIterable()) {
                    if (value != null && elem.getIndex() != null) {
                        value = ReflectionHelper.getIndexedValue(value, elem.getIndex());
                    } else if (value != null && elem.getKey() != null) {
                        value = ReflectionHelper.getMappedValue(value, elem.getKey());
                    } else if (value != null) {
                        throw new IllegalArgumentException("Property path must provide index or map key");
                    }
                    type = ReflectionHelper.getIndexedType(type);
                }
                Class<?> valueClass = value == null ? type : value.getClass();
                return this.collectMetaConstraintsForPath(valueClass, value, propertyIter, metaConstraints);
            }
        }
        return value;
    }

    private <U> BeanMetaData<U> getBeanMetaData(Class<U> beanClass) {
        BeanMetaDataImpl<U> beanMetaData = this.beanMetaDataCache.getBeanMetaData(beanClass);
        if (beanMetaData == null) {
            beanMetaData = new BeanMetaDataImpl<U>(beanClass, this.constraintHelper, this.beanMetaDataCache);
            this.beanMetaDataCache.addBeanMetaData(beanClass, beanMetaData);
        }
        return beanMetaData;
    }

    private TraversableResolver getCachingTraversableResolver() {
        return new SingleThreadCachedTraversableResolver(this.traversableResolver);
    }

    private boolean isValidationRequired(GlobalExecutionContext globalContext, LocalExecutionContext localContext, MetaConstraint metaConstraint) {
        boolean isReachable;
        if (!metaConstraint.getGroupList().contains(localContext.getCurrentGroup())) {
            return false;
        }
        PathImpl pathToObject = localContext.getPropertyPath().getPathWithoutLeafNode();
        if (pathToObject == null) {
            pathToObject = PathImpl.createNewPath(null);
        }
        try {
            isReachable = globalContext.getTraversableResolver().isReachable(localContext.getCurrentBean(), localContext.getPropertyPath().getLeafNode(), globalContext.getRootBeanClass(), pathToObject, metaConstraint.getElementType());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isReachable() threw an exception", e);
        }
        return isReachable;
    }

    private boolean isCascadeRequired(GlobalExecutionContext globalContext, LocalExecutionContext localContext, Member member) {
        boolean isCascadable;
        boolean isReachable;
        ElementType type = member instanceof Field ? ElementType.FIELD : ElementType.METHOD;
        PathImpl pathToObject = localContext.getPropertyPath().getPathWithoutLeafNode();
        if (pathToObject == null) {
            pathToObject = PathImpl.createNewPath(null);
        }
        try {
            isReachable = globalContext.getTraversableResolver().isReachable(localContext.getCurrentBean(), localContext.getPropertyPath().getLeafNode(), globalContext.getRootBeanClass(), pathToObject, type);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isReachable() threw an exception", e);
        }
        try {
            isCascadable = globalContext.getTraversableResolver().isCascadable(localContext.getCurrentBean(), localContext.getPropertyPath().getLeafNode(), globalContext.getRootBeanClass(), pathToObject, type);
        }
        catch (RuntimeException e) {
            throw new ValidationException("Call to TraversableResolver.isCascadable() threw an exception", e);
        }
        return isReachable && isCascadable;
    }
}

