/*-
 * Copyright (C) 2006 Erik Larsson
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.types.finder;

import org.catacombae.hfsexplorer.types.carbon.Point;
import org.catacombae.hfsexplorer.types.carbon.Rect;
import org.catacombae.hfsexplorer.Util;
import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;

/** This class was generated by CStructToJavaClass. */
public class FolderInfo extends CommonFinderInfo implements StructElements {
    /*
     * struct FolderInfo
     * size: 16 bytes
     * description: 
     * 
     * BP  Size  Type    Identifier     Description
     * --------------------------------------------
     * 0   8     Rect    windowBounds              
     * 8   2     UInt16  finderFlags               
     * 10  4     Point   location                  
     * 14  2     UInt16  reservedField             
     */
    
    private final Rect windowBounds;
    
    public FolderInfo(byte[] data, int offset) {
        super(data, offset);
	windowBounds = new Rect(data, offset+0);
    }
    
    public static int length() { return 16; }

    public Rect getWindowBounds() { return windowBounds; }
    
    @Override
    public byte[] getBytes() {
        byte[] result = new byte[length()];
	byte[] tempData;
	int offset = 0;
        
        tempData = windowBounds.getBytes();
	System.arraycopy(tempData, 0, result, offset, tempData.length); offset += tempData.length;
        
        tempData = super.getBytes();
        System.arraycopy(tempData, 0, result, offset, tempData.length); offset += tempData.length;
        
        return result;
    }
    
    @Override    
    public void printFields(PrintStream ps, String prefix) {
	ps.println(prefix + " windowBounds: ");
	getWindowBounds().print(ps, prefix+"  ");
	super.printFields(ps, prefix);
    }
    
    @Override
    public void print(PrintStream ps, String prefix) {
	ps.println(prefix + "FolderInfo:");
	printFields(ps, prefix);
    }
    
    @Override
    public Dictionary getStructElements() {
        DictionaryBuilder db = new DictionaryBuilder(FolderInfo.class.getSimpleName());
        
        db.add("windowBounds", windowBounds.getStructElements());
        db.addAll(super.getStructElements());
        
        return db.getResult();
    }  
}
