/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorControl;
import ghidra.app.util.pdb.pdbapplicator.PdbApplicatorOptions;
import ghidra.file.formats.dump.DumpData;
import ghidra.file.formats.dump.DumpFile;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.cmd.ModuleToPeHelper;
import ghidra.file.formats.dump.pagedump.FullDumpHeader;
import ghidra.file.formats.dump.pagedump.KdDebuggerData;
import ghidra.file.formats.dump.pagedump.KldrDataTableEntry;
import ghidra.file.formats.dump.pagedump.LoadedDriver;
import ghidra.file.formats.dump.pagedump.MmPfn;
import ghidra.file.formats.dump.pagedump.PagedumpFileHeader;
import ghidra.file.formats.dump.pagedump.PhysicalMemoryDescriptor;
import ghidra.file.formats.dump.pagedump.PhysicalMemoryRun;
import ghidra.file.formats.dump.pagedump.SummaryHeader;
import ghidra.file.formats.dump.pagedump.TriageDataBlock;
import ghidra.file.formats.dump.pagedump.TriageDump;
import ghidra.file.formats.dump.pagedump.TriageStorage;
import ghidra.file.formats.dump.pagedump.UnloadedDriver;
import ghidra.framework.options.Options;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Pagedump
extends DumpFile {
    public static final String DEBUG_DATA_PATH_OPTION_NAME = "Debug Data Path (e.g. /path/to/ntoskrnl.pdb)";
    public static final String DEBUG_DATA_PATH_OPTION_DEFAULT = "";
    public static long ETHREAD_PID_OFFSET;
    public static long ETHREAD_TID_OFFSET;
    public static final int OFFSET_HEADER = 0;
    public static final int OFFSET_TRIAGE = 4096;
    public static final int DUMP_TYPE_UNKNOWN = 0;
    public static final int DUMP_TYPE_FULL = 1;
    public static final int DUMP_TYPE_SUMMARY = 2;
    public static final int DUMP_TYPE_HEADER = 3;
    public static final int DUMP_TYPE_TRIAGE = 4;
    public static final int DUMP_TYPE_BITMAP_FULL = 5;
    public static final int DUMP_TYPE_BITMAP_KERNEL = 6;
    public static final int DUMP_TYPE_AUTOMATIC = 7;
    public static final int SIGNATURE = 1162297680;
    public static final int SIG_FULL = 1347241030;
    public static final int SIG_SUMMARY = 1347241043;
    public static final int SIG_VALID1 = 1347245124;
    public static final int SIG_VALID2 = 1347245124;
    public static final int PAGE_SIZE = 4096;
    public static final int MACHINE_TYPE_OFFSET32 = 32;
    public static final int MACHINE_TYPE_OFFSET64 = 48;
    public static final int TRIAGE_DUMP_CONTEXT = 1;
    public static final int TRIAGE_DUMP_EXCEPTION = 2;
    public static final int TRIAGE_DUMP_PRCB = 4;
    public static final int TRIAGE_DUMP_PROCESS = 8;
    public static final int TRIAGE_DUMP_THREAD = 16;
    public static final int TRIAGE_DUMP_STACK = 32;
    public static final int TRIAGE_DUMP_DRIVER_LIST = 64;
    public static final int TRIAGE_DUMP_BROKEN_DRIVER = 128;
    public static final int TRIAGE_DUMP_BASIC_INFO = 255;
    public static final int TRIAGE_DUMP_MMINFO = 256;
    public static final int TRIAGE_DUMP_DATAPAGE = 512;
    public static final int TRIAGE_DUMP_DEBUGGER_DATA = 1024;
    public static final int TRIAGE_DUMP_DATA_BLOCKS = 2048;
    PagedumpFileHeader header;
    TriageDump triage;
    SummaryHeader summary;
    FullDumpHeader full;
    private CategoryPath categoryPath = new CategoryPath("/ntkrnlmp.pdb");
    private List<String> addins = new ArrayList<String>();
    private int base;
    private long pfnDB;
    Map<Integer, Long> pfnToVA = new HashMap<Integer, Long>();
    Map<Long, Long> VA2fileOffset = new HashMap<Long, Long>();
    protected long cr3;
    private boolean createBlocks = true;
    private boolean is32Bit = false;
    private boolean isPAE = false;

    public Pagedump(DumpFileReader reader, ProgramBasedDataTypeManager dtm, List<Option> options, TaskMonitor monitor) throws IOException {
        super(reader, dtm, options, monitor);
        this.addins.add("ntoskrnl");
        this.addins.add("ntkrnlmp");
        Options props = this.program.getOptions("Program Information");
        props.setString("Executable Format", "Portable Executable (PE)");
        this.initManagerList(this.addins);
        this.createBlocks = OptionUtils.getBooleanOptionValue((String)"Create Memory Blocks", options, (boolean)true);
        String pdbLocation = (String)OptionUtils.getOption((String)DEBUG_DATA_PATH_OPTION_NAME, options, (Object)DEBUG_DATA_PATH_OPTION_DEFAULT);
        if (!pdbLocation.equals(DEBUG_DATA_PATH_OPTION_DEFAULT)) {
            this.loadKernelPDB(pdbLocation, monitor);
        }
        this.header = new PagedumpFileHeader(reader, 0L, this);
        this.cr3 = this.header.getDirectoryTableBase();
        this.is32Bit = this.header.is32Bit();
        this.isPAE = this.header.getPaeEnabled() != 0;
        long hdrLen = this.header.toDataType().getLength();
        this.addInteriorAddressObject("DumpHeader", 0L, 0L, hdrLen);
        this.data.add(new DumpData(0L, this.header.toDataType()));
        PhysicalMemoryDescriptor pmd = this.header.getPhysicalMemoryBlockBuffer();
        if (pmd != null) {
            this.loadPhysicalMemoryRuns(pmd);
        }
        switch (this.header.getDumpType()) {
            case 1: 
            case 5: 
            case 6: {
                int signature = reader.readInt(hdrLen);
                long offset = hdrLen;
                switch (signature) {
                    case 1347241030: 
                    case 1347241043: {
                        this.full = new FullDumpHeader(reader, hdrLen);
                        DataType dt = this.full.toDataType();
                        this.data.add(new DumpData(hdrLen, dt));
                        this.data.add(new DumpData(this.full.getHeaderSize(), "Physical_Memory", 0));
                        offset = (int)this.full.getHeaderSize();
                        this.addInteriorAddressObject("DumpHeader", hdrLen, hdrLen, offset - hdrLen);
                        if (this.createBlocks) {
                            this.mapPages(monitor);
                        }
                        this.walkPsLoadedModules();
                        break;
                    }
                    case 1347245124: {
                        reader.readNextInt();
                    }
                }
                this.addInteriorAddressObject("Unknown", offset, offset, reader.length() - offset);
                break;
            }
            case 4: {
                this.triage = new TriageDump(reader, hdrLen);
                DataType dt = this.triage.toDataType();
                this.data.add(new DumpData(hdrLen, dt));
                this.addInteriorAddressObject("DumpHeader", hdrLen, hdrLen, this.triage.getSizeOfDump());
                long next = hdrLen + this.triage.getSizeOfDump();
                this.addInteriorAddressObject("Unknown", next, next, reader.length() - next);
                this.buildKernelStructures();
            }
        }
    }

    private void loadKernelPDB(String pdbLocation, TaskMonitor monitor) {
        for (String key : this.addins) {
            if (!this.managerList.containsKey(key)) continue;
            return;
        }
        File pdbFile = new File(pdbLocation);
        if (!pdbFile.exists()) {
            return;
        }
        PdbReaderOptions readerOptions = new PdbReaderOptions();
        PdbApplicatorOptions applicatorOptions = new PdbApplicatorOptions();
        applicatorOptions.setProcessingControl(PdbApplicatorControl.DATA_TYPES_ONLY);
        try (AbstractPdb pdb = PdbParser.parse((String)pdbFile.getPath(), (PdbReaderOptions)readerOptions, (TaskMonitor)monitor);){
            monitor.setMessage("PDB: Parsing " + pdbFile + "...");
            pdb.deserialize();
            DefaultPdbApplicator applicator = new DefaultPdbApplicator(pdb);
            applicator.applyTo(this.program, (DataTypeManager)this.dtm, this.program.getImageBase(), applicatorOptions, (MessageLog)null);
        }
        catch (PdbException | CancelledException | IOException e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
    }

    private void loadPhysicalMemoryRuns(PhysicalMemoryDescriptor pmd) throws IOException {
        PhysicalMemoryRun[] runs = pmd.getRuns();
        int total = 1;
        for (PhysicalMemoryRun run : runs) {
            long runLength = run.getPageCount() * 4096L;
            boolean outOfBounds = runLength + (long)(total * 4096) > this.reader.length();
            long bound = outOfBounds ? this.reader.length() - (long)(total * 4096) : runLength;
            ArrayDataType adt = new ArrayDataType(StructConverter.BYTE, (int)bound, 1);
            this.data.add(new DumpData(total * 4096, (DataType)adt));
            total = (int)((long)total + run.getPageCount());
            if (outOfBounds) break;
        }
    }

    private void buildKernelStructures() throws IOException {
        CategoryPath path;
        DataType ctxt;
        ArrayDataType dt;
        long offset;
        if ((this.header.getMiniDumpFields() & 0x100) > 0) {
            offset = this.triage.getMmOffset();
            this.reader.setPointerIndex(offset);
            TriageStorage tstor = new TriageStorage(this.reader, this.reader.getPointerIndex());
            this.data.add(new DumpData(offset, tstor.toDataType()));
        }
        if ((this.header.getMiniDumpFields() & 4) > 0) {
            this.addDumpData(this.triage.getPrcbOffset(), "_KPRCB", this.categoryPath);
        }
        if ((this.header.getMiniDumpFields() & 8) > 0) {
            this.addDumpData(this.triage.getProcessOffset(), "_EPROCESS", this.categoryPath);
        }
        if ((this.header.getMiniDumpFields() & 0x10) > 0) {
            this.addDumpData(this.triage.getThreadOffset(), "_ETHREAD", this.categoryPath);
        }
        if ((this.header.getMiniDumpFields() & 0x20) > 0) {
            int psz = this.reader.getPointerSize();
            offset = this.triage.getCallStackOffset();
            DataType el = psz == 4 ? StructConverter.DWORD : StructConverter.QWORD;
            dt = new ArrayDataType(el, this.triage.getCallStackSize() / psz, psz);
            this.data.add(new DumpData(offset, (DataType)dt, "CALL_STACK"));
        }
        if ((this.header.getMiniDumpFields() & 0x40) > 0) {
            offset = this.triage.getDriverListOffset();
            this.reader.setPointerIndex(offset);
            if (this.triage.getDriverCount() > 0) {
                DataType ldt = null;
                for (int i = 0; i < this.triage.getDriverCount(); ++i) {
                    LoadedDriver ld = new LoadedDriver(this.reader, this.reader.getPointerIndex());
                    ldt = ld.toDataType();
                    int nameOffset = ld.getNameOffset();
                    String name = this.reader.readUnicodeString(nameOffset + 4);
                    this.addModule(name, ld.getDllBase(), i, ld.getSizeOfImage());
                    this.addExteriorAddressObject(name, 0L, ld.getDllBase(), ld.getSizeOfImage());
                }
                dt = new ArrayDataType(ldt, this.triage.getDriverCount(), ldt.getLength());
                this.data.add(new DumpData(offset, (DataType)dt, "LOADED_DRIVERS"));
            } else {
                this.data.add(new DumpData(offset, "LOADED_DRIVERS", 0));
            }
        }
        if ((this.header.getMiniDumpFields() & 0x80) > 0) {
            offset = this.triage.getUnloadedDriversOffset();
            this.reader.setPointerIndex(offset);
            long count = this.reader.readNextLong();
            StructureDataType uds = new StructureDataType("UNLOADED_DRIVERS", 0);
            uds.add(StructConverter.QWORD, 8, "NumberOfUnloadedDrivers", null);
            if (count > 0L) {
                DataType udt = null;
                int i = 0;
                while ((long)i < count) {
                    UnloadedDriver ud = new UnloadedDriver(this.reader, this.reader.getPointerIndex());
                    udt = ud.toDataType();
                    if (ud.getStartAddress() != 0L) {
                        this.addExteriorAddressObject(ud.getName(), 0L, ud.getStartAddress(), ud.getSize());
                    }
                    ++i;
                }
                uds.add((DataType)new ArrayDataType(udt, (int)count, udt.getLength()), udt.getLength() * (int)count, "UnloadedDrivers", null);
            }
            this.data.add(new DumpData(offset, (DataType)uds));
        }
        offset = this.triage.getStringPoolOffset();
        long end = offset + (long)this.triage.getStringPoolSize();
        this.data.add(new DumpData(offset, "STRING_POOL", this.triage.getStringPoolSize()));
        while (offset < end) {
            int len = this.reader.readInt(offset);
            this.data.add(new DumpData(offset, StructConverter.DWORD, DEBUG_DATA_PATH_OPTION_DEFAULT, false, false));
            if (len == 0 || len == -1) break;
            DumpData dd = new DumpData(offset += 4L, (DataType)new TerminatedUnicodeDataType(), DEBUG_DATA_PATH_OPTION_DEFAULT, false, false);
            dd.setSize(len * 2 + 2);
            this.data.add(dd);
            offset = (offset + dd.getSize() + 7L) / 8L * 8L;
        }
        if ((this.header.getMiniDumpFields() & 0x400) > 0) {
            offset = this.triage.getDebuggerDataOffset();
            this.reader.setPointerIndex(offset);
            KdDebuggerData kdd = new KdDebuggerData(this.reader, this.reader.getPointerIndex());
            this.data.add(new DumpData(offset, kdd.toDataType()));
        }
        if (this.createBlocks && (this.header.getMiniDumpFields() & 0x800) > 0) {
            offset = this.triage.getDataBlocksOffset();
            this.reader.setPointerIndex(offset);
            DataType db = null;
            for (int i = 0; i < this.triage.getDataBlocksCount(); ++i) {
                TriageDataBlock tdb = new TriageDataBlock(this.reader, this.reader.getPointerIndex());
                this.addInteriorAddressObject("Memory", tdb.getOffset(), tdb.getAddress(), tdb.getSize());
                this.VA2fileOffset.put(tdb.getAddress(), tdb.getOffset());
                db = tdb.toDataType();
            }
            if (db != null && this.triage.getDataBlocksCount() > 0) {
                dt = new ArrayDataType(db, this.triage.getDataBlocksCount(), db.getLength());
                this.data.add(new DumpData(offset, (DataType)dt, "DATA_BLOCKS"));
            }
        }
        if ((this.header.getMiniDumpFields() & 1) > 0 && this.header.getContextOffset() > 0L && (ctxt = this.getTypeFromArchive(path = new CategoryPath("/winnt.h"), "CONTEXT")) != null) {
            this.setProgramContext(this.header.getContextOffset(), ctxt, "(active)");
        }
    }

    private void walkPsLoadedModules() {
        long listHead = this.header.getPsLoadedModuleList();
        try {
            long next = this.reader.readPointer(this.virtualToRva(listHead));
            this.reader.setPointerIndex(this.virtualToRva(next));
            ArrayList<Long> entryKeys = new ArrayList<Long>();
            while (true) {
                KldrDataTableEntry entry = new KldrDataTableEntry(this.reader, this.reader.getPointerIndex());
                this.data.add(new DumpData(next, entry.toDataType()));
                long namePtr = entry.getFullDllName();
                if (namePtr != 0L) {
                    long fileOffset = this.virtualToRva(namePtr);
                    String name = this.reader.readUnicodeString(fileOffset);
                    this.addExteriorAddressObject(name, 0L, entry.getDllBase(), entry.getSizeOfImage());
                }
                if (!entryKeys.contains(next = entry.getList_Flink())) {
                    entryKeys.add(next);
                    this.reader.setPointerIndex(this.virtualToRva(next));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e.getMessage());
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)"Duplicate name");
        }
    }

    private void mapPages(TaskMonitor monitor) throws IOException {
        this.base = (int)this.full.getHeaderSize();
        this.walkPfnDB();
        monitor.setMessage("Adding pages");
        monitor.initialize((long)this.pfnToVA.keySet().size());
        int count = 0;
        for (Integer pfnx : this.pfnToVA.keySet()) {
            Integer rva = this.full.PFN2RVA(pfnx);
            if (rva == null) {
                Msg.error((Object)this, (Object)("no rva for " + Long.toHexString(pfnx.intValue())));
                continue;
            }
            Long addr = this.pfnToVA.get(pfnx);
            this.addInteriorAddressObject("Memory", this.fileOffset(pfnx), addr, 4096L);
            monitor.setProgress((long)count++);
        }
        monitor.setMessage("Pages added");
    }

    public PagedumpFileHeader getFileHeader() {
        return this.header;
    }

    public TriageDump getTriageDump() {
        return this.triage;
    }

    public boolean usesPreloadedLists() {
        return this.header.getDumpType() != 1;
    }

    public static String getMachineType(DumpFileReader reader) throws IOException {
        PagedumpFileHeader header = new PagedumpFileHeader(reader, 0L);
        return Integer.toHexString(header.getMachineImageType());
    }

    @Override
    public void analyze(TaskMonitor monitor) {
        boolean analyzeEmbeddedObjects = OptionUtils.getBooleanOptionValue((String)"Analyze Embedded Executables (interactive)", (List)this.options, (boolean)ANALYZE_EMBEDDED_OBJECTS_OPTION_DEFAULT);
        if (analyzeEmbeddedObjects) {
            ModuleToPeHelper.queryModules(this.program, monitor);
        }
    }

    private long valueAt(long l) {
        try {
            return this.reader.readLong(l);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)e.getMessage());
            return -1L;
        }
    }

    private void walkPfnDB() throws IOException {
        this.pfnDB = this.header.getPfnTableBase();
        for (Integer pfn : this.full.pfnKeySet()) {
            long toRead = this.pfnDB + (long)(pfn * 48);
            long rva = this.virtualToRva(toRead);
            if (rva < 0L) continue;
            MmPfn pfnEntry = new MmPfn(this.reader, rva);
            long pte = pfnEntry.getPteAddress();
            long addr = pte << 9 | 0xFFFF000000000000L;
            this.pfnToVA.put(pfn, addr);
        }
    }

    private long virtualToRva(long vaddr) {
        if (this.triage != null) {
            return this.VA2fileOffset.get(vaddr);
        }
        int tableHead = (int)(this.cr3 >> 12);
        int shiftPTE = 12;
        int shiftPDE = this.is32Bit && !this.isPAE ? shiftPTE + 10 : shiftPTE + 9;
        int shiftPPE = this.is32Bit && !this.isPAE ? shiftPDE + 10 : shiftPDE + 9;
        int shiftPXE = shiftPPE + 9;
        int mask = this.is32Bit && !this.isPAE ? 1023 : 511;
        long index = vaddr & 0xFFFL;
        long pte = vaddr >> shiftPTE & (long)mask;
        long pde = vaddr >> shiftPDE & (long)mask;
        long ppe = vaddr >> shiftPPE & (long)mask;
        long pxe = vaddr >> shiftPXE & (long)mask;
        int offpte = (int)(pte * 8L);
        int offpde = (int)(pde * 8L);
        int offppe = (int)(ppe * 8L);
        int offpxe = (int)(pxe * 8L);
        long valPXE = this.valueAt(this.fileOffset(tableHead) + (long)offpxe);
        int pfnPXE = this.valueToPfn(valPXE);
        long rvaPXE = this.fileOffset(pfnPXE);
        long valPPE = this.valueAt(rvaPXE + (long)offppe);
        int pfnPPE = this.valueToPfn(valPPE);
        long rvaPPE = this.fileOffset(pfnPPE);
        long valPDE = this.valueAt(rvaPPE + (long)offpde);
        int pfnPDE = this.valueToPfn(valPDE);
        int flagsPDE = this.valueToFlags(valPDE);
        long rvaPDE = this.fileOffset(pfnPDE);
        boolean isLargePage = this.isLargePage(flagsPDE);
        if (isLargePage) {
            index = vaddr & 0x1FFFFFL;
            return rvaPDE + index;
        }
        long valPTE = this.valueAt(rvaPDE + (long)offpte);
        int pfnPTE = this.valueToPfn(valPTE);
        long rvaPTE = this.fileOffset(pfnPTE);
        return rvaPTE + index;
    }

    private long fileOffset(int pfn) {
        Integer val = this.full.PFN2RVA(pfn);
        if (val == null) {
            return -1L;
        }
        return (long)val.intValue() * 4096L + (long)this.base;
    }

    private int valueToPfn(long pfnEntry) {
        return (int)(pfnEntry >> 12 & 0xFFFFFFFFFFFFFFFFL);
    }

    private int valueToFlags(long pfnEntry) {
        return (int)(pfnEntry & 0xFFFL);
    }

    private boolean isLargePage(int flags) {
        return (flags & 0x80) > 0;
    }

    public static Collection<? extends Option> getDefaultOptions(DumpFileReader reader) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Option(DEBUG_DATA_PATH_OPTION_NAME, (Object)DEBUG_DATA_PATH_OPTION_DEFAULT, String.class, "-loader-debugDataFilePath"));
        list.addAll(DumpFile.getDefaultOptions(reader));
        return list;
    }
}

