/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.eclipse;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.DexToJarFileSystem;
import ghidra.file.formats.android.xml.AndroidXmlFileSystem;
import ghidra.file.formats.zip.ZipFileSystem;
import ghidra.file.jad.JadProcessController;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.file.jad.JarDecompiler;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import utilities.util.FileUtilities;

public class AndroidProjectCreator {
    public static ResourceFile androidDirectory;
    private FSRL apkFileFSRL;
    private File eclipseProjectDirectory;
    private File srcDirectory;
    private File genDirectory;
    private File assetDirectory;
    private ResourceFile projectTemplateFile = new ResourceFile(androidDirectory, "eclipse-project");
    private ResourceFile classpathTemplateFile = new ResourceFile(androidDirectory, "eclipse-classpath");
    private MessageLog log = new MessageLog();
    private FileSystemService fsService = FileSystemService.getInstance();

    public AndroidProjectCreator(FSRL apkFileFSRL, File eclipseProjectDirectory) {
        this.apkFileFSRL = apkFileFSRL;
        this.eclipseProjectDirectory = eclipseProjectDirectory;
    }

    public void create(TaskMonitor monitor) throws IOException, CancelledException {
        this.createEclipseProjectDirectories();
        try (ZipFileSystem fs = (ZipFileSystem)this.fsService.mountSpecificFileSystem(this.apkFileFSRL, ZipFileSystem.class, monitor);){
            List listing = fs.getListing(null);
            this.processListing(this.eclipseProjectDirectory, (GFileSystem)fs, listing, monitor);
        }
        File destProjectFile = AndroidProjectCreator.copyFile(this.projectTemplateFile, this.eclipseProjectDirectory, ".project", monitor);
        AndroidProjectCreator.copyFile(this.classpathTemplateFile, this.eclipseProjectDirectory, ".classpath", monitor);
        this.fixupProjectFile(destProjectFile);
    }

    public MessageLog getLog() {
        return this.log;
    }

    private void fixupProjectFile(File projectFile) throws IOException {
        try {
            Document projectDoc = XmlUtilities.readDocFromFile((File)projectFile);
            Element nameElement = projectDoc.getRootElement().getChild("name");
            if (nameElement != null) {
                nameElement.setText(this.apkFileFSRL.getName());
                XmlUtilities.writeDocToFile((Document)projectDoc, (File)projectFile);
            }
        }
        catch (JDOMException e) {
            throw new IOException("Error when processing xml", e);
        }
    }

    private void createEclipseProjectDirectories() throws IOException {
        FileUtilities.checkedMkdirs((File)this.eclipseProjectDirectory);
        this.srcDirectory = FileUtilities.checkedMkdir((File)new File(this.eclipseProjectDirectory, "src"));
        this.genDirectory = FileUtilities.checkedMkdirs((File)new File(this.eclipseProjectDirectory, "gen"));
        this.assetDirectory = FileUtilities.checkedMkdirs((File)new File(this.eclipseProjectDirectory, "asset"));
    }

    private void processListing(File outputDirectory, GFileSystem fs, List<GFile> listing, TaskMonitor monitor) throws IOException, CancelledException {
        for (GFile child : listing) {
            String childName = child.getName();
            if (monitor.isCancelled()) break;
            monitor.setIndeterminate(true);
            if (child.isDirectory()) {
                if (childName.equals("META-INF")) continue;
                File subDir = new File(outputDirectory, childName);
                FileUtilities.checkedMkdir((File)subDir);
                this.processListing(subDir, fs, child.getListing(), monitor);
                continue;
            }
            try {
                ByteProvider childBP = fs.getByteProvider(child, monitor);
                try {
                    if (childName.endsWith(".xml") && AndroidXmlFileSystem.isAndroidXmlFile(childBP, monitor)) {
                        this.processXML(outputDirectory, child, monitor);
                        continue;
                    }
                    if (childName.endsWith("classes.dex")) {
                        this.processDex(outputDirectory, child, monitor);
                        continue;
                    }
                    if (childName.endsWith("resources.arsc")) {
                        AndroidProjectCreator.copyStream(childBP, outputDirectory, child.getName(), monitor);
                        continue;
                    }
                    if (childName.endsWith(".class")) {
                        this.processClass(outputDirectory, child, monitor);
                        continue;
                    }
                    AndroidProjectCreator.copyStream(childBP, outputDirectory, childName, monitor);
                }
                finally {
                    if (childBP == null) continue;
                    childBP.close();
                }
            }
            catch (Exception e) {
                this.log.appendMsg("Unable to export child file: " + child.getFSRL());
                this.log.appendMsg("\tISSUE WAS: " + e.getMessage());
                Msg.error((Object)this, (Object)"Unable to export child file", (Throwable)e);
            }
        }
    }

    private void processDex(File outputDirectory, GFile dexFile, TaskMonitor monitor) throws IOException, CancelledException {
        try (DexToJarFileSystem fs = (DexToJarFileSystem)this.fsService.mountSpecificFileSystem(dexFile.getFSRL(), DexToJarFileSystem.class, monitor);){
            GFile jarFile = fs.getJarFile();
            this.processJar(this.srcDirectory, jarFile.getFSRL(), monitor);
        }
    }

    private void processJar(File outputDirectory, FSRL jarFile, TaskMonitor monitor) throws IOException, CancelledException {
        JarDecompiler decompiler = new JarDecompiler(jarFile, outputDirectory);
        decompiler.decompile(monitor);
        if (decompiler.getLog().hasMessages()) {
            this.log.copyFrom(decompiler.getLog());
        }
    }

    private void processClass(File outputDirectory, GFile classGFile, TaskMonitor monitor) throws IOException, CancelledException {
        String classFileName = classGFile.getName();
        File destClassFile = new File(outputDirectory, classFileName);
        InputStream is = classGFile.getFilesystem().getInputStream(classGFile, monitor);
        AndroidProjectCreator.copyStream(is, outputDirectory, classFileName, monitor);
        JadProcessWrapper wrapper = new JadProcessWrapper(destClassFile);
        JadProcessController controller = new JadProcessController(wrapper, classGFile.getName());
        controller.decompile(5, monitor);
    }

    private void processXML(File outputDirectory, GFile containerFile, TaskMonitor monitor) throws CancelledException {
        try (AndroidXmlFileSystem fs = (AndroidXmlFileSystem)this.fsService.mountSpecificFileSystem(containerFile.getFSRL(), AndroidXmlFileSystem.class, monitor);){
            GFile xmlFile = fs.getPayloadFile();
            AndroidProjectCreator.copyStream(fs.getInputStream(xmlFile, monitor), outputDirectory, containerFile.getName(), monitor);
        }
        catch (IOException ioe) {
            Msg.info((Object)this, (Object)("XML file " + containerFile.getPath() + " is not AndriodXmlFileSystem compatible"), (Throwable)ioe);
        }
    }

    private static File copyFile(ResourceFile inputFile, File outputDirectory, String outputName, TaskMonitor monitor) throws IOException {
        try (InputStream is = inputFile.getInputStream();){
            FileUtilities.checkedMkdirs((File)outputDirectory);
            File destFile = new File(outputDirectory, outputName);
            monitor.setMessage("Copying [" + inputFile.getName() + "] to Eclipse project...");
            FileUtilities.copyStreamToFile((InputStream)is, (File)destFile, (boolean)false, (TaskMonitor)monitor);
            File file = destFile;
            return file;
        }
    }

    private static File copyStream(ByteProvider provider, File outputDirectory, String outputName, TaskMonitor monitor) throws IOException {
        return AndroidProjectCreator.copyStream(provider.getInputStream(0L), outputDirectory, outputName, monitor);
    }

    private static File copyStream(InputStream streamToCopy, File outputDirectory, String outputName, TaskMonitor monitor) throws IOException {
        try (InputStream is = streamToCopy;){
            FileUtilities.checkedMkdirs((File)outputDirectory);
            File destFile = new File(outputDirectory, outputName);
            monitor.setMessage("Copying [" + outputName + "] to Eclipse project...");
            FileUtilities.copyStreamToFile((InputStream)is, (File)destFile, (boolean)false, (TaskMonitor)monitor);
            File file = destFile;
            return file;
        }
    }

    static {
        ResourceFile directory = null;
        try {
            directory = Application.getModuleDataSubDirectory((String)"android");
        }
        catch (IOException e) {
            Msg.error(AndroidProjectCreator.class, (Object)"cannot find android directory");
        }
        androidDirectory = directory;
    }
}

