/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.options.OptionsService;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.codebrowser.ListingMiddleMouseHighlightProvider;
import ghidra.app.plugin.core.functiongraph.FGColorProvider;
import ghidra.app.plugin.core.functiongraph.FGProvider;
import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.SetFormatDialogComponentProvider;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.XRefChooserDialog;
import ghidra.app.plugin.core.functiongraph.mvc.CurrentFunctionGraphViewSettings;
import ghidra.app.plugin.core.functiongraph.mvc.EmptyFunctionGraphData;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FGModel;
import ghidra.app.plugin.core.functiongraph.mvc.FGView;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphViewSettings;
import ghidra.app.plugin.core.functiongraph.mvc.NavigationHistoryChoices;
import ghidra.app.plugin.core.functiongraph.mvc.NoFunctionGraphViewSettings;
import ghidra.app.plugin.core.functiongraph.mvc.PendingFunctionGraphViewSettings;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.CodeViewerService;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.app.util.viewer.listingpanel.ProgramSelectionListener;
import ghidra.app.util.viewer.listingpanel.StringSelectionListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.graph.viewer.FGViewUpdater;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.graph.viewer.PathHighlightMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FGController
implements ProgramLocationListener,
ProgramSelectionListener {
    private final FunctionGraphPlugin plugin;
    private FGProvider provider;
    private final FGModel model;
    private final FGView view;
    private FGData functionGraphData = new EmptyFunctionGraphData("Uninitialized Function Graph");
    private FunctionGraphViewSettings viewSettings = new NoFunctionGraphViewSettings();
    private FGVertex lastUserNavigatedVertex;
    private FormatManager fullFormatManager;
    private FormatManager minimalFormatManager;
    private FormatManager defaultFormatManager;
    private FunctionGraphOptions functionGraphOptions;
    private FgHighlightProvider sharedHighlightProvider;
    private StringSelectionListener sharedStringSelectionListener = string -> this.provider.setClipboardStringContent(string);
    private Cache<Function, FGData> cache;
    private BiConsumer<FGData, Boolean> fgDataDisposeListener = (data, evicted) -> {};

    public FGController(FGProvider provider, FunctionGraphPlugin plugin) {
        this.provider = provider;
        this.plugin = plugin;
        this.cache = this.buildCache((RemovalListener<Function, FGData>)((RemovalListener)this::cacheValueRemoved));
        this.model = new FGModel(this);
        this.view = new FGView(this, this.model.getTaskMonitorComponent());
        this.functionGraphOptions = plugin.getFunctionGraphOptions();
    }

    private boolean disposeGraphDataIfNotInUse(FGData data) {
        if (data == this.functionGraphData) {
            return false;
        }
        data.dispose();
        this.fgDataDisposeListener.accept(data, true);
        return true;
    }

    private FormatManager createMinimalFormatManager() {
        FormatManager userDefinedFormat = this.plugin.getUserDefinedFormat();
        if (userDefinedFormat != null) {
            return userDefinedFormat;
        }
        return this.createDefaultFormat();
    }

    private FormatManager createFullFormatManager() {
        CodeViewerService codeViewer = (CodeViewerService)this.plugin.getTool().getService(CodeViewerService.class);
        return codeViewer.getFormatManager();
    }

    public FormatManager getMinimalFormatManager() {
        if (this.minimalFormatManager == null) {
            this.setMinimalFormatManager(this.createMinimalFormatManager());
        }
        return this.minimalFormatManager;
    }

    private void setMinimalFormatManager(FormatManager formatManager) {
        this.minimalFormatManager = formatManager;
        FgHighlightProvider highlightProvider = this.lazilyCreateSharedHighlightProvider();
        this.minimalFormatManager.addHighlightProvider((ListingHighlightProvider)highlightProvider);
    }

    public FormatManager getFullFormatManager() {
        if (this.fullFormatManager == null) {
            this.fullFormatManager = this.createFullFormatManager();
        }
        return this.fullFormatManager;
    }

    private FormatManager getDefaultFormatManager() {
        if (this.defaultFormatManager == null) {
            this.defaultFormatManager = this.createDefaultFormat();
        }
        return this.defaultFormatManager;
    }

    private FgHighlightProvider lazilyCreateSharedHighlightProvider() {
        if (this.sharedHighlightProvider != null) {
            return this.sharedHighlightProvider;
        }
        this.sharedHighlightProvider = new FgHighlightProvider(this.plugin.getTool(), this.provider.getComponent());
        return this.sharedHighlightProvider;
    }

    public void formatChanged() {
        this.setMinimalFormatManager(this.plugin.getUserDefinedFormat());
        this.view.repaint();
    }

    public Navigatable getNavigatable() {
        return this.provider;
    }

    private FormatManager createDefaultFormat() {
        FieldFactory[] allRowFactories;
        int numRows;
        int i;
        OptionsService options = (OptionsService)this.plugin.getTool().getService(OptionsService.class);
        ToolOptions displayOptions = options.getOptions("Listing Display");
        ToolOptions fieldOptions = options.getOptions("Listing Fields");
        FormatManager newMinimizedFormatManager = new FormatManager(displayOptions, fieldOptions);
        for (i = 0; i < newMinimizedFormatManager.getNumModels(); ++i) {
            FieldFormatModel formatModel = newMinimizedFormatManager.getModel(i);
            numRows = formatModel.getNumRows();
            for (int row = 0; row < numRows; ++row) {
                allRowFactories = formatModel.getFactorys(row);
                for (int col = allRowFactories.length - 1; col >= 0; --col) {
                    FieldFactory fieldFactory = allRowFactories[col];
                    if (fieldFactory.getFieldName().equals("Operands")) {
                        fieldFactory.setWidth(195);
                        formatModel.updateRow(row);
                        continue;
                    }
                    if (fieldFactory.getFieldName().equals("Label")) {
                        fieldFactory.setWidth(150);
                        formatModel.updateRow(row);
                        continue;
                    }
                    if (fieldFactory.getFieldName().equals("Address")) {
                        fieldFactory.setWidth(50);
                        formatModel.updateRow(row);
                        continue;
                    }
                    if (fieldFactory.getFieldName().equals("Mnemonic")) {
                        fieldFactory.setWidth(37);
                        formatModel.updateRow(row);
                        continue;
                    }
                    if (this.isSpacerBeforeLabel(fieldFactory, allRowFactories, col)) {
                        fieldFactory.setWidth(75);
                        formatModel.updateRow(row);
                        continue;
                    }
                    if (fieldFactory.getFieldName().equals("Function Signature") || fieldFactory.getFieldName().equals("Variable Type") || fieldFactory.getFieldName().equals("Variable Location") || fieldFactory.getFieldName().equals("Variable Name")) continue;
                    if (this.isSpacerBeforeVariables(fieldFactory, allRowFactories, col)) {
                        fieldFactory.setWidth(50);
                        formatModel.updateRow(row);
                        continue;
                    }
                    if (fieldFactory.getFieldName().equals("Address") || fieldFactory.getFieldName().equals("Mnemonic")) continue;
                    formatModel.removeFactory(row, col);
                }
            }
        }
        for (i = 0; i < newMinimizedFormatManager.getNumModels(); ++i) {
            FieldFormatModel codeUnitFormat = newMinimizedFormatManager.getModel(i);
            numRows = codeUnitFormat.getNumRows();
            for (int j = numRows - 1; j >= 0; --j) {
                allRowFactories = codeUnitFormat.getFactorys(j);
                if (allRowFactories.length != 0) continue;
                codeUnitFormat.removeRow(j);
            }
        }
        return newMinimizedFormatManager;
    }

    private boolean isSpacerBeforeLabel(FieldFactory fieldFactory, FieldFactory[] allRowFactories, int column) {
        if (!fieldFactory.getFieldName().equals("Spacer")) {
            return false;
        }
        if (column != 0) {
            return false;
        }
        if (allRowFactories.length < 2) {
            return false;
        }
        FieldFactory previousFactory = allRowFactories[1];
        return previousFactory.getFieldName().equals("Label");
    }

    private boolean isSpacerBeforeVariables(FieldFactory fieldFactory, FieldFactory[] allRowFactories, int column) {
        if (!fieldFactory.getFieldName().equals("Spacer")) {
            return false;
        }
        if (column != 0) {
            return false;
        }
        if (allRowFactories.length < 2) {
            return false;
        }
        FieldFactory previousFactory = allRowFactories[1];
        return previousFactory.getFieldName().equals("Variable Type");
    }

    public void setStatusMessage(String message) {
        this.view.setStatusMessage(message);
    }

    public void programLocationChanged(ProgramLocation location, EventTrigger trigger) {
        if (trigger == EventTrigger.GUI_ACTION) {
            this.handleLocationChangedFromVertex(location);
        }
    }

    private void handleLocationChangedFromVertex(ProgramLocation loc) {
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        FGVertex newFocusedVertex = (FGVertex)graph.getFocusedVertex();
        boolean vertexChanged = this.lastUserNavigatedVertex != newFocusedVertex;
        boolean updateHistory = false;
        if (vertexChanged) {
            if (this.shouldSaveVertexChanges()) {
                this.provider.saveLocationToHistory();
                updateHistory = true;
            }
            this.lastUserNavigatedVertex = newFocusedVertex;
        }
        this.viewSettings.setLocation(loc);
        this.provider.graphLocationChanged(loc);
        if (updateHistory) {
            this.provider.saveLocationToHistory();
        }
    }

    private boolean shouldSaveVertexChanges() {
        return this.functionGraphOptions.getNavigationHistoryChoice() == NavigationHistoryChoices.VERTEX_CHANGES;
    }

    public void programSelectionChanged(ProgramSelection selection, EventTrigger trigger) {
        if (trigger != EventTrigger.GUI_ACTION) {
            return;
        }
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        ProgramSelection fullSelection = graph.getProgramSelectionForAllVertices();
        this.viewSettings.setSelection(fullSelection);
        this.provider.graphSelectionChanged(fullSelection);
    }

    public void groupSelectedVertices() {
        this.groupSelectedVertices(null);
    }

    public void groupSelectedVertices(Point2D location) {
        FGViewUpdater updater = this.view.getViewUpdater();
        updater.groupSelectedVertices(this, location);
    }

    public void ungroupAllVertices() {
        FGViewUpdater updater = this.view.getViewUpdater();
        updater.ungroupAllVertices(this);
    }

    public void addToGroup(GroupedFunctionGraphVertex group, Set<FGVertex> vertices) {
        FGViewUpdater updater = this.view.getViewUpdater();
        updater.addToGroup(this, group, vertices);
    }

    public void ungroupVertex(GroupedFunctionGraphVertex group) {
        FGViewUpdater updater = this.view.getViewUpdater();
        updater.ungroupVertex(this, group);
    }

    public void splitVertex(FGVertex v, Address address) {
        FGViewUpdater updater = this.view.getViewUpdater();
        updater.splitVertex(this, v, address);
    }

    public void mergeVertexWithParent(FGVertex v) {
        FGViewUpdater updater = this.view.getViewUpdater();
        updater.mergeVertexWithParent(this, v);
    }

    public String promptUserForGroupVertexText(JComponent parent, String userText, Set<FGVertex> vertices) {
        FGViewUpdater updater = this.view.getViewUpdater();
        return updater.promptUserForGroupVertexText(parent, userText, vertices);
    }

    public String generateGroupVertexDescription(Set<FGVertex> vertices) {
        return GroupedFunctionGraphVertex.generateGroupVertexDescription(vertices);
    }

    public void regroupVertices(FGVertex v) {
        FGViewUpdater updater = this.view.getViewUpdater();
        updater.regroupVertices(this, v);
    }

    public boolean installGroupVertex(GroupedFunctionGraphVertex vertex, Point2D location) {
        FGViewUpdater updater = this.view.getViewUpdater();
        return updater.installGroupVertex(this, vertex, location);
    }

    public void programClosed(Program program) {
        this.clearCacheForProgram(program);
    }

    private void clearCacheForProgram(Program program) {
        for (Function function : this.cache.asMap().keySet()) {
            Program functionProgram = function.getProgram();
            if (functionProgram != program) continue;
            this.cache.invalidate((Object)function);
        }
    }

    private void disposeCache() {
        this.cache.invalidateAll();
    }

    public boolean isSatelliteVisible() {
        return this.view.isSatelliteVisible();
    }

    public boolean isSatelliteDocked() {
        return this.view.isSatelliteDocked();
    }

    public void satelliteProviderShown() {
        if (this.provider.isVisible()) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.provider.setVisible(true));
    }

    public void primaryProviderHidden() {
        this.clear();
    }

    public void setPopupsVisible(boolean visible) {
        this.view.setPopupsVisible(visible);
        this.provider.setPopupsVisible(visible);
    }

    public boolean arePopupsEnabled() {
        return this.view.arePopupsEnabled();
    }

    public FGVertex getFocusedVertex() {
        if (!this.hasResults()) {
            return null;
        }
        return (FGVertex)this.view.getFocusedVertex();
    }

    public Set<FGVertex> getSelectedVertices() {
        if (!this.hasResults()) {
            return null;
        }
        return this.view.getSelectedVertices();
    }

    public boolean hasResults() {
        return this.functionGraphData.hasResults();
    }

    public void requestFocus() {
        this.view.requestFocus();
    }

    public void cleanup() {
        this.clear();
        this.disposeCache();
        this.model.cleanup();
        this.view.cleanup();
    }

    public void setSelection(ProgramSelection selection) {
        this.viewSettings.setSelection(selection);
    }

    public void setHighlight(ProgramSelection highlight) {
        this.viewSettings.setHighlight(highlight);
    }

    public void setGraphPerspective(GraphPerspectiveInfo<FGVertex, FGEdge> info) {
        this.viewSettings.setFunctionGraphPerspectiveInfo(info);
    }

    public FGModel getModel() {
        return this.model;
    }

    public FGView getView() {
        return this.view;
    }

    public void clear() {
        this.model.cancelAll();
        this.viewSettings = new NoFunctionGraphViewSettings();
        if (this.functionGraphData == null || this.functionGraphData.hasResults()) {
            this.doSetFunctionGraphData(new EmptyFunctionGraphData("No Function"));
        }
    }

    public void display(Program program, ProgramLocation location) {
        if (this.viewContainsLocation(location)) {
            this.viewSettings.setLocation(location);
            return;
        }
        if (this.loadCachedGraphData(program, location)) {
            this.viewSettings.setLocation(location);
            return;
        }
        this.doDisplay(program, location, null);
    }

    private boolean viewContainsLocation(ProgramLocation location) {
        return !this.model.isBusy() && this.view.containsLocation(location);
    }

    private boolean loadCachedGraphData(Program program, ProgramLocation location) {
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionContaining(location.getAddress());
        if (function == null) {
            return false;
        }
        FGData cachedFunctionGraphData = (FGData)this.cache.getIfPresent((Object)function);
        if (cachedFunctionGraphData == null) {
            return false;
        }
        this.model.cancelAll();
        this.doSetFunctionGraphData(cachedFunctionGraphData);
        return true;
    }

    private void clearCacheForLocation(Program program, ProgramLocation location) {
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionContaining(location.getAddress());
        if (function != null) {
            this.cache.invalidate((Object)function);
        }
    }

    private void clearCacheForAddress(Program program, Address address) {
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionContaining(address);
        if (function != null) {
            this.cache.invalidate((Object)function);
        }
    }

    public void rebuildDisplay(Program program, ProgramLocation programLocation, boolean maintainPerspective) {
        if (program == null || programLocation == null) {
            this.clear();
            return;
        }
        this.clearCacheForLocation(program, programLocation);
        this.model.reset();
        GraphPerspectiveInfo<FGVertex, FGEdge> perspective = null;
        if (maintainPerspective) {
            perspective = this.getGraphPerspective(programLocation);
        }
        this.doDisplay(program, programLocation, perspective);
    }

    public void rebuildCurrentDisplay() {
        this.provider.refreshAndKeepPerspective();
    }

    public void resetGraph() {
        if (!this.functionGraphData.hasResults()) {
            return;
        }
        this.view.clearUserLayoutSettings();
        Function function = this.functionGraphData.getFunction();
        ProgramLocation location = new ProgramLocation(function.getProgram(), function.getEntryPoint());
        this.rebuildDisplay(function.getProgram(), location, false);
        ProgramLocation externalLocation = this.plugin.getProgramLocation();
        if (!externalLocation.getAddress().equals((Object)location.getAddress())) {
            this.provider.graphLocationChanged(location);
        }
    }

    private void doDisplay(Program program, ProgramLocation location, GraphPerspectiveInfo<FGVertex, FGEdge> perspective) {
        this.model.graphFunction(program, location);
        this.view.setStatusMessage("Graphing function for address: " + location.getAddress());
        this.viewSettings = new PendingFunctionGraphViewSettings(this.viewSettings, perspective);
        this.viewSettings.setLocation(location);
    }

    public void optionsChanged() {
        this.view.optionsChanged();
    }

    public void refreshDisplayWithoutRebuilding() {
        this.view.refreshDisplayWithoutRebuilding();
    }

    public void refreshDisplayForAddress(Address address) {
        this.view.refreshDisplayForAddress(address);
    }

    public Program getProgram() {
        return this.provider.getProgram();
    }

    public FGData getFunctionGraphData() {
        return this.functionGraphData;
    }

    public Function getGraphedFunction() {
        if (this.functionGraphData != null && !this.model.isBusy()) {
            return this.functionGraphData.getFunction();
        }
        return null;
    }

    public JComponent getViewComponent() {
        return this.view.getViewComponent();
    }

    public void changeLayout(FGLayoutProvider newLayout) {
        String newLayoutName;
        FGLayoutProvider previousLayout = (FGLayoutProvider)this.view.getLayoutProvider();
        this.view.setLayoutProvider(newLayout);
        if (previousLayout == null) {
            this.provider.refreshAndResetPerspective();
            return;
        }
        String previousLayoutName = previousLayout.getLayoutName();
        if (previousLayoutName.equals(newLayoutName = newLayout.getLayoutName())) {
            this.view.relayout();
        } else {
            this.provider.refreshAndResetPerspective();
        }
    }

    public FGLayoutProvider getLayoutProvider() {
        return (FGLayoutProvider)this.view.getLayoutProvider();
    }

    public void showFormatChooser() {
        FGVertex vertex = (FGVertex)this.view.getFocusedVertex();
        if (vertex == null) {
            vertex = this.view.getEntryPointVertex();
        }
        PluginTool tool = this.plugin.getTool();
        SetFormatDialogComponentProvider setFormatDialog = new SetFormatDialogComponentProvider(this.getDefaultFormatManager(), this.minimalFormatManager, (ServiceProvider)tool, this.provider.getProgram(), vertex.getAddresses());
        tool.showDialog((DialogComponentProvider)setFormatDialog);
        FormatManager newFormatManager = setFormatDialog.getNewFormatManager();
        if (newFormatManager == null) {
            return;
        }
        SaveState saveState = new SaveState();
        newFormatManager.saveState(saveState);
        this.minimalFormatManager.readState(saveState);
        this.plugin.setUserDefinedFormat(this.minimalFormatManager);
        this.view.repaint();
    }

    public void showXRefsDialog() {
        PluginTool tool = this.plugin.getTool();
        Program program = this.plugin.getCurrentProgram();
        List<Reference> references = this.getXReferencesToGraph();
        XRefChooserDialog chooserDialog = new XRefChooserDialog(references, program, (ServiceProvider)tool);
        tool.showDialog((DialogComponentProvider)chooserDialog, (ComponentProvider)this.provider);
        Reference reference = chooserDialog.getSelectedReference();
        if (reference == null) {
            return;
        }
        this.internalGoTo(new ProgramLocation(program, reference.getFromAddress()), program);
    }

    private List<Reference> getXReferencesToGraph() {
        Program program = this.plugin.getCurrentProgram();
        Function function = this.getGraphedFunction();
        ReferenceManager referenceManager = program.getReferenceManager();
        Address entryPoint = function.getEntryPoint();
        ArrayList<Reference> references = new ArrayList<Reference>();
        ReferenceIterator referencesIterator = referenceManager.getReferencesTo(entryPoint);
        while (referencesIterator.hasNext()) {
            Reference reference = referencesIterator.next();
            references.add(reference);
        }
        return references;
    }

    public void setVertexHoverPathHighlightMode(PathHighlightMode edgeHoverMode) {
        this.view.setVertexHoverPathHighlightMode(edgeHoverMode);
    }

    public void setVertexFocusPathHighlightMode(PathHighlightMode edgeFocusMode) {
        this.view.setVertexFocusPathHighlightMode(edgeFocusMode);
    }

    public PathHighlightMode getVertexHoverPathHighlightMode() {
        return this.view.getVertexHoverPathHighlightMode();
    }

    public PathHighlightMode getVertexFocusPathHighlightMode() {
        return this.view.getVertexFocusPathHighlightMode();
    }

    public GraphPerspectiveInfo<FGVertex, FGEdge> getGraphPerspective(ProgramLocation location) {
        if (this.model.isBusy() || !this.hasResults()) {
            return GraphPerspectiveInfo.createInvalidGraphPerspectiveInfo();
        }
        if (location == null) {
            return GraphPerspectiveInfo.createInvalidGraphPerspectiveInfo();
        }
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        FGVertex vertex = graph.getVertexForAddress(location.getAddress());
        if (vertex == null) {
            return GraphPerspectiveInfo.createInvalidGraphPerspectiveInfo();
        }
        return this.view.generateGraphPerspective();
    }

    public boolean isScaledPastInteractionThreshold() {
        return this.view.isScaledPastInteractionThreshold();
    }

    public void invalidateAllCacheForProgram(Program program) {
        this.clearCacheForProgram(program);
        this.view.setGraphViewStale(true);
    }

    public void invalidateCacheForAddresses(AddressSet addresses) {
        Function currentFunction = this.functionGraphData.getFunction();
        if (currentFunction == null) {
            return;
        }
        AddressSetView body = currentFunction.getBody();
        if (addresses.intersects(body)) {
            this.view.setGraphViewStale(true);
        }
        Program program = currentFunction.getProgram();
        AddressIterator iterator = addresses.getAddresses(true);
        while (iterator.hasNext()) {
            Address address = iterator.next();
            this.clearCacheForAddress(program, address);
        }
    }

    public void setFunctionGraphData(FGData data) {
        if (!data.hasResults()) {
            if (this.reuseCurrentGraph(data)) {
                return;
            }
        } else {
            this.cache.put((Object)data.getFunction(), (Object)data);
        }
        this.doSetFunctionGraphData(data);
    }

    private boolean reuseCurrentGraph(FGData data) {
        if (this.functionGraphData == null || !this.functionGraphData.hasResults()) {
            return false;
        }
        this.view.setStatusMessage(data.getMessage());
        this.viewSettings = new CurrentFunctionGraphViewSettings(this.view, this.viewSettings);
        return true;
    }

    private void doSetFunctionGraphData(FGData data) {
        this.saveGraphSettingsForCurrentFunction();
        FGData oldData = this.functionGraphData;
        this.functionGraphData = data;
        this.view.setViewData(data);
        this.disposeIfNotInCache(oldData);
        this.restoreGraphSettingsForNewFunction();
        this.viewSettings = new CurrentFunctionGraphViewSettings(this.view, this.viewSettings);
        this.provider.functionGraphDataChanged();
    }

    private boolean disposeIfNotInCache(FGData data) {
        Function function = data.getFunction();
        if (function != null && this.cache.getIfPresent((Object)function) != data) {
            data.dispose();
            this.fgDataDisposeListener.accept(data, false);
            return true;
        }
        return false;
    }

    private void restoreGraphSettingsForNewFunction() {
        if (this.functionGraphData == null || !this.functionGraphData.hasResults()) {
            return;
        }
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        graph.restoreSettings();
    }

    private void saveGraphSettingsForCurrentFunction() {
        if (this.functionGraphData == null || !this.functionGraphData.hasResults() || this.isSnapshot()) {
            return;
        }
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        graph.saveSettings();
    }

    private boolean isSnapshot() {
        return !this.provider.isConnected();
    }

    public void zoomOutGraph() {
        this.view.zoomOutGraph();
    }

    public void zoomInGraph() {
        this.view.zoomInGraph();
    }

    public void zoomToVertex(FGVertex v) {
        this.view.zoomToVertex(v);
    }

    public void zoomToWindow() {
        this.view.zoomToWindow();
    }

    public void setVertexViewMode(FGVertex vertex, boolean maximized) {
        this.view.setViewMode(vertex, maximized);
        this.minimalFormatManager.update();
    }

    public void repaint() {
        this.view.repaint();
    }

    public PluginTool getTool() {
        return this.provider.getTool();
    }

    public FGProvider getProvider() {
        return this.provider;
    }

    public Point getViewerPointFromVertexPoint(FGVertex vertex, Point point) {
        return this.view.translatePointFromVertexToViewSpace(vertex, point);
    }

    public Rectangle translateRectangleFromVertexToViewSpace(FGVertex vertex, Rectangle rectangle) {
        return this.view.translateRectangleFromVertexToViewSpace(vertex, rectangle);
    }

    public MouseEvent translateMouseEventFromVertexToViewSpace(FGVertex vertex, MouseEvent event) {
        return this.view.translateMouseEventFromVertexToViewSpace(vertex, event);
    }

    public ButtonPressedListener getSharedHighlighterButtonPressedListener() {
        return this.lazilyCreateSharedHighlightProvider();
    }

    public StringSelectionListener getSharedStringSelectionListener() {
        return this.sharedStringSelectionListener;
    }

    public FunctionGraphOptions getFunctionGraphOptions() {
        return this.functionGraphOptions;
    }

    public Color getMostRecentColor() {
        FGColorProvider colorProvider = this.plugin.getColorProvider();
        return colorProvider.getMostRecentColor();
    }

    public List<Color> getRecentColors() {
        FGColorProvider colorProvider = this.plugin.getColorProvider();
        return colorProvider.getRecentColors();
    }

    public void saveVertexColors(FGVertex vertex, FunctionGraphVertexAttributes settings) {
        FGColorProvider colorProvider = this.plugin.getColorProvider();
        colorProvider.saveVertexColors(vertex, settings);
    }

    public void restoreVertexColors(FGVertex vertex, FunctionGraphVertexAttributes settings) {
        FGColorProvider colorProvider = this.plugin.getColorProvider();
        colorProvider.loadVertexColors(vertex, settings);
    }

    public void removeColor(FGVertex vertex) {
        FunctionGraph graph = this.functionGraphData.getFunctionGraph();
        graph.clearVertexColor(vertex);
    }

    public FGColorProvider getColorProvider() {
        return this.plugin.getColorProvider();
    }

    public void synchronizeProgramLocationAfterEdit() {
        this.viewSettings.setLocation(this.provider.getLocation());
    }

    public void synchronizeProgramLocationToVertex(ProgramLocation location) {
        ProgramLocation viewSettingsLocation = this.viewSettings.getLocation();
        if (SystemUtilities.isEqual((Object)viewSettingsLocation, (Object)location)) {
            return;
        }
        this.handleLocationChangedFromVertex(location);
    }

    public void internalGoTo(ProgramLocation programLocation, Program program) {
        this.provider.internalGoTo(programLocation, program);
    }

    private Cache<Function, FGData> buildCache(RemovalListener<Function, FGData> listener) {
        return CacheBuilder.newBuilder().maximumSize(5L).removalListener(listener).build();
    }

    void setCache(Cache<Function, FGData> cache) {
        this.cache.invalidateAll();
        this.cache = cache;
    }

    void cacheValueRemoved(RemovalNotification<Function, FGData> notification) {
        this.disposeGraphDataIfNotInUse((FGData)notification.getValue());
    }

    void setFGDataDisposedListener(BiConsumer<FGData, Boolean> listener) {
        this.fgDataDisposeListener = listener != null ? listener : (data, evicted) -> {};
    }

    private static class FgHighlightProvider
    implements ListingHighlightProvider,
    ButtonPressedListener {
        private ListingMiddleMouseHighlightProvider highlighter;

        FgHighlightProvider(PluginTool tool, Component repaintComponent) {
            this.highlighter = new ListingMiddleMouseHighlightProvider(tool, repaintComponent);
        }

        public Highlight[] createHighlights(String text, ListingField field, int cursorTextOffset) {
            return this.highlighter.createHighlights(text, field, cursorTextOffset);
        }

        public void buttonPressed(ProgramLocation location, FieldLocation fieldLocation, ListingField field, MouseEvent event) {
            this.highlighter.buttonPressed(location, fieldLocation, field, event);
        }
    }
}

