/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.util.PseudoInstruction;
import ghidra.pcode.emu.AbstractPcodeMachine;
import ghidra.pcode.emu.DisassemblerContextAdapter;
import ghidra.pcode.emu.InstructionDecoder;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.SleighInstructionDecoder;
import ghidra.pcode.emu.ThreadPcodeExecutorState;
import ghidra.pcode.exec.AccessPcodeExecutionException;
import ghidra.pcode.exec.AnnotatedPcodeUseropLibrary;
import ghidra.pcode.exec.InjectionErrorPcodeExecutionException;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutionException;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.exec.SuspendedPcodeExecutionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.util.ProgramContextImpl;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DefaultPcodeThread<T>
implements PcodeThread<T> {
    private final String name;
    private final AbstractPcodeMachine<T> machine;
    protected final SleighLanguage language;
    protected final PcodeArithmetic<T> arithmetic;
    protected final ThreadPcodeExecutorState<T> state;
    protected final InstructionDecoder decoder;
    protected final PcodeUseropLibrary<T> library;
    protected final PcodeThreadExecutor<T> executor;
    protected final Register pc;
    protected final Register contextreg;
    private Address counter;
    private RegisterValue context;
    protected Instruction instruction;
    protected PcodeFrame frame;
    protected final ProgramContextImpl defaultContext;
    protected final Map<Address, PcodeProgram> injects = new HashMap<Address, PcodeProgram>();

    public DefaultPcodeThread(String name, AbstractPcodeMachine<T> machine) {
        this.name = name;
        this.machine = machine;
        this.language = machine.language;
        this.arithmetic = machine.arithmetic;
        PcodeExecutorState<T> sharedState = machine.getSharedState();
        PcodeExecutorState<T> localState = machine.createLocalState(this);
        this.state = new ThreadPcodeExecutorState<T>(sharedState, localState);
        this.decoder = this.createInstructionDecoder(sharedState);
        this.library = this.createUseropLibrary();
        this.executor = this.createExecutor();
        this.pc = Objects.requireNonNull(this.language.getProgramCounter(), "Language has no program counter");
        this.contextreg = this.language.getContextBaseRegister();
        if (this.contextreg != Register.NO_CONTEXT) {
            this.defaultContext = new ProgramContextImpl((Language)this.language);
            this.language.applyContextSettings((DefaultProgramContext)this.defaultContext);
            this.context = this.defaultContext.getDefaultDisassemblyContext();
        } else {
            this.defaultContext = null;
        }
        this.reInitialize();
    }

    protected SleighInstructionDecoder createInstructionDecoder(PcodeExecutorState<T> sharedState) {
        return new SleighInstructionDecoder((Language)this.language, sharedState);
    }

    protected PcodeUseropLibrary<T> createUseropLibrary() {
        return new PcodeEmulationLibrary(this).compose(this.machine.library);
    }

    protected PcodeThreadExecutor<T> createExecutor() {
        return new PcodeThreadExecutor(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractPcodeMachine<T> getMachine() {
        return this.machine;
    }

    @Override
    public void setCounter(Address counter) {
        this.counter = counter;
    }

    @Override
    public Address getCounter() {
        return this.counter;
    }

    protected void branchToAddress(Address target) {
        this.writeCounter(target);
        this.decoder.branched(this.counter);
    }

    protected void writeCounter(Address counter) {
        this.setCounter(counter);
        this.state.setVar(this.pc, this.arithmetic.fromConst(counter.getAddressableWordOffset(), this.pc.getMinimumByteSize()));
    }

    @Override
    public void overrideCounter(Address counter) {
        this.writeCounter(counter);
    }

    @Override
    public void assignContext(RegisterValue context) {
        if (!context.getRegister().isProcessorContext()) {
            throw new IllegalArgumentException("context must be the contextreg value");
        }
        this.context = this.context.assign(context.getRegister(), context);
    }

    @Override
    public RegisterValue getContext() {
        return this.context;
    }

    @Override
    public void overrideContext(RegisterValue context) {
        this.assignContext(context);
        this.state.setVar(this.contextreg, this.arithmetic.fromConst(this.context.getUnsignedValueIgnoreMask(), this.contextreg.getMinimumByteSize(), true));
    }

    @Override
    public void overrideContextWithDefault() {
        RegisterValue defaultValue;
        if (this.contextreg != Register.NO_CONTEXT && (defaultValue = this.defaultContext.getDefaultValue(this.contextreg, this.counter)) != null) {
            this.overrideContext(defaultValue);
        }
    }

    protected void doPluggableInitialization() {
        if (this.machine.initializer != null) {
            this.machine.initializer.initializeThread(this);
        }
    }

    @Override
    public void reInitialize() {
        long offset = this.arithmetic.toLong(this.state.getVar(this.pc, PcodeExecutorStatePiece.Reason.RE_INIT), PcodeArithmetic.Purpose.BRANCH);
        this.setCounter(this.language.getDefaultSpace().getAddress(offset, true));
        if (this.contextreg != Register.NO_CONTEXT) {
            try {
                BigInteger ctx = this.arithmetic.toBigInteger(this.state.getVar(this.contextreg, PcodeExecutorStatePiece.Reason.RE_INIT), PcodeArithmetic.Purpose.CONTEXT);
                this.assignContext(new RegisterValue(this.contextreg, ctx));
            }
            catch (AccessPcodeExecutionException e) {
                Msg.info((Object)this, (Object)"contextreg not recorded in trace. This is pretty normal.");
            }
        }
        this.doPluggableInitialization();
    }

    @Override
    public void stepInstruction() {
        PcodeProgram inj = this.getInject(this.counter);
        if (inj != null) {
            this.instruction = null;
            try {
                this.executor.execute(inj, this.library);
            }
            catch (PcodeExecutionException e) {
                this.frame = e.getFrame();
                throw e;
            }
        } else {
            this.executeInstruction();
        }
    }

    @Override
    public void stepPcodeOp() {
        if (this.frame == null) {
            this.beginInstructionOrInject();
        } else if (!this.frame.isFinished()) {
            this.executor.step(this.frame, this.library);
        } else {
            this.advanceAfterFinished();
        }
    }

    @Override
    public void skipPcodeOp() {
        if (this.frame == null) {
            this.beginInstructionOrInject();
        } else if (!this.frame.isFinished()) {
            this.executor.skip(this.frame);
        } else {
            this.advanceAfterFinished();
        }
    }

    @Override
    public void stepPatch(String sleigh) {
        PcodeProgram prog = ((AbstractPcodeMachine)this.getMachine()).compileSleigh("patch", sleigh + ";");
        this.executor.execute(prog, this.library);
    }

    protected void beginInstructionOrInject() {
        PcodeProgram inj = this.getInject(this.counter);
        if (inj != null) {
            this.instruction = null;
            this.frame = this.executor.begin(inj);
        } else {
            this.instruction = this.decoder.decodeInstruction(this.counter, this.context);
            PcodeProgram pcode = PcodeProgram.fromInstruction(this.instruction);
            this.frame = this.executor.begin(pcode);
        }
    }

    protected RegisterValue getContextAfterCommits() {
        PseudoInstruction pins = (PseudoInstruction)this.instruction;
        try {
            SleighParserContext parserCtx = (SleighParserContext)pins.getParserContext();
            var procCtx = new DisassemblerContextAdapter(){
                RegisterValue ctxVal;
                {
                    this.ctxVal = new RegisterValue(DefaultPcodeThread.this.language.getContextBaseRegister());
                }

                @Override
                public void setFutureRegisterValue(Address address, RegisterValue value) {
                    if (!value.getRegister().isProcessorContext()) {
                        return;
                    }
                    if (!address.equals((Object)DefaultPcodeThread.this.counter)) {
                        Msg.warn((Object)this, (Object)"Context applied somewhere other than the counter.");
                        return;
                    }
                    this.ctxVal = this.ctxVal.assign(value.getRegister(), value);
                }
            };
            parserCtx.applyCommits((ProcessorContext)procCtx);
            return procCtx.ctxVal;
        }
        catch (MemoryAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void advanceAfterFinished() {
        if (this.instruction == null) {
            this.frame = null;
            return;
        }
        if (this.frame.isFallThrough()) {
            this.overrideCounter(this.counter.addWrap((long)this.decoder.getLastLengthWithDelays()));
        }
        if (this.contextreg != Register.NO_CONTEXT) {
            RegisterValue ctx = new RegisterValue(this.contextreg, BigInteger.ZERO).combineValues(this.defaultContext.getDefaultValue(this.contextreg, this.counter)).combineValues(this.defaultContext.getFlowValue(this.context)).combineValues(this.getContextAfterCommits());
            this.overrideContext(ctx);
        }
        this.postExecuteInstruction();
        this.frame = null;
        this.instruction = null;
    }

    @Override
    public PcodeFrame getFrame() {
        return this.frame;
    }

    @Override
    public Instruction getInstruction() {
        return this.instruction;
    }

    protected void assertCompletedInstruction() {
        if (this.frame != null) {
            throw new IllegalStateException("The current instruction or inject has not finished.");
        }
    }

    protected void assertMidInstruction() {
        if (this.frame == null) {
            throw new IllegalStateException("There is no current instruction to finish.");
        }
    }

    protected void preExecuteInstruction() {
    }

    protected void postExecuteInstruction() {
    }

    protected boolean onMissingUseropDef(PcodeOp op, String opName) {
        return false;
    }

    @Override
    public void executeInstruction() {
        this.assertCompletedInstruction();
        this.instruction = this.decoder.decodeInstruction(this.counter, this.context);
        PcodeProgram insProg = PcodeProgram.fromInstruction(this.instruction);
        this.preExecuteInstruction();
        try {
            this.frame = this.executor.execute(insProg, this.library);
        }
        catch (PcodeExecutionException e) {
            this.frame = e.getFrame();
            throw e;
        }
        this.advanceAfterFinished();
    }

    @Override
    public void finishInstruction() {
        this.assertMidInstruction();
        this.executor.finish(this.frame, this.library);
        this.advanceAfterFinished();
    }

    @Override
    public void skipInstruction() {
        this.assertCompletedInstruction();
        this.instruction = this.decoder.decodeInstruction(this.counter, this.context);
        this.overrideCounter(this.counter.addWrap((long)this.decoder.getLastLengthWithDelays()));
    }

    @Override
    public void dropInstruction() {
        this.frame = null;
    }

    @Override
    public void run() {
        this.executor.suspended = false;
        if (this.frame != null) {
            this.finishInstruction();
        }
        while (true) {
            this.stepInstruction();
        }
    }

    @Override
    public void setSuspended(boolean suspended) {
        this.executor.suspended = suspended;
    }

    @Override
    public boolean isSuspended() {
        return this.executor.suspended;
    }

    @Override
    public SleighLanguage getLanguage() {
        return this.language;
    }

    @Override
    public PcodeArithmetic<T> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public PcodeExecutor<T> getExecutor() {
        return this.executor;
    }

    @Override
    public PcodeUseropLibrary<T> getUseropLibrary() {
        return this.library;
    }

    @Override
    public ThreadPcodeExecutorState<T> getState() {
        return this.state;
    }

    protected PcodeProgram getInject(Address address) {
        PcodeProgram inj = this.injects.get(address);
        if (inj != null) {
            return inj;
        }
        return this.machine.getInject(address);
    }

    @Override
    public void inject(Address address, String source) {
        PcodeProgram pcode = SleighProgramCompiler.compileProgram(this.language, "thread_inject:" + address, source, this.library);
        this.injects.put(address, pcode);
    }

    @Override
    public void clearInject(Address address) {
        this.injects.remove(address);
    }

    @Override
    public void clearAllInjects() {
        this.injects.clear();
    }

    protected void checkLoad(AddressSpace space, T offset, int size) {
        this.machine.checkLoad(space, offset, size);
    }

    protected void checkStore(AddressSpace space, T offset, int size) {
        this.machine.checkStore(space, offset, size);
    }

    protected void swi() {
        this.machine.swi();
    }

    protected void stepped() {
        this.machine.stepped();
    }

    public static class PcodeThreadExecutor<T>
    extends PcodeExecutor<T> {
        volatile boolean suspended = false;
        protected final DefaultPcodeThread<T> thread;

        public PcodeThreadExecutor(DefaultPcodeThread<T> thread) {
            super(thread.language, thread.arithmetic, thread.state, PcodeExecutorStatePiece.Reason.EXECUTE_READ);
            this.thread = thread;
        }

        @Override
        public void executeSleigh(String source) {
            PcodeProgram program = SleighProgramCompiler.compileProgram(this.language, "exec", source, this.thread.library);
            this.execute(program, this.thread.library);
        }

        @Override
        public void stepOp(PcodeOp op, PcodeFrame frame, PcodeUseropLibrary<T> library) {
            if (this.suspended || this.thread.machine.suspended) {
                throw new SuspendedPcodeExecutionException(frame, null);
            }
            super.stepOp(op, frame, library);
            this.thread.stepped();
        }

        @Override
        protected void checkLoad(AddressSpace space, T offset, int size) {
            this.thread.checkLoad(space, offset, size);
        }

        @Override
        protected void checkStore(AddressSpace space, T offset, int size) {
            this.thread.checkStore(space, offset, size);
        }

        @Override
        protected void branchToAddress(Address target) {
            this.thread.branchToAddress(target);
        }

        @Override
        protected void onMissingUseropDef(PcodeOp op, PcodeFrame frame, String opName, PcodeUseropLibrary<T> library) {
            if (!this.thread.onMissingUseropDef(op, opName)) {
                super.onMissingUseropDef(op, frame, opName, library);
            }
        }

        public DefaultPcodeThread<T> getThread() {
            return this.thread;
        }
    }

    public static class PcodeEmulationLibrary<T>
    extends AnnotatedPcodeUseropLibrary<T> {
        private final DefaultPcodeThread<T> thread;

        public PcodeEmulationLibrary(DefaultPcodeThread<T> thread) {
            this.thread = thread;
        }

        @AnnotatedPcodeUseropLibrary.PcodeUserop
        public void emu_exec_decoded() {
            PcodeFrame saved = this.thread.frame;
            this.thread.dropInstruction();
            this.thread.executeInstruction();
            this.thread.frame = saved;
        }

        @AnnotatedPcodeUseropLibrary.PcodeUserop
        public void emu_skip_decoded() {
            PcodeFrame saved = this.thread.frame;
            this.thread.dropInstruction();
            this.thread.skipInstruction();
            this.thread.frame = saved;
        }

        @AnnotatedPcodeUseropLibrary.PcodeUserop
        public void emu_swi() {
            this.thread.swi();
        }

        @AnnotatedPcodeUseropLibrary.PcodeUserop
        public void emu_injection_err() {
            throw new InjectionErrorPcodeExecutionException(null, null);
        }
    }
}

