/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import generic.timer.GhidraSwinglessTimer;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.RepositoryInfo;
import ghidra.framework.protocol.ghidra.TransientProjectManager;
import ghidra.framework.remote.RepositoryHandle;
import ghidra.framework.store.LockException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import utilities.util.FileUtilities;

public class TransientProjectData
extends DefaultProjectData {
    private TransientProjectManager dataMgr;
    final RepositoryInfo repositoryInfo;
    private int instanceUseCount = 0;
    private boolean readyForCleanup = false;
    private boolean timerInitiatedDisposal = false;
    private boolean disposed = false;
    private GhidraSwinglessTimer cleanupTimer;

    TransientProjectData(TransientProjectManager dataMgr, ProjectLocator tmpProjectLocation, RepositoryInfo repositoryInfo, RepositoryAdapter repository) throws IOException, LockException {
        super(tmpProjectLocation, repository, !repositoryInfo.readOnly);
        this.dataMgr = dataMgr;
        this.repositoryInfo = repositoryInfo;
        this.cleanupTimer = new GhidraSwinglessTimer(RepositoryHandle.CLIENT_CHECK_PERIOD, () -> this.cleanup());
        this.cleanupTimer.start();
        Msg.debug((Object)this, (Object)("Created transient project (" + repositoryInfo.toShortString() + "): " + tmpProjectLocation.getProjectDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        GhidraSwinglessTimer ghidraSwinglessTimer = this.cleanupTimer;
        synchronized (ghidraSwinglessTimer) {
            if (!this.isValid() || !this.cleanupTimer.isRunning()) {
                return;
            }
            RepositoryAdapter repository = this.getRepository();
            int handleCount = repository.getOpenFileHandleCount();
            if (this.instanceUseCount != 0 || handleCount != 0) {
                this.readyForCleanup = false;
                if (SystemUtilities.isInTestingMode()) {
                    Msg.debug((Object)this, (Object)("Transient project cleanup (" + this.repositoryInfo.toShortString() + "): Not ready: use-count=" + this.instanceUseCount + " open-handles=" + handleCount));
                }
            } else if (!this.readyForCleanup) {
                this.readyForCleanup = true;
                if (SystemUtilities.isInTestingMode()) {
                    Msg.debug((Object)this, (Object)("Transient project cleanup (" + this.repositoryInfo.toShortString() + "): Ready"));
                }
            } else {
                if (SystemUtilities.isInTestingMode()) {
                    Msg.debug((Object)this, (Object)("Transient project cleanup (" + this.repositoryInfo.toShortString() + "): Dispose"));
                }
                this.timerInitiatedDisposal = true;
                this.stopCleanupTimer();
            }
        }
        if (this.timerInitiatedDisposal) {
            this.forcedDispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValid() {
        GhidraSwinglessTimer ghidraSwinglessTimer = this.cleanupTimer;
        synchronized (ghidraSwinglessTimer) {
            return !this.disposed && !this.timerInitiatedDisposal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean stopCleanupTimer() {
        GhidraSwinglessTimer ghidraSwinglessTimer = this.cleanupTimer;
        synchronized (ghidraSwinglessTimer) {
            if (!this.isValid()) {
                return false;
            }
            this.readyForCleanup = false;
            this.cleanupTimer.stop();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleanupTimer() {
        GhidraSwinglessTimer ghidraSwinglessTimer = this.cleanupTimer;
        synchronized (ghidraSwinglessTimer) {
            this.readyForCleanup = false;
            this.cleanupTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementInstanceUseCount() throws IOException {
        GhidraSwinglessTimer ghidraSwinglessTimer = this.cleanupTimer;
        synchronized (ghidraSwinglessTimer) {
            if (this.disposed) {
                throw new IOException("Remote transient project has been disposed");
            }
            this.readyForCleanup = false;
            this.cleanupTimer.stop();
            ++this.instanceUseCount;
            Msg.debug((Object)this, (Object)("Increased instance count (" + this.repositoryInfo.toShortString() + "): " + this.instanceUseCount));
            this.cleanupTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forcedDispose() {
        GhidraSwinglessTimer ghidraSwinglessTimer = this.cleanupTimer;
        synchronized (ghidraSwinglessTimer) {
            if (this.disposed) {
                return;
            }
            this.stopCleanupTimer();
            this.disposed = true;
            String msgTail = " transient project (" + this.repositoryInfo.toShortString() + "): " + this.getProjectLocator().getProjectDir() + ", URL: " + this.repositoryInfo.getURL();
            if (this.instanceUseCount != 0) {
                Msg.error((Object)this, (Object)("Premature removal of active" + msgTail));
            } else {
                Msg.debug((Object)this, (Object)("Removing idle" + msgTail));
            }
        }
        this.dataMgr.cleanupProjectData(this.repositoryInfo, this);
        super.dispose();
        ProjectLocator locator = this.getProjectLocator();
        FileUtilities.deleteDir((File)locator.getProjectDir());
        locator.getMarkerFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GhidraSwinglessTimer ghidraSwinglessTimer = this.cleanupTimer;
        synchronized (ghidraSwinglessTimer) {
            if (this.instanceUseCount == 0) {
                Msg.error((Object)this, (Object)("Transient project (" + this.repositoryInfo.toShortString() + ") use count has gone negative"));
            } else {
                --this.instanceUseCount;
                Msg.debug((Object)this, (Object)("Reduced instance count on dispose (" + this.repositoryInfo.toShortString() + "): " + this.instanceUseCount));
            }
        }
    }

    @Override
    protected void dispose() {
    }

    @Override
    public URL getSharedProjectURL() {
        return this.repositoryInfo.getURL();
    }

    @Override
    public URL getLocalProjectURL() {
        return null;
    }
}

