/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.ToolUtils;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.FolderLinkContentHandler;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.DefaultLaunchMode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ToolAssociationInfo;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolChestChangeListener;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.project.tool.GhidraToolTemplate;
import ghidra.framework.project.tool.ToolManagerImpl;
import ghidra.framework.project.tool.WorkspaceImpl;
import ghidra.framework.protocol.ghidra.GetUrlContentTypeTask;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.xml.GenericXMLOutputter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jdom.Document;
import util.CollectionUtils;

class ToolServicesImpl
implements ToolServices {
    private static String TOOL_ASSOCIATION_PREFERENCE = "ToolAssociation";
    private static String SEPARATOR = ":";
    private ToolChest toolChest;
    private ToolManagerImpl toolManager;
    private ToolChestChangeListener toolChestChangeListener;
    private Set<ContentHandler<?>> contentHandlers;

    ToolServicesImpl(ToolChest toolChest, ToolManagerImpl toolManager) {
        this.toolChest = toolChest;
        this.toolManager = toolManager;
    }

    void dispose() {
        this.toolChest.removeToolChestChangeListener(this.toolChestChangeListener);
    }

    @Override
    public void closeTool(PluginTool tool) {
        this.toolManager.closeTool(tool);
    }

    @Override
    public File exportTool(ToolTemplate tool) throws FileNotFoundException, IOException {
        File location = this.chooseToolFile(tool);
        if (location == null) {
            return location;
        }
        Object filename = location.getName();
        if (!((String)filename).endsWith(".tool")) {
            filename = (String)filename + ".tool";
        }
        try (FileOutputStream f = new FileOutputStream(location.getParent() + File.separator + (String)filename);){
            BufferedOutputStream bf = new BufferedOutputStream(f);
            Document doc = new Document(tool.saveToXml());
            GenericXMLOutputter xmlout = new GenericXMLOutputter();
            xmlout.output(doc, (OutputStream)bf);
        }
        return location;
    }

    private File chooseToolFile(ToolTemplate tool) {
        GhidraFileChooser fileChooser = this.getFileChooser();
        File exportFile = null;
        while (exportFile == null) {
            int result;
            exportFile = fileChooser.getSelectedFile();
            if (exportFile == null) {
                return null;
            }
            Preferences.setProperty((String)"LastToolExportDirectory", (String)exportFile.getParent());
            if (!exportFile.getName().endsWith(".tool")) {
                exportFile = new File(exportFile.getAbsolutePath() + ".tool");
            }
            if (!exportFile.exists() || (result = OptionDialog.showOptionDialog(null, (String)"Overwrite?", (String)("Overwrite existing file: '" + exportFile.getName() + "'?"), (String)"Overwrite", (int)3)) == 1) continue;
            exportFile = null;
        }
        fileChooser.dispose();
        return exportFile;
    }

    private GhidraFileChooser getFileChooser() {
        GhidraFileChooser newFileChooser = new GhidraFileChooser(null);
        newFileChooser.setFileFilter(new GhidraFileFilter(){

            public boolean accept(File file, GhidraFileChooserModel model) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                return file.getAbsolutePath().toLowerCase().endsWith("tool");
            }

            public String getDescription() {
                return "Tools";
            }
        });
        String exportDir = Preferences.getProperty((String)"LastToolExportDirectory");
        if (exportDir != null) {
            newFileChooser.setCurrentDirectory(new File(exportDir));
        }
        newFileChooser.setTitle("Export Tool");
        newFileChooser.setApproveButtonText("Export");
        return newFileChooser;
    }

    @Override
    public void saveTool(PluginTool tool) {
        boolean toolChanged = tool.hasConfigChanged();
        ToolTemplate template = tool.saveToolToToolTemplate();
        this.toolManager.toolSaved(tool, toolChanged);
        this.toolChest.replaceToolTemplate(template);
        this.toolManager.setWorkspaceChanged((WorkspaceImpl)this.toolManager.getActiveWorkspace());
    }

    @Override
    public ToolChest getToolChest() {
        return this.toolChest;
    }

    private static DefaultLaunchMode getDefaultLaunchMode() {
        DefaultLaunchMode defaultLaunchMode = DefaultLaunchMode.DEFAULT;
        FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
        if (frontEndTool != null) {
            defaultLaunchMode = frontEndTool.getDefaultLaunchMode();
        }
        return defaultLaunchMode;
    }

    private PluginTool defaultLaunch(ToolTemplate template, Function<PluginTool, Boolean> openFunction) {
        DefaultLaunchMode defaultLaunchMode = ToolServicesImpl.getDefaultLaunchMode();
        if (defaultLaunchMode == DefaultLaunchMode.REUSE_TOOL) {
            if (template != null) {
                PluginTool[] defaultToolName = template.getName();
                PluginTool[] pluginToolArray = this.getRunningTools();
                int n = pluginToolArray.length;
                for (int i = 0; i < n; ++i) {
                    PluginTool tool = pluginToolArray[i];
                    if (!tool.getName().equals(defaultToolName) || !openFunction.apply(tool).booleanValue()) continue;
                    return tool;
                }
            }
            for (PluginTool tool : this.getRunningTools()) {
                if (!openFunction.apply(tool).booleanValue()) continue;
                return tool;
            }
        }
        if (template == null) {
            return null;
        }
        Workspace workspace = this.toolManager.getActiveWorkspace();
        PluginTool tool = workspace.runTool(template);
        if (tool == null) {
            return null;
        }
        tool.setVisible(true);
        openFunction.apply(tool);
        return tool;
    }

    @Override
    public PluginTool launchDefaultTool(Collection<DomainFile> domainFiles) {
        if (CollectionUtils.isBlank(domainFiles)) {
            throw new IllegalArgumentException("Domain files cannot be empty");
        }
        ToolTemplate template = this.getDefaultToolTemplate((DomainFile)CollectionUtils.any(domainFiles));
        return this.defaultLaunch(template, t -> t.acceptDomainFiles((DomainFile[])domainFiles.toArray(DomainFile[]::new)));
    }

    @Override
    public PluginTool launchTool(String toolName, Collection<DomainFile> domainFiles) {
        GhidraToolTemplate template = this.findToolChestToolTemplate(toolName);
        if (template == null) {
            return null;
        }
        return this.defaultLaunch(template, t -> {
            if (CollectionUtils.isBlank((Collection)domainFiles)) {
                return true;
            }
            return t.acceptDomainFiles((DomainFile[])domainFiles.toArray(DomainFile[]::new));
        });
    }

    @Override
    public PluginTool launchDefaultToolWithURL(URL ghidraUrl) throws IllegalArgumentException {
        String contentType = this.getContentType(ghidraUrl);
        if (contentType == null) {
            return null;
        }
        ToolTemplate template = this.getDefaultToolTemplate(contentType);
        return this.defaultLaunch(template, t -> t.accept(ghidraUrl));
    }

    @Override
    public PluginTool launchToolWithURL(String toolName, URL ghidraUrl) throws IllegalArgumentException {
        if (!GhidraURL.isLocalProjectURL(ghidraUrl) && !GhidraURL.isServerRepositoryURL(ghidraUrl)) {
            throw new IllegalArgumentException("unsupported URL");
        }
        GhidraToolTemplate template = this.findToolChestToolTemplate(toolName);
        if (template == null) {
            return null;
        }
        Workspace workspace = this.toolManager.getActiveWorkspace();
        PluginTool tool = workspace.runTool(template);
        if (tool != null) {
            tool.setVisible(true);
            tool.accept(ghidraUrl);
        }
        return tool;
    }

    private String getContentType(URL url) throws IllegalArgumentException {
        GetUrlContentTypeTask task = new GetUrlContentTypeTask(url);
        TaskLauncher.launch((Task)task);
        return task.getContentType();
    }

    @Override
    public void setContentTypeToolAssociations(Set<ToolAssociationInfo> infos) {
        for (ToolAssociationInfo info : infos) {
            ContentHandler handler = info.getContentHandler();
            String contentType = handler.getContentType();
            String preferenceKey = this.getToolAssociationPreferenceKey(contentType);
            if (!info.isDefault()) {
                ToolTemplate template = info.getCurrentTemplate();
                String toolName = template.getName();
                Preferences.setProperty((String)preferenceKey, (String)toolName);
            } else {
                Preferences.setProperty((String)preferenceKey, null);
            }
            this.ensureToolIsInToolChest(info.getCurrentTemplate());
        }
        Preferences.store();
    }

    private void ensureToolIsInToolChest(ToolTemplate template) {
        if (template == null) {
            return;
        }
        ToolTemplate existingTemplate = this.toolChest.getToolTemplate(template.getName());
        if (existingTemplate != null) {
            return;
        }
        this.toolChest.addToolTemplate(template);
    }

    @Override
    public Set<ToolAssociationInfo> getContentTypeToolAssociations() {
        HashSet<ToolAssociationInfo> set = new HashSet<ToolAssociationInfo>();
        Set<ContentHandler<?>> handlers = this.getContentHandlers();
        for (ContentHandler<?> contentHandler : handlers) {
            set.add(this.createToolAssociationInfo(contentHandler));
        }
        return set;
    }

    private ToolAssociationInfo createToolAssociationInfo(ContentHandler<?> contentHandler) {
        String contentType = contentHandler.getContentType();
        String defaultToolName = contentHandler.getDefaultToolName();
        String userPreferredToolName = Preferences.getProperty((String)this.getToolAssociationPreferenceKey(contentType), null, (boolean)true);
        if (userPreferredToolName != null) {
            GhidraToolTemplate userDefinedTemplate = this.findToolChestToolTemplate(userPreferredToolName);
            return new ToolAssociationInfo(contentHandler, userPreferredToolName, userDefinedTemplate, this.findDefaultToolTemplate(defaultToolName));
        }
        GhidraToolTemplate defaultToolChestTemplate = this.findToolChestToolTemplate(defaultToolName);
        return new ToolAssociationInfo(contentHandler, defaultToolName, defaultToolChestTemplate, this.findDefaultToolTemplate(defaultToolName));
    }

    @Override
    public ToolTemplate getDefaultToolTemplate(DomainFile domainFile) {
        return this.getDefaultToolTemplate(domainFile.getContentType());
    }

    @Override
    public ToolTemplate getDefaultToolTemplate(String contentType) {
        String toolName = Preferences.getProperty((String)this.getToolAssociationPreferenceKey(contentType), null, (boolean)true);
        if (toolName == null) {
            toolName = this.getDefaultToolAssociation(contentType);
        }
        return this.findToolChestToolTemplate(toolName);
    }

    @Override
    public Set<ToolTemplate> getCompatibleTools(Class<? extends DomainObject> domainClass) {
        ToolTemplate[] toolTemplates;
        HashMap<String, ToolTemplate> nameToTemplateMap = new HashMap<String, ToolTemplate>();
        for (ToolTemplate toolTemplate : toolTemplates = this.toolChest.getToolTemplates()) {
            Class<?>[] types;
            for (Class<? extends DomainObject> clazz : types = toolTemplate.getSupportedDataTypes()) {
                if (!clazz.isAssignableFrom(domainClass)) continue;
                nameToTemplateMap.put(toolTemplate.getName(), toolTemplate);
            }
        }
        Set<ContentHandler<?>> compatibleHandlers = this.getCompatibleContentHandlers(domainClass);
        for (ContentHandler<?> handler : compatibleHandlers) {
            String defaultToolName = handler.getDefaultToolName();
            if (nameToTemplateMap.get(defaultToolName) != null) continue;
            GhidraToolTemplate toolChestTemplate = this.findToolChestToolTemplate(defaultToolName);
            if (toolChestTemplate != null) {
                nameToTemplateMap.put(toolChestTemplate.getName(), toolChestTemplate);
                continue;
            }
            GhidraToolTemplate defaultToolTemplate = this.findDefaultToolTemplate(defaultToolName);
            if (defaultToolTemplate == null) continue;
            nameToTemplateMap.put(defaultToolTemplate.getName(), defaultToolTemplate);
        }
        Set<ToolTemplate> defaultTools = ToolUtils.getAllApplicationTools();
        for (ToolTemplate toolTemplate : defaultTools) {
            Class<?>[] types;
            String toolName = toolTemplate.getName();
            if (nameToTemplateMap.get(toolName) != null) continue;
            for (Class<? extends DomainObject> clazz : types = toolTemplate.getSupportedDataTypes()) {
                if (!clazz.isAssignableFrom(domainClass)) continue;
                nameToTemplateMap.put(toolName, toolTemplate);
            }
        }
        return new HashSet<ToolTemplate>(nameToTemplateMap.values());
    }

    private Set<ContentHandler<?>> getCompatibleContentHandlers(Class<? extends DomainObject> domainClass) {
        HashSet set = new HashSet();
        Set<ContentHandler<?>> handlers = this.getContentHandlers();
        for (ContentHandler<?> contentHandler : handlers) {
            Class<?> handlerDomainClass = contentHandler.getDomainObjectClass();
            if (handlerDomainClass != domainClass) continue;
            set.add(contentHandler);
        }
        return set;
    }

    private String getToolAssociationPreferenceKey(String contentType) {
        return TOOL_ASSOCIATION_PREFERENCE + SEPARATOR + contentType;
    }

    private String getDefaultToolAssociation(String contentType) {
        Set<ContentHandler<?>> handlers = this.getContentHandlers();
        for (ContentHandler<?> contentHandler : handlers) {
            String type = contentHandler.getContentType();
            if (!type.equals(contentType)) continue;
            return contentHandler.getDefaultToolName();
        }
        return null;
    }

    private Set<ContentHandler<?>> getContentHandlers() {
        if (this.contentHandlers != null) {
            return this.contentHandlers;
        }
        this.contentHandlers = new HashSet();
        List instances = ClassSearcher.getInstances(ContentHandler.class);
        for (ContentHandler contentHandler : instances) {
            if (contentHandler instanceof FolderLinkContentHandler) continue;
            String contentType = contentHandler.getContentType();
            if (contentType == null) {
                Msg.error(DomainObjectAdapter.class, (Object)("ContentHandler<?> " + contentHandler.getClass().getName() + " does not specify a content type"));
                continue;
            }
            String toolName = contentHandler.getDefaultToolName();
            if (toolName == null) {
                Msg.error(DomainObjectAdapter.class, (Object)("ContentHandler<?> " + contentHandler.getClass().getName() + " does not specify a default tool"));
                continue;
            }
            this.contentHandlers.add(contentHandler);
        }
        return this.contentHandlers;
    }

    private GhidraToolTemplate findToolChestToolTemplate(String toolName) {
        if (toolName != null) {
            return (GhidraToolTemplate)this.toolChest.getToolTemplate(toolName);
        }
        return null;
    }

    private GhidraToolTemplate findDefaultToolTemplate(String defaultToolName) {
        if (defaultToolName == null) {
            return null;
        }
        Set<ToolTemplate> defaultTools = ToolUtils.getAllApplicationTools();
        for (ToolTemplate toolTemplate : defaultTools) {
            if (!defaultToolName.equals(toolTemplate.getName())) continue;
            return (GhidraToolTemplate)toolTemplate;
        }
        return null;
    }

    private PluginTool[] getSameNamedRunningTools(PluginTool tool) {
        String toolName = tool.getToolName();
        PluginTool[] tools = this.toolManager.getRunningTools();
        ArrayList<PluginTool> toolList = new ArrayList<PluginTool>(tools.length);
        for (PluginTool element : tools) {
            if (!toolName.equals(element.getToolName())) continue;
            toolList.add(element);
        }
        return toolList.toArray(new PluginTool[toolList.size()]);
    }

    @Override
    public PluginTool[] getRunningTools() {
        return this.toolManager.getRunningTools();
    }

    private PluginTool findToolUsingFile(PluginTool[] tools, DomainFile domainFile) {
        PluginTool matchingTool = null;
        block0: for (int toolNum = 0; toolNum < tools.length && matchingTool == null; ++toolNum) {
            DomainFile[] df;
            PluginTool pTool = tools[toolNum];
            for (DomainFile element : df = pTool.getDomainFiles()) {
                if (!domainFile.equals(element)) continue;
                matchingTool = tools[toolNum];
                continue block0;
            }
        }
        return matchingTool;
    }

    @Override
    public boolean canAutoSave(PluginTool tool) {
        return this.toolManager.canAutoSave(tool);
    }
}

