/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.ByteField;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.options.AbstractOptions;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.ClosedException;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class OptionsDB
extends AbstractOptions {
    private static final String PROPERTY_TABLE_NAME = "Property Table";
    private static final Schema PROPERTY_SCHEMA = new Schema(0, (Field)StringField.INSTANCE, "Property Name", new Field[]{StringField.INSTANCE, ByteField.INSTANCE}, new String[]{"Value", "Type"});
    private static final int VALUE_COL = 0;
    private static final int TYPE_COL = 1;
    private Table propertyTable;
    private DomainObjectAdapterDB domainObj;

    OptionsDB(DomainObjectAdapterDB domainObj) {
        super("");
        this.domainObj = domainObj;
        this.propertyTable = domainObj.getDBHandle().getTable(PROPERTY_TABLE_NAME);
    }

    synchronized void performAlterations(Map<String, String> propertyAlterations) throws IOException {
        if (propertyAlterations == null) {
            return;
        }
        if (!super.getOptionNames().isEmpty()) {
            throw new IllegalStateException("property list alterations not permitted");
        }
        for (String oldPath : propertyAlterations.keySet()) {
            this.checkAlterationPath(oldPath, false);
            String newPath = propertyAlterations.get(oldPath);
            this.checkAlterationPath(newPath, true);
            if (newPath != null && this.moveProperties(oldPath, newPath)) continue;
            this.removeProperties(oldPath);
        }
    }

    private void checkAlterationPath(String path, boolean nullIsOK) {
        if (!nullIsOK && path == null) {
            throw new IllegalArgumentException("property alteration old-path may not be null");
        }
        if (path != null && path.endsWith(DELIMITER_STRING)) {
            throw new IllegalArgumentException("property alteration paths must not end with '.': " + path);
        }
    }

    private synchronized boolean moveProperties(String oldPath, String newPath) throws IOException {
        String keyName;
        String keyName2;
        String oldSubListPath = oldPath + ".";
        String newSubListPath = newPath + ".";
        if (this.propertyTable.getRecord((Field)new StringField(newPath)) != null) {
            return false;
        }
        RecordIterator iterator = this.propertyTable.iterator((Field)new StringField(newSubListPath));
        DBRecord rec = iterator.next();
        if (rec != null && (keyName2 = ((StringField)rec.getKeyField()).getString()).startsWith(newSubListPath)) {
            return false;
        }
        ArrayList<DBRecord> list = new ArrayList<DBRecord>();
        rec = this.propertyTable.getRecord((Field)new StringField(oldPath));
        if (rec != null) {
            this.propertyTable.deleteRecord((Field)new StringField(oldPath));
            rec.setKey((Field)new StringField(newPath));
            list.add(rec);
        }
        iterator = this.propertyTable.iterator((Field)new StringField(oldSubListPath));
        while (iterator.hasNext() && (keyName = ((StringField)(rec = iterator.next()).getKeyField()).getString()).startsWith(oldSubListPath)) {
            iterator.delete();
            rec.setKey((Field)new StringField(newSubListPath + keyName.substring(oldSubListPath.length())));
            list.add(rec);
        }
        for (DBRecord updatedRec : list) {
            this.propertyTable.putRecord(updatedRec);
        }
        return true;
    }

    private synchronized void removeProperties(String path) throws IOException {
        String subListPath = path + ".";
        RecordIterator iterator = this.propertyTable.iterator((Field)new StringField(path));
        while (iterator.hasNext()) {
            DBRecord rec = iterator.next();
            String keyName = ((StringField)rec.getKeyField()).getString();
            if (keyName.equals(path)) {
                iterator.delete();
                continue;
            }
            if (!keyName.startsWith(subListPath)) continue;
            iterator.delete();
        }
    }

    public synchronized void removeOption(String propertyName) {
        super.removeOption(propertyName);
        this.removePropertyFromDB(propertyName);
        this.notifyOptionChanged(propertyName, null, null);
    }

    private void removePropertyFromDB(String propertyName) {
        try {
            StringField key = new StringField(propertyName);
            if (this.propertyTable.hasRecord((Field)key)) {
                this.propertyTable.deleteRecord((Field)key);
            }
        }
        catch (IOException e) {
            this.domainObj.dbError(e);
        }
    }

    synchronized void clearCache() {
        for (Option option : this.valueMap.values()) {
            DBOption dbOption = (DBOption)option;
            dbOption.clearCache();
        }
    }

    public synchronized List<String> getOptionNames() {
        HashSet names = new HashSet(this.valueMap.keySet());
        names.addAll(this.aliasMap.keySet());
        try {
            if (this.propertyTable != null) {
                for (DBRecord rec : this.propertyTable) {
                    names.add(rec.getKeyField().getString());
                }
            }
        }
        catch (IOException e) {
            this.domainObj.dbError(e);
        }
        ArrayList<String> optionNames = new ArrayList<String>(names);
        Collections.sort(optionNames);
        return optionNames;
    }

    public synchronized boolean contains(String optionName) {
        if (super.contains(optionName)) {
            return true;
        }
        try {
            if (this.propertyTable != null) {
                for (DBRecord rec : this.propertyTable) {
                    String key = rec.getKeyField().getString();
                    if (!optionName.equals(key)) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            this.domainObj.dbError(e);
        }
        return false;
    }

    private DBRecord getPropertyRecord(String propertyName) {
        if (this.propertyTable == null) {
            return null;
        }
        try {
            return this.propertyTable.getRecord((Field)new StringField(propertyName));
        }
        catch (ClosedException e) {
            return null;
        }
        catch (IOException e) {
            this.domainObj.dbError(e);
            return null;
        }
    }

    private void putRecord(DBRecord rec) {
        try {
            if (this.propertyTable == null) {
                this.propertyTable = this.domainObj.getDBHandle().createTable(PROPERTY_TABLE_NAME, PROPERTY_SCHEMA);
            }
            this.propertyTable.putRecord(rec);
        }
        catch (IOException e) {
            this.domainObj.dbError(e);
        }
    }

    protected Option createRegisteredOption(String optionName, OptionType type, String description, HelpLocation help, Object defaultValue, PropertyEditor editor) {
        return new DBOption(optionName, type, description, help, defaultValue, true, editor);
    }

    protected Option createUnregisteredOption(String optionName, OptionType type, Object defaultValue) {
        DBRecord record;
        if (type == OptionType.NO_TYPE && (record = this.getPropertyRecord(optionName)) != null) {
            type = OptionType.values()[record.getByteValue(1)];
        }
        return new DBOption(optionName, type, null, null, defaultValue, false, null);
    }

    protected boolean notifyOptionChanged(String optionName, Object oldValue, Object newValue) {
        return this.domainObj.propertyChanged(optionName, oldValue, newValue);
    }

    class DBOption
    extends Option {
        private Object value;
        private boolean isCached;

        protected DBOption(String name, OptionType type, String description, HelpLocation help, Object defaultValue, boolean isRegistered, PropertyEditor editor) {
            super(name, type, description, help, defaultValue, isRegistered, editor);
            this.value = null;
            this.isCached = false;
            this.getCurrentValue();
        }

        public Object getCurrentValue() {
            if (!this.isCached) {
                DBRecord rec = OptionsDB.this.getPropertyRecord(this.getName());
                if (rec == null) {
                    this.value = this.getDefaultValue();
                } else {
                    OptionType optionType = OptionType.values()[rec.getByteValue(1)];
                    if (optionType == this.getOptionType()) {
                        this.value = optionType.convertStringToObject(rec.getString(0));
                    } else {
                        Msg.info((Object)((Object)this), (Object)("The type for '" + this.getName() + "' has changed!  Using default value."));
                        this.value = this.getDefaultValue();
                    }
                }
            }
            this.isCached = true;
            return this.value;
        }

        public void doSetCurrentValue(Object newValue) {
            if (SystemUtilities.isEqual((Object)this.getCurrentValue(), (Object)newValue)) {
                return;
            }
            this.value = newValue;
            this.isCached = true;
            if (SystemUtilities.isEqual((Object)newValue, (Object)this.getDefaultValue())) {
                OptionsDB.this.removePropertyFromDB(this.getName());
            } else {
                DBRecord rec = PROPERTY_SCHEMA.createRecord((Field)new StringField(this.getName()));
                OptionType optionType = this.getOptionType();
                rec.setByteValue(1, (byte)optionType.ordinal());
                rec.setString(0, optionType.convertObjectToString(newValue));
                OptionsDB.this.putRecord(rec);
            }
        }

        void clearCache() {
            this.value = null;
            this.isCached = false;
        }
    }
}

