/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.shapes;

import docking.widgets.shapes.Location;
import docking.widgets.shapes.PopupWindowPlacer;
import java.util.Arrays;

public class PopupWindowPlacerBuilder {
    private PopupWindowPlacer head = null;
    private PopupWindowPlacer current = null;

    public PopupWindowPlacer build() {
        return this.head;
    }

    private void add(PopupWindowPlacer next) {
        if (this.current == null) {
            this.head = this.current = next;
        } else {
            this.current.setNext(next);
            this.current = next;
        }
    }

    public PopupWindowPlacerBuilder rightEdge(Location ... minors) {
        return this.edge(Location.RIGHT, minors);
    }

    public PopupWindowPlacerBuilder leftEdge(Location ... minors) {
        return this.edge(Location.LEFT, minors);
    }

    public PopupWindowPlacerBuilder bottomEdge(Location ... minors) {
        return this.edge(Location.BOTTOM, minors);
    }

    public PopupWindowPlacerBuilder topEdge(Location ... minors) {
        return this.edge(Location.TOP, minors);
    }

    public PopupWindowPlacerBuilder edge(Location major, Location ... minors) {
        if (minors.length > 3) {
            throw new IllegalArgumentException("Too many preferred Locations: " + Arrays.toString((Object[])minors));
        }
        for (Location minor : minors) {
            if (major.validMinor(minor)) continue;
            throw new IllegalArgumentException("Preferred Location " + minor + " is not valid for " + major + " edge.");
        }
        if (minors.length == 0) {
            if (major.isHorizontal()) {
                this.add(new PopupWindowPlacer.EdgePopupPlacer(major, Location.BOTTOM, Location.TOP));
            } else {
                this.add(new PopupWindowPlacer.EdgePopupPlacer(major, Location.RIGHT, Location.LEFT));
            }
        } else if (minors.length == 1) {
            if (minors[0] == Location.CENTER) {
                if (major.isHorizontal()) {
                    this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minors[0], Location.BOTTOM));
                    this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minors[0], Location.TOP));
                } else {
                    this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minors[0], Location.RIGHT));
                    this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minors[0], Location.LEFT));
                }
            } else {
                this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minors[0], Location.CENTER));
            }
        } else {
            for (int i = 0; i < minors.length - 1; ++i) {
                this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minors[i], minors[i + 1]));
            }
        }
        return this;
    }

    public PopupWindowPlacerBuilder thenRotateClockwise() {
        if (this.current == null) {
            return this.rotateClockwise(Location.BOTTOM, Location.RIGHT);
        }
        return this.rotateClockwise(this.current.major, this.current.minorBegin);
    }

    public PopupWindowPlacerBuilder rotateClockwise(Location majorBegin, Location minorBegin) {
        Location major = majorBegin;
        Location minor = minorBegin;
        do {
            this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minor, major.clockwise()));
            minor = major;
        } while ((major = major.clockwise()) != majorBegin);
        if (minor != minorBegin) {
            this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minor, minorBegin));
        }
        return this;
    }

    public PopupWindowPlacerBuilder thenRotateCounterClockwise() {
        if (this.current == null) {
            return this.rotateCounterClockwise(Location.RIGHT, Location.BOTTOM);
        }
        return this.rotateCounterClockwise(this.current.major, this.current.minorBegin);
    }

    public PopupWindowPlacerBuilder rotateCounterClockwise(Location majorBegin, Location minorBegin) {
        Location major = majorBegin;
        Location minor = minorBegin;
        do {
            this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minor, major.counterClockwise()));
            minor = major;
        } while ((major = major.counterClockwise()) != majorBegin);
        if (minor != minorBegin) {
            this.add(new PopupWindowPlacer.EdgePopupPlacer(major, minor, minorBegin));
        }
        return this;
    }

    public PopupWindowPlacerBuilder leastOverlapCorner() {
        this.add(new PopupWindowPlacer.LeastOverlapCornerPopupWindowPlacer());
        return this;
    }

    public PopupWindowPlacerBuilder throwsAssertException() {
        this.add(new PopupWindowPlacer.ThrowsAssertExceptionPlacer());
        return this;
    }
}

