/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.ActionContext;
import docking.DefaultActionContext;
import docking.action.ActionContextProvider;
import docking.action.DockingActionIf;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;

public class ActionAdapter
implements Action,
PropertyChangeListener {
    private final DockingActionIf dockingAction;
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private ActionContextProvider contextProvider;
    private Action defaultAction;

    public ActionAdapter(DockingActionIf dockingAction) {
        this(dockingAction, null);
    }

    public ActionAdapter(DockingActionIf dockingAction, ActionContextProvider provider) {
        this.dockingAction = dockingAction;
        this.contextProvider = provider;
        dockingAction.addPropertyChangeListener(this);
    }

    public void setDefaultAction(Action defaultAction) {
        this.defaultAction = defaultAction;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Object getValue(String key) {
        if (key.equals("Name")) {
            return this.dockingAction.getName();
        }
        if (key.equals("ShortDescription")) {
            return this.dockingAction.getDescription();
        }
        if (key.equals("LongDescription")) {
            return this.dockingAction.getDescription();
        }
        if (key.equals("SmallIcon")) {
            return this.getIcon();
        }
        if (key.equals("AcceleratorKey")) {
            return this.dockingAction.getKeyBinding();
        }
        return null;
    }

    private Icon getIcon() {
        if (this.dockingAction.getToolBarData() != null) {
            return this.dockingAction.getToolBarData().getIcon();
        }
        if (this.dockingAction.getMenuBarData() != null) {
            return this.dockingAction.getMenuBarData().getMenuIcon();
        }
        if (this.dockingAction.getPopupMenuData() != null) {
            return this.dockingAction.getPopupMenuData().getMenuIcon();
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.dockingAction.isEnabled();
    }

    @Override
    public void putValue(String key, Object value) {
        System.err.println("PutValue key = " + key + " value = " + value);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setEnabled(boolean b) {
        this.dockingAction.setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionContext context = null;
        if (this.contextProvider != null) {
            context = this.contextProvider.getActionContext(null);
        }
        if (context == null) {
            context = new DefaultActionContext();
            context.setSourceObject(e.getSource());
        }
        if (this.dockingAction.isEnabledForContext(context)) {
            this.dockingAction.actionPerformed(context);
        } else if (this.defaultAction != null) {
            this.defaultAction.actionPerformed(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }
}

