/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class ByteArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_SIZE = 4;
    byte[] bytes = new byte[4];
    int lastNonZeroIndex = -1;

    public void put(int index, byte value) {
        if (value == 0) {
            this.remove(index);
            return;
        }
        if (index >= this.bytes.length) {
            this.adjustArray(Math.max(index + 1, this.bytes.length * 2));
        }
        this.bytes[index] = value;
        if (index > this.lastNonZeroIndex) {
            this.lastNonZeroIndex = index;
        }
    }

    @Override
    public void remove(int index) {
        if (index >= this.bytes.length) {
            return;
        }
        this.bytes[index] = 0;
        if (index == this.lastNonZeroIndex) {
            this.lastNonZeroIndex = this.findLastNonZeroIndex();
        }
        if (this.lastNonZeroIndex < this.bytes.length / 4) {
            this.adjustArray(this.lastNonZeroIndex * 2);
        }
    }

    private int findLastNonZeroIndex() {
        for (int i = this.lastNonZeroIndex; i >= 0; --i) {
            if (this.bytes[i] == 0) continue;
            return i;
        }
        return -1;
    }

    public byte get(int index) {
        if (index < this.bytes.length) {
            return this.bytes[index];
        }
        return 0;
    }

    private void adjustArray(int size) {
        if (size < 4) {
            size = 4;
        }
        byte[] newBytes = new byte[size];
        int len = Math.min(size, this.bytes.length);
        System.arraycopy(this.bytes, 0, newBytes, 0, len);
        this.bytes = newBytes;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastNonZeroIndex;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putByte(toIndex, toCol, this.get(index));
    }
}

