/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class ClassLocation {
    protected static final String CLASS_EXT = ".class";
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected Set<Class<?>> classes = new HashSet();

    ClassLocation() {
    }

    protected abstract void getClasses(Set<Class<?>> var1, TaskMonitor var2) throws CancelledException;

    protected void checkForDuplicates(Set<Class<?>> existingClasses) {
        for (Class<?> c : this.classes) {
            if (!existingClasses.contains(c)) continue;
            this.log.warn(() -> this.generateMessage(c));
        }
    }

    private String generateMessage(Class<?> c) {
        return String.format("Class defined in multiple locations: %s. Keeping class loaded from %s; ignoring class from %s", c, this.toLocation(c), this);
    }

    private String toLocation(Class<?> clazz) {
        String name = clazz.getName();
        String classAsPath = "/" + name.replace('.', '/') + CLASS_EXT;
        URL url = clazz.getResource(classAsPath);
        String urlPath = url.getPath();
        int index = urlPath.indexOf(classAsPath);
        return urlPath.substring(0, index);
    }
}

