/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.FolderNotEmptyException;
import ghidra.framework.store.local.IndexedLocalFileSystem;
import ghidra.framework.store.local.IndexedV1LocalFileSystem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.InvalidNameException;
import ghidra.util.NamingUtilities;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.DuplicateFileException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import utilities.util.FileUtilities;

public class MangledLocalFileSystem
extends LocalFileSystem {
    public static final int MAX_NAME_LENGTH = 60;
    private boolean migrationInProgress = false;

    MangledLocalFileSystem(String rootPath, boolean isVersioned, boolean readOnly, boolean enableAsyncronousDispatching) throws FileNotFoundException {
        super(rootPath, isVersioned, readOnly, enableAsyncronousDispatching);
        if (!readOnly) {
            this.cleanupAfterConstruction();
        }
    }

    MangledLocalFileSystem() {
    }

    @Override
    public int getMaxNameLength() {
        return 60;
    }

    @Override
    protected LocalFileSystem.ItemStorage findItemStorage(String folderPath, String itemName) throws FileNotFoundException {
        File dir = this.getFile(folderPath);
        String storageName = this.mangleName(itemName);
        return new LocalFileSystem.ItemStorage(dir, storageName, folderPath, itemName);
    }

    @Override
    protected LocalFileSystem.ItemStorage allocateItemStorage(String folderPath, String itemName) throws IOException, InvalidNameException {
        LocalFileSystem.ItemStorage itemStorage = this.findItemStorage(folderPath, itemName);
        File pf = new File(itemStorage.dir, itemStorage.storageName + ".prp");
        if (pf.exists()) {
            throw new DuplicateFileException(MangledLocalFileSystem.getPath(folderPath, itemName) + " already exists.");
        }
        this.createFolders(itemStorage.dir, folderPath);
        return itemStorage;
    }

    @Override
    protected void deallocateItemStorage(String folderPath, String itemName) {
    }

    @Override
    public int getItemCount() {
        throw new UnsupportedOperationException("getItemCount");
    }

    @Override
    protected String[] getItemNames(String folderPath, boolean includeHiddenFiles) throws IOException {
        File dir = this.getFile(folderPath);
        File[] dirList = dir.listFiles();
        if (dirList == null) {
            throw new FileNotFoundException("Folder " + folderPath + " not found");
        }
        ArrayList<String> fileList = new ArrayList<String>(dirList.length);
        for (File element : dirList) {
            String name = element.getName();
            if (!name.endsWith(".prp") || !element.isFile()) continue;
            if (!NamingUtilities.isValidMangledName(element.getName())) {
                log.warn("Ignoring property file with bad name: " + element);
                continue;
            }
            int index = name.lastIndexOf(".prp");
            if ((name = this.demangleName(name.substring(0, index))) == null || !includeHiddenFiles && name.startsWith(".ghidra.")) continue;
            fileList.add(name);
        }
        Collections.sort(fileList);
        return fileList.toArray(new String[fileList.size()]);
    }

    @Override
    public synchronized String[] getFolderNames(String folderPath) throws IOException {
        File dir = this.getFile(folderPath);
        File[] dirList = dir.listFiles();
        if (dirList == null) {
            throw new FileNotFoundException("Folder " + folderPath + " not found");
        }
        ArrayList<String> folderList = new ArrayList<String>(dirList.length);
        for (File element : dirList) {
            String name;
            if (!element.isDirectory() || (name = this.demangleName(element.getName())) == null) continue;
            folderList.add(name);
        }
        Collections.sort(folderList);
        return folderList.toArray(new String[folderList.size()]);
    }

    @Override
    public synchronized void createFolder(String parentPath, String folderName) throws InvalidNameException, IOException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.testValidName(parentPath, true);
        this.testValidName(folderName, false);
        String path = MangledLocalFileSystem.getPath(parentPath, folderName);
        File dir = this.getFile(path);
        if (dir.exists()) {
            return;
        }
        this.createFolders(dir, path);
    }

    @Override
    public synchronized void deleteFolder(String folderPath) throws IOException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        if (SEPARATOR.equals(folderPath)) {
            throw new IOException("Root folder may not be deleted");
        }
        File file = this.getFile(folderPath);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            throw new FileNotFoundException(folderPath + " does not exist or is not a directory");
        }
        String[] contents = file.list();
        if (!(contents.length == 0 || contents.length <= 1 && ".properties".equals(contents[0]))) {
            throw new FolderNotEmptyException(folderPath + " is not empty");
        }
        FileUtilities.deleteDir((File)file);
        this.eventManager.folderDeleted(MangledLocalFileSystem.getParentPath(folderPath), MangledLocalFileSystem.getName(folderPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void moveFolder(String parentPath, String folderName, String newParentPath) throws InvalidNameException, IOException {
        boolean success = false;
        try {
            if (this.readOnly) {
                throw new ReadOnlyException();
            }
            this.testValidName(newParentPath, true);
            String folderPath = MangledLocalFileSystem.getPath(parentPath, folderName);
            File folder = this.getFile(folderPath);
            if (!folder.isDirectory()) {
                throw new FileNotFoundException(folderPath + " does not exist or is not a folder");
            }
            String newFolderPath = MangledLocalFileSystem.getPath(newParentPath, folderName);
            File newFolder = this.getFile(newFolderPath);
            if (newFolder.exists()) {
                throw new DuplicateFileException(newFolderPath + " already exists.");
            }
            this.createFolders(this.getFile(newParentPath), newParentPath);
            if (!folder.renameTo(newFolder)) {
                throw new IOException("move failed for unknown reason");
            }
            this.eventManager.folderMoved(parentPath, folderName, newParentPath);
            this.deleteEmptyVersionedFolders(parentPath);
        }
        finally {
            if (!success) {
                this.deleteEmptyVersionedFolders(newParentPath);
            }
        }
    }

    @Override
    public synchronized void renameFolder(String parentPath, String folderName, String newFolderName) throws InvalidNameException, IOException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        this.testValidName(newFolderName, false);
        String folderPath = MangledLocalFileSystem.getPath(parentPath, folderName);
        File folder = this.getFile(folderPath);
        if (!folder.isDirectory()) {
            throw new FileNotFoundException(folderPath + " does not exist or is not a folder");
        }
        String newFolderPath = MangledLocalFileSystem.getPath(parentPath, newFolderName);
        File newFolder = this.getFile(newFolderPath);
        if (newFolder.exists()) {
            throw new DuplicateFileException(newFolderPath + " already exists.");
        }
        if (!folder.renameTo(newFolder)) {
            throw new IOException("Folder may contain files that are in use");
        }
        this.eventManager.folderRenamed(parentPath, folderName, newFolderName);
    }

    private File getFile(String path) throws FileNotFoundException {
        if (this.root == null) {
            throw new FileNotFoundException("Empty read-only file system");
        }
        if (path.charAt(0) != '/') {
            throw new FileNotFoundException("Path names must begin with '/'");
        }
        if (path.length() == 1) {
            return this.root;
        }
        path = this.toSystemDependantSeparator(this.manglePath(path));
        return new File(this.root, path);
    }

    private String manglePath(String path) {
        String[] split;
        if (SEPARATOR.equals(path)) {
            return path;
        }
        StringBuilder buf = new StringBuilder();
        for (String element : split = path.split(SEPARATOR)) {
            buf.append('/');
            buf.append(MangledLocalFileSystem.escapeHiddenDirPrefixChars(element));
        }
        return NamingUtilities.mangle(buf.toString());
    }

    private String mangleName(String name) {
        return NamingUtilities.mangle(MangledLocalFileSystem.escapeHiddenDirPrefixChars(name));
    }

    private String demangleName(String name) {
        return MangledLocalFileSystem.unescapeHiddenDirPrefixChars(NamingUtilities.demangle(name));
    }

    private String toSystemDependantSeparator(String path) {
        int n = path.length();
        StringBuffer sb = new StringBuffer(n - 1);
        for (int i = 1; i < n; ++i) {
            char c = path.charAt(i);
            c = c == '/' ? File.separatorChar : c;
            sb.append(c);
        }
        return sb.toString();
    }

    private void createFolders(File folderDir, String folderPath) throws FileNotFoundException {
        if (folderDir.exists()) {
            return;
        }
        File parentDir = folderDir.getParentFile();
        String parentPath = MangledLocalFileSystem.getParentPath(folderPath);
        this.createFolders(parentDir, parentPath);
        folderDir.mkdir();
        this.eventManager.folderCreated(parentPath, MangledLocalFileSystem.getName(folderPath));
    }

    @Override
    public boolean folderExists(String folderPath) {
        try {
            File file = this.getFile(folderPath);
            return file.isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean migrationInProgress() {
        return this.migrationInProgress;
    }

    public synchronized void convertToIndexedLocalFileSystem() throws IOException {
        if (this.readOnly) {
            throw new IOException("Unable to convert read-only filesystem");
        }
        this.cleanupAfterConstruction();
        File tmpRoot = new File(this.root.getCanonicalFile().getParentFile(), HIDDEN_DIR_PREFIX + "." + this.root.getName());
        if (tmpRoot.exists() || !tmpRoot.mkdir()) {
            throw new IOException("Failed to create data directory: " + tmpRoot);
        }
        IndexedV1LocalFileSystem indexedFs = new IndexedV1LocalFileSystem(tmpRoot.getAbsolutePath(), this.isVersioned, false, false, true);
        this.migrationInProgress = true;
        this.migrateFolder(SEPARATOR, indexedFs);
        indexedFs.dispose();
        for (File f : this.root.listFiles()) {
            File newFile = new File(tmpRoot, f.getName());
            f.renameTo(newFile);
        }
        if (!this.root.delete()) {
            throw new IOException("Failed to remove old root following conversion: " + this.root);
        }
        tmpRoot.renameTo(this.root);
    }

    private void migrateFolder(String folderPath, IndexedLocalFileSystem indexedFs) throws IOException {
        try {
            for (String name : this.getFolderNames(folderPath)) {
                indexedFs.createFolder(folderPath, name);
                this.migrateFolder(MangledLocalFileSystem.getPath(folderPath, name), indexedFs);
            }
            for (String name : this.getItemNames(folderPath)) {
                LocalFolderItem item = this.getItem(folderPath, name);
                indexedFs.migrateItem(item);
            }
            if (!SEPARATOR.equals(folderPath)) {
                File dir = this.getFile(folderPath);
                dir.delete();
            }
        }
        catch (InvalidNameException e) {
            throw new IOException("Unexpected exception", e);
        }
    }
}

