/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import agent.gdb.manager.impl.GdbFrameInfo;
import agent.gdb.manager.parsing.GdbMiParser;
import ghidra.util.Msg;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GdbThreadInfo {
    protected static final Pattern TARGET_ID_LINE_PATTERN0 = Pattern.compile("\\s*Thread 0x(?<addr>[0-9,A-F,a-f]+)\\s+\\(LWP (?<tid>[0-9]+)\\)\\s*");
    protected static final Pattern TARGET_ID_LINE_PATTERN1 = Pattern.compile("\\s*process (?<tid>[0-9]+)\\s*");
    private final String id;
    private final String targetId;
    private final String name;
    private final String state;
    private final String core;
    private final List<GdbFrameInfo> frames;
    private BigInteger addr;
    private Integer tid;

    public static GdbThreadInfo parseInfo(GdbMiParser.GdbMiFieldList info) {
        String id = info.getString("id");
        String targetId = info.getString("target-id");
        String name = info.getString("name");
        String state = info.getString("state");
        String core = info.getString("core");
        Collection<Object> finfo = info.get("frame");
        ArrayList<GdbFrameInfo> frames = new ArrayList<GdbFrameInfo>();
        for (Object object : finfo) {
            if (!(object instanceof GdbMiParser.GdbMiFieldList)) continue;
            frames.add(GdbFrameInfo.parseInfo((GdbMiParser.GdbMiFieldList)object));
        }
        return new GdbThreadInfo(id, targetId, name, state, core, frames);
    }

    GdbThreadInfo(String id, String targetId, String name, String state, String core, List<GdbFrameInfo> frames) {
        this.id = id;
        this.targetId = targetId;
        this.name = name;
        this.frames = frames;
        this.state = state;
        this.core = core;
        Matcher mappingMatcher = TARGET_ID_LINE_PATTERN0.matcher(targetId);
        if (mappingMatcher.matches()) {
            try {
                this.addr = new BigInteger(mappingMatcher.group("addr"), 16);
                this.tid = Integer.parseInt(mappingMatcher.group("tid"));
                return;
            }
            catch (NumberFormatException e) {
                Msg.error((Object)this, (Object)("Could not parse target id: " + targetId), (Throwable)e);
            }
        }
        if ((mappingMatcher = TARGET_ID_LINE_PATTERN1.matcher(targetId)).matches()) {
            try {
                this.tid = Integer.parseInt(mappingMatcher.group("tid"));
            }
            catch (NumberFormatException e) {
                Msg.error((Object)this, (Object)("Could not parse target id: " + targetId), (Throwable)e);
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getTargetId());
    }

    public String toString() {
        return "<GdbThreadInfo id=" + this.getId() + ",target-id=" + this.getTargetId() + ">";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GdbThreadInfo)) {
            return false;
        }
        GdbThreadInfo that = (GdbThreadInfo)obj;
        if (this.getId() != that.getId()) {
            return false;
        }
        return this.getTargetId() == that.getTargetId();
    }

    public String getId() {
        return this.id;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getInferiorName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public String getCore() {
        return this.core;
    }

    public List<GdbFrameInfo> getFrames() {
        return this.frames;
    }

    public BigInteger getAddr() {
        return this.addr;
    }

    public Integer getTid() {
        return this.tid;
    }
}

