/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.evt;

import agent.gdb.manager.GdbCause;
import agent.gdb.manager.GdbState;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.parsing.GdbParsingUtils;

public abstract class AbstractGdbEvent<T>
implements GdbEvent<T> {
    private final T info;
    protected GdbCause cause = GdbCause.Causes.UNCLAIMED;
    protected boolean stolen = false;

    protected AbstractGdbEvent(CharSequence tail) throws GdbParsingUtils.GdbParseError {
        this.info = this.parseInfo(tail);
    }

    protected AbstractGdbEvent(T info) {
        this.info = info;
    }

    protected abstract T parseInfo(CharSequence var1) throws GdbParsingUtils.GdbParseError;

    @Override
    public T getInfo() {
        return this.info;
    }

    @Override
    public void claim(GdbPendingCommand<?> cmd) {
        if (this.cause != GdbCause.Causes.UNCLAIMED) {
            throw new IllegalStateException("Event is already claimed by " + this.cause);
        }
        this.cause = cmd;
    }

    @Override
    public GdbCause getCause() {
        return this.cause;
    }

    @Override
    public void steal() {
        this.stolen = true;
    }

    @Override
    public boolean isStolen() {
        return this.stolen;
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + " " + this.info + " >";
    }

    @Override
    public GdbState newState() {
        return null;
    }
}

