/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memview;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.debug.gui.memview.MemoryBox;
import ghidra.app.plugin.core.debug.gui.memview.MemviewMap;
import ghidra.app.plugin.core.debug.gui.memview.MemviewProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class MemviewPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private static final Color ARROW_COLOR = new GColor("color.debugger.plugin.plugin.memview.arrow");
    private MemviewProvider provider;
    private MemviewMap amap;
    private MemviewMap tmap;
    private List<MemoryBox> boxList = new ArrayList<MemoryBox>();
    private int pressedX;
    private int pressedY;
    private boolean enableDrag = false;
    private boolean ctrlPressed = false;
    private int barWidth = 1000;
    private int barHeight = 500;
    private boolean vertical = false;
    private int currentPixelAddr = -1;
    private int currentPixelTime = -1;
    private Rectangle currentRectangle = null;
    private List<MemoryBox> blist = null;
    private Map<String, MemoryBox> bmap = new HashMap<String, MemoryBox>();
    private TreeSet<Address> addresses = new TreeSet();
    private TreeSet<Long> times = new TreeSet();
    private Address[] addressArray;
    private Long[] timesArray;
    private Map<Long, Set<MemoryBox>> addr2box = new HashMap<Long, Set<MemoryBox>>();
    private Map<Long, Set<MemoryBox>> time2box = new HashMap<Long, Set<MemoryBox>>();
    private static final int LOCATION_BASE_WIDTH = 1;
    private static final int LOCATION_BASE_HEIGHT = 6;
    private static final int LOCATION_ARROW_WIDTH = 3;
    private static final int LOCATION_ARROW_HEIGHT = 9;
    private static final int[] locXs = new int[]{0, -1, -1, -3, 0, 3, 1, 1};
    private static final int[] locYs = new int[]{0, 0, 6, 6, 9, 6, 6, 0};

    public MemviewPanel(MemviewProvider provider) {
        this.provider = provider;
        this.setPreferredSize(new Dimension(this.barWidth, this.barHeight));
        this.setSize(this.getPreferredSize());
        this.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER, 1));
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public Dimension getPreferredSize() {
        int asz = this.amap != null ? (int)this.amap.getSize() : 500;
        int tsz = this.tmap != null ? (int)this.tmap.getSize() : 500;
        int w = this.vertical ? tsz : asz;
        int h = this.vertical ? asz : tsz;
        return new Dimension(w, h);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        Rectangle clip = g.getClipBounds();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        int height = this.getHeight();
        int width = this.getWidth();
        if (this.vertical && clip.height > height || !this.vertical && clip.width > width) {
            this.refresh();
            return;
        }
        g.fillRect(0, 0, width, height);
        for (MemoryBox box : this.boxList) {
            box.render(g, this.vertical);
        }
        if (this.currentPixelAddr >= 0) {
            this.drawArrow(g);
        }
        if (this.currentRectangle != null) {
            this.drawFrame(g);
        }
    }

    private void drawArrow(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.vertical) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, 9);
            g.translate(this.currentPixelAddr, -this.currentPixelTime);
            g2.rotate(Math.PI);
        } else {
            g2.translate(0, -9);
            g.translate(this.currentPixelAddr, this.currentPixelTime);
        }
        g.setColor(ARROW_COLOR);
        g.fillPolygon(locXs, locYs, locXs.length);
        if (this.vertical) {
            g2.rotate(Math.PI);
            g.translate(-this.currentPixelAddr, this.currentPixelTime);
            g2.translate(0, -9);
            g2.rotate(-1.5707963267948966);
        } else {
            g.translate(-this.currentPixelAddr, -this.currentPixelTime);
            g2.translate(0, 9);
        }
    }

    private void drawFrame(Graphics g) {
        int x = this.currentRectangle.x;
        int y = this.currentRectangle.y;
        int w = this.currentRectangle.width;
        int h = this.currentRectangle.height;
        g.setColor(ARROW_COLOR);
        g.fillRect(x - 1, y - 1, 1, h + 2);
        g.fillRect(x - 1, y - 1, w + 2, 1);
        g.fillRect(x + w + 1, y - 1, 1, h + 2);
        g.fillRect(x - 1, y + h + 1, w + 2, 1);
    }

    void initViews() {
        this.setSize(new Dimension(this.vertical ? this.times.size() : this.addresses.size(), this.vertical ? this.addresses.size() : this.times.size()));
        this.amap = new MemviewMap(this.addresses.size(), this.addresses.size());
        this.tmap = new MemviewMap(this.times.size(), this.times.size());
    }

    public void refresh() {
        if (this.amap == null || this.tmap == null) {
            return;
        }
        if (this.vertical) {
            this.amap.createMapping(this.provider.getZoomAmountA());
            this.tmap.createMapping(this.provider.getZoomAmountT());
        } else {
            this.amap.createMapping(this.provider.getZoomAmountA());
            this.tmap.createMapping(this.provider.getZoomAmountT());
        }
        this.updateBoxes();
    }

    void updateBoxes() {
        if (!this.isShowing()) {
            return;
        }
        this.boxList = new ArrayList<MemoryBox>();
        List<MemoryBox> boxes = this.getBoxes();
        if (boxes == null) {
            return;
        }
        for (MemoryBox box : boxes) {
            if (box == null) continue;
            int bound = this.vertical ? this.getHeight() - 1 : this.getWidth() - 1;
            box.setAddressBounds(this.amap, bound);
            bound = this.vertical ? this.getWidth() - 1 : this.getHeight() - 1;
            box.setTimeBounds(this.tmap, bound);
            this.boxList.add(box);
        }
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.ctrlPressed = false;
        this.currentRectangle = null;
        if (e.getButton() == 1) {
            this.enableDrag = true;
            this.pressedX = e.getX();
            this.pressedY = e.getY();
            this.currentPixelAddr = this.vertical ? this.pressedY : this.pressedX;
            this.currentPixelTime = this.vertical ? this.pressedX : this.pressedY;
            this.provider.selectTableEntry(this.getBoxesAt(this.pressedX, this.pressedY));
            this.provider.refresh();
        }
        if (e.getButton() == 2) {
            System.err.println("BUTTON2");
        }
        if (e.getButton() == 3) {
            this.ctrlPressed = true;
            this.enableDrag = true;
            this.pressedX = e.getX();
            this.pressedY = e.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.enableDrag = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.enableDrag = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.enableDrag) {
            if (!this.ctrlPressed) {
                this.provider.goTo(this.pressedX - e.getX(), this.pressedY - e.getY());
            } else {
                this.currentRectangle = new Rectangle(this.pressedX, this.pressedY, e.getX() - this.pressedX, e.getY() - this.pressedY);
                this.provider.selectTableEntry(this.getBoxesIn(this.currentRectangle));
                this.provider.refresh();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void setSelection(Set<MemoryBox> boxes) {
        for (MemoryBox memoryBox : boxes) {
            this.currentPixelAddr = memoryBox.pixAstart;
            this.currentPixelTime = memoryBox.pixTstart;
            this.refresh();
        }
    }

    public String getTitleAnnotation() {
        if (this.currentPixelAddr < 0 || this.addressArray == null) {
            return "";
        }
        String aval = this.getTagForAddr(this.currentPixelAddr);
        String tval = this.getTagForTick(this.currentPixelTime);
        String vals = this.vertical ? tval + ":" + aval : aval + ":" + tval;
        return "curpos=[" + vals + "]";
    }

    public Set<MemoryBox> getBoxesAt(int x, int y) {
        long addr = this.getAddr(x, y);
        long tick = this.getTick(x, y);
        long pos = this.vertical ? (long)x : (long)y;
        HashSet<MemoryBox> matches = new HashSet<MemoryBox>();
        Set<MemoryBox> mboxes = this.addr2box.get(addr);
        if (mboxes != null && tick < (long)this.timesArray.length) {
            for (MemoryBox memoryBox : mboxes) {
                if (!memoryBox.inPixelRange(pos)) continue;
                matches.add(memoryBox);
            }
        }
        return matches;
    }

    public Set<MemoryBox> getBoxesIn(Rectangle r) {
        long startAddr = this.getAddr(r.x, r.y);
        long startTick = this.getTick(r.x, r.y);
        long stopAddr = this.getAddr(r.x + r.width, r.y + r.height);
        long stopTick = this.getTick(r.x + r.width, r.y + r.height);
        HashSet<MemoryBox> matches = new HashSet<MemoryBox>();
        for (long addr = startAddr; addr < stopAddr; ++addr) {
            Set<MemoryBox> mboxes = this.addr2box.get(addr);
            for (MemoryBox memoryBox : mboxes) {
                if (memoryBox.getStartTime() < startTick && memoryBox.getStopTime() > stopTick) continue;
                matches.add(memoryBox);
            }
        }
        return matches;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.amap == null || this.tmap == null) {
            return e.getX() + ":" + e.getY();
        }
        long addr = this.getAddr(e.getX(), e.getY());
        long tick = this.getTick(e.getX(), e.getY());
        String aval = this.getTagForAddr(addr);
        String tval = this.getTagForTick(tick);
        Set<MemoryBox> boxes = this.getBoxesAt(e.getX(), e.getY());
        for (MemoryBox memoryBox : boxes) {
            aval = memoryBox.getId();
        }
        return this.vertical ? tval + ":" + aval : aval + ":" + tval;
    }

    private void parseBoxes(Collection<MemoryBox> boxes) {
        AddressRange range;
        this.addresses.clear();
        this.times.clear();
        this.addr2box.clear();
        this.time2box.clear();
        for (MemoryBox box : boxes) {
            range = box.getRange();
            if (range != null) {
                this.addresses.add(range.getMinAddress());
                this.addresses.add(range.getMaxAddress());
            }
            long start = box.getStart();
            long end = box.getEnd();
            this.times.add(start);
            this.times.add(end);
        }
        this.initViews();
        this.addressArray = new Address[this.addresses.size()];
        this.timesArray = new Long[this.times.size()];
        this.addresses.toArray(this.addressArray);
        this.times.toArray(this.timesArray);
        for (MemoryBox box : boxes) {
            range = box.getRange();
            if (range != null) {
                box.setStartAddress(this.addresses.headSet(range.getMinAddress()).size());
                box.setStopAddress(this.addresses.headSet(range.getMaxAddress()).size());
            }
            box.setStartTime(this.times.headSet(box.getStart()).size());
            box.setStopTime(this.times.headSet(box.getEnd()).size());
            Set<MemoryBox> mboxes = this.addr2box.get(box.getStartAddress());
            if (mboxes == null) {
                mboxes = new HashSet<MemoryBox>();
            }
            mboxes.add(box);
            this.addr2box.put(box.getStartAddress(), mboxes);
            mboxes = this.addr2box.get(box.getStopAddress());
            if (mboxes == null) {
                mboxes = new HashSet<MemoryBox>();
            }
            mboxes.add(box);
            this.addr2box.put(box.getStopAddress(), mboxes);
            mboxes = this.time2box.get(box.getStartTime());
            if (mboxes == null) {
                mboxes = new HashSet<MemoryBox>();
            }
            mboxes.add(box);
            this.time2box.put(box.getStartTime(), mboxes);
            mboxes = this.time2box.get(box.getStopTime());
            if (mboxes == null) {
                mboxes = new HashSet<MemoryBox>();
            }
            mboxes.add(box);
            this.time2box.put(box.getStopTime(), mboxes);
        }
        this.refresh();
    }

    public List<MemoryBox> getBoxes() {
        return this.blist;
    }

    public void setBoxes(List<MemoryBox> boxes) {
        this.blist = boxes;
        for (MemoryBox b : boxes) {
            this.bmap.put(b.getId(), b);
        }
        this.parseBoxes(this.blist);
    }

    public void addBoxes(List<MemoryBox> boxes) {
        if (this.blist == null) {
            this.blist = new ArrayList<MemoryBox>();
        }
        for (MemoryBox b : boxes) {
            if (this.bmap.containsKey(b.getId())) {
                MemoryBox box = this.bmap.get(b.getId());
                this.blist.remove(box);
            }
            this.blist.add(b);
            this.bmap.put(b.getId(), b);
        }
        this.parseBoxes(this.blist);
    }

    public void reset() {
        this.blist = new ArrayList<MemoryBox>();
        this.bmap.clear();
        this.parseBoxes(this.blist);
    }

    void setAddressPixelMap(MemviewMap map) {
        this.amap = map;
    }

    void setTimePixelMap(MemviewMap tmap) {
        this.tmap = tmap;
    }

    public boolean getVerticalMode() {
        return this.vertical;
    }

    public void setVerticalMode(boolean vertical) {
        this.vertical = vertical;
    }

    public long getAddr(int x, int y) {
        if (this.amap == null) {
            return 0L;
        }
        return this.vertical ? this.amap.getOffset(y) : this.amap.getOffset(x);
    }

    public long getTick(int x, int y) {
        if (this.tmap == null) {
            return 0L;
        }
        return this.vertical ? this.tmap.getOffset(x) : this.tmap.getOffset(y);
    }

    public String getTagForAddr(long addr) {
        String aval = "";
        if (0L <= addr && addr < (long)this.addressArray.length) {
            aval = this.addressArray[(int)addr].toString();
        }
        return aval;
    }

    public String getTagForTick(long tick) {
        String tval = "";
        if (0L <= tick && tick < (long)this.timesArray.length) {
            tval = Long.toString(this.timesArray[(int)tick]);
        }
        return tval;
    }

    public void scaleCurrentPixelAddr(double changeAmount) {
        this.currentPixelAddr = (int)((double)this.currentPixelAddr * Math.pow(2.0, changeAmount));
    }

    public void scaleCurrentPixelTime(double changeAmount) {
        this.currentPixelTime = (int)((double)this.currentPixelTime * Math.pow(2.0, changeAmount));
    }
}

