/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerWithOffsetMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class VirtualFunctionTablePointerTypeApplier
extends MsTypeApplier {
    public VirtualFunctionTablePointerTypeApplier(DefaultPdbApplicator applicator, AbstractMsType msType) throws IllegalArgumentException {
        super(applicator, VirtualFunctionTablePointerTypeApplier.validateType(msType));
    }

    @Override
    BigInteger getSize() {
        return BigInteger.valueOf(this.applicator.getDataOrganization().getPointerSize());
    }

    int getOffset() {
        if (this.msType instanceof AbstractVirtualFunctionTablePointerWithOffsetMsType) {
            return ((AbstractVirtualFunctionTablePointerWithOffsetMsType)this.msType).getOffset();
        }
        return 0;
    }

    String getMemberName() {
        return "VFTablePtr" + this.getOffset();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        AbstractMsType abstractMsType = this.msType;
        if (abstractMsType instanceof AbstractVirtualFunctionTablePointerWithOffsetMsType) {
            AbstractVirtualFunctionTablePointerWithOffsetMsType vftPtrWOffset = (AbstractVirtualFunctionTablePointerWithOffsetMsType)abstractMsType;
            this.dataType = this.applyPointer(vftPtrWOffset.getPointerTypeRecordNumber());
        } else {
            abstractMsType = this.msType;
            if (abstractMsType instanceof AbstractVirtualFunctionTablePointerMsType) {
                AbstractVirtualFunctionTablePointerMsType vftPtr = (AbstractVirtualFunctionTablePointerMsType)abstractMsType;
                this.dataType = this.applyPointer(vftPtr.getPointerTypeRecordNumber());
            } else {
                this.dataType = VoidDataType.dataType;
                this.applicator.appendLogMsg("PDB Warning: Type not handled: " + this.msType.getClass().getSimpleName());
            }
        }
    }

    private DataType applyPointer(RecordNumber pointerTypeRecordNumber) {
        MsTypeApplier rawApplier = this.applicator.getTypeApplier(pointerTypeRecordNumber);
        if (rawApplier instanceof PointerTypeApplier) {
            PointerTypeApplier pointerApplier = (PointerTypeApplier)rawApplier;
            return pointerApplier.getDataType();
        }
        this.applicator.appendLogMsg("cannot process " + rawApplier.getClass().getSimpleName() + "for " + this.getClass().getSimpleName());
        return null;
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof AbstractVirtualFunctionTablePointerMsType) && !(type instanceof AbstractVirtualFunctionTablePointerWithOffsetMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + VirtualFunctionTablePointerTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

