/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager;

import agent.frida.manager.FridaError;
import agent.frida.manager.FridaPointer;
import agent.frida.manager.FridaSession;
import agent.frida.manager.FridaTarget;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;

public class FridaProcess
extends FridaPointer {
    private NativeLong pid;
    private String name;
    private FridaSession session;
    private String identifier;

    public FridaProcess(Pointer process, NativeLong pid) {
        super(process);
        this.pid = pid;
    }

    public FridaProcess() {
        super(null);
        this.pid = new NativeLong(-1L);
    }

    public Long getPID() {
        return this.pid.longValue();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FridaSession getSession() {
        return this.session;
    }

    public void setSession(FridaSession session) {
        this.session = session;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public FridaTarget getTarget() {
        return this.session.getTarget();
    }

    public FridaError resume() {
        FridaTarget target = this.getTarget();
        FridaError error = new FridaError();
        target.resumeProcess(this.pid, error);
        return error;
    }

    public FridaError destroy() {
        FridaTarget target = this.getTarget();
        FridaError error = new FridaError();
        target.killProcess(this.pid, error);
        return error;
    }

    public FridaError kill() {
        FridaTarget target = this.getTarget();
        FridaError error = new FridaError();
        target.killProcess(this.pid, error);
        return error;
    }

    public String getDescription() {
        return this.getName();
    }
}

