/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import generic.constraint.DecisionSet;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.constraint.ProgramDecisionTree;
import ghidra.xml.XmlParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Patterns {
    public static final String DEFAULT_PATTERNCONSTRAINTS_XML = "patternconstraints.xml";
    private static final String PATTERN_FILE_NAME_XMLTAG = "patternfile";
    private static final String DATA_PATTERNS_SUBDIR = "data/patterns";

    public static ProgramDecisionTree getPatternDecisionTree() {
        return Patterns.getPatternDecisionTree(DEFAULT_PATTERNCONSTRAINTS_XML);
    }

    public static ProgramDecisionTree getPatternDecisionTree(String patternConstraintsFileName) {
        List patternDirs = Application.findModuleSubDirectories((String)DATA_PATTERNS_SUBDIR);
        List<ResourceFile> patternConstraintFiles = Patterns.findPatternConstraintFiles(patternDirs, patternConstraintsFileName);
        ProgramDecisionTree decisionTree = new ProgramDecisionTree();
        decisionTree.registerPropertyName(PATTERN_FILE_NAME_XMLTAG);
        for (ResourceFile resourceFile : patternConstraintFiles) {
            try {
                decisionTree.loadConstraints(resourceFile);
            }
            catch (Exception e) {
                Msg.showError(Patterns.class, null, (String)"Error Processing Pattern File", (Object)("Error processing pattern file " + resourceFile + "\n" + e.getMessage()));
            }
        }
        return decisionTree;
    }

    public static boolean hasPatternFiles(Program program, ProgramDecisionTree decisionTree) {
        DecisionSet decisionsSet = decisionTree.getDecisionsSet((Object)program, PATTERN_FILE_NAME_XMLTAG);
        return !decisionsSet.isEmpty();
    }

    public static ResourceFile[] findPatternFiles(Program program, ProgramDecisionTree decisionTree) throws FileNotFoundException, IOException, XmlParseException {
        DecisionSet decisionsSet = decisionTree.getDecisionsSet((Object)program, PATTERN_FILE_NAME_XMLTAG);
        List values = decisionsSet.getValues();
        ArrayList<ResourceFile> patternFileList = new ArrayList<ResourceFile>();
        List patternDirs = Application.findModuleSubDirectories((String)DATA_PATTERNS_SUBDIR);
        for (String patternFileName : values) {
            patternFileList.add(Patterns.getPatternFile(patternDirs, patternFileName));
        }
        return patternFileList.toArray(new ResourceFile[patternFileList.size()]);
    }

    private static ResourceFile getPatternFile(List<ResourceFile> patternDirs, String patternFileName) throws FileNotFoundException {
        for (ResourceFile dir : patternDirs) {
            ResourceFile file = new ResourceFile(dir, patternFileName);
            if (!file.exists()) continue;
            return file;
        }
        throw new FileNotFoundException("can't find pattern file: " + patternFileName);
    }

    private static List<ResourceFile> findPatternConstraintFiles(List<ResourceFile> patternDirs, String constraintsFileName) {
        ArrayList<ResourceFile> patternConstraintFiles = new ArrayList<ResourceFile>();
        for (ResourceFile dir : patternDirs) {
            ResourceFile file = new ResourceFile(dir, constraintsFileName);
            if (!file.exists()) continue;
            patternConstraintFiles.add(file);
        }
        return patternConstraintFiles;
    }
}

