/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import java.util.Iterator;

public class CombinedAddressRangeIterator
implements AddressRangeIterator {
    AddressRangeManager manager1;
    AddressRangeManager manager2;

    public CombinedAddressRangeIterator(AddressRangeIterator it1, AddressRangeIterator it2) {
        this.manager1 = new AddressRangeManager(it1);
        this.manager2 = new AddressRangeManager(it2);
    }

    public Iterator<AddressRange> iterator() {
        return this;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.manager1.hasMoreRanges() || this.manager2.hasMoreRanges();
    }

    public AddressRange next() {
        if (!this.manager1.hasMoreRanges()) {
            return this.manager2.getNextRange();
        }
        if (!this.manager2.hasMoreRanges()) {
            return this.manager1.getNextRange();
        }
        int minCompare = this.manager1.compareMin(this.manager2);
        if (minCompare == 0) {
            return this.adjustEndRange();
        }
        if (minCompare > 0) {
            return this.manager2.severMyHeadRange(this.manager1);
        }
        return this.manager1.severMyHeadRange(this.manager2);
    }

    private AddressRange adjustEndRange() {
        int maxCompare = this.manager1.compareMax(this.manager2);
        if (maxCompare == 0) {
            this.manager1.getNextRange();
            return this.manager2.getNextRange();
        }
        if (maxCompare > 0) {
            return this.manager1.severMyHeadAndAdvanceOtherManager(this.manager2);
        }
        return this.manager2.severMyHeadAndAdvanceOtherManager(this.manager1);
    }

    private class AddressRangeManager {
        AddressRangeIterator it;
        AddressRangeImpl range;

        AddressRangeManager(AddressRangeIterator it) {
            this.it = it;
            this.getNextRange();
        }

        public AddressRange severMyHeadRange(AddressRangeManager manager) {
            if (this.range.getMaxAddress().compareTo((Object)manager.range.getMinAddress()) < 0) {
                return this.getNextRange();
            }
            AddressRangeImpl severedRange = new AddressRangeImpl(this.range.getMinAddress(), manager.range.getMinAddress().previous());
            this.range = new AddressRangeImpl(manager.range.getMinAddress(), this.range.getMaxAddress());
            return severedRange;
        }

        public AddressRange severMyHeadAndAdvanceOtherManager(AddressRangeManager manager) {
            Address newMin = manager.range.getMaxAddress().next();
            this.range = new AddressRangeImpl(newMin, this.range.getMaxAddress());
            return manager.getNextRange();
        }

        public int compareMin(AddressRangeManager mgr) {
            return this.range.getMinAddress().compareTo((Object)mgr.range.getMinAddress());
        }

        public int compareMax(AddressRangeManager mgr) {
            return this.range.getMaxAddress().compareTo((Object)mgr.range.getMaxAddress());
        }

        public AddressRange getNextRange() {
            AddressRangeImpl tmpRange = this.range;
            this.range = this.it.hasNext() ? new AddressRangeImpl((AddressRange)this.it.next()) : null;
            return tmpRange;
        }

        public boolean hasMoreRanges() {
            return this.range != null;
        }
    }
}

