/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileHashProvider;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.LocalFileSystemSub;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryIgnore;
import ghidra.formats.gfilesystem.fileinfo.FileAttribute;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.formats.gfilesystem.fileinfo.FileType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.map.ReferenceMap;

@FileSystemInfo(type="file", description="Local filesystem", factory=GFileSystemFactoryIgnore.class)
public class LocalFileSystem
implements GFileSystem,
GFileHashProvider {
    public static final String FSTYPE = "file";
    private final List<GFile> emptyDir = List.of();
    private final FSRLRoot fsFSRL;
    private final FileSystemRefManager refManager = new FileSystemRefManager(this);
    private final ReferenceMap<FileFingerprintRec, String> fileFingerprintToMD5Map = new ReferenceMap();

    public static LocalFileSystem makeGlobalRootFS() {
        return new LocalFileSystem(FSRLRoot.makeRoot(FSTYPE));
    }

    private LocalFileSystem(FSRLRoot fsrl) {
        this.fsFSRL = fsrl;
    }

    boolean isSameFS(FSRL fsrl) {
        return this.fsFSRL.equals(fsrl.getFS());
    }

    public LocalFileSystemSub getSubFileSystem(FSRL fsrl) throws IOException {
        if (this.isLocalSubdir(fsrl)) {
            File localDir = this.getLocalFile(fsrl);
            return new LocalFileSystemSub(localDir, this);
        }
        return null;
    }

    public boolean isLocalSubdir(FSRL fsrl) {
        if (!this.isSameFS(fsrl)) {
            return false;
        }
        File localFile = new File(fsrl.getPath());
        return localFile.isDirectory();
    }

    public File getLocalFile(FSRL fsrl) throws IOException {
        if (!this.isSameFS(fsrl)) {
            throw new IOException("FSRL does not specify local file: " + fsrl);
        }
        File localFile = new File(fsrl.getPath());
        return localFile;
    }

    public FSRL getLocalFSRL(File f) {
        return this.fsFSRL.withPath(FSUtilities.normalizeNativePath(f.getAbsolutePath()));
    }

    @Override
    public String getName() {
        return "Root Filesystem";
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public List<GFile> getListing(GFile directory) {
        ArrayList<GFile> results = new ArrayList<GFile>();
        if (directory == null) {
            for (File f : File.listRoots()) {
                FSRL rootElemFSRL = this.fsFSRL.withPath(FSUtilities.normalizeNativePath(f.getName()));
                results.add(GFileImpl.fromFSRL(this, null, rootElemFSRL, f.isDirectory(), -1L));
            }
        } else {
            File localDir = new File(directory.getPath());
            if (!localDir.isDirectory() || Files.isSymbolicLink(localDir.toPath())) {
                return this.emptyDir;
            }
            File[] files = localDir.listFiles();
            if (files == null) {
                return this.emptyDir;
            }
            for (File f : files) {
                if (!f.isFile() && !f.isDirectory()) continue;
                FSRL newFileFSRL = directory.getFSRL().appendPath(f.getName());
                results.add(GFileImpl.fromFSRL(this, directory, newFileFSRL, f.isDirectory(), f.length()));
            }
        }
        return results;
    }

    @Override
    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        File f = new File(file.getPath());
        return this.getFileAttributes(f);
    }

    public FileAttributes getFileAttributes(File f) {
        Path p = f.toPath();
        FileType fileType = LocalFileSystem.fileToFileType(p);
        Path symLinkDest = null;
        try {
            symLinkDest = fileType == FileType.SYMBOLIC_LINK ? Files.readSymbolicLink(p) : null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FileAttributes.of(FileAttribute.create(FileAttributeType.NAME_ATTR, f.getName()), FileAttribute.create(FileAttributeType.FILE_TYPE_ATTR, fileType), FileAttribute.create(FileAttributeType.SIZE_ATTR, Long.valueOf(f.length())), FileAttribute.create(FileAttributeType.MODIFIED_DATE_ATTR, new Date(f.lastModified())), symLinkDest != null ? FileAttribute.create(FileAttributeType.SYMLINK_DEST_ATTR, symLinkDest.toString()) : null);
    }

    private static FileType fileToFileType(Path p) {
        if (Files.isSymbolicLink(p)) {
            return FileType.SYMBOLIC_LINK;
        }
        if (Files.isDirectory(p, new LinkOption[0])) {
            return FileType.DIRECTORY;
        }
        if (Files.isRegularFile(p, new LinkOption[0])) {
            return FileType.FILE;
        }
        return FileType.UNKNOWN;
    }

    @Override
    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    @Override
    public GFile lookup(String path) throws IOException {
        File f = LocalFileSystem.lookupFile(null, path, null);
        return f != null ? GFileImpl.fromPathString(this, FSUtilities.normalizeNativePath(f.getPath()), null, f.isDirectory(), f.length()) : null;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    @Override
    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException {
        return this.getInputStream(file.getFSRL(), monitor);
    }

    InputStream getInputStream(FSRL fsrl, TaskMonitor monitor) throws IOException {
        return new FileInputStream(this.getLocalFile(fsrl));
    }

    @Override
    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException {
        return this.getByteProvider(file.getFSRL(), monitor);
    }

    ByteProvider getByteProvider(FSRL fsrl, TaskMonitor monitor) throws IOException {
        File f = this.getLocalFile(fsrl);
        return new FileByteProvider(f, fsrl, AccessMode.READ);
    }

    public String toString() {
        return "Local file system " + this.fsFSRL;
    }

    @Override
    public String getMD5Hash(GFile file, boolean required, TaskMonitor monitor) throws CancelledException, IOException {
        return this.getMD5Hash(file.getFSRL(), required, monitor);
    }

    synchronized String getMD5Hash(FSRL fsrl, boolean required, TaskMonitor monitor) throws CancelledException, IOException {
        File f = this.getLocalFile(fsrl);
        if (!f.isFile()) {
            return null;
        }
        FileFingerprintRec fileFingerprintRec = new FileFingerprintRec(f.getPath(), f.lastModified(), f.length());
        String md5 = (String)this.fileFingerprintToMD5Map.get((Object)fileFingerprintRec);
        if (md5 == null && required) {
            md5 = FSUtilities.getFileMD5(f, monitor);
            this.fileFingerprintToMD5Map.put((Object)fileFingerprintRec, (Object)md5);
        }
        return md5;
    }

    public static File lookupFile(File baseDir, String path, Comparator<String> nameComp) {
        File f = new File(baseDir, path = Objects.requireNonNullElse(path, "/"));
        if (!f.isAbsolute()) {
            Msg.debug(LocalFileSystem.class, (Object)("Non-absolute path encountered in LocalFileSystem lookup: " + path));
            f = f.getAbsoluteFile();
        }
        try {
            File canonicalFile;
            if (nameComp == null || f.getParentFile() == null) {
                return f.exists() ? f.getCanonicalFile() : null;
            }
            if (f.exists() && nameComp.compare(path, FSUtilities.normalizeNativePath((canonicalFile = f.getCanonicalFile()).getPath())) == 0) {
                return canonicalFile;
            }
            List<File> pathParts = LocalFileSystem.getFilePathParts(f);
            for (int i = pathParts.size() - 2; i >= 0; --i) {
                File part;
                File parentDir = pathParts.get(i + 1);
                File foundFile = LocalFileSystem.findInDir(parentDir, (part = pathParts.get(i)).getName(), nameComp);
                if (foundFile == null) {
                    return null;
                }
                pathParts.set(i, foundFile);
            }
            return pathParts.get(0);
        }
        catch (IOException e) {
            Msg.warn(LocalFileSystem.class, (Object)("Error resolving path: " + path), (Throwable)e);
            return null;
        }
    }

    static File findInDir(File dir, String name, Comparator<String> nameComp) {
        File[] files = dir.listFiles();
        ArrayList<File> candidateMatches = new ArrayList<File>();
        if (files != null) {
            for (File f : files) {
                String foundFilename = f.getName();
                if (nameComp.compare(name, foundFilename) != 0) continue;
                if (name.equals(foundFilename)) {
                    return f;
                }
                candidateMatches.add(f);
            }
        }
        Collections.sort(candidateMatches);
        return !candidateMatches.isEmpty() ? (File)candidateMatches.get(0) : null;
    }

    static List<File> getFilePathParts(File f) {
        ArrayList<File> results = new ArrayList<File>();
        while (f != null) {
            results.add(f);
            f = f.getParentFile();
        }
        return results;
    }

    private record FileFingerprintRec(String path, long timestamp, long length) {
    }
}

