/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldUtils;
import docking.widgets.fieldpanel.support.RowColLocation;
import generic.theme.GThemeDefaults;
import ghidra.app.util.DisplayableEol;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.RefRepeatComment;
import ghidra.app.util.viewer.field.Annotation;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormatOptions;
import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AutomaticCommentFieldLocation;
import ghidra.program.util.CommentFieldLocation;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RefRepeatCommentFieldLocation;
import ghidra.program.util.RepeatableCommentFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.bean.field.AnnotatedTextFieldElement;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class EolCommentFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "EOL Comment";
    private static final String GROUP_TITLE = "EOL Comments Field";
    private static final String SEMICOLON_PREFIX = "; ";
    public static final String ENABLE_WORD_WRAP_MSG = "EOL Comments Field.Enable Word Wrapping";
    public static final String MAX_DISPLAY_LINES_MSG = "EOL Comments Field.Maximum Lines To Display";
    public static final String ENABLE_SHOW_SEMICOLON_MSG = "EOL Comments Field.Show Semicolon at Start of Each Line";
    public static final String ENABLE_ALWAYS_SHOW_REPEATABLE_MSG = "EOL Comments Field.Always Show the Repeatable Comment";
    public static final String ENABLE_ALWAYS_SHOW_REF_REPEATABLE_MSG = "EOL Comments Field.Always Show the Referenced Repeatable Comments";
    public static final String ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG = "EOL Comments Field.Always Show the Automatic Comment";
    public static final String USE_ABBREVIATED_AUTOMITIC_COMMENT_MSG = "EOL Comments Field.Use Abbreviated Automatic Comments";
    public static final String SHOW_FUNCTION_AUTOMITIC_COMMENT_MSG = "EOL Comments Field.Show Function Reference Automatic Comments";
    public static final String ENABLE_PREPEND_REF_ADDRESS_MSG = "EOL Comments Field.Prepend the Address to Each Referenced Comment";
    public static final Color DEFAULT_COLOR = GThemeDefaults.Colors.Palette.BLUE;
    private boolean isWordWrap;
    private int maxDisplayLines;
    private boolean showSemicolon;
    private boolean alwaysShowRepeatable;
    private boolean alwaysShowRefRepeatables;
    private boolean alwaysShowAutomatic;
    private boolean useAbbreviatedAutomatic;
    private boolean showAutomaticFunctions;
    private boolean prependRefAddress;
    private int repeatableCommentStyle;
    private int automaticCommentStyle;
    private int refRepeatableCommentStyle;
    private BrowserCodeUnitFormatOptions codeUnitFormatOptions;

    public EolCommentFieldFactory() {
        super(FIELD_NAME);
    }

    private EolCommentFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        super(FIELD_NAME, model, hlProvider, (Options)displayOptions, (Options)fieldOptions);
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "EOL_Comments_Field");
        fieldOptions.registerOption(MAX_DISPLAY_LINES_MSG, (Object)6, hl, "The maximum number of lines used to display the end-of-line comment.");
        fieldOptions.registerOption(ENABLE_WORD_WRAP_MSG, (Object)false, hl, "Enables word wrapping.  When on, each line of text is wrapped as needed to fit within the current width.  When off, comments are displayed as entered by the user.  Lines that are too long for the field are truncated.");
        fieldOptions.registerOption(ENABLE_SHOW_SEMICOLON_MSG, (Object)false, hl, "Displays a semi-colon before each line in the end-of-line comment. This option is ignored if word wrapping is on.");
        fieldOptions.registerOption(ENABLE_ALWAYS_SHOW_REPEATABLE_MSG, (Object)false, hl, "Displays all referenced repeatable comments even if there is an EOL or repeatable comment at the code unit.");
        fieldOptions.registerOption(ENABLE_ALWAYS_SHOW_REF_REPEATABLE_MSG, (Object)false, hl, "Displays all referenced repeatable comments even if there is an EOL or repeatable comment at the code unit.");
        fieldOptions.registerOption(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG, (Object)false, hl, "Displays an automatic comment whenever one exists instead of only if there aren't any EOL or repeatable comments.");
        fieldOptions.registerOption(USE_ABBREVIATED_AUTOMITIC_COMMENT_MSG, (Object)true, hl, "When showing automatic comments, show the smallest amount of information possible");
        fieldOptions.registerOption(SHOW_FUNCTION_AUTOMITIC_COMMENT_MSG, (Object)true, hl, "When showing automatic comments, show direct function references");
        fieldOptions.registerOption(ENABLE_PREPEND_REF_ADDRESS_MSG, (Object)false, hl, "Displays the address before each referenced repeatable comment.");
        this.maxDisplayLines = fieldOptions.getInt(MAX_DISPLAY_LINES_MSG, 6);
        this.isWordWrap = fieldOptions.getBoolean(ENABLE_WORD_WRAP_MSG, false);
        this.repeatableCommentStyle = displayOptions.getInt(OptionsGui.COMMENT_REPEATABLE.getStyleOptionName(), -1);
        this.automaticCommentStyle = displayOptions.getInt(OptionsGui.COMMENT_AUTO.getStyleOptionName(), -1);
        this.refRepeatableCommentStyle = displayOptions.getInt(OptionsGui.COMMENT_REF_REPEAT.getStyleOptionName(), -1);
        this.showSemicolon = fieldOptions.getBoolean(ENABLE_SHOW_SEMICOLON_MSG, false);
        this.alwaysShowRepeatable = fieldOptions.getBoolean(ENABLE_ALWAYS_SHOW_REPEATABLE_MSG, false);
        this.alwaysShowRefRepeatables = fieldOptions.getBoolean(ENABLE_ALWAYS_SHOW_REF_REPEATABLE_MSG, false);
        this.alwaysShowAutomatic = fieldOptions.getBoolean(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG, false);
        this.useAbbreviatedAutomatic = fieldOptions.getBoolean(USE_ABBREVIATED_AUTOMITIC_COMMENT_MSG, true);
        this.showAutomaticFunctions = fieldOptions.getBoolean(SHOW_FUNCTION_AUTOMITIC_COMMENT_MSG, true);
        this.prependRefAddress = fieldOptions.getBoolean(ENABLE_PREPEND_REF_ADDRESS_MSG, false);
        fieldOptions.getOptions(GROUP_TITLE).setOptionsHelpLocation(hl);
        this.codeUnitFormatOptions = new BrowserCodeUnitFormatOptions(fieldOptions, true);
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(MAX_DISPLAY_LINES_MSG)) {
            this.setMaximumLinesToDisplay((Integer)newValue, options);
        } else if (optionName.equals(ENABLE_WORD_WRAP_MSG)) {
            this.isWordWrap = (Boolean)newValue;
        } else if (optionName.equals(ENABLE_SHOW_SEMICOLON_MSG)) {
            this.showSemicolon = (Boolean)newValue;
        } else if (optionName.equals(ENABLE_ALWAYS_SHOW_REPEATABLE_MSG)) {
            this.alwaysShowRepeatable = (Boolean)newValue;
        } else if (optionName.equals(ENABLE_ALWAYS_SHOW_REF_REPEATABLE_MSG)) {
            this.alwaysShowRefRepeatables = (Boolean)newValue;
        } else if (optionName.equals(ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG)) {
            this.alwaysShowAutomatic = (Boolean)newValue;
        } else if (optionName.equals(USE_ABBREVIATED_AUTOMITIC_COMMENT_MSG)) {
            this.useAbbreviatedAutomatic = (Boolean)newValue;
        } else if (optionName.equals(ENABLE_PREPEND_REF_ADDRESS_MSG)) {
            this.prependRefAddress = (Boolean)newValue;
        }
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        this.adjustRepeatableDisplayOptions(options, optionName, oldValue, newValue);
        this.adjustRefRepeatDisplayOptions(options, optionName, oldValue, newValue);
        this.adjustAutomaticCommentDisplayOptions(options, optionName, oldValue, newValue);
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
    }

    private void adjustRepeatableDisplayOptions(Options options, String optionName, Object oldValue, Object newValue) {
        String repeatableStyleName = OptionsGui.COMMENT_REPEATABLE.getStyleOptionName();
        if (optionName.equals(repeatableStyleName)) {
            this.repeatableCommentStyle = options.getInt(repeatableStyleName, -1);
        }
    }

    private void adjustRefRepeatDisplayOptions(Options options, String optionName, Object oldValue, Object newValue) {
        String refRepeatStyleName = OptionsGui.COMMENT_REF_REPEAT.getStyleOptionName();
        if (optionName.equals(refRepeatStyleName)) {
            this.refRepeatableCommentStyle = options.getInt(refRepeatStyleName, -1);
        }
    }

    private void adjustAutomaticCommentDisplayOptions(Options options, String optionName, Object oldValue, Object newValue) {
        String automaticCommentStyleName = OptionsGui.COMMENT_AUTO.getStyleOptionName();
        if (optionName.equals(automaticCommentStyleName)) {
            this.automaticCommentStyle = options.getInt(automaticCommentStyleName, -1);
        }
    }

    private void setMaximumLinesToDisplay(int maxLines, Options options) {
        if (maxLines < 1) {
            maxLines = 1;
            options.setInt(MAX_DISPLAY_LINES_MSG, maxLines);
        }
        this.maxDisplayLines = maxLines;
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        FieldElement[] fieldElements;
        boolean isOpen;
        Data data;
        Object obj = proxy.getObject();
        int x = this.startX + varWidth;
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        Program program = cu.getProgram();
        if (cu instanceof Data && (data = (Data)cu).getNumComponents() > 0 && (isOpen = proxy.getListingLayoutModel().isOpen((Data)proxy.getObject()))) {
            return null;
        }
        DisplayableEol displayableEol = new DisplayableEol(cu, this.alwaysShowRepeatable, this.alwaysShowRefRepeatables, this.alwaysShowAutomatic, this.codeUnitFormatOptions.followReferencedPointers(), this.maxDisplayLines, this.useAbbreviatedAutomatic, this.showAutomaticFunctions);
        ArrayList<FieldElement> elementList = new ArrayList<FieldElement>();
        AttributedString myEolPrefixString = new AttributedString(SEMICOLON_PREFIX, (Color)ListingColors.CommentColors.EOL, this.getMetrics(this.style), false, null);
        String[] eolComments = displayableEol.getEOLComments();
        List<FieldElement> eolFieldElements = this.convertToFieldElements(program, eolComments, myEolPrefixString, this.showSemicolon, this.isWordWrap, this.getNextRow(elementList));
        elementList.addAll(eolFieldElements);
        if (this.alwaysShowRepeatable || elementList.isEmpty()) {
            AttributedString myRepeatablePrefixString = new AttributedString(SEMICOLON_PREFIX, (Color)ListingColors.CommentColors.REPEATABLE, this.getMetrics(this.repeatableCommentStyle), false, null);
            String[] repeatableComments = displayableEol.getRepeatableComments();
            List<FieldElement> repeatableFieldElements = this.convertToFieldElements(program, repeatableComments, myRepeatablePrefixString, this.showSemicolon, this.isWordWrap, this.getNextRow(elementList));
            elementList.addAll(repeatableFieldElements);
        }
        if (this.alwaysShowRefRepeatables || elementList.isEmpty()) {
            AttributedString refRepeatPrefixString = new AttributedString(SEMICOLON_PREFIX, (Color)ListingColors.CommentColors.REF_REPEATABLE, this.getMetrics(this.refRepeatableCommentStyle), false, null);
            int refRepeatCount = displayableEol.getReferencedRepeatableCommentsCount();
            for (int subTypeIndex = 0; subTypeIndex < refRepeatCount; ++subTypeIndex) {
                RefRepeatComment refRepeatComment = displayableEol.getReferencedRepeatableComments(subTypeIndex);
                String[] refRepeatComments = refRepeatComment.getCommentLines();
                List<FieldElement> refRepeatFieldElements = this.convertToRefFieldElements(refRepeatComments, program, refRepeatPrefixString, this.showSemicolon, this.isWordWrap, this.prependRefAddress, refRepeatComment.getAddress(), this.getNextRow(elementList));
                elementList.addAll(refRepeatFieldElements);
            }
        }
        if (this.alwaysShowAutomatic || elementList.isEmpty()) {
            AttributedString autoCommentPrefixString = new AttributedString(SEMICOLON_PREFIX, (Color)ListingColors.CommentColors.AUTO, this.getMetrics(this.automaticCommentStyle), false, null);
            String[] autoComment = displayableEol.getAutomaticComment();
            List<FieldElement> autoCommentFieldElements = this.convertToFieldElements(program, autoComment, autoCommentPrefixString, this.showSemicolon, this.isWordWrap, this.getNextRow(elementList));
            elementList.addAll(autoCommentFieldElements);
        }
        if ((fieldElements = elementList.toArray(new FieldElement[elementList.size()])).length == 0) {
            return null;
        }
        return ListingTextField.createMultilineTextField(this, proxy, fieldElements, x, this.width, this.maxDisplayLines, this.hlProvider);
    }

    private int getNextRow(List<FieldElement> elementList) {
        int elementIndex = elementList.size() - 1;
        if (elementIndex >= 0) {
            FieldElement element = elementList.get(elementIndex);
            int length = element.length();
            int charIndex = length > 0 ? length - 1 : 0;
            RowColLocation rowCol = element.getDataLocationForCharacterIndex(charIndex);
            return rowCol.row() + 1;
        }
        return 0;
    }

    private List<FieldElement> convertToFieldElements(Program program, String[] comments, AttributedString currentPrefixString, boolean showPrefix, boolean wordWrap, int nextRow) {
        List<Object> fieldElements = new ArrayList<FieldElement>();
        if (comments.length == 0) {
            return fieldElements;
        }
        for (int rowIndex = 0; rowIndex < comments.length; ++rowIndex) {
            int encodedRow = nextRow + rowIndex;
            fieldElements.add(CommentUtils.parseTextForAnnotations(comments[rowIndex], program, currentPrefixString, encodedRow));
        }
        if (wordWrap) {
            int lineWidth = showPrefix ? this.width - currentPrefixString.getStringWidth() : this.width;
            fieldElements = FieldUtils.wrap(fieldElements, (int)lineWidth);
        }
        if (showPrefix) {
            for (int i = 0; i < fieldElements.size(); ++i) {
                RowColLocation startRowCol = ((FieldElement)fieldElements.get(i)).getDataLocationForCharacterIndex(0);
                int encodedRow = startRowCol.row();
                int encodedCol = startRowCol.col();
                TextFieldElement prefix = new TextFieldElement(currentPrefixString, encodedRow, encodedCol);
                fieldElements.set(i, new CompositeFieldElement(new FieldElement[]{prefix, (FieldElement)fieldElements.get(i)}));
            }
        }
        return fieldElements;
    }

    private List<FieldElement> convertToRefFieldElements(String[] comments, Program program, AttributedString currentPrefixString, boolean showPrefix, boolean wordWrap, boolean showRefAddress, Address refAddress, int nextRow) {
        int numCommentLines = comments.length;
        List<Object> fieldElements = new ArrayList<FieldElement>();
        if (numCommentLines == 0) {
            return fieldElements;
        }
        for (int rowIndex = 0; rowIndex < numCommentLines; ++rowIndex) {
            int encodedRow = nextRow + rowIndex;
            fieldElements.add(CommentUtils.parseTextForAnnotations(comments[rowIndex], program, currentPrefixString, encodedRow));
        }
        if (showRefAddress) {
            FieldElement commentElement = (FieldElement)fieldElements.get(0);
            String refAddrComment = "{@address " + refAddress.toString() + "}";
            RowColLocation startRowCol = commentElement.getDataLocationForCharacterIndex(0);
            int encodedRow = startRowCol.row();
            int encodedCol = startRowCol.col();
            Annotation annotation = new Annotation(refAddrComment, currentPrefixString, program);
            AnnotatedTextFieldElement addressElement = new AnnotatedTextFieldElement(annotation, encodedRow, encodedCol);
            AttributedString spaceStr = new AttributedString(" ", currentPrefixString.getColor(0), currentPrefixString.getFontMetrics(0), false, null);
            TextFieldElement spacerElement = new TextFieldElement(spaceStr, encodedRow, encodedCol);
            fieldElements.add(new CompositeFieldElement(new FieldElement[]{addressElement, spacerElement, commentElement}));
        }
        if (wordWrap) {
            int lineWidth = showPrefix ? this.width - currentPrefixString.getStringWidth() : this.width;
            fieldElements = FieldUtils.wrap(fieldElements, (int)lineWidth);
        }
        if (showPrefix) {
            for (int i = 0; i < fieldElements.size(); ++i) {
                RowColLocation startRowCol = ((FieldElement)fieldElements.get(i)).getDataLocationForCharacterIndex(0);
                int encodedRow = startRowCol.row();
                int encodedCol = startRowCol.col();
                TextFieldElement prefixFieldElement = new TextFieldElement(currentPrefixString, encodedRow, encodedCol);
                fieldElements.set(i, new CompositeFieldElement(new FieldElement[]{prefixFieldElement, (FieldElement)fieldElements.get(i)}));
            }
        }
        return fieldElements;
    }

    @Override
    public ProgramLocation getProgramLocation(int screenRow, int screenColumn, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        DisplayableEol displayableEol = new DisplayableEol(cu, this.alwaysShowRepeatable, this.alwaysShowRefRepeatables, this.alwaysShowAutomatic, this.codeUnitFormatOptions.followReferencedPointers(), this.maxDisplayLines, this.useAbbreviatedAutomatic, this.showAutomaticFunctions);
        int numLeadColumns = 0;
        if (this.showSemicolon) {
            numLeadColumns += SEMICOLON_PREFIX.length();
        }
        if (screenColumn < numLeadColumns) {
            screenColumn = 0;
        }
        ListingTextField btf = (ListingTextField)bf;
        RowColLocation rowCol = btf.screenToDataLocation(screenRow, screenColumn);
        int eolRow = rowCol.row();
        int eolColumn = rowCol.col();
        return displayableEol.getLocation(eolRow, eolColumn);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (!(loc instanceof EolCommentFieldLocation || loc instanceof RepeatableCommentFieldLocation || loc instanceof RefRepeatCommentFieldLocation || loc instanceof AutomaticCommentFieldLocation)) {
            return null;
        }
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        DisplayableEol displayableEol = new DisplayableEol((CodeUnit)obj, this.alwaysShowRepeatable, this.alwaysShowRefRepeatables, this.alwaysShowAutomatic, this.codeUnitFormatOptions.followReferencedPointers(), this.maxDisplayLines, this.useAbbreviatedAutomatic, this.showAutomaticFunctions);
        ListingTextField btf = (ListingTextField)bf;
        RowColLocation eolRowCol = displayableEol.getRowCol((CommentFieldLocation)loc);
        RowColLocation rcl = btf.dataToScreenLocation(eolRowCol.row(), eolRowCol.col());
        if (!this.hasSamePath(bf, loc)) {
            return null;
        }
        return new FieldLocation(index, fieldNum, rcl.row(), rcl.col());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel fieldFormatModel, ListingHighlightProvider highlightProvider, ToolOptions newDisplayOptions, ToolOptions newFieldOptions) {
        return new EolCommentFieldFactory(fieldFormatModel, highlightProvider, newDisplayOptions, newFieldOptions);
    }

    public static String getSingleString(String[] comments, char separatorChar) {
        if (comments.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(comments[0]);
        for (int i = 1; i < comments.length; ++i) {
            buf.append(separatorChar + comments[i]);
        }
        return buf.toString();
    }
}

