/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.MachHeaderFileTypes;
import ghidra.app.util.bin.format.macho.MachHeaderFlags;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupsCommand;
import ghidra.app.util.bin.format.macho.commands.DyldExportsTrieCommand;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLibrary;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLinkerCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.EncryptedInformationCommand;
import ghidra.app.util.bin.format.macho.commands.EntryPointCommand;
import ghidra.app.util.bin.format.macho.commands.ExportTrie;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.LinkerOptionCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.bin.format.macho.commands.LoadCommandTypes;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.PreboundDynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.RunPathCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SubClientCommand;
import ghidra.app.util.bin.format.macho.commands.SubFrameworkCommand;
import ghidra.app.util.bin.format.macho.commands.SubLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.SubUmbrellaCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.UnsupportedLoadCommand;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedFixups;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImports;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsOffsets;
import ghidra.app.util.bin.format.macho.commands.dyld.BindingTable;
import ghidra.app.util.bin.format.macho.commands.dyld.ClassicBindProcessor;
import ghidra.app.util.bin.format.macho.commands.dyld.ClassicLazyBindProcessor;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandler;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandlerFactory;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ExternalSymbolResolver;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;

public class MachoProgramBuilder {
    public static final String BLOCK_SOURCE_NAME = "Mach-O Loader";
    protected MachHeader machoHeader;
    protected Program program;
    protected ByteProvider provider;
    protected FileBytes fileBytes;
    protected MessageLog log;
    protected TaskMonitor monitor;
    protected Memory memory;
    protected Listing listing;
    protected AddressSpace space;

    protected MachoProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) {
        this.program = program;
        this.provider = provider;
        this.fileBytes = fileBytes;
        this.log = log;
        this.monitor = monitor;
        this.memory = program.getMemory();
        this.listing = program.getListing();
        this.space = program.getAddressFactory().getDefaultAddressSpace();
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) throws Exception {
        MachoProgramBuilder machoProgramBuilder = new MachoProgramBuilder(program, provider, fileBytes, log, monitor);
        machoProgramBuilder.build();
    }

    protected void build() throws Exception {
        this.monitor.setMessage("Completing Mach-O header parsing...");
        this.monitor.setCancelEnabled(false);
        this.machoHeader = new MachHeader(this.provider);
        this.machoHeader.parse();
        this.monitor.setCancelEnabled(true);
        this.setImageBase();
        this.processMemoryBlocks(this.machoHeader, this.provider.getName(), true, true);
        this.fixupProgramTree();
        this.processEntryPoint();
        boolean exportsFound = this.processExports(this.machoHeader);
        this.processSymbolTables(this.machoHeader, !exportsFound);
        this.processIndirectSymbols();
        this.processUndefinedSymbols();
        this.processAbsoluteSymbols();
        List<Address> chainedFixups = this.processChainedFixups(this.machoHeader);
        this.processBindings(false);
        this.processSectionRelocations();
        this.processExternalRelocations();
        this.processLocalRelocations();
        this.processLibraries();
        this.processEncryption();
        this.processUnsupportedLoadCommands();
        this.markupHeaders(this.machoHeader, this.setupHeaderAddr(this.machoHeader.getAllSegments()));
        this.markupSections();
        this.markupLoadCommandData(this.machoHeader, null);
        this.markupChainedFixups(this.machoHeader, chainedFixups);
        this.markupProgramVars();
        this.setRelocatableProperty();
        this.setProgramDescription();
        this.renameObjMsgSendRtpSymbol();
    }

    protected void setImageBase() throws Exception {
        Address imageBaseAddr = null;
        for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
            if (segment.getFileSize() <= 0L) continue;
            Address segmentAddr = this.space.getAddress(segment.getVMaddress());
            if (imageBaseAddr == null) {
                imageBaseAddr = segmentAddr;
                continue;
            }
            if (segmentAddr.compareTo((Object)imageBaseAddr) >= 0) continue;
            imageBaseAddr = segmentAddr;
        }
        if (imageBaseAddr != null) {
            this.program.setImageBase(imageBaseAddr, true);
        } else {
            this.program.setImageBase(this.space.getAddress(0L), true);
        }
    }

    protected void processMemoryBlocks(MachHeader header, String source, boolean processSections, boolean allowZeroAddr) throws Exception {
        this.monitor.setMessage("Processing memory blocks for " + source + "...");
        if (header.getFileType() == 9) {
            return;
        }
        ListIterator<SegmentCommand> it = header.getAllSegments().listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            SegmentCommand segment = it.next();
            if (this.monitor.isCancelled()) break;
            if (segment.getFileSize() <= 0L || !allowZeroAddr && segment.getVMaddress() == 0L) continue;
            Object segmentName = segment.getSegmentName();
            if (((String)segmentName).isBlank()) {
                segmentName = "SEGMENT." + i;
            }
            if (this.createMemoryBlock((String)segmentName, this.space.getAddress(segment.getVMaddress()), segment.getFileOffset(), segment.getFileSize(), (String)segmentName, source, segment.isRead(), segment.isWrite(), segment.isExecute(), false) == null) {
                this.log.appendMsg(String.format("Failed to create block: %s 0x%x 0x%x", segment.getSegmentName(), segment.getVMaddress(), segment.getVMsize()));
            }
            if (segment.getVMsize() <= segment.getFileSize() || this.createMemoryBlock((String)segmentName, this.space.getAddress(segment.getVMaddress()).add(segment.getFileSize()), 0L, segment.getVMsize() - segment.getFileSize(), (String)segmentName, source, segment.isRead(), segment.isWrite(), segment.isExecute(), true) != null) continue;
            this.log.appendMsg(String.format("Failed to create block: %s 0x%x 0x%x", segment.getSegmentName(), segment.getVMaddress(), segment.getVMsize()));
        }
        if (processSections) {
            for (Section section : header.getAllSections()) {
                if (this.monitor.isCancelled()) break;
                if (section.getSize() <= 0L || !allowZeroAddr && section.getAddress() == 0L || this.createMemoryBlock(section.getSectionName(), this.space.getAddress(section.getAddress()), section.getOffset(), section.getSize(), section.getSegmentName(), source, section.isRead(), section.isWrite(), section.isExecute(), section.getType() == 1) != null) continue;
                this.log.appendMsg(String.format("Failed to create block: %s.%s 0x%x 0x%x %s", section.getSegmentName(), section.getSectionName(), section.getAddress(), section.getSize(), source));
            }
        }
    }

    private MemoryBlock createMemoryBlock(String name, Address start, long dataOffset, long dataLength, String comment, String source, boolean r, boolean w, boolean x, boolean zeroFill) throws Exception {
        ArrayList<MemoryBlock> intersectingBlocks = new ArrayList<MemoryBlock>();
        AddressSet range = new AddressSet(start, start.add(dataLength - 1L));
        for (MemoryBlock block : this.memory.getBlocks()) {
            if (!range.intersects(block.getStart(), block.getEnd())) continue;
            intersectingBlocks.add(block);
        }
        if (intersectingBlocks.isEmpty()) {
            if (zeroFill) {
                return MemoryBlockUtils.createUninitializedBlock(this.program, false, name, start, dataLength, comment, source, r, w, x, this.log);
            }
            return MemoryBlockUtils.createInitializedBlock(this.program, false, name, start, this.fileBytes, dataOffset, dataLength, comment, source, r, w, x, this.log);
        }
        MemoryBlock startingBlock = (MemoryBlock)intersectingBlocks.get(0);
        if (start.compareTo((Object)startingBlock.getStart()) > 0) {
            this.memory.split(startingBlock, start);
        }
        MemoryBlock endingBlock = (MemoryBlock)intersectingBlocks.get(intersectingBlocks.size() - 1);
        if (start.add(dataLength - 1L).compareTo((Object)endingBlock.getEnd()) < 0) {
            this.memory.split(endingBlock, start.add(dataLength));
            MemoryBlock newEndingBlock = this.memory.getBlock(start.add(dataLength));
            newEndingBlock.setName(endingBlock.getName());
            newEndingBlock.setSourceName(endingBlock.getSourceName());
            newEndingBlock.setComment(endingBlock.getComment());
        }
        for (MemoryBlock block : this.memory.getBlocks()) {
            if (!range.intersects(block.getStart(), block.getEnd())) continue;
            block.setName(name);
            block.setPermissions(r, w, x);
            block.setSourceName(source);
            block.setComment(comment);
        }
        return this.memory.getBlock(start);
    }

    protected void fixupProgramTree() throws Exception {
        ProgramModule rootModule = this.listing.getDefaultRootModule();
        ListIterator<SegmentCommand> it = this.machoHeader.getAllSegments().listIterator();
        while (it.hasNext()) {
            Object segmentName;
            int i = it.nextIndex();
            SegmentCommand segment = it.next();
            if (segment.getVMsize() == 0L) continue;
            Address segmentStart = this.space.getAddress(segment.getVMaddress());
            Address segmentEnd = segmentStart.add(segment.getVMsize() - 1L);
            if (!this.memory.contains(segmentStart)) continue;
            if (!this.memory.contains(segmentEnd)) {
                segmentEnd = this.memory.getBlock(segmentStart).getEnd();
            }
            if (((String)(segmentName = segment.getSegmentName())).isBlank()) {
                segmentName = "SEGMENT." + i;
            }
            String noSectionsName = (String)segmentName + " <no section>";
            ProgramFragment segmentFragment = null;
            for (Group group : rootModule.getChildren()) {
                ProgramFragment fragment;
                if (!(group instanceof ProgramFragment) || !(fragment = (ProgramFragment)group).getName().equals(segmentName)) continue;
                fragment.setName(noSectionsName);
                segmentFragment = fragment;
                break;
            }
            if (segmentFragment == null) {
                this.log.appendMsg("Could not find/fixup segment in Program Tree: " + (String)segmentName);
                continue;
            }
            ProgramModule segmentModule = rootModule.createModule((String)segmentName);
            try {
                segmentModule.reparent(noSectionsName, rootModule);
            }
            catch (NotFoundException e) {
                this.log.appendException((Throwable)e);
                continue;
            }
            for (Section section : segment.getSections()) {
                if (section.getSize() == 0L) continue;
                Address sectionStart = this.space.getAddress(section.getAddress());
                Address sectionEnd = sectionStart.add(section.getSize() - 1L);
                if (!this.memory.contains(sectionEnd)) {
                    sectionEnd = this.memory.getBlock(sectionStart).getEnd();
                }
                ProgramFragment sectionFragment = segmentModule.createFragment(String.format("%s %s", section.getSegmentName(), section.getSectionName()));
                sectionFragment.move(sectionStart, sectionEnd);
            }
            if (!segmentFragment.isEmpty()) continue;
            segmentModule.removeChild(segmentFragment.getName());
        }
    }

    protected void processEntryPoint() throws Exception {
        long pointer;
        ThreadCommand threadCommand;
        SegmentCommand segment;
        long offset;
        this.monitor.setMessage("Processing entry point...");
        Address entryPointAddr = null;
        EntryPointCommand entryPointCommand = this.machoHeader.getFirstLoadCommand(EntryPointCommand.class);
        if (entryPointCommand != null && (offset = entryPointCommand.getEntryOffset()) > 0L && (segment = this.machoHeader.getSegment("__TEXT")) != null) {
            entryPointAddr = this.space.getAddress(segment.getVMaddress()).add(offset);
        }
        if (entryPointAddr == null && (threadCommand = this.machoHeader.getFirstLoadCommand(ThreadCommand.class)) != null && (pointer = threadCommand.getInitialInstructionPointer()) != -1L) {
            entryPointAddr = this.space.getAddress(pointer);
        }
        if (entryPointAddr != null) {
            this.program.getSymbolTable().createLabel(entryPointAddr, "entry", SourceType.IMPORTED);
            this.program.getSymbolTable().addExternalEntryPoint(entryPointAddr);
            this.createOneByteFunction("entry", entryPointAddr);
        } else {
            this.log.appendMsg("Unable to determine entry point.");
        }
    }

    protected boolean processExports(MachHeader header) throws Exception {
        this.monitor.setMessage("Processing exports...");
        ArrayList<ExportTrie.ExportEntry> exports = new ArrayList<ExportTrie.ExportEntry>();
        List<DyldInfoCommand> dyldInfoCommands = header.getLoadCommands(DyldInfoCommand.class);
        for (DyldInfoCommand dyldInfoCommand : dyldInfoCommands) {
            exports.addAll(dyldInfoCommand.getExportTrie().getExports(e -> !e.isReExport()));
        }
        List<DyldExportsTrieCommand> dyldExportsTrieCommands = header.getLoadCommands(DyldExportsTrieCommand.class);
        for (DyldExportsTrieCommand dyldExportsTreeCommand : dyldExportsTrieCommands) {
            exports.addAll(dyldExportsTreeCommand.getExportTrie().getExports(e -> !e.isReExport()));
        }
        if (exports.isEmpty()) {
            return false;
        }
        SegmentCommand segmentCommand = header.getSegment("__TEXT");
        if (segmentCommand == null) {
            this.log.appendMsg("Cannot process exports, __TEXT segment not found!");
            return false;
        }
        Address baseAddr = this.space.getAddress(segmentCommand.getVMaddress());
        for (ExportTrie.ExportEntry export : exports) {
            String name = SymbolUtilities.replaceInvalidChars((String)export.name(), (boolean)true);
            try {
                Address exportAddr = baseAddr.add(export.address());
                this.program.getSymbolTable().addExternalEntryPoint(exportAddr);
                this.program.getSymbolTable().createLabel(exportAddr, name, SourceType.IMPORTED);
            }
            catch (AddressOutOfBoundsException e2) {
                this.log.appendMsg("Failed to process export '" + export + "': " + e2.getMessage());
            }
            catch (Exception e3) {
                this.log.appendMsg("Unable to create symbol: " + e3.getMessage());
            }
        }
        return !exports.isEmpty();
    }

    protected void processSymbolTables(MachHeader header, boolean processExports) throws Exception {
        this.monitor.setMessage("Processing symbol tables...");
        SymbolTable symbolTable = this.program.getSymbolTable();
        List<SymbolTableCommand> commands = header.getLoadCommands(SymbolTableCommand.class);
        for (SymbolTableCommand symbolTableCommand : commands) {
            List<NList> symbols = symbolTableCommand.getSymbols();
            for (NList symbol : symbols) {
                String string;
                if (this.monitor.isCancelled()) {
                    return;
                }
                if (symbol.isTypePreboundUndefined() || symbol.isLazyBind()) continue;
                Address addr = this.space.getAddress(symbol.getValue());
                if (symbol.isSymbolicDebugging() || symbol.isTypeAbsolute() || symbol.isTypeUndefined() || symbol.isIndirect()) continue;
                if (processExports && symbol.isExternal()) {
                    symbolTable.addExternalEntryPoint(addr);
                }
                if ((string = symbol.getString()).length() == 0) continue;
                string = SymbolUtilities.replaceInvalidChars((String)string, (boolean)true);
                if (symbol.isThumbSymbol()) {
                    this.markAsThumb(addr);
                }
                if (symbolTable.getGlobalSymbol(string, addr) != null) continue;
                try {
                    if (symbol.isExternal() && !processExports) continue;
                    Symbol primary = symbolTable.getPrimarySymbol(addr);
                    Symbol newSymbol = symbolTable.createLabel(addr, string, SourceType.IMPORTED);
                    if (primary != null && primary.getName().equals("<redacted>")) {
                        newSymbol.setPrimary();
                    }
                    if (!symbol.isExternal()) continue;
                    symbolTable.addExternalEntryPoint(addr);
                }
                catch (Exception e) {
                    this.log.appendMsg("Unable to create symbol: " + e.getMessage());
                }
            }
        }
    }

    protected void processIndirectSymbols() throws Exception {
        if (this.machoHeader.getFirstLoadCommand(DyldChainedFixupsCommand.class) != null || this.machoHeader.getFirstLoadCommand(DyldInfoCommand.class) != null) {
            return;
        }
        this.monitor.setMessage("Processing indirect symbols...");
        SymbolTableCommand symbolTableCommand = this.machoHeader.getFirstLoadCommand(SymbolTableCommand.class);
        DynamicSymbolTableCommand dynamicCommand = this.machoHeader.getFirstLoadCommand(DynamicSymbolTableCommand.class);
        if (dynamicCommand == null) {
            return;
        }
        int[] indirectSymbols = dynamicCommand.getIndirectSymbols();
        if (indirectSymbols.length == 0) {
            return;
        }
        List<Integer> sectionTypes = List.of(Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8));
        List<Section> sections = this.machoHeader.getAllSections().stream().filter(s -> sectionTypes.contains(s.getType())).toList();
        for (Section section : sections) {
            if (this.monitor.isCancelled()) {
                return;
            }
            if (section.getSize() == 0L) continue;
            Namespace namespace = this.createNamespace(section.getSectionName());
            int indirectSymbolTableIndex = section.getReserved1();
            int symbolSize = this.machoHeader.getAddressSize();
            if (section.getType() == 8) {
                symbolSize = section.getReserved2();
            }
            int nSymbols = (int)section.getSize() / symbolSize;
            Address startAddr = this.space.getAddress(section.getAddress());
            for (int i = indirectSymbolTableIndex; i < indirectSymbolTableIndex + nSymbols && !this.monitor.isCancelled(); ++i) {
                String name;
                int symbolIndex = indirectSymbols[i];
                NList symbol = symbolTableCommand.getSymbolAt(symbolIndex);
                if (symbol != null && (name = SymbolUtilities.replaceInvalidChars((String)symbol.getString(), (boolean)true)) != null && name.length() > 0) {
                    try {
                        this.program.getSymbolTable().createLabel(startAddr, name, namespace, SourceType.IMPORTED);
                    }
                    catch (Exception e) {
                        this.log.appendMsg("Unable to create indirect symbol " + name);
                        this.log.appendException((Throwable)e);
                    }
                }
                startAddr = startAddr.add((long)symbolSize);
            }
        }
    }

    protected void processUndefinedSymbols() throws Exception {
        this.monitor.setMessage("Processing undefined symbols...");
        ArrayList<NList> undefinedSymbols = new ArrayList<NList>();
        List<LoadCommand> commands = this.machoHeader.getLoadCommands();
        for (LoadCommand command : commands) {
            if (this.monitor.isCancelled()) {
                return;
            }
            if (!(command instanceof SymbolTableCommand)) continue;
            SymbolTableCommand symbolTableCommand = (SymbolTableCommand)command;
            List<NList> symbols = symbolTableCommand.getSymbols();
            for (NList symbol : symbols) {
                List globalSymbols;
                if (this.monitor.isCancelled()) {
                    return;
                }
                if (symbol.isSymbolicDebugging() || !symbol.isTypeUndefined() || !(globalSymbols = this.program.getSymbolTable().getLabelOrFunctionSymbols(symbol.getString(), null)).isEmpty()) continue;
                undefinedSymbols.add(symbol);
            }
        }
        if (undefinedSymbols.size() == 0) {
            return;
        }
        Address start = this.getAddress();
        try {
            MemoryBlock block = this.memory.createUninitializedBlock("EXTERNAL", start, (long)(undefinedSymbols.size() * this.machoHeader.getAddressSize()), false);
            block.setWrite(true);
            block.setSourceName(BLOCK_SOURCE_NAME);
            block.setComment("NOTE: This block is artificial and is used to make relocations work correctly");
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to create undefined memory block: " + e.getMessage());
        }
        for (NList symbol : undefinedSymbols) {
            if (this.monitor.isCancelled()) {
                return;
            }
            try {
                String name = SymbolUtilities.replaceInvalidChars((String)symbol.getString(), (boolean)true);
                if (name != null && name.length() > 0) {
                    this.program.getSymbolTable().createLabel(start, name, SourceType.IMPORTED);
                }
            }
            catch (Exception e) {
                this.log.appendMsg("Unable to create undefined symbol: " + e.getMessage());
            }
            start = start.add((long)this.machoHeader.getAddressSize());
        }
    }

    protected void processAbsoluteSymbols() throws Exception {
        this.monitor.setMessage("Processing absolute symbols...");
        ArrayList<NList> absoluteSymbols = new ArrayList<NList>();
        List<LoadCommand> commands = this.machoHeader.getLoadCommands();
        for (LoadCommand command : commands) {
            if (this.monitor.isCancelled()) {
                return;
            }
            if (!(command instanceof SymbolTableCommand)) continue;
            SymbolTableCommand symbolTableCommand = (SymbolTableCommand)command;
            List<NList> symbols = symbolTableCommand.getSymbols();
            for (NList symbol : symbols) {
                if (this.monitor.isCancelled()) {
                    return;
                }
                if (symbol.isSymbolicDebugging() || !symbol.isTypeAbsolute()) continue;
                absoluteSymbols.add(symbol);
            }
        }
        if (absoluteSymbols.size() == 0) {
            return;
        }
        Address start = this.getAddress();
        try {
            this.memory.createUninitializedBlock("ABSOLUTE", start, (long)(absoluteSymbols.size() * this.machoHeader.getAddressSize()), false);
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to create absolute memory block: " + e.getMessage());
        }
        for (NList symbol : absoluteSymbols) {
            try {
                String name = SymbolUtilities.replaceInvalidChars((String)symbol.getString(), (boolean)true);
                if (name != null && name.length() > 0) {
                    this.program.getSymbolTable().createLabel(start, name, SourceType.IMPORTED);
                }
            }
            catch (Exception e) {
                this.log.appendMsg("Unable to create absolute symbol: " + e.getMessage());
            }
            start = start.add((long)this.machoHeader.getAddressSize());
        }
    }

    public List<Address> processChainedFixups(MachHeader header) throws Exception {
        DyldChainedFixups dyldChainedFixups = new DyldChainedFixups(this.program, header, this.log, this.monitor);
        return dyldChainedFixups.processChainedFixups();
    }

    protected void processBindings(boolean doClassic) throws Exception {
        List<DyldInfoCommand> commands = this.machoHeader.getLoadCommands(DyldInfoCommand.class);
        for (DyldInfoCommand command : commands) {
            this.processBindings(command.getBindingTable());
            this.processBindings(command.getLazyBindingTable());
            this.processBindings(command.getWeakBindingTable());
        }
        if (commands.size() == 0 && doClassic) {
            ClassicBindProcessor classicBindProcess = new ClassicBindProcessor(this.machoHeader, this.program);
            try {
                classicBindProcess.process(this.monitor);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
            ClassicLazyBindProcessor classicLazyBindProcess = new ClassicLazyBindProcessor(this.machoHeader, this.program);
            try {
                classicLazyBindProcess.process(this.monitor);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBindings(BindingTable bindingTable) throws Exception {
        DataConverter converter = DataConverter.getInstance((boolean)this.program.getLanguage().isBigEndian());
        SymbolTable symbolTable = this.program.getSymbolTable();
        List<BindingTable.Binding> bindings = bindingTable.getBindings();
        List<BindingTable.Binding> threadedBindings = bindingTable.getThreadedBindings();
        List<SegmentCommand> segments = this.machoHeader.getAllSegments();
        if (threadedBindings != null) {
            DyldChainedFixups dyldChainedFixups = new DyldChainedFixups(this.program, this.machoHeader, this.log, this.monitor);
            DyldChainedImports chainedImports = new DyldChainedImports(bindings);
            for (BindingTable.Binding threadedBinding : threadedBindings) {
                ArrayList<Address> fixedAddresses = new ArrayList<Address>();
                SegmentCommand segment = segments.get(threadedBinding.getSegmentIndex());
                dyldChainedFixups.processPointerChain(chainedImports, fixedAddresses, DyldChainedPtr.DyldChainType.DYLD_CHAINED_PTR_ARM64E, segments.get(threadedBinding.getSegmentIndex()).getVMaddress(), threadedBinding.getSegmentOffset(), 0L);
                this.log.appendMsg("Fixed up %d chained pointers in %s".formatted(fixedAddresses.size(), segment.getSegmentName()));
            }
        } else {
            for (BindingTable.Binding binding : bindings) {
                if (binding.getUnknownOpcode() != null) {
                    this.log.appendMsg("Unknown bind opcode: 0x%x".formatted(binding.getUnknownOpcode()));
                    continue;
                }
                List symbols = symbolTable.getGlobalSymbols(binding.getSymbolName());
                if (symbols.isEmpty()) continue;
                Symbol symbol = (Symbol)symbols.get(0);
                long offset = symbol.getAddress().getOffset();
                byte[] bytes = this.program.getDefaultPointerSize() == 8 ? converter.getBytes(offset) : converter.getBytes((int)offset);
                Address addr = this.space.getAddress(segments.get(binding.getSegmentIndex()).getVMaddress() + binding.getSegmentOffset());
                boolean success = false;
                try {
                    this.program.getMemory().setBytes(addr, bytes);
                    success = true;
                }
                catch (MemoryAccessException e) {
                    try {
                        this.handleRelocationError(addr, String.format("Relocation failure at address %s: error accessing memory.", addr));
                    }
                    catch (Throwable throwable) {
                        this.program.getRelocationTable().add(addr, success ? Relocation.Status.APPLIED_OTHER : Relocation.Status.FAILURE, binding.getType(), null, bytes.length, binding.getSymbolName());
                        throw throwable;
                    }
                    this.program.getRelocationTable().add(addr, success ? Relocation.Status.APPLIED_OTHER : Relocation.Status.FAILURE, binding.getType(), null, bytes.length, binding.getSymbolName());
                    continue;
                }
                this.program.getRelocationTable().add(addr, success ? Relocation.Status.APPLIED_OTHER : Relocation.Status.FAILURE, binding.getType(), null, bytes.length, binding.getSymbolName());
            }
        }
    }

    protected void markupHeaders(MachHeader header, Address headerAddr) throws Exception {
        this.monitor.setMessage("Processing header markup...");
        if (headerAddr == null) {
            return;
        }
        try {
            DataUtilities.createData((Program)this.program, (Address)headerAddr, (DataType)header.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            for (LoadCommand loadCommand : header.getLoadCommands()) {
                if (this.monitor.isCancelled()) break;
                Address loadCommandAddr = headerAddr.add(loadCommand.getStartIndex() - header.getStartIndexInProvider());
                DataType loadCommandDataType = loadCommand.toDataType();
                DataUtilities.createData((Program)this.program, (Address)loadCommandAddr, (DataType)loadCommandDataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.listing.setComment(loadCommandAddr, 1, LoadCommandTypes.getLoadCommandName(loadCommand.getCommandType()));
                if (loadCommand instanceof SegmentCommand) {
                    SegmentCommand segmentCommand = (SegmentCommand)loadCommand;
                    this.listing.setComment(loadCommandAddr, 0, segmentCommand.getSegmentName());
                    int sectionOffset = loadCommandDataType.getLength();
                    for (Section section : segmentCommand.getSections()) {
                        DataType sectionDataType = section.toDataType();
                        Address sectionAddr = loadCommandAddr.add((long)sectionOffset);
                        DataUtilities.createData((Program)this.program, (Address)sectionAddr, (DataType)sectionDataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                        this.listing.setComment(sectionAddr, 0, section.getSegmentName() + "." + section.getSectionName());
                        sectionOffset += sectionDataType.getLength();
                    }
                    continue;
                }
                if (loadCommand instanceof DynamicLinkerCommand) {
                    DynamicLinkerCommand dynamicLinkerCommand = (DynamicLinkerCommand)loadCommand;
                    LoadCommandString name = dynamicLinkerCommand.getLoadCommandString();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof DynamicLibraryCommand) {
                    DynamicLibraryCommand dynamicLibraryCommand = (DynamicLibraryCommand)loadCommand;
                    LoadCommandString name = dynamicLibraryCommand.getDynamicLibrary().getName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof RunPathCommand) {
                    RunPathCommand runPathCommand = (RunPathCommand)loadCommand;
                    LoadCommandString path = runPathCommand.getPath();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)path.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - path.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubFrameworkCommand) {
                    SubFrameworkCommand subFrameworkCommand = (SubFrameworkCommand)loadCommand;
                    LoadCommandString name = subFrameworkCommand.getUmbrellaFrameworkName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubClientCommand) {
                    SubClientCommand subClientCommand = (SubClientCommand)loadCommand;
                    LoadCommandString name = subClientCommand.getClientName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubLibraryCommand) {
                    SubLibraryCommand subLibraryCommand = (SubLibraryCommand)loadCommand;
                    LoadCommandString name = subLibraryCommand.getSubLibraryName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof SubUmbrellaCommand) {
                    SubUmbrellaCommand subUmbrellaCommand = (SubUmbrellaCommand)loadCommand;
                    LoadCommandString name = subUmbrellaCommand.getSubUmbrellaFrameworkName();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (loadCommand instanceof FileSetEntryCommand) {
                    FileSetEntryCommand fileSetEntryCommand = (FileSetEntryCommand)loadCommand;
                    LoadCommandString name = fileSetEntryCommand.getFileSetEntryId();
                    DataUtilities.createData((Program)this.program, (Address)loadCommandAddr.add((long)name.getOffset()), (DataType)StructConverter.STRING, (int)(loadCommand.getCommandSize() - name.getOffset()), (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    continue;
                }
                if (!(loadCommand instanceof LinkerOptionCommand)) continue;
                LinkerOptionCommand linkerOptionCommand = (LinkerOptionCommand)loadCommand;
                List<String> linkerOptions = linkerOptionCommand.getLinkerOptions();
                int offset = linkerOptionCommand.toDataType().getLength();
                for (int i = 0; i < linkerOptions.size(); ++i) {
                    Address addr = loadCommandAddr.add((long)offset);
                    int len = linkerOptions.get(i).length() + 1;
                    if (i == linkerOptions.size() - 1) {
                        len = (int)(NumericUtilities.getUnsignedAlignedValue((long)addr.add((long)len).getOffset(), (long)4L) - addr.getOffset());
                    }
                    DataUtilities.createData((Program)this.program, (Address)addr, (DataType)StructConverter.STRING, (int)len, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    offset += len;
                }
            }
        }
        catch (CodeUnitInsertionException e) {
            this.log.appendMsg("Error laying down header structures " + e);
        }
    }

    protected Address setupHeaderAddr(Collection<SegmentCommand> segments) throws AddressOverflowException {
        Address headerAddr = null;
        long lowestFileOffset = Long.MAX_VALUE;
        for (SegmentCommand segment : segments) {
            if (segment.getFileOffset() == 0L && segment.getFileSize() > 0L) {
                return this.space.getAddress(segment.getVMaddress());
            }
            lowestFileOffset = Math.min(lowestFileOffset, segment.getFileOffset());
        }
        headerAddr = AddressSpace.OTHER_SPACE.getAddress(0L);
        MemoryBlock headerBlock = MemoryBlockUtils.createInitializedBlock(this.program, true, "HEADER", headerAddr, this.fileBytes, 0L, lowestFileOffset, "Header", "", false, false, false, this.log);
        return headerBlock.getStart();
    }

    protected void markupSections() throws Exception {
        this.monitor.setMessage("Processing section markup...");
        if (this.machoHeader.getFileType() == 9) {
            return;
        }
        block0: for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
            if (this.monitor.isCancelled()) break;
            if (segment.isAppleProtected()) {
                String msg = "Warning:  " + this.program.getName() + " contains encrypted segment: " + segment.getSegmentName();
                this.log.appendMsg(msg);
                Msg.showWarn((Object)this, null, (String)"Encrypted Binary", (Object)msg);
                continue;
            }
            List<Section> sections = segment.getSections();
            for (Section section : sections) {
                MemoryBlock block;
                if (this.monitor.isCancelled()) continue block0;
                if (section.getSize() == 0L || (block = this.getMemoryBlock(section)) == null) continue;
                if (section.getSectionName().equals("__chain_starts")) {
                    MemoryByteProvider p = new MemoryByteProvider(this.memory, block.getStart());
                    BinaryReader reader = new BinaryReader(p, this.machoHeader.isLittleEndian());
                    DyldChainedStartsOffsets chainedStartsOffsets = new DyldChainedStartsOffsets(reader);
                    DataUtilities.createData((Program)this.program, (Address)block.getStart(), (DataType)chainedStartsOffsets.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                } else if (section.getType() == 2) {
                    this.markupBlock(block, (DataType)new TerminatedStringDataType());
                } else if (section.getType() == 3) {
                    this.markupBlock(block, (DataType)new FloatDataType());
                } else if (section.getType() == 4) {
                    this.markupBlock(block, (DataType)new DoubleDataType());
                } else if (section.getType() == 5) {
                    this.markupBlock(block, (DataType)new PointerDataType());
                } else if (section.getType() == 6 || section.getType() == 7) {
                    this.markupBlock(block, (DataType)new PointerDataType());
                } else if (section.getType() != 8 || section.isExecute()) {
                    // empty if block
                }
                if (section.getType() != 7) continue;
                AddressSet set = new AddressSet(block.getStart(), block.getEnd());
                this.processLazyPointerSection((AddressSetView)set);
            }
        }
    }

    protected void processSectionRelocations() throws CancelledException {
        this.monitor.setMessage("Processing section relocations...");
        LinkedHashMap<RelocationInfo, Address> relocationMap = new LinkedHashMap<RelocationInfo, Address>();
        for (Section section : this.machoHeader.getAllSections()) {
            this.monitor.checkCancelled();
            MemoryBlock sectionMemoryBlock = this.getMemoryBlock(section);
            if (sectionMemoryBlock == null) {
                if (section.getNumberOfRelocations() <= 0) continue;
                this.log.appendMsg("Unable to process relocations for " + section.getSectionName() + ". No memory block was created.");
                continue;
            }
            for (RelocationInfo relocationInfo : section.getRelocations()) {
                this.monitor.checkCancelled();
                Address address = sectionMemoryBlock.getStart().add((long)relocationInfo.getAddress());
                relocationMap.put(relocationInfo, address);
            }
        }
        this.performRelocations(relocationMap);
    }

    protected void processExternalRelocations() throws CancelledException {
        this.monitor.setMessage("Processing external relocations...");
        LinkedHashMap<RelocationInfo, Address> relocationMap = new LinkedHashMap<RelocationInfo, Address>();
        for (DynamicSymbolTableCommand cmd : this.machoHeader.getLoadCommands(DynamicSymbolTableCommand.class)) {
            this.monitor.checkCancelled();
            for (RelocationInfo relocationInfo : cmd.getExternalRelocations()) {
                this.monitor.checkCancelled();
                relocationMap.put(relocationInfo, this.space.getAddress((long)relocationInfo.getAddress()));
            }
        }
        this.performRelocations(relocationMap);
    }

    protected void processLocalRelocations() throws CancelledException {
        this.monitor.setMessage("Processing local relocations...");
        LinkedHashMap<RelocationInfo, Address> relocationMap = new LinkedHashMap<RelocationInfo, Address>();
        for (DynamicSymbolTableCommand cmd : this.machoHeader.getLoadCommands(DynamicSymbolTableCommand.class)) {
            this.monitor.checkCancelled();
            for (RelocationInfo relocationInfo : cmd.getLocalRelocations()) {
                this.monitor.checkCancelled();
                relocationMap.put(relocationInfo, this.space.getAddress((long)relocationInfo.getAddress()));
            }
        }
        this.performRelocations(relocationMap);
    }

    protected void processLibraries() throws Exception {
        this.monitor.setMessage("Processing libraries...");
        Options props = this.program.getOptions("Program Information");
        int libraryIndex = 0;
        for (LoadCommand command : this.machoHeader.getLoadCommands()) {
            int index;
            String libraryName;
            if (this.monitor.isCancelled()) {
                return;
            }
            String libraryPath = null;
            if (command instanceof DynamicLibraryCommand) {
                DynamicLibraryCommand dylibCommand = (DynamicLibraryCommand)command;
                DynamicLibrary dylib = dylibCommand.getDynamicLibrary();
                libraryPath = dylib.getName().getString();
            } else if (command instanceof SubLibraryCommand) {
                SubLibraryCommand sublibCommand = (SubLibraryCommand)command;
                libraryPath = sublibCommand.getSubLibraryName().getString();
            } else if (command instanceof PreboundDynamicLibraryCommand) {
                PreboundDynamicLibraryCommand pbdlCommand = (PreboundDynamicLibraryCommand)command;
                libraryPath = pbdlCommand.getLibraryName();
            }
            if (libraryPath == null || (libraryName = (index = libraryPath.lastIndexOf("/")) != -1 ? libraryPath.substring(index + 1) : libraryPath).equals(this.program.getName())) continue;
            this.addLibrary(libraryPath);
            props.setString(ExternalSymbolResolver.getRequiredLibraryProperty(libraryIndex++), libraryPath);
        }
        if (this.program.getSymbolTable().getLibrarySymbol("<EXTERNAL>") == null) {
            this.program.getSymbolTable().createExternalLibrary("<EXTERNAL>", SourceType.IMPORTED);
        }
    }

    protected void processEncryption() throws Exception {
        this.monitor.setMessage("Processing encryption...");
        for (EncryptedInformationCommand cmd : this.machoHeader.getLoadCommands(EncryptedInformationCommand.class)) {
            if (cmd.getCryptID() == 0) continue;
            this.log.appendMsg(String.format("ENCRYPTION DETECTED: (file offset 0x%x, size 0x%x)", cmd.getCryptOffset(), cmd.getCryptSize()));
        }
    }

    protected void processUnsupportedLoadCommands() throws CancelledException {
        this.monitor.setMessage("Processing unsupported load commands...");
        for (LoadCommand loadCommand : this.machoHeader.getLoadCommands(UnsupportedLoadCommand.class)) {
            this.monitor.checkCancelled();
            this.log.appendMsg(loadCommand.getCommandName());
        }
    }

    private void performRelocations(LinkedHashMap<RelocationInfo, Address> relocationMap) throws CancelledException {
        if (relocationMap.isEmpty()) {
            return;
        }
        MachoRelocationHandler handler = MachoRelocationHandlerFactory.getHandler(this.machoHeader);
        if (handler == null) {
            this.log.appendMsg(String.format("No relocation handler for machine type 0x%x", this.machoHeader.getCpuType()));
        }
        Iterator<RelocationInfo> iter = relocationMap.keySet().iterator();
        while (iter.hasNext()) {
            RelocationInfo relocationInfo = iter.next();
            Address address = relocationMap.get(relocationInfo);
            MachoRelocation relocation = null;
            RelocationResult result = RelocationResult.FAILURE;
            if (handler != null) {
                relocation = handler.isPairedRelocation(relocationInfo) ? new MachoRelocation(this.program, this.machoHeader, address, relocationInfo, iter.next()) : new MachoRelocation(this.program, this.machoHeader, address, relocationInfo);
                try {
                    result = handler.relocate(relocation);
                    if (result.status() == Relocation.Status.UNSUPPORTED) {
                        this.handleRelocationError(address, String.format("Relocation type 0x%x at address %s is not supported", relocationInfo.getType(), address));
                    }
                }
                catch (MemoryAccessException e) {
                    this.handleRelocationError(address, String.format("Relocation failure at address %s: error accessing memory.", address));
                }
                catch (RelocationException e) {
                    this.handleRelocationError(address, String.format("Relocation failure at address %s: %s", address, e.getMessage()));
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.toString();
                    }
                    msg = String.format("Relocation failure at address %s: %s", address, msg);
                    this.handleRelocationError(address, msg);
                    Msg.error((Object)this, (Object)msg, (Throwable)e);
                }
            }
            this.program.getRelocationTable().add(address, result.status(), relocationInfo.getType(), new long[]{relocationInfo.getValue(), relocationInfo.getLength(), relocationInfo.isPcRelocated() ? 1L : 0L, relocationInfo.isExternal() ? 1L : 0L, relocationInfo.isScattered() ? 1L : 0L}, result.byteLength(), relocation != null ? relocation.getTargetDescription() : null);
        }
    }

    protected void markupLoadCommandData(MachHeader header, String source) throws Exception {
        for (LoadCommand cmd : header.getLoadCommands()) {
            cmd.markup(this.program, header, source, this.monitor, this.log);
        }
    }

    private void handleRelocationError(Address address, String message) {
        this.program.getBookmarkManager().setBookmark(address, "Error", "Relocations", message);
        this.log.appendMsg(message);
    }

    private void addLibrary(String library) {
        library = library.replaceAll(" ", "_");
        try {
            this.program.getExternalManager().addExternalLibraryName(library, SourceType.IMPORTED);
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (Exception e) {
            this.log.appendMsg("Unable to add external library name: " + e.getMessage());
        }
    }

    private Address getAddress() {
        Address maxAddress = this.program.getMaxAddress();
        if (maxAddress == null) {
            return this.space.getAddress(4096L);
        }
        long maxAddr = maxAddress.getOffset();
        long remainder = maxAddr % 4096L;
        return maxAddress.getNewAddress(maxAddr + 4096L - remainder);
    }

    private MemoryBlock getMemoryBlock(Section section) {
        Address blockAddress = this.space.getAddress(section.getAddress());
        return this.memory.getBlock(blockAddress);
    }

    private void markupBlock(MemoryBlock block, DataType datatype) throws Exception {
        Address address = block.getStart();
        while (!this.monitor.isCancelled() && address.compareTo((Object)block.getEnd()) <= 0) {
            int length;
            try {
                this.listing.createData(address, datatype);
                length = this.listing.getDataAt(address).getLength();
            }
            catch (Exception e) {
                if (!(datatype instanceof Pointer)) {
                    this.log.appendException((Throwable)e);
                }
                return;
            }
            if (datatype instanceof Pointer) {
                this.fixupThumbPointers(address);
            }
            address = address.add((long)length);
        }
    }

    private void fixupThumbPointers(Address address) throws AddressOverflowException {
        Data data = this.listing.getDefinedDataAt(address);
        if (data == null) {
            return;
        }
        Object value = data.getValue();
        if (!(value instanceof Address)) {
            return;
        }
        Address pointerAddress = (Address)value;
        if (pointerAddress.getOffset() % 2L == 0L) {
            return;
        }
        MemoryBlock pointerBlock = this.memory.getBlock(pointerAddress);
        if (pointerBlock == null) {
            return;
        }
        if (!pointerBlock.isExecute()) {
            return;
        }
        Reference[] refs = data.getReferencesFrom();
        ReferenceManager referenceManager = this.program.getReferenceManager();
        for (Reference ref : refs) {
            if (this.monitor.isCancelled()) break;
            if (!ref.getToAddress().equals((Object)pointerAddress)) continue;
            referenceManager.delete(ref);
            Address thumbAddress = ref.getToAddress().subtract(1L);
            referenceManager.addMemoryReference(ref.getFromAddress(), thumbAddress, ref.getReferenceType(), ref.getSource(), ref.getOperandIndex());
            try {
                this.markAsThumb(thumbAddress);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
    }

    private void markAsThumb(Address address) throws ContextChangeException, AddressOverflowException {
        if (!this.program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"))) {
            return;
        }
        if ((address.getOffset() & 1L) == 1L) {
            address = address.subtractNoWrap(1L);
        }
        Register tModeRegister = this.program.getLanguage().getRegister("TMode");
        this.program.getProgramContext().setValue(tModeRegister, address, address, BigInteger.ONE);
        this.createOneByteFunction(null, address);
    }

    private void processLazyPointerSection(AddressSetView set) {
        DataIterator dataIterator = this.listing.getData(set, true);
        block2: while (dataIterator.hasNext() && !this.monitor.isCancelled()) {
            Reference[] references;
            Data data = dataIterator.next();
            for (Reference reference : references = data.getReferencesFrom()) {
                if (this.monitor.isCancelled()) continue block2;
                Symbol fromSymbol = this.program.getSymbolTable().getPrimarySymbol(reference.getFromAddress());
                try {
                    MemoryBlock memoryBlock = this.memory.getBlock(reference.getToAddress());
                    Namespace namespace = this.createNamespace(memoryBlock.getName());
                    this.program.getSymbolTable().createLabel(reference.getToAddress(), fromSymbol.getName(), namespace, SourceType.IMPORTED);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected Namespace createNamespace(String namespaceName) {
        try {
            return this.program.getSymbolTable().createNameSpace(this.program.getGlobalNamespace(), namespaceName, SourceType.IMPORTED);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            Namespace namespace = this.program.getSymbolTable().getNamespace(namespaceName, this.program.getGlobalNamespace());
            if (namespace != null) {
                return namespace;
            }
            this.log.appendMsg("Unable to create namespace: " + namespaceName);
            this.log.appendException(e);
            return this.program.getGlobalNamespace();
        }
    }

    void createOneByteFunction(String name, Address address) {
        FunctionManager functionMgr = this.program.getFunctionManager();
        if (functionMgr.getFunctionAt(address) != null) {
            return;
        }
        try {
            functionMgr.createFunction(name, address, (AddressSetView)new AddressSet(address), SourceType.IMPORTED);
        }
        catch (InvalidInputException invalidInputException) {
        }
        catch (OverlappingFunctionException overlappingFunctionException) {
            // empty catch block
        }
    }

    protected void markupChainedFixups(MachHeader header, List<Address> chainedFixups) throws CancelledException {
        for (Address addr : chainedFixups) {
            this.monitor.checkCancelled();
            try {
                this.listing.createData(addr, (DataType)PointerDataType.dataType);
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {}
        }
    }

    protected void markupProgramVars() {
        if (this.program.getLanguage().getProcessor() == Processor.findOrPossiblyCreateProcessor((String)"PowerPC")) {
            return;
        }
        SymbolTable symbolTable = this.program.getSymbolTable();
        int defaultPointerSize = this.program.getDefaultPointerSize();
        QWordDataType intDataType = defaultPointerSize == 8 ? new QWordDataType() : new DWordDataType();
        Pointer intPointerDataType = PointerDataType.getPointer((DataType)intDataType, (int)defaultPointerSize);
        Pointer voidPointerDatatype = PointerDataType.getPointer((DataType)new VoidDataType(), (int)defaultPointerSize);
        Pointer charPointerX1DataType = PointerDataType.getPointer((DataType)new CharDataType(), (int)defaultPointerSize);
        Pointer charPointerX2DataType = PointerDataType.getPointer((DataType)charPointerX1DataType, (int)defaultPointerSize);
        Pointer charPointerX3DataType = PointerDataType.getPointer((DataType)charPointerX2DataType, (int)defaultPointerSize);
        StructureDataType structure = new StructureDataType("__program_vars", 0);
        structure.add((DataType)voidPointerDatatype, "mh", "pointer to __mh_execute_header");
        structure.add((DataType)intPointerDataType, "NXArgcPtr", "pointer to argc");
        structure.add((DataType)charPointerX3DataType, "NXArgvPtr", "pointer to argv");
        structure.add((DataType)charPointerX3DataType, "environPtr", "pointer to environment");
        structure.add((DataType)charPointerX2DataType, "__prognamePtr", "pointer to program name");
        Namespace namespace = this.createNamespace("__program_vars");
        List<Section> sections = this.machoHeader.getAllSections();
        for (Section section : sections) {
            if (!section.getSectionName().equals("__program_vars")) continue;
            MemoryBlock memoryBlock = this.getMemoryBlock(section);
            try {
                this.listing.createData(memoryBlock.getStart(), (DataType)structure);
                Data data = this.listing.getDataAt(memoryBlock.getStart());
                Data mhData = data.getComponent(0);
                if (symbolTable.getSymbol("__mh_execute_header", mhData.getAddress(0), namespace) == null) {
                    symbolTable.createLabel(mhData.getAddress(0), "__mh_execute_header", namespace, SourceType.IMPORTED);
                }
                Data argcData = data.getComponent(1);
                symbolTable.createLabel(argcData.getAddress(0), "NXArgc", namespace, SourceType.IMPORTED);
                this.listing.createData(argcData.getAddress(0), (DataType)intDataType);
                Data argvData = data.getComponent(2);
                symbolTable.createLabel(argvData.getAddress(0), "NXArgv", namespace, SourceType.IMPORTED);
                this.listing.createData(argvData.getAddress(0), (DataType)charPointerX2DataType);
                Data environData = data.getComponent(3);
                symbolTable.createLabel(environData.getAddress(0), "environ", namespace, SourceType.IMPORTED);
                this.listing.createData(environData.getAddress(0), (DataType)charPointerX2DataType);
                Data prognameData = data.getComponent(4);
                symbolTable.createLabel(prognameData.getAddress(0), "__progname", namespace, SourceType.IMPORTED);
                this.listing.createData(prognameData.getAddress(0), (DataType)charPointerX1DataType);
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
                return;
            }
        }
    }

    protected void setRelocatableProperty() {
        Options props = this.program.getOptions("Program Information");
        switch (this.machoHeader.getFileType()) {
            case 2: {
                props.setBoolean("Relocatable", false);
                break;
            }
            default: {
                props.setBoolean("Relocatable", true);
            }
        }
    }

    protected void setProgramDescription() {
        Options props = this.program.getOptions("Program Information");
        props.setString("Mach-O File Type", MachHeaderFileTypes.getFileTypeName(this.machoHeader.getFileType()));
        props.setString("Mach-O File Type Description", MachHeaderFileTypes.getFileTypeDescription(this.machoHeader.getFileType()));
        List<String> flags = MachHeaderFlags.getFlags(this.machoHeader.getFlags());
        for (int i = 0; i < flags.size(); ++i) {
            props.setString("Mach-O Flag " + i, flags.get(i));
        }
        List<SubUmbrellaCommand> umbrellas = this.machoHeader.getLoadCommands(SubUmbrellaCommand.class);
        for (int i = 0; i < umbrellas.size(); ++i) {
            props.setString("Mach-O Sub-umbrella " + i, umbrellas.get(i).getSubUmbrellaFrameworkName().getString());
        }
        List<SubFrameworkCommand> frameworks = this.machoHeader.getLoadCommands(SubFrameworkCommand.class);
        for (int i = 0; i < frameworks.size(); ++i) {
            props.setString("Mach-O Sub-framework " + i, frameworks.get(i).getUmbrellaFrameworkName().getString());
        }
    }

    protected void renameObjMsgSendRtpSymbol() throws DuplicateNameException, InvalidInputException {
        Address address = this.space.getAddress(0xFFFEFF00L);
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(address);
        if (symbol != null && symbol.isDynamic()) {
            symbol.setName("_objc_msgSend_rtp", SourceType.IMPORTED);
        } else {
            this.program.getSymbolTable().createLabel(address, "_objc_msgSend_rtp", SourceType.IMPORTED);
        }
    }
}

