/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.headless;

import generic.stl.Pair;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.app.util.headless.HeadlessAnalyzer;
import ghidra.app.util.headless.HeadlessOptions;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.protocol.ghidra.Handler;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AnalyzeHeadless
implements GhidraLaunchable {
    private static final int EXIT_CODE_ERROR = 1;

    public void launch(GhidraApplicationLayout layout, String[] args) throws Exception {
        int optionStartIndex;
        String projectName = null;
        String rootFolderPath = null;
        URL ghidraURL = null;
        ArrayList<File> filesToImport = new ArrayList<File>();
        if (args.length < 1) {
            this.usage();
        }
        Handler.registerHandler();
        if (args[0].startsWith("ghidra:")) {
            optionStartIndex = 1;
            try {
                ghidraURL = new URL(args[0]);
            }
            catch (MalformedURLException e) {
                System.err.println("Invalid Ghidra URL: " + args[0]);
                this.usage();
            }
        } else {
            if (args.length < 2) {
                this.usage();
            }
            optionStartIndex = 2;
            String projectNameAndFolder = args[1];
            projectName = projectNameAndFolder = projectNameAndFolder.replaceAll("\\\\", "/");
            rootFolderPath = "/";
            int folderIndex = projectNameAndFolder.indexOf("/");
            if (folderIndex == 0) {
                System.err.println(args[1] + " is an invalid project_name/folder_path.");
                this.usage();
            } else if (folderIndex > 0) {
                projectName = projectNameAndFolder.substring(0, folderIndex);
                rootFolderPath = projectNameAndFolder.substring(folderIndex);
            }
        }
        File logFile = null;
        File scriptLogFile = null;
        for (int argi = optionStartIndex; argi < args.length; ++argi) {
            if (this.checkArgument("-log", args, argi)) {
                logFile = new File(args[++argi]);
                continue;
            }
            if (!this.checkArgument("-scriptlog", args, argi)) continue;
            scriptLogFile = new File(args[++argi]);
        }
        HeadlessAnalyzer analyzer = null;
        analyzer = Application.isInitialized() ? HeadlessAnalyzer.getInstance() : HeadlessAnalyzer.getLoggableInstance(logFile, scriptLogFile, true);
        HeadlessOptions options = analyzer.getOptions();
        this.parseOptions(options, args, optionStartIndex, ghidraURL, filesToImport);
        try {
            if (ghidraURL != null) {
                analyzer.processURL(ghidraURL, filesToImport);
            } else {
                analyzer.processLocal(args[0], projectName, rootFolderPath, filesToImport);
            }
        }
        catch (Throwable e) {
            Msg.error(HeadlessAnalyzer.class, (Object)("Abort due to Headless analyzer error: " + e.getMessage()), (Throwable)e);
            System.exit(1);
        }
    }

    private void parseOptions(HeadlessOptions options, String[] args, int startIndex, URL ghidraURL, List<File> filesToImport) throws InvalidInputException {
        String loaderName = null;
        LinkedList<Pair<String, String>> loaderArgs = new LinkedList<Pair<String, String>>();
        String languageId = null;
        String compilerSpecId = null;
        String keystorePath = null;
        String serverUID = null;
        boolean allowPasswordPrompt = false;
        LinkedList<Pair<String, String[]>> preScripts = new LinkedList<Pair<String, String[]>>();
        LinkedList<Pair<String, String[]>> postScripts = new LinkedList<Pair<String, String[]>>();
        block4: for (int argi = startIndex; argi < args.length; ++argi) {
            String[] scriptArgs;
            String scriptName;
            String arg = args[argi];
            if (this.checkArgument("-log", args, argi)) {
                ++argi;
                continue;
            }
            if (this.checkArgument("-scriptlog", args, argi)) {
                ++argi;
                continue;
            }
            if (arg.equalsIgnoreCase("-overwrite")) {
                options.enableOverwriteOnConflict(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-noanalysis")) {
                options.enableAnalysis(false);
                continue;
            }
            if (arg.equalsIgnoreCase("-deleteproject")) {
                options.setDeleteCreatedProjectOnClose(true);
                continue;
            }
            if (this.checkArgument("-loader", args, argi)) {
                loaderName = args[++argi];
                continue;
            }
            if (arg.startsWith("-loader")) {
                if (args[argi + 1].startsWith("-")) {
                    throw new InvalidInputException(args[argi] + " expects value to follow.");
                }
                loaderArgs.add((Pair<String, String>)new Pair((Object)arg, (Object)args[++argi]));
                continue;
            }
            if (this.checkArgument("-processor", args, argi)) {
                languageId = args[++argi];
                continue;
            }
            if (this.checkArgument("-cspec", args, argi)) {
                compilerSpecId = args[++argi];
                continue;
            }
            if (this.checkArgument("-prescript", args, argi)) {
                scriptName = args[++argi];
                scriptArgs = this.getSubArguments(args, argi);
                argi += scriptArgs.length;
                preScripts.add((Pair<String, String[]>)new Pair((Object)scriptName, (Object)scriptArgs));
                continue;
            }
            if (this.checkArgument("-postscript", args, argi)) {
                scriptName = args[++argi];
                scriptArgs = this.getSubArguments(args, argi);
                argi += scriptArgs.length;
                postScripts.add((Pair<String, String[]>)new Pair((Object)scriptName, (Object)scriptArgs));
                continue;
            }
            if (this.checkArgument("-scriptPath", args, argi)) {
                options.setScriptDirectories(args[++argi]);
                continue;
            }
            if (this.checkArgument("-propertiesPath", args, argi)) {
                options.setPropertiesFileDirectories(args[++argi]);
                continue;
            }
            if (this.checkArgument("-import", args, argi)) {
                File inputFile;
                if (!(inputFile = new File(args[++argi]).getAbsoluteFile()).isDirectory() && !inputFile.isFile()) {
                    throw new InvalidInputException(inputFile + " is not a valid directory or file.");
                }
                HeadlessAnalyzer.checkValidFilename(inputFile);
                filesToImport.add(inputFile);
                while (argi < args.length - 1) {
                    String nextArg;
                    if ((nextArg = args[++argi]).charAt(0) == '-') {
                        --argi;
                        continue block4;
                    }
                    File otherFile = new File(nextArg).getAbsoluteFile();
                    if (!otherFile.isFile() && !otherFile.isDirectory()) {
                        throw new InvalidInputException(otherFile + " is not a valid directory or file.");
                    }
                    HeadlessAnalyzer.checkValidFilename(otherFile);
                    filesToImport.add(otherFile);
                }
                continue;
            }
            if ("-connect".equals(args[argi])) {
                if (argi + 1 >= args.length || (arg = args[argi + 1]).startsWith("-")) continue;
                serverUID = arg;
                ++argi;
                continue;
            }
            if ("-commit".equals(args[argi])) {
                String comment = null;
                if (argi + 1 < args.length && !(arg = args[argi + 1]).startsWith("-")) {
                    comment = arg;
                    ++argi;
                }
                options.setCommitFiles(true, comment);
                continue;
            }
            if (this.checkArgument("-keystore", args, argi)) {
                File keystore;
                if ((keystore = new File(keystorePath = args[++argi])).isFile()) continue;
                throw new InvalidInputException(keystore.getAbsolutePath() + " is not a valid keystore file.");
            }
            if (arg.equalsIgnoreCase("-p")) {
                allowPasswordPrompt = true;
                continue;
            }
            if ("-analysisTimeoutPerFile".equalsIgnoreCase(args[argi])) {
                options.setPerFileAnalysisTimeout(args[++argi]);
                continue;
            }
            if ("-process".equals(args[argi])) {
                if (options.runScriptsNoImport) {
                    throw new InvalidInputException("The -process option may only be specified once.");
                }
                String processBinary = null;
                if (argi + 1 < args.length && !(arg = args[argi + 1]).startsWith("-")) {
                    processBinary = arg;
                    ++argi;
                }
                options.setRunScriptsNoImport(true, processBinary);
                continue;
            }
            if ("-recursive".equals(args[argi])) {
                options.enableRecursiveProcessing(true);
                continue;
            }
            if ("-readOnly".equalsIgnoreCase(args[argi])) {
                options.enableReadOnlyProcessing(true);
                continue;
            }
            if (this.checkArgument("-max-cpu", args, argi)) {
                String cpuVal = args[++argi];
                try {
                    options.setMaxCpu(Integer.parseInt(cpuVal));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidInputException("Invalid value for max-cpu: " + cpuVal);
                }
            }
            if ("-okToDelete".equalsIgnoreCase(args[argi])) {
                options.setOkToDelete(true);
                continue;
            }
            throw new InvalidInputException("Bad argument: " + arg);
        }
        options.setPreScriptsWithArgs(preScripts);
        options.setPostScriptsWithArgs(postScripts);
        options.setLoader(loaderName, loaderArgs);
        options.setLanguageAndCompiler(languageId, compilerSpecId);
        try {
            options.setClientCredentials(serverUID, keystorePath, allowPasswordPrompt);
        }
        catch (IOException e) {
            throw new InvalidInputException("Failed to install Ghidra Server authenticator: " + e.getMessage());
        }
        if (options.runScriptsNoImport) {
            if (filesToImport != null && filesToImport.size() > 0) {
                System.err.print("Must use either -process or -import parameters, but not both.");
                System.err.print(" -process runs scripts over existing program(s) in a project, whereas -import");
                System.err.println(" imports new programs and runs scripts and/or analyzes them after import.");
                System.exit(1);
            }
            if (options.overwrite) {
                Msg.warn(HeadlessAnalyzer.class, (Object)"The -overwrite parameter does not apply to -process mode.  Ignoring overwrite and continuing.");
            }
            if (options.readOnly && options.okToDelete) {
                System.err.println("You have specified the conflicting parameters -readOnly and -okToDelete. Please pick one and try again.");
                System.exit(1);
            }
        } else if (filesToImport == null || filesToImport.size() == 0) {
            if (options.preScripts.isEmpty() && options.postScripts.isEmpty()) {
                System.err.println("Nothing to do ... must specify -import, -process, or prescript and/or postscript.");
                System.exit(1);
            } else {
                Msg.warn(HeadlessAnalyzer.class, (Object)"Neither the -import parameter nor the -process parameter was specified; therefore, the specified prescripts and/or postscripts will be executed without any type of program context.");
            }
        }
        if (options.commit && options.readOnly) {
            System.err.println("Can not use -commit and -readOnly at the same time.");
            System.exit(1);
        }
        if (!options.commit && ghidraURL != null) {
            if (!options.readOnly) {
                options.setCommitFiles(true, null);
            } else {
                Msg.warn(HeadlessAnalyzer.class, (Object)"-readOnly mode is on: for -process, changes will not be saved.");
            }
        }
    }

    public static void usage(String execCmd) {
        System.out.println("Headless Analyzer Usage: " + execCmd);
        System.out.println("           <project_location> <project_name>[/<folder_path>]");
        System.out.println("             | ghidra://<server>[:<port>]/<repository_name>[/<folder_path>]");
        System.out.println("           [[-import [<directory>|<file>]+] | [-process [<project_file>]]]");
        System.out.println("           [-preScript <ScriptName>]");
        System.out.println("           [-postScript <ScriptName>]");
        System.out.println("           [-scriptPath \"<path1>[;<path2>...]\"]");
        System.out.println("           [-propertiesPath \"<path1>[;<path2>...]\"]");
        System.out.println("           [-scriptlog <path to script log file>]");
        System.out.println("           [-log <path to log file>]");
        System.out.println("           [-overwrite]");
        System.out.println("           [-recursive]");
        System.out.println("           [-readOnly]");
        System.out.println("           [-deleteProject]");
        System.out.println("           [-noanalysis]");
        System.out.println("           [-processor <languageID>]");
        System.out.println("           [-cspec <compilerSpecID>]");
        System.out.println("           [-analysisTimeoutPerFile <timeout in seconds>]");
        System.out.println("           [-keystore <KeystorePath>]");
        System.out.println("           [-connect <userID>]");
        System.out.println("           [-p]");
        System.out.println("           [-commit [\"<comment>\"]]");
        System.out.println("           [-okToDelete]");
        System.out.println("           [-max-cpu <max cpu cores to use>]");
        System.out.println("           [-loader <desired loader name>]");
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.WINDOWS) {
            System.out.println();
            System.out.println("     - All uses of $GHIDRA_HOME or $USER_HOME in script path must be preceded by '\\'");
        }
        System.out.println();
        System.out.println("Please refer to 'analyzeHeadlessREADME.html' for detailed usage examples and notes.");
        System.out.println();
        System.exit(1);
    }

    private void usage() {
        AnalyzeHeadless.usage("analyzeHeadless");
    }

    private String[] getSubArguments(String[] args, int argi) {
        LinkedList<String> subArgs = new LinkedList<String>();
        int i = argi + 1;
        while (i < args.length && !args[i].startsWith("-")) {
            subArgs.add(args[i++]);
        }
        return subArgs.toArray(new String[0]);
    }

    private boolean checkArgument(String optionName, String[] args, int argi) throws InvalidInputException {
        if (!optionName.equalsIgnoreCase(args[argi])) {
            return false;
        }
        if (argi + 1 == args.length) {
            throw new InvalidInputException(optionName + " requires an argument");
        }
        return true;
    }
}

