/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class MultiPayloadEnumDescriptor
implements SwiftStructure {
    public static final int SIZE = 4;
    private String typeName;
    private int[] contents;

    public MultiPayloadEnumDescriptor(BinaryReader reader) throws IOException {
        this.typeName = reader.readNext(SwiftUtils::relativeString);
        int size = reader.readNextInt() >> 16 & 0xFFFF;
        reader.setPointerIndex(reader.getPointerIndex() - 4L);
        this.contents = reader.readNextIntArray(size);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int[] getContents() {
        return this.contents;
    }

    public long getContentsSize() {
        return this.contents.length * 4;
    }

    @Override
    public String getStructureName() {
        return MultiPayloadEnumDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "multipayload enum descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return SwiftUtils.PTR_STRING;
    }
}

