/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class BuildVersionCommand
extends LoadCommand {
    private int platform;
    private int minos;
    private int sdk;
    private int ntools;
    private BuildToolVersion[] buildToolVersions;

    BuildVersionCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.platform = reader.readNextInt();
        this.minos = reader.readNextInt();
        this.sdk = reader.readNextInt();
        this.ntools = reader.readNextInt();
        this.buildToolVersions = new BuildToolVersion[this.ntools];
        for (int i = 0; i < this.ntools; ++i) {
            this.buildToolVersions[i] = new BuildToolVersion(reader.readNextInt(), reader.readNextInt());
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType buildToolVersionDataType = new BuildToolVersion(0, 0).toDataType();
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "platform", null);
        struct.add(DWORD, "minos", null);
        struct.add(DWORD, "sdk", null);
        struct.add(DWORD, "ntools", null);
        if (this.ntools > 0) {
            struct.add((DataType)new ArrayDataType(buildToolVersionDataType, this.ntools, buildToolVersionDataType.getLength()), "build_tool_version[]", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "build_version_command";
    }

    public int getPlatform() {
        return this.platform;
    }

    public int getMinOS() {
        return this.minos;
    }

    public int getSdk() {
        return this.sdk;
    }

    public int getNumTools() {
        return this.ntools;
    }

    public static class BuildToolVersion
    implements StructConverter {
        private int tool;
        private int version;

        public BuildToolVersion(int tool, int version) {
            this.tool = tool;
            this.version = version;
        }

        public int getTool() {
            return this.tool;
        }

        public int getVersion() {
            return this.version;
        }

        @Override
        public DataType toDataType() throws DuplicateNameException, IOException {
            StructureDataType struct = new StructureDataType("build_tool_version", 0);
            struct.add(DWORD, "tool", null);
            struct.add(DWORD, "version", null);
            struct.setCategoryPath(new CategoryPath("/MachO"));
            return struct;
        }
    }
}

