/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoIface;
import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoFuncType;
import ghidra.app.util.bin.format.golang.rtti.types.GoIMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypedefDataType;
import java.io.IOException;
import java.util.List;
import java.util.Set;

@StructureMapping(structureName="runtime.interfacetype")
public class GoInterfaceType
extends GoType {
    @FieldMapping
    @MarkupReference(value="pkgPath")
    private long pkgpath;
    @FieldMapping
    private GoSlice mhdr;

    @Markup
    public GoName getPkgPath() throws IOException {
        return this.programContext.getGoName(this.pkgpath);
    }

    public String getPkgPathString() throws IOException {
        GoName n = this.getPkgPath();
        return n != null ? n.getName() : "";
    }

    public GoSlice getMethodsSlice() {
        return this.mhdr;
    }

    public List<GoIMethod> getMethods() throws IOException {
        return this.mhdr.readList(GoIMethod.class);
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException {
        this.mhdr.markupArray(null, GoIMethod.class, false, session);
        this.mhdr.markupArrayElements(GoIMethod.class, session);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        Structure dt = this.programContext.getStructureDataType(GoIface.class);
        String name = this.typ.getNameString();
        if (!dt.getName().equals(name)) {
            dt = new TypedefDataType(this.programContext.getRecoveredTypesCp(), name, (DataType)dt, this.programContext.getDTM());
        }
        return dt;
    }

    @Override
    public String getMethodListString() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (GoIMethod imethod : this.getMethods()) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            String methodStr = imethod.getNameString();
            GoType type = imethod.getType();
            if (type instanceof GoFuncType) {
                GoFuncType funcType = (GoFuncType)type;
                methodStr = funcType.getFuncPrototypeString(methodStr);
            } else {
                methodStr = "func %s()".formatted(methodStr);
            }
            sb.append(methodStr);
        }
        return sb.toString();
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        for (GoIMethod imethod : this.getMethods()) {
            GoType type = imethod.getType();
            if (type == null) continue;
            type.discoverGoTypes(discoveredTypes);
        }
        return true;
    }
}

