/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.FaultTolerantInputStream;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.elf.ElfCompressedSectionHeader;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.zip.InflaterInputStream;

public class ElfSectionHeader
implements StructConverter,
MemoryLoadable {
    private int sh_name;
    private int sh_type;
    private long sh_flags;
    private long sh_addr;
    private long sh_offset;
    private long sh_size;
    private int sh_link;
    private int sh_info;
    private long sh_addralign;
    private long sh_entsize;
    private BinaryReader reader;
    private ElfHeader header;
    private String name;
    private byte[] data;
    private boolean modified = false;
    private boolean bytesChanged = false;
    private ElfCompressedSectionHeader compressedHeader;

    public ElfSectionHeader(BinaryReader reader, ElfHeader header) throws IOException {
        this.reader = reader;
        this.header = header;
        this.sh_name = reader.readNextInt();
        this.sh_type = reader.readNextInt();
        if (header.is32Bit()) {
            this.sh_flags = Integer.toUnsignedLong(reader.readNextInt());
            this.sh_addr = Integer.toUnsignedLong(reader.readNextInt());
            this.sh_offset = Integer.toUnsignedLong(reader.readNextInt());
            this.sh_size = Integer.toUnsignedLong(reader.readNextInt());
        } else if (header.is64Bit()) {
            this.sh_flags = reader.readNextLong();
            this.sh_addr = reader.readNextLong();
            this.sh_offset = reader.readNextLong();
            this.sh_size = reader.readNextLong();
        }
        this.sh_link = reader.readNextInt();
        this.sh_info = reader.readNextInt();
        if (header.is32Bit()) {
            this.sh_addralign = Integer.toUnsignedLong(reader.readNextInt());
            this.sh_entsize = Integer.toUnsignedLong(reader.readNextInt());
        } else if (header.is64Bit()) {
            this.sh_addralign = reader.readNextLong();
            this.sh_entsize = reader.readNextLong();
        }
        if ((this.sh_flags & 0x800L) != 0L) {
            this.compressedHeader = this.readCompressedSectionHeader();
        }
    }

    private ElfCompressedSectionHeader readCompressedSectionHeader() {
        try {
            if (!this.isValidForCompressed(this.reader.length())) {
                throw new IOException("Invalid compressed section: %s".formatted(this.getNameAsString()));
            }
            ElfCompressedSectionHeader result = ElfCompressedSectionHeader.read(this.getRawSectionReader(), this.header);
            if (!this.isSupportedCompressionType(result.getCh_type())) {
                throw new IOException("Unknown ELF section compression type 0x%x for section %s".formatted(this.compressedHeader.getCh_type(), this.getNameAsString()));
            }
            return result;
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)("Error reading compressed section information: " + e));
            Msg.debug((Object)this, (Object)"Error reading compressed section information", (Throwable)e);
            return null;
        }
    }

    private boolean isValidForCompressed(long streamLength) {
        long endOffset = this.sh_offset + this.sh_size;
        return !this.isAlloc() && this.sh_offset >= 0L && this.sh_size > 0L && endOffset > 0L && endOffset <= streamLength;
    }

    ElfSectionHeader(ElfHeader header, MemoryBlock block, int sh_name, long imageBase) throws MemoryAccessException {
        this.header = header;
        this.sh_name = sh_name;
        this.sh_type = block.isInitialized() ? 1 : 8;
        this.sh_flags = 7L;
        this.sh_addr = block.getStart().getOffset();
        this.sh_offset = block.getStart().getAddressableWordOffset() - imageBase;
        this.sh_size = block.getSize();
        this.sh_link = 0;
        this.sh_info = 0;
        this.sh_addralign = 0L;
        this.sh_entsize = 0L;
        this.name = block.getName();
        this.data = new byte[(int)this.sh_size];
        if (block.isInitialized()) {
            block.getBytes(block.getStart(), this.data);
        }
        this.modified = true;
    }

    ElfSectionHeader(ElfHeader header, String name, int sh_name, int type) {
        this.header = header;
        this.name = name;
        this.sh_name = sh_name;
        this.sh_type = type;
        this.sh_flags = 7L;
        this.sh_link = 0;
        this.sh_info = 0;
        this.sh_addralign = 0L;
        this.sh_entsize = 0L;
        this.data = new byte[0];
        this.sh_size = 0L;
        this.sh_addr = -1L;
        this.sh_offset = -1L;
    }

    public ElfHeader getElfHeader() {
        return this.header;
    }

    public long getAddress() {
        return this.header.adjustAddressForPrelink(this.sh_addr);
    }

    public long getAddressAlignment() {
        return this.compressedHeader == null ? this.sh_addralign : this.compressedHeader.getCh_addralign();
    }

    public long getEntrySize() {
        return this.sh_entsize;
    }

    public long getFlags() {
        return this.sh_flags;
    }

    public boolean isWritable() {
        return this.header.getLoadAdapter().isSectionWritable(this);
    }

    public boolean isExecutable() {
        return this.header.getLoadAdapter().isSectionExecutable(this);
    }

    public boolean isAlloc() {
        return this.header.getLoadAdapter().isSectionAllocated(this);
    }

    public boolean isCompressed() {
        return this.compressedHeader != null;
    }

    private boolean isSupportedCompressionType(int compressionType) {
        return switch (compressionType) {
            case 1 -> true;
            default -> false;
        };
    }

    private boolean isNoBits() {
        return this.sh_type == 8;
    }

    public int getInfo() {
        return this.sh_info;
    }

    public int getLink() {
        return this.sh_link;
    }

    public int getName() {
        return this.sh_name;
    }

    void updateName() {
        if (this.reader == null) {
            throw new UnsupportedOperationException("This ElfSectionHeader does not have a reader");
        }
        ElfSectionHeader[] sections = this.header.getSections();
        int e_shstrndx = this.header.e_shstrndx();
        this.name = null;
        try {
            long stringTableOffset;
            long offset;
            if (this.sh_name >= 0 && e_shstrndx > 0 && e_shstrndx < sections.length && !sections[e_shstrndx].isInvalidOffset() && (offset = (stringTableOffset = sections[e_shstrndx].getOffset()) + (long)this.sh_name) < this.reader.length()) {
                this.name = this.reader.readUtf8String(stringTableOffset + (long)this.sh_name);
                if ("".equals(this.name)) {
                    this.name = null;
                }
            }
        }
        catch (IOException stringTableOffset) {
            // empty catch block
        }
        if (this.name == null) {
            this.name = "NO-NAME";
            for (int i = 0; i < sections.length; ++i) {
                if (sections[i] != this) continue;
                this.name = "SECTION" + i;
                break;
            }
        }
    }

    public String getNameAsString() {
        return this.name;
    }

    public String toString() {
        return this.name + " - 0x" + Long.toHexString(this.sh_addr) + ":0x" + Long.toHexString(this.sh_addr + this.sh_size - 1L) + " - 0x" + Long.toHexString(this.sh_size) + "  - 0x" + Long.toHexString(this.sh_offset);
    }

    public long getOffset() {
        return this.sh_offset;
    }

    public boolean isInvalidOffset() {
        return this.sh_offset < 0L || this.header.is32Bit() && this.sh_offset == 0xFFFFFFFFL;
    }

    public long getSize() {
        return this.sh_size;
    }

    public long getLogicalSize() {
        return this.compressedHeader == null ? this.sh_size : this.compressedHeader.getCh_size();
    }

    @Override
    public boolean hasFilteredLoadInputStream(ElfLoadHelper elfLoadHelper, Address start) {
        return this.isCompressed() || this.header.getLoadAdapter().hasFilteredLoadInputStream(elfLoadHelper, this, start);
    }

    @Override
    public InputStream getFilteredLoadInputStream(ElfLoadHelper elfLoadHelper, Address start, long dataLength, BiConsumer<String, Throwable> errorConsumer) throws IOException {
        InputStream is = this.isCompressed() ? this.getDecompressedDataStream(dataLength, errorConsumer) : this.getRawInputStream();
        return this.header.getLoadAdapter().getFilteredLoadInputStream(elfLoadHelper, this, start, dataLength, is);
    }

    @Override
    public InputStream getRawInputStream() throws IOException {
        return this.getRawSectionByteProvider().getInputStream(0L);
    }

    public int getType() {
        return this.sh_type;
    }

    public String getTypeAsString() {
        ElfSectionHeaderType sectionHeaderType = this.header.getSectionHeaderType(this.sh_type);
        if (sectionHeaderType != null) {
            return sectionHeaderType.name;
        }
        return "SHT_0x" + StringUtilities.pad((String)Integer.toHexString(this.sh_type), (char)'0', (int)8);
    }

    private InputStream getDecompressedDataStream(long dataLength, BiConsumer<String, Throwable> errorConsumer) throws IOException {
        if (this.compressedHeader == null || dataLength != this.compressedHeader.getCh_size()) {
            throw new UnsupportedOperationException();
        }
        int skip = this.compressedHeader.getHeaderSize();
        InputStream is = this.getRawSectionByteProvider().getInputStream(skip);
        is = this.getDecompressionStream(is);
        return new FaultTolerantInputStream(is, this.compressedHeader.getCh_size(), errorConsumer);
    }

    private ByteProvider getRawSectionByteProvider() {
        if (this.reader == null) {
            throw new UnsupportedOperationException("This ElfSectionHeader does not have a reader");
        }
        if (this.isNoBits()) {
            return ByteProvider.EMPTY_BYTEPROVIDER;
        }
        return new ByteProviderWrapper(this.reader.getByteProvider(), this.sh_offset, this.sh_size);
    }

    private BinaryReader getRawSectionReader() throws IOException {
        return new BinaryReader(this.getRawSectionByteProvider(), this.header.isLittleEndian());
    }

    private InputStream getDecompressionStream(InputStream compressedStream) throws IOException {
        switch (this.compressedHeader.getCh_type()) {
            case 1: {
                Msg.debug((Object)this, (Object)"Decompressing ELF section %s, original/decompressed size: 0x%x/0x%x".formatted(this.getNameAsString(), this.sh_size, this.compressedHeader.getCh_size()));
                return new InflaterInputStream(compressedStream);
            }
        }
        throw new IOException("Unknown ELF section compression type 0x%x for section %s".formatted(this.compressedHeader.getCh_type(), this.getNameAsString()));
    }

    public BinaryReader getReader() {
        return this.reader;
    }

    public boolean isBytesChanged() {
        return this.bytesChanged;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setAddress(long addr) {
        if (!this.header.isRelocatable() && this.sh_addr == 0L) {
            throw new RuntimeException("Attempting to place non-loaded section into memory :" + this.name);
        }
        this.sh_addr = this.header.unadjustAddressForPrelink(addr);
    }

    @Override
    public DataType toDataType() {
        String dtName = this.header.is32Bit() ? "Elf32_Shdr" : "Elf64_Shdr";
        StructureDataType struct = new StructureDataType(new CategoryPath("/ELF"), dtName, 0);
        struct.add(DWORD, "sh_name", null);
        struct.add(this.getTypeDataType(), "sh_type", null);
        if (this.header.is32Bit()) {
            struct.add(DWORD, "sh_flags", null);
            struct.add(DWORD, "sh_addr", null);
            struct.add(DWORD, "sh_offset", null);
            struct.add(DWORD, "sh_size", null);
        } else if (this.header.is64Bit()) {
            struct.add(QWORD, "sh_flags", null);
            struct.add(QWORD, "sh_addr", null);
            struct.add(QWORD, "sh_offset", null);
            struct.add(QWORD, "sh_size", null);
        }
        struct.add(DWORD, "sh_link", null);
        struct.add(DWORD, "sh_info", null);
        if (this.header.is32Bit()) {
            struct.add(DWORD, "sh_addralign", null);
            struct.add(DWORD, "sh_entsize", null);
        } else if (this.header.is64Bit()) {
            struct.add(QWORD, "sh_addralign", null);
            struct.add(QWORD, "sh_entsize", null);
        }
        return struct;
    }

    private DataType getTypeDataType() {
        HashMap<Integer, ElfSectionHeaderType> sectionHeaderTypeMap = this.header.getSectionHeaderTypeMap();
        if (sectionHeaderTypeMap == null) {
            return DWordDataType.dataType;
        }
        Object dtName = "Elf_SectionHeaderType";
        String typeSuffix = this.header.getTypeSuffix();
        if (typeSuffix != null) {
            dtName = (String)dtName + typeSuffix;
        }
        EnumDataType typeEnum = new EnumDataType(new CategoryPath("/ELF"), (String)dtName, 4);
        for (ElfSectionHeaderType type : sectionHeaderTypeMap.values()) {
            typeEnum.add(type.name, (long)type.value);
        }
        return typeEnum;
    }

    public int hashCode() {
        return (int)(17L * this.sh_offset + (this.sh_offset >>> 32));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElfSectionHeader)) {
            return false;
        }
        ElfSectionHeader other = (ElfSectionHeader)obj;
        return this.reader == other.reader && this.sh_name == other.sh_name && this.sh_type == other.sh_type && this.sh_flags == other.sh_flags && this.sh_addr == other.sh_addr && this.sh_offset == other.sh_offset && this.sh_size == other.sh_size && this.sh_link == other.sh_link && this.sh_info == other.sh_info && this.sh_addralign == other.sh_addralign && this.sh_entsize == other.sh_entsize;
    }
}

