/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.ComponentProviderActivationListener;
import docking.DockingContextListener;
import docking.Tool;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.table.threaded.GThreadedTablePanel;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.RestrictedAddressSetContext;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.searchtext.AbstractSearchTableModel;
import ghidra.app.plugin.core.searchtext.ListingDisplaySearchTableModel;
import ghidra.app.plugin.core.searchtext.ListingDisplaySearcher;
import ghidra.app.plugin.core.searchtext.SearchOptions;
import ghidra.app.plugin.core.searchtext.SearchTask;
import ghidra.app.plugin.core.searchtext.SearchTextDialog;
import ghidra.app.plugin.core.searchtext.Searcher;
import ghidra.app.plugin.core.searchtext.databasesearcher.ProgramDatabaseSearchTableModel;
import ghidra.app.plugin.core.searchtext.databasesearcher.ProgramDatabaseSearcher;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.SearchConstants;
import ghidra.app.util.query.TableService;
import ghidra.app.util.viewer.field.EolCommentFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FunctionRepeatableCommentFieldFactory;
import ghidra.app.util.viewer.field.FunctionSignatureFieldFactory;
import ghidra.app.util.viewer.field.LabelFieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.MnemonicFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.app.util.viewer.field.PlateFieldFactory;
import ghidra.app.util.viewer.field.PostCommentFieldFactory;
import ghidra.app.util.viewer.field.PreCommentFieldFactory;
import ghidra.app.util.viewer.field.VariableCommentFieldFactory;
import ghidra.app.util.viewer.field.VariableLocFieldFactory;
import ghidra.app.util.viewer.field.VariableNameFieldFactory;
import ghidra.app.util.viewer.field.VariableTypeFieldFactory;
import ghidra.app.util.viewer.field.XRefFieldFactory;
import ghidra.app.util.viewer.field.XRefHeaderFieldFactory;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UserSearchUtils;
import ghidra.util.bean.opteditor.OptionsVetoException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Search", shortDescription="Search Program Text", description="This plugin searches program text for a string. It provides a program database search and a listing display match search. The program database search searches the program database and is faster than the listing display match search. The listing display match search may take a long time because a string must be rendered to search for each address in the program or in the selection. This string is the same as what would be displayed by the Code Browser if the address were visible. The search can be done incrementally, on a selection, or on the entire program. Multiple matches are displayed in a query results table. An option allows the search results to be highlighted in the Code Browser.", servicesRequired={ProgramManager.class, GoToService.class})
public class SearchTextPlugin
extends ProgramPlugin
implements OptionsChangeListener,
TaskListener,
NavigatableRemovalListener,
DockingContextListener {
    private static final Icon SEARCH_MARKER_ICON = new GIcon("icon.base.search.marker");
    private static final String DESCRIPTION = "Search program text for string";
    private boolean waitingForSearchAll;
    private SearchTextDialog searchDialog;
    private GoToService goToService;
    private int searchLimit;
    private SearchTask currentTask;
    private String lastSearchedText;
    private boolean doHighlight;
    private Navigatable navigatable;
    private TableLoadingListener currentTableListener;
    private TaskMonitor searchAllTaskMonitor;
    private boolean searchedOnce;

    public SearchTextPlugin(PluginTool plugintool) {
        super(plugintool);
        this.createActions();
        this.initializeOptions();
        this.tool.addContextListener((DockingContextListener)this);
    }

    public void taskCancelled(Task task) {
        this.searchDialog.setStatusText("Search cancelled");
        if (task == this.currentTask) {
            this.currentTask = null;
        }
    }

    public void taskCompleted(Task task) {
        if (this.tool == null || this.navigatable == null) {
            return;
        }
        this.searchDialog.setStatusText("");
        SearchTask searchTask = (SearchTask)task;
        Navigatable searchNavigatable = ((SearchTask)task).getNavigatable();
        Program program = ((SearchTask)task).getProgram();
        if (searchNavigatable.getProgram() == null || searchNavigatable.isDisposed()) {
            return;
        }
        Searcher.TextSearchResult result = searchTask.getSearchLocation();
        Searcher textSearcher = searchTask.getTextSearcher();
        SearchOptions searchOptions = textSearcher.getSearchOptions();
        if (result == null) {
            this.searchDialog.setStatusText("Not found");
        } else if (result.programLocation().equals((Object)this.currentLocation)) {
            this.searchNext(searchTask.getProgram(), searchNavigatable, textSearcher);
        } else {
            this.searchDialog.setStatusText("");
            ProgramLocation loc = result.programLocation();
            if (this.goToService.goTo(searchNavigatable, loc, program)) {
                new SearchTextHighlightProvider(searchNavigatable, searchOptions, null, program, result);
            }
        }
        this.lastSearchedText = searchOptions.getText();
        if (task == this.currentTask) {
            this.currentTask = null;
        }
    }

    String getLastSearchText() {
        return this.lastSearchedText;
    }

    protected void dispose() {
        this.tool.removeContextListener((DockingContextListener)this);
        ToolOptions opt = this.tool.getOptions("Tool");
        opt.removeOptionsChangeListener((OptionsChangeListener)this);
        opt = this.tool.getOptions("Search");
        opt.removeOptionsChangeListener((OptionsChangeListener)this);
        this.navigatable = null;
        if (this.searchDialog != null) {
            if (this.searchDialog.isVisible()) {
                TaskMonitorComponent taskMonitor = this.searchDialog.getTaskMonitorComponent();
                taskMonitor.cancel();
                if (this.searchAllTaskMonitor != null) {
                    this.searchAllTaskMonitor.cancel();
                }
            }
            this.searchDialog.dispose();
        }
        if (this.currentTask != null) {
            this.currentTask.cancel();
        }
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
    }

    private void setNavigatable(Navigatable newNavigatable) {
        if (newNavigatable == this.navigatable) {
            return;
        }
        if (this.navigatable != null) {
            this.navigatable.removeNavigatableListener(this);
        }
        if (newNavigatable != null) {
            newNavigatable.addNavigatableListener(this);
        }
        this.navigatable = newNavigatable;
        if (this.searchDialog != null) {
            this.searchDialog.setSearchEnabled(newNavigatable != null);
        }
    }

    private void updateSelection(NavigatableActionContext context) {
        if (this.searchDialog != null) {
            this.searchDialog.setHasSelection(context.hasSelection());
        }
    }

    private void updateSelectionFromCurrentNavigatable() {
        if (this.navigatable == null) {
            return;
        }
        if (this.searchDialog == null) {
            return;
        }
        ProgramSelection selection = this.navigatable.getSelection();
        this.searchDialog.setHasSelection(selection != null && !selection.isEmpty());
    }

    void next() {
        Program program = this.navigatable.getProgram();
        ProgramLocation location = this.getStartLocation();
        Searcher textSearcher = null;
        SearchOptions searchOptions = this.searchDialog.getSearchOptions();
        AddressSetView addressSet = this.getAddressSet(this.navigatable, searchOptions);
        textSearcher = searchOptions.isProgramDatabaseSearch() ? new ProgramDatabaseSearcher((ServiceProvider)this.tool, program, location, addressSet, searchOptions, this.searchDialog.showTaskMonitorComponent("Text Search", true, true)) : new ListingDisplaySearcher(this.tool, program, location, addressSet, this.searchDialog.getSearchOptions(), this.searchDialog.showTaskMonitorComponent("Text Search", true, true));
        this.searchNext(this.navigatable.getProgram(), this.navigatable, textSearcher);
    }

    private ProgramLocation getStartLocation() {
        this.currentLocation = this.navigatable.getLocation();
        return this.currentLocation;
    }

    private void searchNext(Program program, Navigatable searchNavigatable, Searcher textSearcher) {
        SearchTask task = new SearchTask(searchNavigatable, program, textSearcher);
        task.addTaskListener(this);
        this.currentTask = task;
        this.searchDialog.setStatusText("Searching...");
        this.searchDialog.executeProgressTask(task, 500);
    }

    void searchAll(SearchOptions options) {
        ProgramSelection selection = this.navigatable.getSelection();
        Program program = this.navigatable.getProgram();
        AddressSetView view = this.getSearchAllAddresses(program, selection);
        this.waitingForSearchAll = true;
        AbstractSearchTableModel ttModel = null;
        ttModel = options.isProgramDatabaseSearch() ? new ProgramDatabaseSearchTableModel(this.tool, program, view, options) : new ListingDisplaySearchTableModel(this.tool, program, view, options);
        this.showQueryData(ttModel, options, program, this.navigatable);
    }

    private AddressSetView getSearchAllAddresses(Program program, ProgramSelection selection) {
        Memory view = program.getMemory();
        if (this.searchDialog.searchSelection() && !selection.isEmpty()) {
            return new AddressSet((AddressSetView)selection);
        }
        return view;
    }

    private void showQueryData(GhidraProgramTableModel<ProgramLocation> model, SearchOptions searchOptions, Program searchProgram, Navigatable searchNavigatable) {
        TableService query = (TableService)this.tool.getService(TableService.class);
        String matchType = "Listing Display Match";
        if (model instanceof ProgramDatabaseSearchTableModel) {
            matchType = "Program Database";
        }
        String searchString = searchOptions.getText();
        if (searchNavigatable.getProgram() != searchProgram) {
            return;
        }
        this.currentTableListener = new TableLoadingListener(model);
        model.addInitialLoadListener(this.currentTableListener);
        TableComponentProvider<ProgramLocation> tableProvider = this.getTableResultsProvider(model, searchProgram, query, matchType, searchString);
        tableProvider.installRemoveItemsAction();
        this.currentTableListener.setProvider(tableProvider);
        GThreadedTablePanel<ProgramLocation> tablePanel = tableProvider.getThreadedTablePanel();
        this.searchAllTaskMonitor = tablePanel.getTaskMonitor();
        tableProvider.setHelpLocation(new HelpLocation("Search", "SearchAllResults"));
        new SearchTextHighlightProvider(searchNavigatable, searchOptions, tableProvider, searchProgram, null);
    }

    private TableComponentProvider<ProgramLocation> getTableResultsProvider(GhidraProgramTableModel<ProgramLocation> model, Program searchProgram, TableService query, String matchType, String searchString) {
        if (this.navigatable.supportsMarkers()) {
            return query.showTableWithMarkers("Search Text - \"" + searchString + "\"  [" + matchType + "]", "Search", model, (Color)SearchConstants.SEARCH_HIGHLIGHT_COLOR, SEARCH_MARKER_ICON, "Search", this.navigatable);
        }
        return query.showTable("Search Text - \"" + searchString + "\"  [" + matchType + "]", "Search", model, "Search", this.navigatable);
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        if (this.navigatable != null && this.navigatable.getProgram() == dObj && (this.waitingForSearchAll || this.currentTask != null)) {
            this.tool.setStatusInfo("Can't close program while searching...", true);
            return false;
        }
        return true;
    }

    void searched() {
        this.tool.contextChanged(null);
        this.searchedOnce = true;
    }

    int getResultsLimit() {
        return this.searchLimit;
    }

    SearchTextDialog getSearchDialog() {
        return this.searchDialog;
    }

    boolean isWaitingForSearchAll() {
        return this.waitingForSearchAll;
    }

    private void createActions() {
        String subGroup = this.getClass().getName();
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Search Text", this.getName()).menuPath(new String[]{"&Search", "Program &Text..."})).menuGroup("search", subGroup)).keyBinding("ctrl shift E")).description(DESCRIPTION)).helpLocation(new HelpLocation("Search", "Search Text"))).withContext(NavigatableActionContext.class, true).validContextWhen(c -> !(c instanceof RestrictedAddressSetContext)).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> {
            this.setNavigatable(c.getNavigatable());
            this.displayDialog((NavigatableActionContext)c);
        }).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Repeat Text Search", this.getName()).menuPath(new String[]{"&Search", "Repeat Text Search"})).menuGroup("search", subGroup)).keyBinding("ctrl shift F3")).description(DESCRIPTION)).helpLocation(new HelpLocation("Search", "Repeat Text Search"))).withContext(NavigatableActionContext.class, true).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).enabledWhen(c -> this.searchedOnce).onAction(c -> {
            this.setNavigatable(c.getNavigatable());
            this.searchDialog.repeatSearch();
        }).buildAndInstall((Tool)this.tool);
    }

    protected void updateNavigatable(ActionContext context) {
        if (context instanceof ListingActionContext) {
            NavigatableActionContext navContext = (NavigatableActionContext)context;
            this.setNavigatable(navContext.getNavigatable());
            this.updateSelection(navContext);
        } else {
            this.updateSelectionFromCurrentNavigatable();
        }
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals("Search Limit")) {
            int newSearchLimit = (Integer)newValue;
            if (newSearchLimit <= 0) {
                throw new OptionsVetoException("Search limit must be greater than 0");
            }
            this.searchLimit = newSearchLimit;
        } else if (optionName.equals("Highlight Search Results")) {
            this.doHighlight = (Boolean)newValue;
        }
    }

    private void initializeOptions() {
        ToolOptions opt = this.tool.getOptions("Search");
        HelpLocation loc = new HelpLocation("Search", "HighlightText");
        opt.registerOption("Highlight Search Results", (Object)true, loc, "Determines whether to highlight the matched string for a search in the listing.");
        opt.registerThemeColorBinding(" Highlight Color", SearchConstants.SEARCH_HIGHLIGHT_COLOR.getId(), null, "The search result highlight color");
        opt.registerThemeColorBinding("Highlight Color for Current Match", SearchConstants.SEARCH_HIGHLIGHT_CURRENT_ADDR_COLOR.getId(), null, "The search result highlight color for the currently selected match");
        this.searchLimit = opt.getInt("Search Limit", 500);
        this.doHighlight = opt.getBoolean("Highlight Search Results", true);
        opt.setOptionsHelpLocation(new HelpLocation("Search", "Search_Text"));
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    private void displayDialog(NavigatableActionContext context) {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchTextDialog(this);
            this.searchDialog.setHasSelection(context.hasSelection());
        }
        String textSelection = this.navigatable.getTextSelection();
        ProgramLocation location = this.navigatable.getLocation();
        Address address = location.getAddress();
        Listing listing = context.getProgram().getListing();
        CodeUnit codeUnit = listing.getCodeUnitAt(address);
        boolean isInstruction = false;
        if (textSelection != null) {
            if (codeUnit != null) {
                isInstruction = codeUnit instanceof Instruction;
                this.searchDialog.setCurrentField(location, isInstruction);
            }
            this.searchDialog.setValueFieldText(textSelection);
        }
        this.searchDialog.show(context.getComponentProvider());
    }

    private AddressSetView getAddressSet(Navigatable searchNavigatable, SearchOptions options) {
        ProgramSelection selection = searchNavigatable.getSelection();
        Program program = searchNavigatable.getProgram();
        AddressSetView addressSet = this.getMemoryAddressSet(program, options);
        if (selection != null && !selection.isEmpty() && this.searchDialog.searchSelection()) {
            addressSet = addressSet.intersect((AddressSetView)selection);
        }
        return addressSet;
    }

    private AddressSetView getMemoryAddressSet(Program program, SearchOptions options) {
        Memory memory = program.getMemory();
        if (options.includeNonLoadedMemoryBlocks()) {
            return memory;
        }
        AddressSet set = new AddressSet();
        for (MemoryBlock block : memory.getBlocks()) {
            if (!block.isLoaded()) continue;
            set.add(block.getStart(), block.getEnd());
        }
        return set;
    }

    public Navigatable getNavigatable() {
        return this.navigatable;
    }

    @Override
    public void navigatableRemoved(Navigatable removedNavigatable) {
        this.setNavigatable(null);
    }

    public void contextChanged(ActionContext context) {
        this.updateNavigatable(context);
    }

    private class SearchTextHighlightProvider
    implements ListingHighlightProvider,
    ComponentProviderActivationListener {
        private SearchOptions searchOptions;
        private TableComponentProvider<?> provider;
        private Program highlightProgram;
        private final Navigatable highlightNavigatable;
        private boolean showAllResults;
        private Searcher.TextSearchResult searchResult;

        SearchTextHighlightProvider(Navigatable navigatable, SearchOptions searchOptions, TableComponentProvider<?> provider, Program program, Searcher.TextSearchResult searchResult) {
            this.highlightNavigatable = navigatable;
            this.searchOptions = searchOptions;
            this.provider = provider;
            this.highlightProgram = program;
            this.searchResult = searchResult;
            boolean bl = this.showAllResults = searchResult == null;
            if (provider != null) {
                provider.addActivationListener(this);
            }
            this.highlightNavigatable.setHighlightProvider(this, program);
        }

        @Override
        public Highlight[] createHighlights(String text, ListingField field, int cursorTextOffset) {
            Class<?> fieldFactoryClass = field.getFieldFactory().getClass();
            if (!SearchTextPlugin.this.doHighlight) {
                return NO_HIGHLIGHTS;
            }
            if (this.checkRemoveHighlights()) {
                return NO_HIGHLIGHTS;
            }
            if (!this.shouldHighlight(field)) {
                return NO_HIGHLIGHTS;
            }
            if (!(this.searchOptions.searchAllFields() || fieldFactoryClass != XRefFieldFactory.class && fieldFactoryClass != XRefHeaderFieldFactory.class)) {
                return NO_HIGHLIGHTS;
            }
            if (this.showAllResults) {
                return this.getAllHighlights(text, cursorTextOffset);
            }
            Address address = this.searchResult.programLocation().getAddress();
            ProxyObj<?> proxy = field.getProxy();
            if (proxy.contains(address)) {
                return this.getSingleSearchHighlight(text, field, cursorTextOffset);
            }
            return NO_HIGHLIGHTS;
        }

        private Highlight[] getAllHighlights(String text, int cursorTextOffset) {
            String searchText = this.searchOptions.getText();
            if (StringUtils.isBlank((CharSequence)searchText) || StringUtils.isBlank((CharSequence)text)) {
                return NO_HIGHLIGHTS;
            }
            ArrayList<Highlight> list = new ArrayList<Highlight>();
            Pattern regexp = UserSearchUtils.createSearchPattern((String)searchText, (boolean)this.searchOptions.isCaseSensitive());
            Matcher matcher = regexp.matcher(text);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end() - 1;
                GColor hlColor = SearchConstants.SEARCH_HIGHLIGHT_COLOR;
                if (start <= cursorTextOffset && end >= cursorTextOffset) {
                    hlColor = SearchConstants.SEARCH_HIGHLIGHT_CURRENT_ADDR_COLOR;
                }
                list.add(new Highlight(start, end, (Color)hlColor));
            }
            if (list.isEmpty()) {
                return NO_HIGHLIGHTS;
            }
            return (Highlight[])list.toArray(Highlight[]::new);
        }

        private Highlight[] getSingleSearchHighlight(String text, ListingField field, int cursorTextOffset) {
            int charOffset;
            ProgramLocation loc;
            String searchText = this.searchOptions.getText();
            if (StringUtils.isBlank((CharSequence)searchText) || StringUtils.isBlank((CharSequence)text)) {
                return NO_HIGHLIGHTS;
            }
            FieldFactory fieldFactory = field.getFieldFactory();
            if (!fieldFactory.supportsLocation(field, loc = this.searchResult.programLocation())) {
                return NO_HIGHLIGHTS;
            }
            int searchStart = charOffset = this.searchResult.offset();
            int searchEnd = searchStart + searchText.length();
            Pattern regexp = UserSearchUtils.createSearchPattern((String)searchText, (boolean)this.searchOptions.isCaseSensitive());
            Matcher matcher = regexp.matcher(text);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                if (start != searchStart || end != searchEnd) continue;
                GColor hlColor = SearchConstants.SEARCH_HIGHLIGHT_COLOR;
                if (start <= cursorTextOffset && end >= cursorTextOffset) {
                    hlColor = SearchConstants.SEARCH_HIGHLIGHT_CURRENT_ADDR_COLOR;
                }
                int endEx = end - 1;
                return new Highlight[]{new Highlight(start, endEx, (Color)hlColor)};
            }
            return NO_HIGHLIGHTS;
        }

        private boolean shouldHighlight(ListingField field) {
            Program navigatableProgram;
            ProxyObj<?> proxy = field.getProxy();
            Object obj = proxy.getObject();
            Program program = navigatableProgram = SearchTextPlugin.this.navigatable == null ? null : SearchTextPlugin.this.navigatable.getProgram();
            if (navigatableProgram != this.highlightProgram) {
                return false;
            }
            if (this.searchOptions.searchAllFields()) {
                return true;
            }
            Class<?> factoryClass = field.getFieldFactory().getClass();
            if (this.searchOptions.searchComments() && (factoryClass == PreCommentFieldFactory.class || factoryClass == PlateFieldFactory.class || factoryClass == PostCommentFieldFactory.class || factoryClass == EolCommentFieldFactory.class)) {
                return true;
            }
            if (this.searchOptions.searchBothInstructionMnemonicAndOperands() && obj instanceof Instruction && (factoryClass == MnemonicFieldFactory.class || factoryClass == OperandFieldFactory.class)) {
                return true;
            }
            if (this.searchOptions.searchOnlyInstructionMnemonics() && obj instanceof Instruction && factoryClass == MnemonicFieldFactory.class) {
                return true;
            }
            if (this.searchOptions.searchOnlyInstructionOperands() && obj instanceof Instruction && factoryClass == OperandFieldFactory.class) {
                return true;
            }
            if (this.searchOptions.searchBothDataMnemonicsAndOperands() && obj instanceof Data && (factoryClass == MnemonicFieldFactory.class || factoryClass == OperandFieldFactory.class)) {
                return true;
            }
            if (this.searchOptions.searchOnlyDataMnemonics() && obj instanceof Data && factoryClass == MnemonicFieldFactory.class) {
                return true;
            }
            if (this.searchOptions.searchOnlyDataOperands() && obj instanceof Data && factoryClass == OperandFieldFactory.class) {
                return true;
            }
            if (this.searchOptions.searchFunctions() && (factoryClass == FunctionRepeatableCommentFieldFactory.class || factoryClass == FunctionSignatureFieldFactory.class || factoryClass == VariableCommentFieldFactory.class || factoryClass == VariableLocFieldFactory.class || factoryClass == VariableNameFieldFactory.class || factoryClass == VariableTypeFieldFactory.class)) {
                return true;
            }
            return this.searchOptions.searchLabels() && factoryClass == LabelFieldFactory.class;
        }

        private boolean checkRemoveHighlights() {
            if (this.provider != null) {
                if (!SearchTextPlugin.this.tool.isVisible(this.provider)) {
                    this.highlightNavigatable.removeHighlightProvider(this, this.highlightProgram);
                    return true;
                }
            } else if (!SearchTextPlugin.this.searchDialog.isVisible()) {
                this.highlightNavigatable.removeHighlightProvider(this, this.highlightProgram);
                return true;
            }
            return false;
        }

        public void componentProviderActivated(ComponentProvider componentProvider) {
            this.highlightNavigatable.setHighlightProvider(this, this.highlightProgram);
        }

        public void componentProviderDeactivated(ComponentProvider componentProvider) {
        }
    }

    class TableLoadingListener
    implements ThreadedTableModelListener {
        private ThreadedTableModel<?, ?> model;
        private TableComponentProvider<ProgramLocation> provider;

        TableLoadingListener(ThreadedTableModel<?, ?> model) {
            this.model = model;
        }

        void setProvider(TableComponentProvider<ProgramLocation> tableProvider) {
            this.provider = tableProvider;
        }

        public void loadingFinished(boolean wasCancelled) {
            if (SearchTextPlugin.this.isDisposed()) {
                return;
            }
            SearchTextPlugin.this.waitingForSearchAll = false;
            SearchTextPlugin.this.searchDialog.searchAllFinished();
            if (wasCancelled) {
                SearchTextPlugin.this.searchDialog.setStatusText("Search Cancelled");
                return;
            }
            int matchCount = this.model.getRowCount();
            if (matchCount == 0) {
                SearchTextPlugin.this.searchDialog.setStatusText("No matches found.");
                return;
            }
            if (matchCount >= SearchTextPlugin.this.searchLimit) {
                Msg.showWarn(this.getClass(), (Component)this.getParentComponent(), (String)"Search Limit Exceeded!", (Object)("Stopped search after finding " + matchCount + " matches.\nThe search limit can be changed at Edit->Tool Options, under Search."));
            }
        }

        private Component getParentComponent() {
            if (this.provider != null) {
                return this.provider.getComponent();
            }
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            return focusOwner;
        }

        public void loadingStarted() {
        }

        public void loadPending() {
        }
    }
}

