/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import docking.options.editor.OptionsDialog;
import docking.options.editor.OptionsEditorListener;
import docking.options.editor.StringBasedFileEditor;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.events.CloseProgramPluginEvent;
import ghidra.app.events.ExternalProgramLocationPluginEvent;
import ghidra.app.events.ExternalProgramSelectionPluginEvent;
import ghidra.app.events.OpenProgramPluginEvent;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.progmgr.CloseProgramAction;
import ghidra.app.plugin.core.progmgr.MultiProgramManager;
import ghidra.app.plugin.core.progmgr.ProgramOptionsAction;
import ghidra.app.plugin.core.progmgr.ProgramSaveManager;
import ghidra.app.plugin.core.progmgr.RedoAction;
import ghidra.app.plugin.core.progmgr.SaveAsProgramAction;
import ghidra.app.plugin.core.progmgr.SaveProgramAction;
import ghidra.app.plugin.core.progmgr.UndoAction;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.task.OpenProgramTask;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.main.OpenVersionedFileDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.beans.PropertyEditor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Support", shortDescription="Manage open programs", description="This plugin provides actions for opening and closing programs.  It also provides a service to allow plugins to open/close programs.  This plugin is responsible for sending out plugin events to notify all other programs when a program is opened or close.", servicesProvided={ProgramManager.class}, eventsConsumed={OpenProgramPluginEvent.class, CloseProgramPluginEvent.class, ExternalProgramLocationPluginEvent.class, ExternalProgramSelectionPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class}, eventsProduced={OpenProgramPluginEvent.class, CloseProgramPluginEvent.class, ExternalProgramLocationPluginEvent.class, ExternalProgramSelectionPluginEvent.class, ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramActivatedPluginEvent.class})
public class ProgramManagerPlugin
extends Plugin
implements ProgramManager {
    private static final String SAVE_GROUP = "DomainObjectSave";
    static final String OPEN_GROUP = "DomainObjectOpen";
    private MultiProgramManager programMgr;
    private ProgramSaveManager programSaveMgr;
    private int transactionID = -1;
    private boolean locked = false;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private ProgramLocation currentLocation;

    public ProgramManagerPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.programMgr = new MultiProgramManager(this);
        this.programSaveMgr = new ProgramSaveManager(tool, this);
    }

    public boolean acceptData(DomainFile[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        if (this.locked) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Open Program Failed", (Object)"Program manager is locked and cannot open additional programs");
            return false;
        }
        ArrayList<DomainFile> filesToOpen = new ArrayList<DomainFile>();
        for (DomainFile domainFile : data) {
            Class domainObjectClass;
            if (domainFile == null || !Program.class.isAssignableFrom(domainObjectClass = domainFile.getDomainObjectClass())) continue;
            filesToOpen.add(domainFile);
        }
        this.openPrograms(filesToOpen);
        return !filesToOpen.isEmpty();
    }

    public boolean accept(URL url) {
        return this.openProgram(url, 1) != null;
    }

    public Class<?>[] getSupportedDataTypes() {
        return new Class[]{Program.class};
    }

    @Override
    public Program openProgram(URL ghidraURL, int state) {
        if (this.locked) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Open Program Failed", (Object)"Program manager is locked and cannot open additional programs");
            return null;
        }
        URL url = GhidraURL.getNormalizedURL((URL)ghidraURL);
        Program p = this.programMgr.getOpenProgram(url);
        if (p != null) {
            this.showProgram(p, url, state);
            if (state == 1) {
                this.gotoProgramRef(p, ghidraURL.getRef());
                this.programMgr.saveLocation();
            }
            return p;
        }
        Program program = (Program)Swing.runNow(() -> this.doOpenProgram(ghidraURL, state));
        if (program != null) {
            Msg.info((Object)this, (Object)("Opened program in " + this.tool.getName() + " tool: " + ghidraURL));
        }
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program doOpenProgram(URL ghidraURL, int openState) {
        Program p;
        block4: {
            p = null;
            try {
                URL url = GhidraURL.getNormalizedURL((URL)ghidraURL);
                OpenProgramTask task = new OpenProgramTask(url, (Object)this);
                new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
                OpenProgramTask.OpenProgramRequest openProgramReq = task.getOpenProgram();
                if (openProgramReq != null) {
                    p = openProgramReq.getProgram();
                    this.showProgram(p, url, openState);
                    openProgramReq.release();
                }
                if (p == null || openState != 1) break block4;
                this.gotoProgramRef(p, ghidraURL.getRef());
            }
            catch (Throwable throwable) {
                if (p != null && openState == 1) {
                    this.gotoProgramRef(p, ghidraURL.getRef());
                    this.programMgr.saveLocation();
                }
                throw throwable;
            }
            this.programMgr.saveLocation();
        }
        return p;
    }

    private boolean gotoProgramRef(Program program, String ref) {
        if (ref == null) {
            return false;
        }
        String trimmedRef = ref.trim();
        if (trimmedRef.length() == 0) {
            return false;
        }
        List symbols = NamespaceUtils.getSymbols((String)trimmedRef, (Program)program);
        Symbol sym = symbols.isEmpty() ? null : (Symbol)symbols.get(0);
        FunctionSignatureFieldLocation loc = null;
        if (sym != null) {
            SymbolType type = sym.getSymbolType();
            if (type == SymbolType.FUNCTION) {
                loc = new FunctionSignatureFieldLocation(sym.getProgram(), sym.getAddress());
            } else if (type == SymbolType.LABEL) {
                loc = new LabelFieldLocation(sym);
            }
        } else {
            Address addr = program.getAddressFactory().getAddress(trimmedRef);
            if (addr != null && addr.isMemoryAddress()) {
                loc = new CodeUnitLocation(program, addr, 0, 0, 0);
            }
        }
        if (loc == null) {
            Msg.showError((Object)this, null, (String)"Navigation Failed", (Object)("Referenced label/function not found: " + trimmedRef));
            return false;
        }
        this.firePluginEvent(new ProgramLocationPluginEvent(this.getName(), (ProgramLocation)loc, program));
        return true;
    }

    @Override
    public Program openProgram(DomainFile df) {
        return this.openProgram(df, -1, 1);
    }

    @Override
    public Program openProgram(DomainFile df, Component parent) {
        return this.openProgram(df, -1, 1);
    }

    @Override
    public Program openProgram(DomainFile df, int version) {
        return this.openProgram(df, version, 1);
    }

    @Override
    public Program openProgram(DomainFile domainFile, int version, int state) {
        if (domainFile == null) {
            throw new IllegalArgumentException("Domain file cannot be null");
        }
        if (this.locked) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Open Program Failed", (Object)"Program manager is locked and cannot open additional programs");
            return null;
        }
        Program program = (Program)Swing.runNow(() -> this.doOpenProgram(domainFile, version, state));
        if (program != null) {
            Msg.info((Object)this, (Object)("Opened program in " + this.tool.getName() + " tool: " + domainFile));
        }
        return program;
    }

    @Override
    public Program getCurrentProgram() {
        return this.programMgr.getCurrentProgram();
    }

    public DomainFile[] getData() {
        Program[] p = this.getAllOpenPrograms();
        DomainFile[] dfs = new DomainFile[p.length];
        for (int i = 0; i < dfs.length; ++i) {
            dfs[i] = p[i].getDomainFile();
        }
        return dfs;
    }

    @Override
    public Program[] getAllOpenPrograms() {
        return this.programMgr.getAllPrograms();
    }

    public void dispose() {
        this.programMgr.dispose();
        this.tool.clearLastEvents();
    }

    @Override
    public boolean closeOtherPrograms(boolean ignoreChanges) {
        Program[] otherPrograms = this.programMgr.getOtherPrograms();
        Runnable r = () -> this.doCloseAllPrograms(otherPrograms, ignoreChanges);
        Swing.runNow((Runnable)r);
        return this.programMgr.isEmpty();
    }

    @Override
    public boolean closeAllPrograms(boolean ignoreChanges) {
        Program[] openPrograms = this.programMgr.getAllPrograms();
        Runnable r = () -> this.doCloseAllPrograms(openPrograms, ignoreChanges);
        Swing.runNow((Runnable)r);
        return this.programMgr.isEmpty();
    }

    private void doCloseAllPrograms(Program[] openPrograms, boolean ignoreChanges) {
        ArrayList<Program> toRemove = new ArrayList<Program>();
        Program currentProgram = this.programMgr.getCurrentProgram();
        for (Program p : openPrograms) {
            if (ignoreChanges) {
                toRemove.add(p);
            } else if (p.isClosed()) {
                toRemove.add(p);
            }
            if (!this.tool.canCloseDomainObject((DomainObject)p)) continue;
            if (!this.programSaveMgr.canClose(p)) {
                return;
            }
            toRemove.add(p);
        }
        if (toRemove.contains(currentProgram)) {
            toRemove.remove(currentProgram);
            toRemove.add(currentProgram);
        }
        for (Program program : toRemove) {
            this.programMgr.removeProgram(program);
        }
        this.contextChanged();
    }

    @Override
    public boolean closeProgram(Program program, boolean ignoreChanges) {
        if (program == null) {
            return false;
        }
        Runnable r = () -> {
            if (ignoreChanges || program.isClosed() || this.programMgr.isPersistent(program) || this.tool.canCloseDomainObject((DomainObject)program) && this.programSaveMgr.canClose(program)) {
                this.programMgr.removeProgram(program);
                this.contextChanged();
            }
        };
        Swing.runNow((Runnable)r);
        return !this.programMgr.contains(program);
    }

    protected void close() {
        Program[] programs = this.programMgr.getAllPrograms();
        if (programs.length == 0) {
            return;
        }
        Program currentProgram = this.getCurrentProgram();
        for (Program program : programs) {
            if (program == currentProgram) continue;
            this.programMgr.removeProgram(program);
        }
        if (currentProgram != null) {
            this.programMgr.removeProgram(currentProgram);
        }
        this.contextChanged();
        this.tool.setSubTitle("");
        this.tool.clearLastEvents();
    }

    @Override
    public void setCurrentProgram(Program p) {
        Runnable r = () -> {
            this.programMgr.setCurrentProgram(p);
            this.contextChanged();
        };
        Swing.runNow((Runnable)r);
    }

    @Override
    public Program getProgram(Address addr) {
        return this.programMgr.getProgram(addr);
    }

    @Override
    public void openProgram(Program program) {
        this.openProgram(program, true);
    }

    @Override
    public void openProgram(Program program, boolean current) {
        this.openProgram(program, current ? 1 : 2);
    }

    @Override
    public void openProgram(Program program, int state) {
        this.showProgram(program, program.getDomainFile(), state);
    }

    private void showProgram(Program p, URL ghidraUrl, int state) {
        if (p == null || p.isClosed()) {
            throw new AssertException("Opened program required");
        }
        if (this.locked) {
            throw new IllegalStateException("Progam manager is locked and cannot accept a new program");
        }
        Runnable r = () -> {
            this.programMgr.addProgram(p, ghidraUrl, state);
            if (state == 1) {
                this.programMgr.saveLocation();
            }
            this.contextChanged();
        };
        Swing.runNow((Runnable)r);
    }

    private void showProgram(Program p, DomainFile domainFile, int state) {
        if (p == null || p.isClosed()) {
            throw new AssertException("Opened program required");
        }
        if (this.locked) {
            throw new IllegalStateException("Progam manager is locked and cannot accept a new program");
        }
        Runnable r = () -> {
            this.programMgr.addProgram(p, domainFile, state);
            if (state == 1) {
                this.programMgr.saveLocation();
            }
            this.contextChanged();
        };
        Swing.runNow((Runnable)r);
    }

    @Override
    public boolean closeProgram() {
        return this.closeProgram(this.getCurrentProgram(), false);
    }

    protected boolean saveData() {
        boolean result = this.programSaveMgr.saveAll();
        this.contextChanged();
        return result;
    }

    protected boolean hasUnsaveData() {
        Program[] allOpenPrograms;
        for (Program program : allOpenPrograms = this.getAllOpenPrograms()) {
            if (!program.isChanged()) continue;
            return true;
        }
        return false;
    }

    private void createActions() {
        int subMenuGroup = 1;
        DockingAction openAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Open File", this.getName()).menuPath(new String[]{"&File", "&Open..."})).menuGroup(OPEN_GROUP, Integer.toString(subMenuGroup++))).keyBinding("ctrl O")).enabledWhen(c -> !this.locked)).onAction(c -> this.open())).buildAndInstall((Tool)this.tool);
        openAction.addToWindowWhen(ProgramActionContext.class);
        this.tool.addAction((DockingActionIf)new CloseProgramAction(this, OPEN_GROUP, subMenuGroup++));
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Close Others", this.getName()).menuPath(new String[]{"&File", "Close &Others"})).menuGroup(OPEN_GROUP, Integer.toString(subMenuGroup++))).enabled(false)).withContext(ProgramActionContext.class).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).enabledWhen(c -> this.programMgr.contains(c.getProgram())).onAction(c -> this.closeOtherPrograms(false)).buildAndInstall((Tool)this.tool);
        DockingAction closeAllAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Close All", this.getName()).menuPath(new String[]{"&File", "Close &All"})).menuGroup(OPEN_GROUP, Integer.toString(subMenuGroup++))).enabledWhen(c -> !this.programMgr.isEmpty())).onAction(c -> this.closeAllPrograms(false))).buildAndInstall((Tool)this.tool);
        closeAllAction.addToWindowWhen(ProgramActionContext.class);
        this.tool.addAction((DockingActionIf)new SaveProgramAction(this, SAVE_GROUP, subMenuGroup));
        this.tool.addAction((DockingActionIf)new SaveAsProgramAction(this, SAVE_GROUP, subMenuGroup));
        DockingAction saveAllAction = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Save All Files", this.getName()).menuPath(new String[]{"&File", "Save All"})).description("Save All Programs")).menuGroup(SAVE_GROUP, Integer.toString(subMenuGroup++))).enabledWhen(c -> this.programMgr.hasUnsavedPrograms())).onAction(c -> this.programSaveMgr.saveChangedPrograms())).buildAndInstall((Tool)this.tool);
        saveAllAction.addToWindowWhen(ProgramActionContext.class);
        this.tool.addAction((DockingActionIf)new ProgramOptionsAction(this));
        this.undoAction = new UndoAction(this, this.tool);
        this.redoAction = new RedoAction(this, this.tool);
        this.tool.addAction((DockingActionIf)this.undoAction);
        this.tool.addAction((DockingActionIf)this.redoAction);
    }

    void showProgramOptions(final Program currentProgram) {
        List names = currentProgram.getOptionsNames();
        Options[] options = new Options[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            String optionName = (String)names.get(i);
            options[i] = currentProgram.getOptions(optionName);
            if (!optionName.equals("Program Information")) continue;
            this.setPropertyEditor(options[i], "Executable Location");
            options[i].setOptionsHelpLocation(new HelpLocation(this.getName(), "Program_Options"));
        }
        OptionsDialog dialog = new OptionsDialog("Properties for " + currentProgram.getName(), "Properties", options, new OptionsEditorListener(){

            public void beforeChangesApplied() {
                ProgramManagerPlugin.this.startTransaction(currentProgram);
            }

            public void changesApplied() {
                ProgramManagerPlugin.this.endTransaction(currentProgram);
            }
        });
        dialog.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Program_Options"));
        this.tool.showDialog((DialogComponentProvider)dialog);
        dialog.dispose();
    }

    private void setPropertyEditor(Options options, String filePropertyName) {
        PropertyEditor editor = options.getPropertyEditor(filePropertyName);
        if (editor == null && options.getType(filePropertyName) == OptionType.STRING_TYPE) {
            options.registerOption(filePropertyName, OptionType.STRING_TYPE, null, null, null, (PropertyEditor)new StringBasedFileEditor());
        }
    }

    private void startTransaction(Program currentProgram) {
        if (this.transactionID < 0) {
            this.transactionID = currentProgram.startTransaction("Edit Program Properties");
        }
    }

    private void endTransaction(Program currentProgram) {
        if (this.transactionID >= 0) {
            currentProgram.endTransaction(this.transactionID, true);
            this.transactionID = -1;
        }
    }

    void contextChanged() {
        this.tool.contextChanged(null);
    }

    private void open() {
        OpenVersionedFileDialog<Program> openDialog = new OpenVersionedFileDialog<Program>(this.tool, "Open Program", Program.class);
        openDialog.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "Open_File_Dialog"));
        openDialog.addOkActionListener(e -> {
            DomainFile domainFile = openDialog.getDomainFile();
            int version = openDialog.getVersion();
            if (domainFile == null) {
                openDialog.setStatusText("Please choose a Program");
            } else {
                openDialog.close();
                this.doOpenProgram(domainFile, version, 1);
            }
        });
        this.tool.showDialog(openDialog);
        this.contextChanged();
    }

    public void openPrograms(List<DomainFile> filesToOpen) {
        Program showIfNeeded = null;
        OpenProgramTask openTask = null;
        for (DomainFile domainFile : filesToOpen) {
            Program p = this.programMgr.getOpenProgram(domainFile, -1);
            if (p != null) {
                showIfNeeded = p;
                continue;
            }
            if (openTask == null) {
                openTask = new OpenProgramTask(domainFile, -1, (Object)this);
                continue;
            }
            openTask.addProgramToOpen(domainFile, -1);
        }
        if (openTask != null) {
            new TaskLauncher(openTask, (Component)this.tool.getToolFrame());
            List<OpenProgramTask.OpenProgramRequest> openProgramReqs = openTask.getOpenPrograms();
            boolean isFirst = true;
            for (OpenProgramTask.OpenProgramRequest programReq : openProgramReqs) {
                this.showProgram(programReq.getProgram(), programReq.getDomainFile(), isFirst ? 1 : 2);
                programReq.release();
                isFirst = false;
                showIfNeeded = null;
            }
        }
        if (showIfNeeded != null) {
            this.showProgram(showIfNeeded, showIfNeeded.getDomainFile(), 1);
        }
    }

    protected Program doOpenProgram(DomainFile domainFile, int version, int openState) {
        Program p = this.programMgr.getOpenProgram(domainFile, version);
        if (p != null) {
            this.openProgram(p, openState);
        } else {
            OpenProgramTask task = new OpenProgramTask(domainFile, version, (Object)this);
            new TaskLauncher((Task)task, (Component)this.tool.getToolFrame());
            OpenProgramTask.OpenProgramRequest programReq = task.getOpenProgram();
            if (programReq != null) {
                p = programReq.getProgram();
                this.showProgram(p, programReq.getDomainFile(), openState);
                programReq.release();
            }
        }
        return p;
    }

    @Override
    public void saveProgram() {
        this.saveProgram(this.getCurrentProgram());
    }

    @Override
    public void saveProgram(Program program) {
        Swing.runIfSwingOrRunLater(() -> this.programSaveMgr.saveProgram(program));
    }

    @Override
    public void saveProgramAs() {
        this.saveProgramAs(this.getCurrentProgram());
    }

    @Override
    public void saveProgramAs(Program program) {
        Swing.runIfSwingOrRunLater(() -> this.programSaveMgr.saveAs(program));
    }

    public void writeDataState(SaveState saveState) {
        ProjectLocator projectLocator;
        ArrayList<MultiProgramManager.ProgramInfo> programInfos = new ArrayList<MultiProgramManager.ProgramInfo>();
        for (Program p : this.programMgr.getAllPrograms()) {
            MultiProgramManager.ProgramInfo info = this.programMgr.getInfo(p);
            if (info == null) continue;
            programInfos.add(info);
        }
        saveState.putInt("NUM_PROGRAMS", programInfos.size());
        int i = 0;
        for (MultiProgramManager.ProgramInfo programInfo : programInfos) {
            this.writeProgramInfo(programInfo, saveState, i++);
        }
        Program p = this.programMgr.getCurrentProgram();
        if (p != null && (projectLocator = p.getDomainFile().getProjectLocator()) != null && !projectLocator.isTransient()) {
            saveState.putString("CURRENT_FILE", p.getDomainFile().getName());
            if (this.currentLocation != null) {
                this.currentLocation.saveState(saveState);
            }
        }
    }

    public void readDataState(SaveState saveState) {
        if (!this.programMgr.isEmpty()) {
            this.currentLocation = null;
            return;
        }
        this.loadPrograms(saveState);
        String currentFile = saveState.getString("CURRENT_FILE", null);
        Program[] programs = this.programMgr.getAllPrograms();
        if (programs.length != 0) {
            if (currentFile != null) {
                for (Program program : programs) {
                    if (!program.getDomainFile().getName().equals(currentFile)) continue;
                    this.programMgr.setCurrentProgram(program);
                    this.currentLocation = ProgramLocation.getLocation((Program)program, (SaveState)saveState);
                    break;
                }
            }
            if (this.getCurrentProgram() == null) {
                this.programMgr.setCurrentProgram(programs[0]);
            }
        }
        this.contextChanged();
    }

    public void dataStateRestoreCompleted() {
        if (this.currentLocation != null) {
            this.tool.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.getName(), this.currentLocation, this.getCurrentProgram()));
        }
    }

    private void writeProgramInfo(MultiProgramManager.ProgramInfo programInfo, SaveState saveState, int index) {
        if (this.locked) {
            return;
        }
        URL url = programInfo.getGhidraUrl();
        if (url != null) {
            saveState.putString("URL_" + index, url.toString());
            return;
        }
        String projectLocation = null;
        String projectName = null;
        String path = null;
        Program program = programInfo.program;
        DomainFile df = program.getDomainFile();
        ProjectLocator projectLocator = df.getProjectLocator();
        if (projectLocator != null && !projectLocator.isTransient()) {
            projectLocation = projectLocator.getLocation();
            projectName = projectLocator.getName();
            path = df.getPathname();
        }
        int version = -1;
        if (!df.isLatestVersion()) {
            version = df.getVersion();
        }
        saveState.putString("LOCATION_" + index, projectLocation);
        saveState.putString("PROJECT_NAME_" + index, projectName);
        saveState.putInt("VERSION_" + index, version);
        saveState.putString("PATHNAME_" + index, path);
    }

    private void loadPrograms(SaveState saveState) {
        int n = saveState.getInt("NUM_PROGRAMS", 0);
        if (n == 0) {
            return;
        }
        OpenProgramTask openTask = new OpenProgramTask(this);
        for (int index = 0; index < n; ++index) {
            URL url = this.getGhidraURL(saveState, index);
            if (url != null) {
                openTask.addProgramToOpen(url);
                continue;
            }
            DomainFile domainFile = this.getDomainFile(saveState, index);
            if (domainFile == null) continue;
            int version = this.getVersion(saveState, index);
            openTask.addProgramToOpen(domainFile, version);
        }
        if (!openTask.hasOpenProgramRequests()) {
            return;
        }
        openTask.setNoCheckout();
        try {
            new TaskLauncher((Task)openTask, (Component)this.tool.getToolFrame(), 100);
        }
        catch (RuntimeException e) {
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Error Getting Domain File", (Object)"Can't open program", (Throwable)e);
        }
        List<OpenProgramTask.OpenProgramRequest> openProgramReqs = openTask.getOpenPrograms();
        for (OpenProgramTask.OpenProgramRequest programReq : openProgramReqs) {
            DomainFile df = programReq.getDomainFile();
            if (df != null) {
                this.showProgram(programReq.getProgram(), df, 2);
            } else {
                this.showProgram(programReq.getProgram(), programReq.getGhidraURL(), 2);
            }
            programReq.release();
        }
    }

    private URL getGhidraURL(SaveState saveState, int index) {
        String url = saveState.getString("URL_" + index, null);
        if (url == null) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private DomainFile getDomainFile(SaveState saveState, int index) {
        String pathname = saveState.getString("PATHNAME_" + index, null);
        String location = saveState.getString("LOCATION_" + index, null);
        String projectName = saveState.getString("PROJECT_NAME_" + index, null);
        if (location == null || projectName == null) {
            return null;
        }
        ProjectLocator projectLocator = new ProjectLocator(location, projectName);
        ProjectData projectData = this.tool.getProject().getProjectData(projectLocator);
        if (projectData == null) {
            return null;
        }
        DomainFile df = projectData.getFile(pathname);
        if (df == null) {
            String message = "Can't open program - \"" + pathname + "\"";
            int version = this.getVersion(saveState, index);
            if (version != -1) {
                message = message + " version " + version;
            }
            Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Program Not Found", (Object)message);
        }
        return df;
    }

    private int getVersion(SaveState saveState, int index) {
        return saveState.getInt("VERSION_" + index, -1);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof OpenProgramPluginEvent) {
            OpenProgramPluginEvent ev = (OpenProgramPluginEvent)event;
            this.openProgram(ev.getProgram());
        } else if (event instanceof CloseProgramPluginEvent) {
            CloseProgramPluginEvent ev = (CloseProgramPluginEvent)event;
            this.closeProgram(ev.getProgram(), ev.ignoreChanges());
        } else if (event instanceof ProgramActivatedPluginEvent) {
            Program p = ((ProgramActivatedPluginEvent)event).getActiveProgram();
            this.programMgr.setCurrentProgram(p);
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
            this.currentLocation = ev.getLocation();
            this.firePluginEvent(new ExternalProgramLocationPluginEvent(this.getName(), this.currentLocation, ev.getProgram()));
        } else if (event instanceof ExternalProgramLocationPluginEvent) {
            Program currentProgram = this.programMgr.getCurrentProgram();
            if (currentProgram == null) {
                return;
            }
            ExternalProgramLocationPluginEvent ev = (ExternalProgramLocationPluginEvent)event;
            ProgramLocation loc = ev.getLocation();
            if (loc != null && (loc = this.localizeLocation(currentProgram, loc)) != null && currentProgram.getAddressFactory().isValidAddress(loc.getAddress()) && currentProgram.getMemory().contains(loc.getAddress())) {
                this.firePluginEvent(new ProgramLocationPluginEvent(this.getName(), loc, ev.getProgram()));
            }
        } else if (event instanceof ProgramSelectionPluginEvent) {
            ProgramSelectionPluginEvent ev = (ProgramSelectionPluginEvent)event;
            this.firePluginEvent(new ExternalProgramSelectionPluginEvent(this.getName(), ev.getSelection(), ev.getProgram()));
        } else if (event instanceof ExternalProgramSelectionPluginEvent) {
            Program currentProgram = this.programMgr.getCurrentProgram();
            ExternalProgramSelectionPluginEvent ev = (ExternalProgramSelectionPluginEvent)event;
            if (currentProgram == null) {
                return;
            }
            ProgramSelection sel = ev.getSelection();
            if (sel != null && this.hasValidAddresses(currentProgram, sel = this.localizeSelection(currentProgram, sel))) {
                this.firePluginEvent(new ProgramSelectionPluginEvent(this.getName(), sel, ev.getProgram()));
            }
        }
    }

    private ProgramSelection localizeSelection(Program currentProgram, ProgramSelection sel) {
        if (this.hasValidAddresses(currentProgram, sel)) {
            return sel;
        }
        AddressFactory addrFactory = currentProgram.getAddressFactory();
        AddressSpace defaultSpace = addrFactory.getDefaultAddressSpace();
        AddressSet locAddressSet = new AddressSet();
        AddressRangeIterator riter = sel.getAddressRanges();
        while (riter.hasNext()) {
            AddressRange range = (AddressRange)riter.next();
            Address min = range.getMinAddress();
            Address max = range.getMaxAddress();
            try {
                min = defaultSpace.getAddress(min.getOffset());
                max = defaultSpace.getAddress(max.getOffset());
                locAddressSet.addRange(min, max);
            }
            catch (Exception exception) {}
        }
        return new ProgramSelection((AddressSetView)locAddressSet);
    }

    private ProgramLocation localizeLocation(Program currentProgram, ProgramLocation loc) {
        Address addr = loc.getAddress();
        Address refAddr = loc.getRefAddress();
        if (loc.isValid(currentProgram)) {
            return loc;
        }
        AddressFactory addressFactory = currentProgram.getAddressFactory();
        try {
            addr = addressFactory.getAddress(addr.toString(true));
            if (addr == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (refAddr != null) {
            try {
                refAddr = addressFactory.getAddress(refAddr.toString(true));
            }
            catch (Exception e) {
                refAddr = null;
            }
        }
        return new ProgramLocation(currentProgram, addr, loc.getComponentPath(), refAddr, 0, 0, 0);
    }

    private boolean hasValidAddresses(Program currentProgram, ProgramSelection sel) {
        AddressRangeIterator it = sel.getAddressRanges();
        AddressFactory af = currentProgram.getAddressFactory();
        while (it.hasNext()) {
            AddressRange range = (AddressRange)it.next();
            if (af.isValidAddress(range.getMinAddress())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isVisible(Program program) {
        return this.programMgr.isVisible(program);
    }

    @Override
    public void releaseProgram(Program program, Object owner) {
        if (this.programMgr.contains(program)) {
            this.programMgr.releaseProgram(program, owner);
            Msg.info(ClientUtil.class, (Object)("Released program from " + this.tool.getName() + " tool: " + program.getDomainFile()));
        }
    }

    @Override
    public boolean setPersistentOwner(Program program, Object owner) {
        return this.programMgr.setPersistentOwner(program, owner);
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lockDown(boolean state) {
        this.locked = state;
        this.contextChanged();
    }

    public boolean isManaged(Program program) {
        return this.programMgr.contains(program);
    }
}

