/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.model;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.instructionsearch.model.InstructionTableObserver;
import ghidra.app.plugin.core.instructionsearch.model.OperandMetadata;
import ghidra.app.plugin.core.instructionsearch.ui.AbstractInstructionTable;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class InstructionTableDataObject {
    private Set<InstructionTableObserver> observers = new HashSet<InstructionTableObserver>();
    private String data;
    private Color backgroundColor;
    private Color foregroundColor = GThemeDefaults.Colors.FOREGROUND;
    private int fontStyle;
    private Border border;
    private AbstractInstructionTable.OperandState state;
    private boolean isInstruction;
    private OperandMetadata operandCase;
    private static final Color BG_COLOR_MASKED_INSTRUCTION = new GColor("color.bg.plugin.instructionsearch.table.masked.instruction");
    private static final Color BG_COLOR_NOT_MASKED_INSTRUCTION = new GColor("color.bg.plugin.instructionsearch.table.not.masked.instruction");
    private static final Color BG_COLOR_MASKED_NON_INSTRUCTION = new GColor("color.bg.plugin.instructionsearch.table.masked.non.instruction");
    private static final Color BG_COLOR_NOT_MASKED_NON_INSTRUCTION = new GColor("color.bg.plugin.instructionsearch.table.not.masked.non.instruction");
    private static final Color BG_COLOR_DEFAULT = new GColor("color.bg.plugin.instructionsearch.table.default");

    public InstructionTableDataObject(String data, boolean isInstruction, AbstractInstructionTable.OperandState state) {
        this.data = data;
        this.isInstruction = isInstruction;
        this.setState(state, false);
    }

    public void toggleMaskState() {
        switch (this.state) {
            case MASKED: {
                this.setState(AbstractInstructionTable.OperandState.NOT_MASKED, false);
                this.notifySubscribers();
                break;
            }
            case NOT_MASKED: {
                this.setState(AbstractInstructionTable.OperandState.MASKED, false);
                this.notifySubscribers();
                break;
            }
            case NA: {
                break;
            }
        }
    }

    public void setState(AbstractInstructionTable.OperandState state, boolean update) {
        this.state = state;
        switch (state) {
            case MASKED: {
                this.backgroundColor = this.isInstruction ? BG_COLOR_MASKED_INSTRUCTION : BG_COLOR_MASKED_NON_INSTRUCTION;
                this.border = BorderFactory.createLoweredSoftBevelBorder();
                break;
            }
            case NOT_MASKED: {
                this.backgroundColor = this.isInstruction ? BG_COLOR_NOT_MASKED_INSTRUCTION : BG_COLOR_NOT_MASKED_NON_INSTRUCTION;
                this.border = BorderFactory.createRaisedSoftBevelBorder();
                break;
            }
            case NA: {
                this.backgroundColor = BG_COLOR_DEFAULT;
                break;
            }
            case PREVIEW: {
                Color color = this.backgroundColor = this.isInstruction ? BG_COLOR_MASKED_INSTRUCTION : BG_COLOR_MASKED_NON_INSTRUCTION;
            }
        }
        if (update) {
            this.notifySubscribers();
        }
    }

    public void register(InstructionTableObserver observer) {
        this.observers.add(observer);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public AbstractInstructionTable.OperandState getState() {
        return this.state;
    }

    public Border getBorder() {
        return this.border;
    }

    public OperandMetadata getOperandCase() {
        return this.operandCase;
    }

    public void setOperandCase(OperandMetadata operandCase) {
        this.operandCase = operandCase;
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public String toString() {
        return this.data;
    }

    private void notifySubscribers() {
        for (InstructionTableObserver obs : this.observers) {
            if (obs == null) continue;
            obs.changed();
        }
    }
}

