/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.widgets.label.GDHtmlLabel;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.MissingArchiveDataTypeHTMLRepresentation;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.TypeDef;
import ghidra.util.HTMLUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class DataTypeSynchronizer {
    private final DataTypeManager dataTypeManager;
    private final SourceArchive sourceArchive;
    private final DataTypeManager sourceDTM;
    private int sourceTransactionID;
    private int localTransactionID;

    public DataTypeSynchronizer(DataTypeManagerHandler dataTypeManagerHandler, DataTypeManager dataTypeManager, SourceArchive source) {
        this.dataTypeManager = dataTypeManager;
        this.sourceArchive = source;
        this.sourceDTM = dataTypeManagerHandler.getDataTypeManager(source);
    }

    public List<DataTypeSyncInfo> findOutOfSynchDataTypes() {
        List dataTypes = this.dataTypeManager.getDataTypes(this.sourceArchive);
        ArrayList<DataTypeSyncInfo> dataTypeSyncInfo = new ArrayList<DataTypeSyncInfo>();
        for (DataType dt : dataTypes) {
            DataTypeSyncInfo syncInfo = new DataTypeSyncInfo(dt, this.sourceDTM);
            if (!syncInfo.canCommit() && !syncInfo.canUpdate()) continue;
            dataTypeSyncInfo.add(syncInfo);
        }
        return dataTypeSyncInfo;
    }

    public List<DataTypeSyncInfo> findAssociatedDataTypes() {
        List dataTypes = this.dataTypeManager.getDataTypes(this.sourceArchive);
        ArrayList<DataTypeSyncInfo> dataTypeSyncInfo = new ArrayList<DataTypeSyncInfo>();
        for (DataType dt : dataTypes) {
            dataTypeSyncInfo.add(new DataTypeSyncInfo(dt, this.sourceDTM));
        }
        return dataTypeSyncInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit(DataTypeManager sourceDTM, DataType refDT) {
        DataTypeManager refDTM = refDT.getDataTypeManager();
        int sourceTransactionID = sourceDTM.startTransaction("Commit Datatype Changes");
        int refTransactionID = refDTM.startTransaction("Update DataType Sync Time");
        try {
            DataTypeSynchronizer.commitAssumingTransactionsOpen(sourceDTM, refDT);
        }
        finally {
            refDTM.endTransaction(refTransactionID, true);
            sourceDTM.endTransaction(sourceTransactionID, true);
        }
    }

    public static void update(DataTypeManager refDTM, DataType sourceDT) {
        int transactionID = refDTM.startTransaction("Update Datatype");
        try {
            DataTypeSynchronizer.updateAssumingTransactionsOpen(refDTM, sourceDT);
        }
        finally {
            refDTM.endTransaction(transactionID, true);
        }
    }

    public static void commitAssumingTransactionsOpen(DataTypeManager sourceDTM, DataType refDT) {
        DataTypeManager refDTM = refDT.getDataTypeManager();
        SourceArchive sourceArchive = refDTM.getSourceArchive(sourceDTM.getUniversalID());
        refDTM.associateDataTypeWithArchive(refDT, sourceArchive);
        long lastChangeTime = refDT.getLastChangeTime();
        DataType sourceDT = sourceDTM.resolve(refDT, DataTypeConflictHandler.REPLACE_HANDLER);
        if (!DataTypeSynchronizer.namesAreEquivalent(refDT, sourceDT)) {
            DataTypeSynchronizer.renameDataType(sourceDTM, sourceDT, refDT);
        }
        if (!StringUtils.equals((CharSequence)refDT.getDescription(), (CharSequence)sourceDT.getDescription())) {
            sourceDT.setDescription(refDT.getDescription());
        }
        sourceDT.setLastChangeTime(lastChangeTime);
        refDT.setLastChangeTimeInSourceArchive(lastChangeTime);
    }

    public static void updateAssumingTransactionsOpen(DataTypeManager refDTM, DataType sourceDT) {
        long lastChangeTime = sourceDT.getLastChangeTime();
        DataType refDT = refDTM.resolve(sourceDT, DataTypeConflictHandler.REPLACE_HANDLER);
        if (!DataTypeSynchronizer.namesAreEquivalent(refDT, sourceDT)) {
            DataTypeSynchronizer.renameDataType(refDTM, refDT, sourceDT);
        }
        if (!StringUtils.equals((CharSequence)sourceDT.getDescription(), (CharSequence)refDT.getDescription())) {
            refDT.setDescription(sourceDT.getDescription());
        }
        refDT.setLastChangeTimeInSourceArchive(lastChangeTime);
        refDT.setLastChangeTime(lastChangeTime);
    }

    public static boolean commit(DataTypeManagerHandler dtmHandler, DataType dt) {
        SourceArchive sourceArchive = dt.getSourceArchive();
        DataTypeManager sourceDTM = dtmHandler.getDataTypeManager(sourceArchive);
        if (sourceDTM == null) {
            return false;
        }
        DataTypeSynchronizer.commit(sourceDTM, dt);
        return true;
    }

    public static boolean update(DataTypeManagerHandler dtmHandler, DataType dt) {
        DataTypeManager dataTypeManager = dt.getDataTypeManager();
        SourceArchive sourceArchive = dt.getSourceArchive();
        DataTypeManager sourceDtm = dtmHandler.getDataTypeManager(sourceArchive);
        if (dataTypeManager == null || sourceDtm == null) {
            return false;
        }
        DataType sourceDt = sourceDtm.getDataType(sourceArchive, dt.getUniversalID());
        DataTypeSynchronizer.update(dataTypeManager, sourceDt);
        return true;
    }

    public void markSynchronized() {
        int transactionID = this.dataTypeManager.startTransaction("Clear dirty flag for data type manager.");
        try {
            this.sourceArchive.setDirtyFlag(false);
            this.sourceArchive.setLastSyncTime(this.sourceDTM.getLastChangeTimeForMyManager());
        }
        finally {
            this.dataTypeManager.endTransaction(transactionID, true);
        }
    }

    public void removeSourceArchive() {
        int transactionID = this.dataTypeManager.startTransaction("Remove Source Archive");
        try {
            this.dataTypeManager.removeSourceArchive(this.sourceArchive);
        }
        finally {
            this.dataTypeManager.endTransaction(transactionID, true);
        }
    }

    public String getArchiveName() {
        return this.sourceArchive.getName();
    }

    public void openTransactions() {
        if (this.sourceDTM != null) {
            this.sourceTransactionID = this.sourceDTM.startTransaction("Data Type Synchronization");
        }
        this.localTransactionID = this.dataTypeManager.startTransaction("Data Type Synchronization");
    }

    public void closeTransactions() {
        this.dataTypeManager.endTransaction(this.localTransactionID, true);
        if (this.sourceDTM != null) {
            this.sourceDTM.endTransaction(this.sourceTransactionID, true);
        }
    }

    public static void disassociate(DataType dataType) {
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        int transactionID = dataTypeManager.startTransaction("Disassociate Data Type");
        try {
            dataTypeManager.disassociate(dataType);
        }
        finally {
            dataTypeManager.endTransaction(transactionID, true);
        }
    }

    private static void renameDataType(DataTypeManager sourceDTM, DataType sourceDT, DataType dtToCopy) {
        CategoryPath path;
        if (DataTypeSynchronizer.isAutoNamedTypedef(dtToCopy) && sourceDT instanceof TypeDef) {
            ((TypeDef)sourceDT).enableAutoNaming();
            return;
        }
        String name = dtToCopy.getName();
        int index = name.indexOf(".conflict");
        if (index > 0) {
            name = name.substring(0, index);
        }
        if (sourceDTM.getDataType(path = sourceDT.getCategoryPath(), name) != null) {
            name = ((DataTypeManagerDB)sourceDTM).getUnusedConflictName(sourceDT.getCategoryPath(), name);
        }
        try {
            sourceDT.setName(name);
        }
        catch (InvalidNameException e) {
            throw new AssertException("This should not occur here, all we did is tack more on the end");
        }
        catch (DuplicateNameException e) {
            throw new AssertException("This should not occur here, we already looked to see if it existed");
        }
    }

    private static boolean isAutoNamedTypedef(DataType dt) {
        if (dt instanceof TypeDef) {
            TypeDef td = (TypeDef)dt;
            return td.isAutoNamed();
        }
        return false;
    }

    public static boolean namesAreEquivalent(DataType dt1, DataType dt2) {
        String name2;
        if (DataTypeSynchronizer.isAutoNamedTypedef(dt1)) {
            return DataTypeSynchronizer.isAutoNamedTypedef(dt2);
        }
        if (DataTypeSynchronizer.isAutoNamedTypedef(dt2)) {
            return false;
        }
        String name1 = dt1.getName();
        if (name1.equals(name2 = dt2.getName())) {
            return true;
        }
        int index = name1.indexOf(".conflict");
        if (index > 0) {
            name1 = name1.substring(0, index);
        }
        if ((index = name2.indexOf(".conflict")) > 0) {
            name2 = name2.substring(0, index);
        }
        return name1.equals(name2);
    }

    public static DataTypeSyncState getSyncStatus(DataTypeManagerHandler handler, DataType dataType) {
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        SourceArchive sourceArchive = dataType.getSourceArchive();
        UniversalID dataTypeID = dataType.getUniversalID();
        if (sourceArchive == null || dataTypeID == null || sourceArchive.getSourceArchiveID().equals((Object)dataTypeManager.getUniversalID())) {
            return DataTypeSyncState.UNKNOWN;
        }
        boolean hasChangedLocally = dataType.getLastChangeTime() != dataType.getLastChangeTimeInSourceArchive();
        DataTypeManager sourceDTM = handler.getDataTypeManager(sourceArchive);
        DataTypeSyncInfo syncInfo = new DataTypeSyncInfo(dataType, sourceDTM);
        if (sourceDTM == null) {
            return hasChangedLocally ? DataTypeSyncState.COMMIT : DataTypeSyncState.IN_SYNC;
        }
        return syncInfo.getSyncState();
    }

    public static String getDiffToolTip(DataTypeManagerHandler handler, DataType dataType) {
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        SourceArchive sourceArchive = dataType.getSourceArchive();
        UniversalID dataTypeID = dataType.getUniversalID();
        if (sourceArchive == null || dataTypeID == null || sourceArchive.getSourceArchiveID().equals((Object)dataTypeManager.getUniversalID())) {
            return null;
        }
        DataTypeManager sourceDTM = handler.getDataTypeManager(sourceArchive);
        boolean hasChangedLocally = dataType.getLastChangeTime() != dataType.getLastChangeTimeInSourceArchive();
        DataType sourceDT = null;
        if (sourceDTM == null) {
            if (!hasChangedLocally) {
                return null;
            }
        } else {
            sourceDT = sourceDTM.getDataType(sourceArchive, dataTypeID);
        }
        HTMLDataTypeRepresentation representation1 = ToolTipUtils.getHTMLRepresentation(dataType);
        HTMLDataTypeRepresentation representation2 = DataTypeSynchronizer.getSourceHTMLRepresentation(sourceDT, sourceArchive);
        HTMLDataTypeRepresentation[] diffs = representation1.diff(representation2);
        String htmlContent = diffs[0].getHTMLContentString();
        String otherContent = diffs[1].getHTMLContentString();
        String spacerString = DataTypeSynchronizer.createHTMLSpacerString(htmlContent, otherContent);
        StringBuilder buffy = new StringBuilder();
        buffy.append("<HTML>");
        buffy.append("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=5>");
        buffy.append("<TR BORDER=LEFT>");
        buffy.append("<TD VALIGN=\"TOP\">");
        buffy.append("<B>").append(HTMLUtilities.escapeHTML((String)dataTypeManager.getName())).append("</B><HR NOSHADE>");
        buffy.append(htmlContent);
        buffy.append("<TT>").append(spacerString).append("</TT>");
        buffy.append("</TD>");
        buffy.append("<TD WIDTH=\"1\" BGCOLOR=#000000>");
        buffy.append("</TD>");
        buffy.append("<TD VALIGN=\"TOP\">");
        buffy.append("<B>").append(HTMLUtilities.escapeHTML((String)sourceArchive.getName())).append("</B><HR NOSHADE>");
        buffy.append(otherContent);
        buffy.append("<TT>").append(spacerString).append("</TT>");
        buffy.append("</TD>");
        buffy.append("</TR>");
        buffy.append("</TABLE>");
        return buffy.toString();
    }

    private static HTMLDataTypeRepresentation getSourceHTMLRepresentation(DataType sourceDT, SourceArchive sourceArchive) {
        if (sourceDT == null) {
            return new MissingArchiveDataTypeHTMLRepresentation(sourceArchive);
        }
        return ToolTipUtils.getHTMLRepresentation(sourceDT);
    }

    private static String createHTMLSpacerString(String htmlContent, String otherHTMLContent) {
        GDHtmlLabel label1 = new GDHtmlLabel("<HTML>" + htmlContent);
        GDHtmlLabel label2 = new GDHtmlLabel("<HTML>" + otherHTMLContent);
        int maxPixelWidth = Math.max(label1.getPreferredSize().width, label2.getPreferredSize().width);
        FontMetrics fontMetrics = label1.getFontMetrics(label1.getFont());
        StringBuilder bigBuffy = new StringBuilder();
        String HTMLSpace = "&nbsp";
        int invisibleCharCount = HTMLSpace.length();
        for (int i = 0; i < 150; ++i) {
            bigBuffy.append(HTMLSpace);
            int width = SwingUtilities.computeStringWidth(fontMetrics, bigBuffy.toString());
            int currentPixelWidth = width / invisibleCharCount;
            if (currentPixelWidth >= maxPixelWidth) break;
        }
        return bigBuffy.toString();
    }

    public String getClientName() {
        return this.dataTypeManager.getName();
    }

    public String getSourceName() {
        if (this.sourceDTM != null) {
            return this.sourceDTM.getName();
        }
        return this.sourceArchive.getName();
    }

    public String getClientType() {
        if (this.dataTypeManager instanceof ProgramDataTypeManager) {
            return "Program";
        }
        return "Archive";
    }

    public void reSyncDataTypes() {
        if (this.sourceDTM == null) {
            Msg.info(this.getClass(), (Object)("Can't access the data types for the " + this.sourceArchive.getName() + " archive."));
            return;
        }
        int transactionID = this.dataTypeManager.startTransaction("re-sync '" + this.sourceArchive.getName() + "' data types");
        try {
            this.reSyncOutOfSyncInTimeOnlyDataTypes();
            this.fixSyncForDifferingDataTypes();
        }
        finally {
            this.dataTypeManager.endTransaction(transactionID, true);
        }
    }

    public void reSyncOutOfSyncInTimeOnlyDataTypes() {
        if (this.sourceDTM == null) {
            Msg.info(this.getClass(), (Object)("Can't access the data types for the " + this.sourceArchive.getName() + " archive."));
            return;
        }
        List<DataTypeSyncInfo> outOfSynchDataTypes = this.findOutOfSynchDataTypes();
        ArrayList<DataTypeSyncInfo> list = new ArrayList<DataTypeSyncInfo>();
        Iterator<DataTypeSyncInfo> iterator = outOfSynchDataTypes.iterator();
        while (iterator.hasNext()) {
            DataTypeSyncInfo dataTypeSyncInfo = iterator.next();
            if (dataTypeSyncInfo.hasChange()) continue;
            list.add(dataTypeSyncInfo);
            iterator.remove();
        }
        this.autoUpdateDataTypesThatHaveNoRealChanges(list, outOfSynchDataTypes.isEmpty());
    }

    private void fixSyncForDifferingDataTypes() {
        boolean fixedSync = false;
        List dataTypes = this.dataTypeManager.getDataTypes(this.sourceArchive);
        for (DataType dataType : dataTypes) {
            DataTypeSyncInfo dataTypeSyncInfo = new DataTypeSyncInfo(dataType, this.sourceDTM);
            DataType sourceDataType = dataTypeSyncInfo.getSourceDataType();
            DataTypeSyncState syncState = dataTypeSyncInfo.getSyncState();
            if (syncState != DataTypeSyncState.IN_SYNC || !dataTypeSyncInfo.hasChange()) continue;
            Msg.info(this.getClass(), (Object)("Program data type '" + dataType.getPathName() + "' differs from its source data type '" + sourceDataType.getPathName() + "' and is being changed to not be in-sync!"));
            dataType.setLastChangeTimeInSourceArchive(0L);
            fixedSync = true;
        }
        if (fixedSync) {
            this.sourceArchive.setDirtyFlag(true);
            this.sourceArchive.setLastSyncTime(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoUpdateDataTypesThatHaveNoRealChanges(List<DataTypeSyncInfo> outOfSynchInTimeOnlyList, boolean markArchiveSynchronized) {
        int transactionID = this.dataTypeManager.startTransaction("auto sync datatypes");
        try {
            for (DataTypeSyncInfo dataTypeSyncInfo : outOfSynchInTimeOnlyList) {
                dataTypeSyncInfo.syncTimes();
            }
            if (markArchiveSynchronized) {
                this.markSynchronized();
            }
        }
        finally {
            this.dataTypeManager.endTransaction(transactionID, true);
        }
    }
}

