/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.ReusableDialogComponentProvider;
import docking.UndoRedoKeeper;
import docking.widgets.OptionDialog;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import ghidra.app.plugin.core.comments.CommentsPlugin;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.Annotation;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.CodeUnit;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public class CommentsDialog
extends ReusableDialogComponentProvider
implements KeyListener {
    private JTextArea eolField;
    private JTextArea preField;
    private JTextArea postField;
    private JTextArea plateField;
    private JTextArea repeatableField;
    private Map<Document, UndoRedoKeeper> documentUndoRedoMap = new HashMap<Document, UndoRedoKeeper>(9);
    private String preComment;
    private String postComment;
    private String eolComment;
    private String plateComment;
    private String repeatableComment;
    private JTabbedPane tab;
    private CommentsPlugin plugin;
    private CodeUnit codeUnit;
    private boolean wasChanged;
    private boolean enterMode = false;
    private JCheckBox enterBox = new GCheckBox("Enter accepts comment", this.enterMode);
    private JPopupMenu popup = new JPopupMenu();

    CommentsDialog(CommentsPlugin plugin) {
        super("Set Comments");
        this.enterBox.addChangeListener(e -> {
            this.enterMode = this.enterBox.isSelected();
            plugin.updateOptions();
        });
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Comments"));
        this.addWorkPanel(this.createPanel());
        this.addOKButton();
        this.addApplyButton();
        this.addDismissButton();
        this.plugin = plugin;
    }

    void showDialog(CodeUnit cu, int type) {
        this.setTitle("Set Comment(s) at Address " + cu.getMinAddress());
        this.codeUnit = cu;
        this.preComment = cu.getComment(1);
        this.postComment = cu.getComment(2);
        this.eolComment = cu.getComment(0);
        this.plateComment = cu.getComment(3);
        this.repeatableComment = cu.getComment(4);
        this.preComment = this.preComment == null ? "" : this.preComment;
        this.postComment = this.postComment == null ? "" : this.postComment;
        this.eolComment = this.eolComment == null ? "" : this.eolComment;
        this.plateComment = this.plateComment == null ? "" : this.plateComment;
        String string = this.repeatableComment = this.repeatableComment == null ? "" : this.repeatableComment;
        if (!this.preField.getText().equals(this.preComment)) {
            this.preField.setText(this.preComment);
        }
        if (!this.postField.getText().equals(this.postComment)) {
            this.postField.setText(this.postComment);
        }
        if (!this.eolField.getText().equals(this.eolComment)) {
            this.eolField.setText(this.eolComment);
        }
        if (!this.plateField.getText().equals(this.plateComment)) {
            this.plateField.setText(this.plateComment);
        }
        if (!this.repeatableField.getText().equals(this.repeatableComment)) {
            this.repeatableField.setText(this.repeatableComment);
        }
        this.setCommentType(type);
        this.setApplyEnabled(false);
        this.setFocusComponent(this.getSelectedTextArea());
        PluginTool tool = this.plugin.getTool();
        tool.showDialog((DialogComponentProvider)this);
    }

    void setCommentType(int type) {
        switch (type) {
            case 0: {
                this.tab.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.tab.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.tab.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.tab.setSelectedIndex(3);
                break;
            }
            case 4: {
                this.tab.setSelectedIndex(4);
            }
        }
    }

    protected void cancelCallback() {
        if (this.wasChanged) {
            int result = OptionDialog.showYesNoCancelDialog((Component)this.getComponent(), (String)"Save Changes?", (String)"Some comments were modified.\nSave Changes?");
            if (result == 1) {
                this.applyCallback();
            } else if (result == 2) {
                if (!this.preField.getText().equals(this.preComment)) {
                    this.preField.setText(this.preComment);
                }
                if (!this.postField.getText().equals(this.postComment)) {
                    this.postField.setText(this.postComment);
                }
                if (!this.eolField.getText().equals(this.eolComment)) {
                    this.eolField.setText(this.eolComment);
                }
                if (!this.plateField.getText().equals(this.plateComment)) {
                    this.plateField.setText(this.plateComment);
                }
                if (!this.repeatableField.getText().equals(this.repeatableComment)) {
                    this.repeatableField.setText(this.repeatableComment);
                }
                this.wasChanged = false;
                this.setApplyEnabled(false);
            } else {
                return;
            }
        }
        this.close();
    }

    protected void okCallback() {
        if (this.wasChanged) {
            this.applyCallback();
        }
        this.close();
        this.clearState();
    }

    private void clearState() {
        Collection<UndoRedoKeeper> undoRedoKeepers = this.documentUndoRedoMap.values();
        for (UndoRedoKeeper undoRedoKeeper : undoRedoKeepers) {
            undoRedoKeeper.clear();
        }
    }

    protected void applyCallback() {
        this.preComment = this.preField.getText();
        this.postComment = this.postField.getText();
        this.eolComment = this.eolField.getText();
        this.plateComment = this.plateField.getText();
        this.repeatableComment = this.repeatableField.getText();
        this.plugin.updateComments(this.codeUnit, this.preComment, this.postComment, this.eolComment, this.plateComment, this.repeatableComment);
        this.wasChanged = false;
        this.setApplyEnabled(false);
    }

    private AnnotationAdapterWrapper[] getAnnotationAdapterWrappers() {
        List<AnnotatedStringHandler> annotations = Annotation.getAnnotatedStringHandlers();
        int count = annotations.size();
        AnnotationAdapterWrapper[] retVal = new AnnotationAdapterWrapper[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = new AnnotationAdapterWrapper(annotations.get(i));
        }
        return retVal;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.tab = new JTabbedPane();
        panel.add((Component)this.tab, "Center");
        JPanel auxiliaryControlPanel = new JPanel(new BorderLayout());
        auxiliaryControlPanel.add((Component)this.enterBox, "South");
        Object[] annotations = this.getAnnotationAdapterWrappers();
        Arrays.sort(annotations);
        GComboBox annotationsComboBox = new GComboBox(annotations);
        JButton addAnnotationButton = new JButton("Add Annotation");
        addAnnotationButton.addActionListener(e -> {
            JTextArea textArea = this.getSelectedTextArea();
            AnnotationAdapterWrapper aaw = (AnnotationAdapterWrapper)annotationsComboBox.getSelectedItem();
            String selectedText = textArea.getSelectedText();
            if (!StringUtils.isBlank((CharSequence)selectedText)) {
                textArea.replaceSelection(aaw.getPrototypeString(selectedText));
            } else {
                this.insertAnnotation(textArea, aaw);
            }
        });
        JPanel annoPanel = new JPanel();
        annoPanel.add(addAnnotationButton);
        annoPanel.add((Component)annotationsComboBox);
        auxiliaryControlPanel.add((Component)annoPanel, "North");
        panel.add((Component)auxiliaryControlPanel, "South");
        this.preField = new JTextArea(5, 80){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                boolean b = super.getScrollableTracksViewportWidth();
                return b;
            }
        };
        this.postField = new JTextArea(5, 80);
        this.plateField = new JTextArea(5, 80);
        this.eolField = new JTextArea(5, 80);
        this.repeatableField = new JTextArea(5, 80);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CommentsDialog.this.checkChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CommentsDialog.this.checkChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CommentsDialog.this.checkChanged();
            }
        };
        Document document = this.preField.getDocument();
        document.addDocumentListener(dl);
        this.installUndoRedo(this.preField);
        document = this.postField.getDocument();
        document.addDocumentListener(dl);
        this.installUndoRedo(this.postField);
        document = this.eolField.getDocument();
        document.addDocumentListener(dl);
        this.installUndoRedo(this.eolField);
        document = this.plateField.getDocument();
        document.addDocumentListener(dl);
        this.installUndoRedo(this.plateField);
        document = this.repeatableField.getDocument();
        document.addDocumentListener(dl);
        this.installUndoRedo(this.repeatableField);
        this.preField.addKeyListener(this);
        this.postField.addKeyListener(this);
        this.eolField.addKeyListener(this);
        this.plateField.addKeyListener(this);
        this.repeatableField.addKeyListener(this);
        this.preField.setLineWrap(true);
        this.postField.setLineWrap(true);
        this.eolField.setLineWrap(true);
        this.plateField.setLineWrap(true);
        this.repeatableField.setLineWrap(true);
        this.preField.setWrapStyleWord(true);
        this.postField.setWrapStyleWord(true);
        this.eolField.setWrapStyleWord(true);
        this.plateField.setWrapStyleWord(true);
        this.repeatableField.setWrapStyleWord(true);
        this.tab.addTab("  EOL Comment    ", new JScrollPane(this.eolField));
        this.tab.addTab("  Pre Comment    ", new JScrollPane(this.preField));
        this.tab.addTab("  Post Comment   ", new JScrollPane(this.postField));
        this.tab.addTab("  Plate Comment  ", new JScrollPane(this.plateField));
        this.tab.addTab("  Repeatable Comment  ", new JScrollPane(this.repeatableField));
        this.tab.addChangeListener(ev -> this.chooseFocus());
        ActionListener addAnnotationAction = arg_0 -> this.lambda$createPanel$3((AnnotationAdapterWrapper[])annotations, arg_0);
        JMenu insertMenu = new JMenu("Insert");
        for (Object annotation : annotations) {
            JMenuItem menuItem = new JMenuItem(((AnnotationAdapterWrapper)annotation).toString());
            menuItem.addActionListener(addAnnotationAction);
            insertMenu.add(menuItem);
        }
        this.popup.add(insertMenu);
        this.preField.addMouseListener(new PopupListener());
        this.postField.addMouseListener(new PopupListener());
        this.eolField.addMouseListener(new PopupListener());
        this.plateField.addMouseListener(new PopupListener());
        this.repeatableField.addMouseListener(new PopupListener());
        return panel;
    }

    private void insertAnnotation(JTextArea textArea, AnnotationAdapterWrapper annotation) {
        textArea.insert(annotation.getPrototypeString(), textArea.getCaretPosition());
        textArea.setCaretPosition(textArea.getCaretPosition() - 1);
    }

    private void installUndoRedo(JTextComponent textComponent) {
        UndoRedoKeeper undoRedoKeeper = DockingUtils.installUndoRedo((JTextComponent)textComponent);
        Document document = textComponent.getDocument();
        this.documentUndoRedoMap.put(document, undoRedoKeeper);
    }

    private void checkChanged() {
        if (this.hasChanges()) {
            this.wasChanged = true;
            this.setApplyEnabled(true);
        } else {
            this.wasChanged = false;
            this.setApplyEnabled(false);
        }
    }

    private boolean hasChanges() {
        if (!this.preComment.equals(this.preField.getText())) {
            return true;
        }
        if (!this.postComment.equals(this.postField.getText())) {
            return true;
        }
        if (!this.eolComment.equals(this.eolField.getText())) {
            return true;
        }
        if (!this.plateComment.equals(this.plateField.getText())) {
            return true;
        }
        return !this.repeatableComment.equals(this.repeatableField.getText());
    }

    private JTextArea getSelectedTextArea() {
        int index = this.tab.getSelectedIndex();
        switch (index) {
            case 0: {
                return this.eolField;
            }
            case 1: {
                return this.preField;
            }
            case 2: {
                return this.postField;
            }
            case 3: {
                return this.plateField;
            }
            case 4: {
                return this.repeatableField;
            }
        }
        return null;
    }

    private void chooseFocus() {
        this.getSelectedTextArea().requestFocus();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        JTextArea textArea = (JTextArea)e.getSource();
        if (e.getKeyCode() != 10) {
            return;
        }
        int modifiers = e.getModifiersEx();
        if ((modifiers & 0x40) == 64) {
            textArea.replaceSelection("\n");
            e.consume();
            return;
        }
        if ((modifiers & 0x80) == 128) {
            this.okCallback();
            e.consume();
            return;
        }
        if (this.enterMode) {
            e.consume();
            this.okCallback();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public boolean getEnterMode() {
        return this.enterMode;
    }

    public void setEnterMode(boolean enterMode) {
        this.enterMode = enterMode;
        this.enterBox.setSelected(enterMode);
    }

    private /* synthetic */ void lambda$createPanel$3(AnnotationAdapterWrapper[] annotations, ActionEvent e) {
        JTextArea currentTextArea = this.getSelectedTextArea();
        for (AnnotationAdapterWrapper annotation : annotations) {
            if (!annotation.toString().equals(e.getActionCommand())) continue;
            this.insertAnnotation(currentTextArea, annotation);
        }
    }

    class AnnotationAdapterWrapper
    implements Comparable<AnnotationAdapterWrapper> {
        private AnnotatedStringHandler handler;

        public AnnotationAdapterWrapper(AnnotatedStringHandler handler) {
            this.handler = handler;
        }

        @Override
        public int compareTo(AnnotationAdapterWrapper wrapper) {
            return this.handler.getDisplayString().compareTo(wrapper.handler.getDisplayString());
        }

        public String toString() {
            return this.handler.getDisplayString();
        }

        public String getPrototypeString() {
            return this.handler.getPrototypeString();
        }

        public String getPrototypeString(String contained) {
            return this.handler.getPrototypeString(contained);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                CommentsDialog.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

