/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadata;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class SwiftTypeMetadataAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Swift Type Metadata Analyzer";
    private static final String DESCRIPTION = "Discovers Swift type metadata records.";

    public SwiftTypeMetadataAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS);
    }

    @Override
    public boolean canAnalyze(Program program) {
        return SwiftUtils.isSwift(program);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            SwiftTypeMetadata typeMetadata = new SwiftTypeMetadata(program, monitor, log);
            typeMetadata.markup();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

