/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.task;

import ghidra.util.task.TaskMonitor;
import ghidra.util.task.WrappingTaskMonitor;

public class UnknownProgressWrappingTaskMonitor
extends WrappingTaskMonitor {
    public UnknownProgressWrappingTaskMonitor(TaskMonitor delegate, long startMaximum) {
        super(delegate);
        delegate.setMaximum(startMaximum);
    }

    public void setProgress(long value) {
        super.setProgress(value);
        this.maybeUpdateMaximum();
    }

    public void incrementProgress(long incrementAmount) {
        super.incrementProgress(incrementAmount);
        this.maybeUpdateMaximum();
    }

    private void maybeUpdateMaximum() {
        long _75_percent;
        long currentMaximum = this.delegate.getMaximum();
        long progress = this.delegate.getProgress();
        if (progress > (_75_percent = currentMaximum - currentMaximum / 4L)) {
            this.delegate.setMaximum(Math.max(progress, currentMaximum + currentMaximum / 4L));
        }
    }
}

