/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBBuffer;
import db.DBHandle;
import db.DBRecord;
import db.Table;
import ghidra.program.database.mem.BitMappedSubMemoryBlock;
import ghidra.program.database.mem.BufferSubMemoryBlock;
import ghidra.program.database.mem.ByteMappedSubMemoryBlock;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.database.mem.UninitializedSubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class MemoryMapDBAdapterV2
extends MemoryMapDBAdapter {
    private static final int V2_VERSION = 2;
    private static final String V2_TABLE_NAME = "Memory Blocks";
    private static final int V2_NAME_COL = 0;
    private static final int V2_COMMENTS_COL = 1;
    private static final int V2_SOURCE_COL = 2;
    private static final int V2_PERMISSIONS_COL = 3;
    private static final int V2_START_ADDR_COL = 4;
    private static final int V2_BLOCK_TYPE_COL = 5;
    private static final int V2_OVERLAY_ADDR_COL = 6;
    private static final int V2_LENGTH_COL = 7;
    private static final int V2_CHAIN_BUF_COL = 8;
    private static final int V2_SEGMENT_COL = 9;
    private static final int INITIALIZED = 0;
    private static final int UNINITIALIZED = 1;
    private static final int BIT_MAPPED = 2;
    private static final int BYTE_MAPPED = 4;
    private DBHandle handle;
    private MemoryMapDB memMap;
    private List<MemoryBlockDB> blocks = new ArrayList<MemoryBlockDB>();

    protected MemoryMapDBAdapterV2(DBHandle handle, MemoryMapDB memMap) throws VersionException, IOException {
        this.handle = handle;
        this.memMap = memMap;
        Table table = handle.getTable(V2_TABLE_NAME);
        if (table == null) {
            throw new VersionException("Memory Block table not found");
        }
        int versionNumber = table.getSchema().getVersion();
        if (versionNumber != 2) {
            throw new VersionException("Memory Block table: Expected Version 2, got " + versionNumber);
        }
        int recCount = table.getRecordCount();
        this.blocks = new ArrayList<MemoryBlockDB>(recCount);
        int key = 0;
        for (DBRecord rec : table) {
            byte permissions = rec.getByteValue(3);
            long startAddr = rec.getLongValue(4);
            long length = rec.getLongValue(7);
            int bufID = rec.getIntValue(8);
            int segment = rec.getIntValue(9);
            DBRecord blockRecord = BLOCK_SCHEMA.createRecord((long)key);
            DBRecord subBlockRecord = SUB_BLOCK_SCHEMA.createRecord((long)key);
            blockRecord.setString(0, rec.getString(0));
            blockRecord.setString(1, rec.getString(1));
            blockRecord.setString(2, rec.getString(2));
            blockRecord.setByteValue(3, permissions);
            blockRecord.setLongValue(4, startAddr);
            blockRecord.setLongValue(5, length);
            blockRecord.setIntValue(6, segment);
            subBlockRecord.setLongValue(0, (long)key);
            subBlockRecord.setLongValue(2, length);
            subBlockRecord.setLongValue(3, 0L);
            short type = rec.getShortValue(5);
            long overlayAddr = rec.getLongValue(6);
            SubMemoryBlock subBlock = this.getSubBlock(bufID, subBlockRecord, type, overlayAddr);
            this.blocks.add(new MemoryBlockDB(this, blockRecord, Arrays.asList(subBlock)));
        }
        Collections.sort(this.blocks);
    }

    private SubMemoryBlock getSubBlock(int bufID, DBRecord record, int type, long overlayAddr) throws IOException {
        switch (type) {
            case 2: {
                record.setByteValue(1, (byte)0);
                record.setLongValue(5, overlayAddr);
                return new BitMappedSubMemoryBlock(this, record);
            }
            case 4: {
                record.setByteValue(1, (byte)1);
                record.setLongValue(5, overlayAddr);
                return new ByteMappedSubMemoryBlock(this, record);
            }
            case 0: {
                record.setByteValue(1, (byte)2);
                record.setIntValue(4, bufID);
                return new BufferSubMemoryBlock(this, record);
            }
            case 1: {
                record.setByteValue(1, (byte)3);
                return new UninitializedSubMemoryBlock(this, record);
            }
        }
        throw new IOException("Unknown memory block type: " + type);
    }

    @Override
    List<MemoryBlockDB> getMemoryBlocks() {
        return this.blocks;
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, DBBuffer buf, int permissions) throws AddressOverflowException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, InputStream is, long length, int permissions) throws AddressOverflowException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    MemoryBlockDB createBlock(MemoryBlockType blockType, String name, Address startAddr, long length, Address mappedAddress, boolean initializeBytes, int permissions, int mappingScheme) throws AddressOverflowException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteMemoryBlock(MemoryBlockDB block) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteTable(DBHandle dbHandle) throws IOException {
        dbHandle.deleteTable(V2_TABLE_NAME);
    }

    @Override
    void updateBlockRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBBuffer createBuffer(int length, byte initialValue) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void refreshMemory() throws IOException {
    }

    @Override
    DBBuffer getBuffer(int bufferID) throws IOException {
        if (bufferID >= 0) {
            return this.handle.getBuffer(bufferID);
        }
        return null;
    }

    @Override
    MemoryMapDB getMemoryMap() {
        return this.memMap;
    }

    @Override
    void deleteSubBlock(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void updateSubBlockRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBRecord createSubBlockRecord(long memBlockId, long startingOffset, long length, byte subType, int data1, long data2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected MemoryBlockDB createBlock(String name, Address addr, long length, int permissions, List<SubMemoryBlock> splitBlocks) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected MemoryBlockDB createFileBytesBlock(String name, Address startAddress, long length, FileBytes fileBytes, long offset, int permissions) throws IOException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }
}

