/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BooleanField;
import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.SourceArchiveAdapter;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class SourceArchiveAdapterV0
extends SourceArchiveAdapter {
    static final int VERSION = 0;
    static final int V0_ARCHIVE_ID_DOMAIN_FILE_ID_COL = 0;
    static final int V0_ARCHIVE_ID_NAME_COL = 1;
    static final int V0_ARCHIVE_ID_TYPE_COL = 2;
    static final int V0_ARCHIVE_ID_LAST_SYNC_TIME_COL = 3;
    static final int V0_ARCHIVE_ID_DIRTY_FLAG_COL = 4;
    static final Schema V0_SCHEMA = new Schema(0, "Archive ID", new Field[]{StringField.INSTANCE, StringField.INSTANCE, ByteField.INSTANCE, LongField.INSTANCE, BooleanField.INSTANCE}, new String[]{"Domain File ID", "Name", "Type", "Last Sync Time", "Dirty Flag"});
    private Table table;

    public SourceArchiveAdapterV0(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + "Data Type Archive IDs";
        if (create) {
            this.table = handle.createTable(tableName, V0_SCHEMA);
            this.createRecordForLocalManager();
        } else {
            this.table = handle.getTable(tableName);
            if (this.table == null) {
                throw new VersionException(true);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(false);
            }
        }
    }

    private void createRecordForLocalManager() throws IOException {
        DBRecord record = V0_SCHEMA.createRecord(0L);
        record.setLongValue(3, new Date().getTime());
        this.table.putRecord(record);
    }

    @Override
    public DBRecord createRecord(SourceArchive archive) throws IOException {
        DBRecord record = V0_SCHEMA.createRecord(archive.getSourceArchiveID().getValue());
        record.setString(0, archive.getDomainFileID());
        record.setString(1, archive.getName());
        record.setByteValue(2, (byte)archive.getArchiveType().ordinal());
        record.setLongValue(3, archive.getLastSyncTime());
        record.setBooleanValue(4, false);
        this.table.putRecord(record);
        return record;
    }

    @Override
    void deleteRecord(UniversalID sourceArchiveID) throws IOException {
        this.table.deleteRecord(sourceArchiveID.getValue());
    }

    @Override
    public DBRecord getRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    public List<DBRecord> getRecords() throws IOException {
        ArrayList<DBRecord> records = new ArrayList<DBRecord>();
        RecordIterator iterator = this.table.iterator();
        while (iterator.hasNext()) {
            records.add(iterator.next());
        }
        return records;
    }

    @Override
    public void updateRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public boolean removeRecord(long dataTypeArchiveID) throws IOException {
        return this.table.deleteRecord(dataTypeArchiveID);
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(this.table.getName());
    }
}

