/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.table.AbstractGTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GThemeDefaults;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.store.LockException;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.SpecExtension;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.PrototypeModelMerged;
import ghidra.program.model.pcode.XmlEncode;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlParseException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.xml.sax.SAXException;

public class SpecExtensionPanel
extends JPanel {
    private ProgramDB program;
    private PropertyChangeListener listener;
    private boolean unappliedChanges;
    private SpecExtension specExtension;
    private List<CompilerElement> tableElements;
    private SpecExtensionTableModel tableModel;
    private GTable extensionTable;
    private JButton exportButton;
    private JButton removeButton;
    private ListSelectionModel selectionModel;
    private static final int EXTENSION_TYPE_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int STATUS_COLUMN = 2;
    private static final String LAST_EXPORT_DIRECTORY = "LastSpecificationExportDirectory";
    public static final String PREFERENCES_FILE_EXTENSION = ".xml";
    private static final GhidraFileFilter FILE_FILTER = new GhidraFileFilter(){

        public boolean accept(File pathname, GhidraFileChooserModel model) {
            return pathname.isDirectory() || pathname.getName().endsWith(SpecExtensionPanel.PREFERENCES_FILE_EXTENSION);
        }

        public String getDescription() {
            return "Specification XML Files";
        }
    };

    private void populateElementTable() {
        String[] callOtherNames;
        String[] callFixupNames;
        PrototypeModel[] models;
        this.tableElements = new ArrayList<CompilerElement>();
        CompilerSpec compilerSpec = this.program.getCompilerSpec();
        for (PrototypeModel model : models = compilerSpec.getAllModels()) {
            SpecExtension.Type type = SpecExtension.Type.PROTOTYPE_MODEL;
            Status status = Status.CORE;
            if (model.isProgramExtension()) {
                Status status2 = status = model.isErrorPlaceholder() ? Status.EXTENSION_ERROR : Status.EXTENSION;
            }
            if (model instanceof PrototypeModelMerged) {
                type = SpecExtension.Type.MERGE_MODEL;
            }
            CompilerElement compEl = new CompilerElement(model.getName(), type, status);
            this.tableElements.add(compEl);
        }
        PcodeInjectLibrary injectLibrary = compilerSpec.getPcodeInjectLibrary();
        for (String fixupName : callFixupNames = injectLibrary.getCallFixupNames()) {
            SpecExtension.Type type = SpecExtension.Type.CALL_FIXUP;
            Status status = Status.CORE;
            if (injectLibrary.hasProgramPayload(fixupName, 1)) {
                status = Status.EXTENSION;
                if (injectLibrary.getPayload(1, fixupName).isErrorPlaceholder()) {
                    status = Status.EXTENSION_ERROR;
                }
            }
            CompilerElement compEl = new CompilerElement(fixupName, type, status);
            this.tableElements.add(compEl);
        }
        for (String fixupName : callOtherNames = injectLibrary.getCallotherFixupNames()) {
            SpecExtension.Type type = SpecExtension.Type.CALLOTHER_FIXUP;
            Status status = Status.CORE;
            if (injectLibrary.hasProgramPayload(fixupName, 2)) {
                status = Status.EXTENSION;
                if (injectLibrary.isOverride(fixupName, 2)) {
                    status = Status.EXTENSION_OVERRIDE;
                }
                if (injectLibrary.getPayload(2, fixupName).isErrorPlaceholder()) {
                    status = Status.EXTENSION_ERROR;
                }
            }
            CompilerElement compEl = new CompilerElement(fixupName, type, status);
            this.tableElements.add(compEl);
        }
        this.tableElements.sort(null);
    }

    private void addListeners() {
        this.selectionModel = this.extensionTable.getSelectionModel();
        this.selectionModel.addListSelectionListener(new TableSelectionListener());
    }

    SpecExtensionPanel(ProgramDB program, PropertyChangeListener listener) {
        this.program = program;
        this.listener = listener;
        this.unappliedChanges = false;
        this.specExtension = new SpecExtension(program);
        this.createPanel();
        this.populateElementTable();
        this.addListeners();
    }

    public void apply(TaskMonitor monitor) {
        ChangeExtensionTask task = new ChangeExtensionTask();
        new TaskLauncher((Task)task, (Component)this);
        this.populateElementTable();
        this.changesMade(false);
        this.tableModel.fireTableDataChanged();
    }

    public void cancel() {
        this.populateElementTable();
        this.tableModel.fireTableDataChanged();
    }

    private void adjustTableColumns() {
        this.extensionTable.doLayout();
        TableColumn column = this.extensionTable.getColumn((Object)this.extensionTable.getColumnName(0));
        column.setPreferredWidth(100);
        column = this.extensionTable.getColumn((Object)this.extensionTable.getColumnName(1));
        column.setPreferredWidth(250);
        column = this.extensionTable.getColumn((Object)this.extensionTable.getColumnName(2));
        column.setPreferredWidth(150);
    }

    private void createPanel() {
        this.setLayout(new BorderLayout(10, 10));
        this.tableModel = new SpecExtensionTableModel();
        this.extensionTable = new CompilerElementTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane((Component)this.extensionTable);
        this.extensionTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.extensionTable.setSelectionMode(0);
        this.adjustTableColumns();
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel lowerPanel = this.createButtonPanel();
        centerPanel.add((Component)sp, "Center");
        this.add((Component)centerPanel, "Center");
        this.add((Component)lowerPanel, "South");
    }

    private static File getStartingDir() {
        String lastDirectoryPath = Preferences.getProperty((String)LAST_EXPORT_DIRECTORY);
        if (lastDirectoryPath != null) {
            return new File(lastDirectoryPath);
        }
        return new File(System.getProperty("user.home"));
    }

    private static File getFileFromUser(String suggestedName) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeComponent = kfm.getActiveWindow();
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)activeComponent);
        fileChooser.setTitle("Please Select A File");
        fileChooser.setFileFilter(FILE_FILTER);
        fileChooser.setApproveButtonText("OK");
        File startDir = SpecExtensionPanel.getStartingDir();
        if (suggestedName != null) {
            fileChooser.setSelectedFile(new File(startDir, suggestedName));
        } else {
            fileChooser.setCurrentDirectory(startDir);
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile != null && !selectedFile.getName().endsWith(PREFERENCES_FILE_EXTENSION)) {
            selectedFile = new File(selectedFile.getAbsolutePath() + PREFERENCES_FILE_EXTENSION);
        }
        Preferences.setProperty((String)LAST_EXPORT_DIRECTORY, (String)fileChooser.getCurrentDirectory().getAbsolutePath());
        fileChooser.dispose();
        return selectedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fileToString(File file) throws IOException {
        FileReader inputReader = new FileReader(file);
        try (BufferedReader reader = new BufferedReader(inputReader);){
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
            String string = buffer.toString();
            return string;
        }
    }

    private int findMatch(SpecExtension.Type type, String name) {
        for (int i = 0; i < this.tableElements.size(); ++i) {
            CompilerElement el = this.tableElements.get(i);
            if (!el.name.equals(name) || el.type != type) continue;
            return i;
        }
        return -1;
    }

    private void changesMade(boolean changes) {
        this.listener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", this.unappliedChanges, changes));
        this.unappliedChanges = changes;
    }

    private void importExtension() {
        if (!this.program.hasExclusiveAccess()) {
            Msg.showError((Object)this, (Component)this, (String)"Import Failure", (Object)"Must have an exclusive checkout to import a new extension");
            return;
        }
        File file = SpecExtensionPanel.getFileFromUser(null);
        if (file == null) {
            return;
        }
        SpecExtension.DocInfo docInfo = null;
        Exception errMessage = null;
        try {
            String document = SpecExtensionPanel.fileToString(file).trim();
            docInfo = this.specExtension.testExtensionDocument(document);
            int pos = this.findMatch(docInfo.getType(), docInfo.getFormalName());
            Status status = Status.EXTENSION_INSTALL;
            if (pos >= 0) {
                CompilerElement previousEl = this.tableElements.get(pos);
                switch (previousEl.status) {
                    case CORE: {
                        if (!docInfo.isOverride()) {
                            throw new DuplicateNameException("Cannot override core extension: " + previousEl.name);
                        }
                        status = Status.EXTENSION_OVERPENDING;
                        break;
                    }
                    case EXTENSION: 
                    case EXTENSION_ERROR: 
                    case EXTENSION_REMOVE: 
                    case EXTENSION_REPLACE: {
                        status = Status.EXTENSION_REPLACE;
                        break;
                    }
                    case EXTENSION_OVERRIDE: 
                    case EXTENSION_OVERPENDING: {
                        status = Status.EXTENSION_OVERPENDING;
                        break;
                    }
                }
            }
            CompilerElement newEl = new CompilerElement(docInfo.getFormalName(), docInfo.getType(), status);
            newEl.xmlString = document;
            if (pos >= 0) {
                this.tableElements.set(pos, newEl);
            } else {
                this.tableElements.add(newEl);
            }
            this.tableElements.sort(null);
            this.changesMade(true);
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception e) {
            errMessage = e;
        }
        if (errMessage != null) {
            Msg.showError((Object)this, (Component)this, (String)"Import Failure", (Object)errMessage.getMessage(), (Throwable)errMessage);
            return;
        }
    }

    private String getXmlString(CompilerElement element) throws IOException {
        String resultString;
        CompilerSpec compilerSpec = this.program.getCompilerSpec();
        PcodeInjectLibrary injectLibrary = compilerSpec.getPcodeInjectLibrary();
        if (element.status == Status.CORE) {
            XmlEncode encoder = new XmlEncode();
            switch (element.type) {
                case CALL_FIXUP: {
                    InjectPayload payload = injectLibrary.getPayload(1, element.name);
                    if (payload == null) break;
                    payload.encode(encoder);
                    break;
                }
                case CALLOTHER_FIXUP: {
                    InjectPayload payload = injectLibrary.getPayload(2, element.name);
                    if (payload == null) break;
                    payload.encode(encoder);
                    break;
                }
                case PROTOTYPE_MODEL: 
                case MERGE_MODEL: {
                    PrototypeModel model = compilerSpec.getCallingConvention(element.name);
                    if (model == null) break;
                    model.encode(encoder, injectLibrary);
                }
            }
            resultString = encoder.toString();
        } else {
            resultString = SpecExtension.getCompilerSpecExtension(this.program, element.type, element.name);
        }
        if (resultString == null || resultString.length() == 0) {
            throw new IOException("Unable to  build document for " + element.name);
        }
        return resultString;
    }

    private void exportExtension() {
        int userChoice;
        CompilerElement compilerElement = this.getSelectedCompilerElement();
        if (compilerElement == null) {
            return;
        }
        if (!compilerElement.isExisting()) {
            return;
        }
        String suggestedName = compilerElement.name + PREFERENCES_FILE_EXTENSION;
        File outputFile = SpecExtensionPanel.getFileFromUser(suggestedName);
        if (outputFile == null) {
            return;
        }
        if (outputFile.exists() && (userChoice = OptionDialog.showYesNoDialog((Component)this, (String)"File exists.", (String)("Overwrite " + outputFile.getName() + " ?"))) != 1) {
            return;
        }
        FileWriter writer = null;
        try {
            String exportString = this.getXmlString(compilerElement);
            writer = new FileWriter(outputFile);
            writer.write(exportString);
            writer.close();
        }
        catch (IOException ex) {
            Msg.showError((Object)this, (Component)this, (String)"Export Failure", (Object)("Failed to write to file: " + ex.getMessage()));
        }
    }

    private void removeExtension() {
        if (!this.program.hasExclusiveAccess()) {
            Msg.showError((Object)this, (Component)this, (String)"Remove Failure", (Object)"Must have an exclusive checkout to remove an extension");
            return;
        }
        CompilerElement compilerElement = this.getSelectedCompilerElement();
        if (compilerElement == null) {
            return;
        }
        if (compilerElement.status == Status.EXTENSION || compilerElement.status == Status.EXTENSION_ERROR) {
            int userChoice = OptionDialog.showYesNoDialog((Component)this, (String)"Remove Extension?", (String)("Mark the extension " + compilerElement.name + " for removal?"));
            if (userChoice != 1) {
                return;
            }
        } else if (compilerElement.status == Status.EXTENSION_OVERRIDE) {
            int userChoice = OptionDialog.showYesNoDialog((Component)this, (String)"Remove Override?", (String)("Mark the override " + compilerElement.name + " for removal?"));
            if (userChoice != 1) {
                return;
            }
        } else {
            return;
        }
        compilerElement.status = Status.EXTENSION_REMOVE;
        this.extensionTable.clearSelection();
        this.changesMade(true);
        this.tableModel.fireTableDataChanged();
    }

    private CompilerElement getSelectedCompilerElement() {
        if (this.selectionModel.isSelectionEmpty()) {
            return null;
        }
        int selectedRow = this.extensionTable.getSelectedRow();
        return this.tableElements.get(selectedRow);
    }

    private JPanel createButtonPanel() {
        JButton importButton = new JButton("Import...");
        importButton.setToolTipText("Load extension from an XML file");
        importButton.addActionListener(event -> Swing.runLater(() -> {
            this.extensionTable.clearSelection();
            this.importExtension();
        }));
        this.exportButton = new JButton("Export...");
        this.exportButton.setToolTipText("Export extensions to an XML file");
        this.exportButton.addActionListener(event -> Swing.runLater(() -> this.exportExtension()));
        this.removeButton = new JButton("Remove");
        this.removeButton.setToolTipText("Remove an existing extension");
        this.removeButton.addActionListener(event -> Swing.runLater(() -> this.removeExtension()));
        JPanel containerPanel = new JPanel(new FlowLayout(2));
        containerPanel.add(importButton);
        containerPanel.add(this.exportButton);
        containerPanel.add(this.removeButton);
        return containerPanel;
    }

    public static enum Status {
        CORE("core"),
        EXTENSION("extension"),
        EXTENSION_ERROR("extension(parse error)"),
        EXTENSION_INSTALL("install"),
        EXTENSION_REPLACE("replace"),
        EXTENSION_REMOVE("remove"),
        EXTENSION_OVERRIDE("override"),
        EXTENSION_OVERPENDING("override pending");

        private String formalName;

        private Status(String nm) {
            this.formalName = nm;
        }
    }

    private static class CompilerElement
    implements Comparable<CompilerElement> {
        String name;
        String optionName;
        SpecExtension.Type type;
        Status status;
        String xmlString;

        public CompilerElement(String nm, SpecExtension.Type tp, Status st) {
            this.name = nm;
            this.type = tp;
            this.optionName = this.type.getOptionName(this.name);
            this.status = st;
            this.xmlString = null;
        }

        public boolean isExisting() {
            return this.status == Status.CORE || this.status == Status.EXTENSION || this.status == Status.EXTENSION_ERROR || this.status == Status.EXTENSION_OVERRIDE;
        }

        @Override
        public int compareTo(CompilerElement o) {
            if (this.type != o.type) {
                return this.type.ordinal() - o.type.ordinal();
            }
            if (this.status != o.status) {
                return this.status.ordinal() - o.status.ordinal();
            }
            return this.name.compareTo(o.name);
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            CompilerElement compilerElement = SpecExtensionPanel.this.getSelectedCompilerElement();
            if (compilerElement == null) {
                SpecExtensionPanel.this.removeButton.setEnabled(false);
                SpecExtensionPanel.this.exportButton.setEnabled(false);
                return;
            }
            boolean rowExisting = compilerElement.isExisting();
            SpecExtensionPanel.this.removeButton.setEnabled(rowExisting && compilerElement.status != Status.CORE);
            SpecExtensionPanel.this.exportButton.setEnabled(rowExisting);
        }
    }

    public class ChangeExtensionTask
    extends Task {
        public ChangeExtensionTask() {
            super("Committing extension changes", true, true, true);
        }

        public void run(TaskMonitor monitor) {
            try {
                for (CompilerElement element : SpecExtensionPanel.this.tableElements) {
                    switch (element.status) {
                        case CORE: 
                        case EXTENSION: 
                        case EXTENSION_ERROR: 
                        case EXTENSION_OVERRIDE: {
                            break;
                        }
                        case EXTENSION_REMOVE: {
                            SpecExtensionPanel.this.specExtension.removeCompilerSpecExtension(element.optionName, monitor);
                            break;
                        }
                        case EXTENSION_INSTALL: 
                        case EXTENSION_REPLACE: 
                        case EXTENSION_OVERPENDING: {
                            SpecExtensionPanel.this.specExtension.addReplaceCompilerSpecExtension(element.xmlString, monitor);
                        }
                    }
                }
            }
            catch (LockException ex) {
                Msg.showError((Object)((Object)this), null, (String)"Missing Exclusive Access", (Object)"Do not have exclusive acces");
            }
            catch (XmlParseException | SAXException ex) {
                Msg.showError((Object)((Object)this), null, (String)"Failed Committing Extension Changes", (Object)ex.getMessage());
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
    }

    private class SpecExtensionTableModel
    extends AbstractGTableModel<CompilerElement> {
        private final String[] columnNames = new String[]{"Extension Type", "Name", "Status"};

        private SpecExtensionTableModel() {
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getName() {
            return "Compiler Specification Elements";
        }

        public List<CompilerElement> getModelData() {
            return SpecExtensionPanel.this.tableElements;
        }

        public Object getColumnValueForRow(CompilerElement t, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return t.type.getTagName();
                }
                case 1: {
                    return t.name;
                }
                case 2: {
                    if (t.status == Status.CORE) {
                        return "";
                    }
                    return t.status.formalName;
                }
            }
            return "Unknown column!";
        }
    }

    private class CompilerElementTable
    extends GTable {
        private ElementRenderer renderer;

        CompilerElementTable(TableModel model) {
            super(model);
            this.renderer = new ElementRenderer();
        }

        public TableCellRenderer getCellRenderer(int row, int col) {
            return this.renderer;
        }
    }

    private class ElementRenderer
    extends GTableCellRenderer {
        private ElementRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            if (data.isSelected()) {
                return this;
            }
            int row = data.getRowViewIndex();
            CompilerElement compilerElement = (CompilerElement)SpecExtensionPanel.this.tableModel.getRowObject(row);
            if (compilerElement.status == Status.EXTENSION_ERROR) {
                this.setBackground((Color)GThemeDefaults.Colors.Palette.PINK);
            }
            return this;
        }
    }
}

