/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.modifier;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.datatype.modifier.MDBasedAttribute;
import mdemangler.naming.MDQualification;

public class MDCVMod
extends MDParsableItem {
    private static final String POINTER = "*";
    private static final String AMPERSAND = "&";
    private static final String CARET = "^";
    private static final String PERCENT = "%";
    private static final String DOUBLE_AMPERSAND = "&&";
    private static final String PTR64 = " __ptr64";
    private static final String UNALIGNED = "__unaligned ";
    private static final String RESTRICT = " __restrict";
    private static final String CONST = "const ";
    private static final String VOLATILE = "volatile ";
    private static final String LREF = "& ";
    private static final String RREF = "&& ";
    private static final String prefixEmitClausePinPointer = "cli::pin_ptr<";
    private static final String suffixEmitClausePinPointer = ">";
    private static final String prefixEmitClauseCLIArray = "cli::array<";
    private static final String suffixEmitClauseCLIArray = ">^";
    private boolean isPointer64;
    private boolean isUnaligned;
    private boolean isRestricted;
    private boolean isThisPointerMod;
    private boolean isLRef;
    private boolean isRRef;
    private boolean isConst;
    private boolean isVolatile;
    private boolean isFunction;
    private boolean isBased;
    private boolean isMember;
    private boolean isData;
    private boolean foundManagedProperty;
    private boolean isGC;
    private boolean isPinPointer;
    private boolean isCLIProperty;
    private boolean isCLIArray;
    private int arrayRank;
    private boolean noProperties;
    private boolean noCV;
    String special;
    private MDQualification qual;
    private MDCVMod thisPointerCVMod;
    private MDBasedAttribute basedType;
    private List<CvPrefix> prefixList = new ArrayList<CvPrefix>();
    private CvModifierType modType = CvModifierType.plain;

    public MDCVMod(MDMang dmang) {
        super(dmang);
    }

    public void clearProperties() {
        this.noProperties = true;
    }

    public boolean hasProperties() {
        return !this.noProperties;
    }

    public void clearCV() {
        this.noCV = true;
    }

    public boolean hasCV() {
        return !this.noCV;
    }

    public void setArrayType() {
        this.modType = CvModifierType.array;
    }

    public void setPointerType() {
        this.modType = CvModifierType.pointer;
    }

    public void setReferenceType() {
        this.modType = CvModifierType.reference;
    }

    public void setRightReferenceTemplateParameter() {
        this.modType = CvModifierType.rightreference;
    }

    public void setOtherType() {
        this.modType = CvModifierType.other;
    }

    public void setQuestionType() {
        this.modType = CvModifierType.question;
    }

    public boolean isPointerType() {
        return this.modType == CvModifierType.pointer;
    }

    public boolean isReferenceType() {
        return this.modType == CvModifierType.reference;
    }

    public boolean isFunctionPointerType() {
        return this.isFunction && this.modType == CvModifierType.pointer;
    }

    public boolean isFunctionReferenceType() {
        return this.isFunction && this.modType == CvModifierType.reference;
    }

    public boolean isArrayType() {
        return this.modType == CvModifierType.array;
    }

    public boolean isOtherType() {
        return this.modType == CvModifierType.other;
    }

    public boolean isQuestionType() {
        return this.modType == CvModifierType.question;
    }

    public MDCVMod getThisPointerMDCVMod() {
        return this.thisPointerCVMod;
    }

    public boolean isPointer64() {
        return this.isPointer64;
    }

    public void setGC() {
        this.isGC = true;
    }

    public boolean isGC() {
        return this.isGC;
    }

    public void setPinPointer() {
        this.isPinPointer = true;
    }

    public boolean isPinPointer() {
        return this.isPinPointer;
    }

    public void setCLIProperty() {
        this.isCLIProperty = true;
    }

    public boolean isCLIProperty() {
        return this.isCLIProperty;
    }

    public void setCLIArray() {
        this.isCLIArray = true;
    }

    public boolean isCLIArray() {
        return this.isCLIArray;
    }

    public boolean isUnaligned() {
        return this.isUnaligned;
    }

    public boolean isRestricted() {
        return this.isRestricted;
    }

    public void setConst() {
        this.isConst = true;
    }

    public void clearConst() {
        this.isConst = false;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setVolatile() {
        this.isVolatile = true;
    }

    public void clearVolatile() {
        this.isVolatile = false;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setThisPointerMod() {
        this.isThisPointerMod = true;
    }

    public String getBasedName() {
        if (this.basedType == null) {
            return null;
        }
        return this.basedType.toString();
    }

    public boolean isBased() {
        return this.basedType != null;
    }

    public boolean isMember() {
        return this.isMember;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public void setIsFunction() {
        this.isFunction = true;
    }

    public boolean isData() {
        return this.isData;
    }

    public String getMemberScope() {
        if (this.qual == null) {
            return null;
        }
        return this.qual.toString();
    }

    public boolean isBasedPtrBased() {
        return this.isBased && this.basedType.isBasedPtrBased();
    }

    public void checkInvalidSymbol() throws MDException {
        if (this.isFunction && (this.foundManagedProperty || this.prefixList.size() != 0)) {
            throw new MDException("EFI and Managed Properies not permitted for function pointer/reference");
        }
        if (this.isFunction && this.modType == CvModifierType.question) {
            throw new MDException("Function refType only permitted on pointer or reference");
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.hasProperties()) {
            this.parseEFGHI();
            while (this.parseManagedProperty() && this.parseEFGHI()) {
            }
        }
        if (this.hasCV()) {
            this.parseCV();
        }
        this.checkInvalidSymbol();
    }

    private boolean parseEFGHI() throws MDException {
        boolean prefixDone = false;
        boolean foundOne = false;
        block7: while (!prefixDone) {
            switch (this.dmang.peek()) {
                case 'E': {
                    this.dmang.parseInfoPush(0, "__ptr64");
                    this.dmang.increment();
                    this.isPointer64 = true;
                    foundOne = true;
                    this.prefixList.add(CvPrefix.ptr64);
                    this.dmang.parseInfoPop();
                    continue block7;
                }
                case 'F': {
                    this.dmang.parseInfoPush(0, "__unaligned");
                    this.dmang.increment();
                    this.isUnaligned = true;
                    foundOne = true;
                    this.prefixList.add(CvPrefix.unaligned);
                    this.dmang.parseInfoPop();
                    continue block7;
                }
                case 'G': {
                    if (this.dmang.allowCVModLRefRRef()) {
                        if (!this.isThisPointerMod) {
                            throw new MDException("LRef only permitted on 'this' pointer");
                        }
                        this.dmang.parseInfoPush(0, "LRef");
                        this.dmang.increment();
                        this.isLRef = true;
                        foundOne = true;
                        this.dmang.parseInfoPop();
                        continue block7;
                    }
                    prefixDone = true;
                    continue block7;
                }
                case 'H': {
                    if (this.dmang.allowCVModLRefRRef()) {
                        if (!this.isThisPointerMod) {
                            throw new MDException("RRef only permitted on 'this' pointer");
                        }
                        this.dmang.parseInfoPush(0, "RRef");
                        this.dmang.increment();
                        this.isRRef = true;
                        foundOne = true;
                        this.dmang.parseInfoPop();
                        continue block7;
                    }
                    prefixDone = true;
                    continue block7;
                }
                case 'I': {
                    this.dmang.parseInfoPush(0, "__restricted");
                    this.dmang.increment();
                    this.isRestricted = true;
                    foundOne = true;
                    this.prefixList.add(CvPrefix.restrict);
                    this.dmang.parseInfoPop();
                    continue block7;
                }
            }
            prefixDone = true;
        }
        return foundOne;
    }

    public boolean parseManagedProperty() throws MDException {
        if (this.dmang.peek() != '$') {
            return false;
        }
        this.dmang.increment();
        char code = this.dmang.peek();
        switch (code) {
            case 'A': {
                this.dmang.increment();
                this.setGC();
                break;
            }
            case 'B': {
                this.dmang.increment();
                if (this.modType == CvModifierType.plain || this.modType == CvModifierType.other) break;
                this.setPinPointer();
                break;
            }
            case 'C': {
                this.dmang.increment();
                this.setCLIProperty();
                if (this.modType != CvModifierType.plain) break;
                this.setPointerType();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.setCLIArray();
                this.dmang.increment();
                if (code >= '0' && code <= '9') {
                    this.arrayRank = code - 48;
                } else if (code >= 'A' && code <= 'F') {
                    this.arrayRank = code - 65 + 10;
                } else {
                    throw new MDException("invalid cli:array rank");
                }
                code = this.dmang.getAndIncrement();
                this.arrayRank = this.arrayRank * 16 + code - 48;
                break;
            }
            default: {
                throw new MDException("unknown managed property: " + code);
            }
        }
        this.foundManagedProperty = true;
        return true;
    }

    private void parseCV() throws MDException {
        char code = this.dmang.getAndIncrement();
        block0 : switch (code) {
            case 'A': {
                this.isData = true;
                break;
            }
            case 'B': 
            case 'J': {
                this.isData = true;
                this.isConst = true;
                break;
            }
            case 'C': 
            case 'G': 
            case 'K': {
                this.isData = true;
                this.isVolatile = true;
                break;
            }
            case 'D': 
            case 'H': 
            case 'L': {
                this.isData = true;
                this.isConst = true;
                this.isVolatile = true;
                break;
            }
            case 'M': {
                this.isData = true;
                this.isBased = true;
                break;
            }
            case 'N': {
                this.isData = true;
                this.isConst = true;
                this.isBased = true;
                break;
            }
            case 'O': {
                this.isData = true;
                this.isVolatile = true;
                this.isBased = true;
                break;
            }
            case 'P': {
                this.isData = true;
                this.isConst = true;
                this.isVolatile = true;
                this.isBased = true;
                break;
            }
            case 'Q': 
            case 'U': 
            case 'Y': {
                this.isData = true;
                this.isMember = true;
                break;
            }
            case 'R': 
            case 'V': 
            case 'Z': {
                this.isData = true;
                this.isConst = true;
                this.isMember = true;
                break;
            }
            case '0': 
            case 'S': 
            case 'W': {
                this.isData = true;
                this.isVolatile = true;
                this.isMember = true;
                break;
            }
            case '1': 
            case 'T': 
            case 'X': {
                this.isData = true;
                this.isConst = true;
                this.isVolatile = true;
                this.isMember = true;
                break;
            }
            case '2': {
                this.isData = true;
                this.isBased = true;
                this.isMember = true;
                break;
            }
            case '3': {
                this.isData = true;
                this.isConst = true;
                this.isBased = true;
                this.isMember = true;
                break;
            }
            case '4': {
                this.isData = true;
                this.isVolatile = true;
                this.isBased = true;
                this.isMember = true;
                break;
            }
            case '5': {
                this.isData = true;
                this.isConst = true;
                this.isVolatile = true;
                this.isBased = true;
                this.isMember = true;
                break;
            }
            case '6': 
            case '7': {
                this.isFunction = true;
                break;
            }
            case '8': 
            case '9': {
                this.isFunction = true;
                this.isMember = true;
                break;
            }
            case '_': {
                this.isFunction = true;
                char code1 = this.dmang.getAndIncrement();
                switch (code1) {
                    case 'A': 
                    case 'B': {
                        this.isBased = true;
                        break block0;
                    }
                    case 'C': 
                    case 'D': {
                        this.isBased = true;
                        this.isMember = true;
                        break block0;
                    }
                }
                throw new MDException("CV code not expected: _" + code1);
            }
            case '\uffff': {
                break;
            }
            default: {
                throw new MDException("CV code not expected: " + code);
            }
        }
        if (this.isMember) {
            this.qual = new MDQualification(this.dmang);
            this.qual.parse();
            if (this.isFunction) {
                this.thisPointerCVMod = new MDCVMod(this.dmang);
                this.thisPointerCVMod.setThisPointerMod();
                this.thisPointerCVMod.parse();
            }
        }
        if (this.isBased) {
            this.basedType = new MDBasedAttribute(this.dmang);
            this.basedType.parse();
        }
    }

    public void insertManagedPropertiesPrefix(StringBuilder builder) {
        if (this.isCLIArray) {
            this.dmang.insertString(builder, prefixEmitClauseCLIArray);
        } else if (this.isPinPointer) {
            this.dmang.insertString(builder, prefixEmitClausePinPointer);
        }
    }

    public void insertManagedPropertiesSuffix(StringBuilder builder) {
        if (this.isCLIArray) {
            this.dmang.appendString(builder, " ");
            if (this.arrayRank > 1) {
                this.dmang.appendString(builder, ",");
                this.dmang.appendString(builder, Integer.toUnsignedString(this.arrayRank));
            }
            this.dmang.appendString(builder, suffixEmitClauseCLIArray);
        } else if (this.isPinPointer) {
            this.dmang.appendString(builder, suffixEmitClausePinPointer);
        }
    }

    public void insertManagedProperties(StringBuilder builder) {
        if (this.isCLIArray) {
            this.dmang.insertString(builder, prefixEmitClauseCLIArray);
            this.dmang.appendString(builder, " ");
            if (this.arrayRank > 1) {
                this.dmang.appendString(builder, ",");
                this.dmang.appendString(builder, Integer.toUnsignedString(this.arrayRank));
            }
            this.dmang.appendString(builder, suffixEmitClauseCLIArray);
        } else if (this.isPinPointer) {
            this.dmang.insertString(builder, prefixEmitClausePinPointer);
            this.dmang.appendString(builder, " ");
            this.dmang.appendString(builder, suffixEmitClausePinPointer);
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (!this.isCLIArray) {
            if (this.isPinPointer) {
                // empty if block
            }
            StringBuilder modBuilder = new StringBuilder();
            this.insertGH(modBuilder);
            this.insertPrefixEI(modBuilder);
            this.insertModType(modBuilder);
            this.insertF(modBuilder);
            this.insertCV(modBuilder);
            this.dmang.insertSpacedString(builder, modBuilder.toString());
        }
    }

    public String getModTypeAnnotation() {
        String annotation = "";
        switch (this.modType) {
            case pointer: {
                if (this.isCLIProperty()) {
                    annotation = PERCENT;
                    break;
                }
                if (this.isGC()) {
                    annotation = CARET;
                    break;
                }
                annotation = POINTER;
                break;
            }
            case reference: {
                if (this.isCLIProperty()) {
                    annotation = PERCENT;
                    break;
                }
                if (this.isGC()) {
                    annotation = PERCENT;
                    break;
                }
                annotation = AMPERSAND;
                break;
            }
            case rightreference: {
                if (this.isCLIProperty()) {
                    annotation = PERCENT;
                    break;
                }
                if (this.isGC()) {
                    annotation = PERCENT;
                    break;
                }
                annotation = DOUBLE_AMPERSAND;
                break;
            }
            case array: {
                break;
            }
            default: {
                if (!this.isCLIProperty()) break;
                annotation = PERCENT;
            }
        }
        return annotation;
    }

    public void insertModType(StringBuilder builder) {
        String annotation = this.getModTypeAnnotation();
        this.dmang.insertSpacedString(builder, annotation);
    }

    public void insertF(StringBuilder builder) {
        for (CvPrefix p : this.prefixList) {
            switch (p) {
                case unaligned: {
                    this.dmang.insertSpacedString(builder, UNALIGNED);
                    break;
                }
            }
        }
    }

    public void insertGH(StringBuilder builder) {
        if (this.isRRef) {
            this.dmang.insertString(builder, RREF);
        }
        if (this.isLRef) {
            this.dmang.insertString(builder, LREF);
        }
    }

    public void insertPrefixEI(StringBuilder builder) {
        ListIterator<CvPrefix> li = this.prefixList.listIterator(this.prefixList.size());
        StringBuilder EIBuilder = new StringBuilder();
        while (li.hasPrevious()) {
            CvPrefix p = li.previous();
            switch (p) {
                case ptr64: {
                    this.dmang.insertSpacedString(EIBuilder, PTR64);
                    break;
                }
                case restrict: {
                    this.dmang.insertSpacedString(EIBuilder, RESTRICT);
                    break;
                }
            }
        }
        this.dmang.insertString(builder, EIBuilder.toString());
    }

    public void insertCV(StringBuilder builder) {
        if (this.isMember && this.qual != null && this.modType != CvModifierType.plain && this.qual.hasContent()) {
            this.dmang.insertString(builder, "::");
            this.qual.insert(builder);
        }
        if (this.isBased) {
            this.basedType.insert(builder);
            if (this.basedType.isBasedPtrBased()) {
                return;
            }
        }
        if (this.isVolatile) {
            this.dmang.insertSpacedString(builder, VOLATILE);
        }
        if (this.isConst) {
            this.dmang.insertSpacedString(builder, CONST);
        }
    }

    private static enum CvModifierType {
        plain,
        pointer,
        reference,
        rightreference,
        caret,
        percent,
        functionpointer,
        functionreference,
        array,
        question,
        other;

    }

    private static enum CvPrefix {
        ptr64,
        unaligned,
        restrict;

    }
}

