/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.datatype.extended;

import mdemangler.MDEncodedNumber;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;

public class MDArrayReferencedType
extends MDDataType {
    private String arrayString = "";
    private MDDataType refDataType;

    public MDArrayReferencedType(MDMang dmang) {
        super(dmang, 0);
    }

    public String getArrayString() {
        return this.arrayString;
    }

    public MDDataType getReferencedType() {
        return this.refDataType;
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() == 'Y') {
            this.dmang.parseInfoPush(0, "Array Property");
            this.dmang.increment();
            MDEncodedNumber n1 = new MDEncodedNumber(this.dmang);
            n1.parse();
            int num = n1.getValue().intValue();
            this.arrayString = "";
            while (num-- > 0) {
                MDEncodedNumber n2 = new MDEncodedNumber(this.dmang);
                n2.parse();
                this.arrayString = this.arrayString + "[" + n2 + "]";
            }
            this.dmang.parseInfoPop();
            this.refDataType = MDDataTypeParser.parsePrimaryDataType(this.dmang, false);
            this.refDataType.parse();
        }
    }

    @Override
    public void insert(StringBuilder builder) {
        if (!this.dmang.isEffectivelyEmpty(builder)) {
            this.dmang.insertString(builder, "(");
            this.dmang.appendString(builder, ")");
        }
        this.dmang.appendString(builder, this.getArrayString());
        this.refDataType.insert(builder);
    }
}

