/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.rmi.trace;

import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiHandler;
import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiPlugin;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;

public class TraceRmiServer {
    protected final TraceRmiPlugin plugin;
    protected final SocketAddress address;
    protected ServerSocket socket;

    public TraceRmiServer(TraceRmiPlugin plugin, SocketAddress address) {
        this.plugin = plugin;
        this.address = address;
    }

    protected void bind() throws IOException {
        this.socket.bind(this.address);
    }

    public void start() throws IOException {
        this.socket = new ServerSocket();
        this.bind();
        new Thread(this::serviceLoop, "trace-rmi server " + this.socket.getLocalSocketAddress()).start();
    }

    public void setTimeout(int millis) throws SocketException {
        this.socket.setSoTimeout(millis);
    }

    protected TraceRmiHandler accept() throws IOException {
        Socket client = this.socket.accept();
        TraceRmiHandler handler = new TraceRmiHandler(this.plugin, client);
        handler.start();
        return handler;
    }

    protected void serviceLoop() {
        try {
            this.accept();
        }
        catch (IOException e) {
            if (this.socket.isClosed()) {
                return;
            }
            Msg.error((Object)"Error accepting TraceRmi client", (Object)e);
            return;
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Msg.error((Object)"Error closing TraceRmi service", (Object)e);
            }
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Msg.error((Object)"Error closing TraceRmi service", (Object)e);
        }
    }

    public SocketAddress getAddress() {
        return this.socket.getLocalSocketAddress();
    }
}

