/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.rmi.trace;

import com.google.protobuf.ByteString;
import db.Transaction;
import generic.Span;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.disassemble.DebuggerDisassemblerPlugin;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.app.plugin.core.debug.service.rmi.trace.OpenTrace;
import ghidra.app.plugin.core.debug.service.rmi.trace.RemoteAsyncResult;
import ghidra.app.plugin.core.debug.service.rmi.trace.RemoteMethod;
import ghidra.app.plugin.core.debug.service.rmi.trace.RemoteMethodRegistry;
import ghidra.app.plugin.core.debug.service.rmi.trace.RemoteParameter;
import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiError;
import ghidra.app.plugin.core.debug.service.rmi.trace.TraceRmiPlugin;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.XmlSchemaContext;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.lifecycle.Internal;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.util.DefaultLanguageService;
import ghidra.rmi.trace.TraceRmi;
import ghidra.trace.database.DBTrace;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.TimedMsg;
import ghidra.util.UnionAddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TraceRmiHandler {
    public static final String VERSION = "10.4";
    private final TraceRmiPlugin plugin;
    private final Socket socket;
    private final InputStream in;
    private final OutputStream out;
    private final CompletableFuture<Void> negotiate = new CompletableFuture();
    private final CompletableFuture<Void> closed = new CompletableFuture();
    private final OpenTraceMap openTraces = new OpenTraceMap();
    private final Map<Tid, OpenTx> openTxes = new HashMap<Tid, OpenTx>();
    private final RemoteMethodRegistry methodRegistry = new RemoteMethodRegistry();
    private final Deque<RemoteAsyncResult> xReqQueue = new ArrayDeque<RemoteAsyncResult>();
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    long dbgSeq = 0L;
    final Dispatcher dispatchNegotiate = (req, rep) -> {
        switch (req.getMsgCase()) {
            case REQUEST_NEGOTIATE: {
                break;
            }
            default: {
                throw new InvalidRequestError(req);
            }
        }
        return rep.setReplyNegotiate(this.handleNegotiate(req.getRequestNegotiate()));
    };
    final Dispatcher dispatchNominal = (req, rep) -> switch (req.getMsgCase()) {
        case TraceRmi.RootMessage.MsgCase.REQUEST_ACTIVATE -> rep.setReplyActivate(this.handleActivate(req.getRequestActivate()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_CLOSE_TRACE -> rep.setReplyCloseTrace(this.handleCloseTrace(req.getRequestCloseTrace()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_CREATE_OBJECT -> rep.setReplyCreateObject(this.handleCreateObject(req.getRequestCreateObject()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_CREATE_OVERLAY -> rep.setReplyCreateOverlay(this.handleCreateOverlay(req.getRequestCreateOverlay()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_CREATE_ROOT_OBJECT -> rep.setReplyCreateObject(this.handleCreateRootObject(req.getRequestCreateRootObject()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_CREATE_TRACE -> rep.setReplyCreateTrace(this.handleCreateTrace(req.getRequestCreateTrace()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_DELETE_BYTES -> rep.setReplyDeleteBytes(this.handleDeleteBytes(req.getRequestDeleteBytes()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_DELETE_REGISTER_VALUE -> rep.setReplyDeleteRegisterValue(this.handleDeleteRegisterValue(req.getRequestDeleteRegisterValue()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_DISASSEMBLE -> rep.setReplyDisassemble(this.handleDisassemble(req.getRequestDisassemble()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_END_TX -> rep.setReplyEndTx(this.handleEndTx(req.getRequestEndTx()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_GET_OBJECT -> rep.setReplyGetObject(this.handleGetObject(req.getRequestGetObject()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_GET_VALUES -> rep.setReplyGetValues(this.handleGetValues(req.getRequestGetValues()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_GET_VALUES_INTERSECTING -> rep.setReplyGetValues(this.handleGetValuesIntersecting(req.getRequestGetValuesIntersecting()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_INSERT_OBJECT -> rep.setReplyInsertObject(this.handleInsertObject(req.getRequestInsertObject()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_PUT_BYTES -> rep.setReplyPutBytes(this.handlePutBytes(req.getRequestPutBytes()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_PUT_REGISTER_VALUE -> rep.setReplyPutRegisterValue(this.handlePutRegisterValue(req.getRequestPutRegisterValue()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_REMOVE_OBJECT -> rep.setReplyRemoveObject(this.handleRemoveObject(req.getRequestRemoveObject()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_RETAIN_VALUES -> rep.setReplyRetainValues(this.handleRetainValues(req.getRequestRetainValues()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_SAVE_TRACE -> rep.setReplySaveTrace(this.handleSaveTrace(req.getRequestSaveTrace()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_SET_MEMORY_STATE -> rep.setReplySetMemoryState(this.handleSetMemoryState(req.getRequestSetMemoryState()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_SET_VALUE -> rep.setReplySetValue(this.handleSetValue(req.getRequestSetValue()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_SNAPSHOT -> rep.setReplySnapshot(this.handleSnapshot(req.getRequestSnapshot()));
        case TraceRmi.RootMessage.MsgCase.REQUEST_START_TX -> rep.setReplyStartTx(this.handleStartTx(req.getRequestStartTx()));
        case TraceRmi.RootMessage.MsgCase.XREPLY_INVOKE_METHOD -> this.handleXInvokeMethod(req.getXreplyInvokeMethod());
        default -> throw new InvalidRequestError(req);
    };

    public TraceRmiHandler(TraceRmiPlugin plugin, Socket socket) throws IOException {
        this.plugin = plugin;
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.negotiate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushXReqQueue(Throwable exc) {
        List<RemoteAsyncResult> copy;
        Deque<RemoteAsyncResult> deque = this.xReqQueue;
        synchronized (deque) {
            copy = List.copyOf(this.xReqQueue);
            this.xReqQueue.clear();
        }
        for (RemoteAsyncResult result : copy) {
            result.completeExceptionally(exc);
        }
    }

    public void dispose() throws IOException {
        Object open;
        Record nextKey;
        this.flushXReqQueue(new TraceRmiError("Socket closed"));
        this.socket.close();
        while (!this.openTxes.isEmpty()) {
            nextKey = this.openTxes.keySet().iterator().next();
            open = this.openTxes.remove(nextKey);
            ((OpenTx)open).tx.close();
        }
        while (!this.openTraces.isEmpty()) {
            nextKey = this.openTraces.idSet().iterator().next();
            open = this.openTraces.removeById((DoId)nextKey);
            if (this.traceManager == null || this.traceManager.isSaveTracesByDefault()) {
                try {
                    ((OpenTrace)open).trace.save("Save on Disconnect", this.plugin.getTaskMonitor());
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Could not save " + ((OpenTrace)open).trace));
                }
                catch (CancelledException cancelledException) {
                    // empty catch block
                }
            }
            ((OpenTrace)open).trace.release((Object)this);
        }
        this.closed.complete(null);
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public void waitClosed() throws InterruptedException, ExecutionException {
        this.closed.get();
    }

    protected DomainFolder getOrCreateNewTracesFolder() throws InvalidNameException, IOException {
        return this.getOrCreateFolder(this.plugin.getTool().getProject().getProjectData().getRootFolder(), "New Traces");
    }

    protected DomainFolder getOrCreateFolder(DomainFolder parent, String name) throws InvalidNameException, IOException {
        try {
            return parent.createFolder(name);
        }
        catch (DuplicateFileException e) {
            return parent.getFolder(name);
        }
    }

    protected DomainFolder createFolders(DomainFolder parent, Path path) throws InvalidNameException, IOException {
        return this.createFolders(parent, path, 0);
    }

    protected DomainFolder createFolders(DomainFolder parent, Path path, int index) throws InvalidNameException, IOException {
        if (path == null && index == 0 || index == path.getNameCount()) {
            return parent;
        }
        String name = path.getName(index).toString();
        return this.createFolders(this.getOrCreateFolder(parent, name), path, index + 1);
    }

    protected DomainFile createDeconflictedFile(DomainFolder parent, DomainObject object) throws InvalidNameException, CancelledException, IOException {
        Object name = object.getName();
        TaskMonitor monitor = this.plugin.getTaskMonitor();
        for (int nextId = 1; nextId < 100; ++nextId) {
            try {
                return parent.createFile((String)name, object, monitor);
            }
            catch (DuplicateFileException e) {
                name = object.getName() + "." + nextId;
                continue;
            }
        }
        return parent.createFile((String)name, object, monitor);
    }

    public void start() {
        new Thread(this::receiveLoop, "trace-rmi handler " + this.socket.getRemoteSocketAddress()).start();
    }

    protected TraceRmi.RootMessage receive() {
        try {
            return TraceRmiHandler.recvDelimited(this.in);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Cannot read packet: " + e));
            this.flushXReqQueue(e);
            return null;
        }
    }

    protected static void sendDelimited(OutputStream out, TraceRmi.RootMessage msg, long dbgSeq) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(msg.getSerializedSize());
        out.write(buf.array());
        msg.writeTo(out);
        out.flush();
    }

    protected static byte[] recvAll(InputStream in, int len) throws IOException {
        int l;
        byte[] buf = new byte[len];
        for (int total = 0; total < len; total += l) {
            l = in.read(buf, total, len - total);
            if (l > 0) continue;
            return null;
        }
        return buf;
    }

    protected static TraceRmi.RootMessage recvDelimited(InputStream in) throws IOException {
        byte[] lenBuf = TraceRmiHandler.recvAll(in, 4);
        if (lenBuf == null) {
            return null;
        }
        int len = ByteBuffer.wrap(lenBuf).getInt();
        byte[] datBuf = TraceRmiHandler.recvAll(in, len);
        if (datBuf == null) {
            return null;
        }
        TraceRmi.RootMessage msg = TraceRmi.RootMessage.parseFrom(datBuf);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean send(TraceRmi.RootMessage rep) {
        try {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                TraceRmiHandler.sendDelimited(this.out, rep, this.dbgSeq++);
            }
            return true;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Cannot send reply", (Throwable)e);
            return false;
        }
    }

    public void receiveLoop() {
        try {
            while (true) {
                TraceRmi.RootMessage req;
                if ((req = this.receive()) == null) {
                    return;
                }
                TraceRmi.RootMessage rep = this.dispatchNominal.handle(req);
                if (rep == null) continue;
                if (this.send(rep)) continue;
                return;
            }
        }
        finally {
            try {
                this.dispose();
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Could not close socket after error", (Throwable)e);
            }
        }
    }

    protected void negotiate() {
        TraceRmi.RootMessage req = this.receive();
        TraceRmi.RootMessage rep = this.dispatchNegotiate.handle(req);
        if (req == null) {
            throw new TraceRmiError("Could not receive negotiation request");
        }
        if (!this.send(rep)) {
            throw new TraceRmiError("Could not respond during negotiation");
        }
    }

    protected OpenTrace requireOpenTrace(TraceRmi.DomObjId domObjId) {
        return this.requireOpenTrace(new DoId(domObjId));
    }

    protected OpenTrace requireOpenTrace(DoId doId) {
        OpenTrace open = this.openTraces.getById(doId);
        if (open == null) {
            throw new InvalidDomObjIdError();
        }
        return open;
    }

    protected DoId requireAvailableDoId(TraceRmi.DomObjId domObjId) {
        return this.requireAvailableDoId(new DoId(domObjId));
    }

    protected DoId requireAvailableDoId(DoId doId) {
        OpenTrace open = this.openTraces.getById(doId);
        if (open != null) {
            throw new DomObjIdInUseError();
        }
        return doId;
    }

    protected Tid requireAvailableTid(OpenTrace open, TraceRmi.TxId txid) {
        return this.requireAvailableTid(new Tid(open.doId, txid.getId()));
    }

    protected Tid requireAvailableTid(Tid tid) {
        OpenTx tx = this.openTxes.get(tid);
        if (tx != null) {
            throw new TxIdInUseError();
        }
        return tid;
    }

    protected CompilerSpec requireCompilerSpec(TraceRmi.Language language, TraceRmi.Compiler compiler) throws LanguageNotFoundException, CompilerSpecNotFoundException {
        return DefaultLanguageService.getLanguageService().getLanguage(new LanguageID(language.getId())).getCompilerSpecByID(new CompilerSpecID(compiler.getId()));
    }

    protected static TraceObjectKeyPath toKeyPath(TraceRmi.ObjPath path) {
        return TraceObjectKeyPath.parse((String)path.getPath());
    }

    protected static PathPattern toPathPattern(TraceRmi.ObjPath path) {
        return new PathPattern(PathUtils.parse((String)path.getPath()));
    }

    protected static Lifespan toLifespan(TraceRmi.Span span) {
        return Lifespan.span((long)span.getMin(), (long)span.getMax());
    }

    protected static TraceMemoryState toMemoryState(TraceRmi.MemoryState state) {
        return switch (state) {
            case TraceRmi.MemoryState.MS_UNKNOWN -> TraceMemoryState.UNKNOWN;
            case TraceRmi.MemoryState.MS_KNOWN -> TraceMemoryState.KNOWN;
            case TraceRmi.MemoryState.MS_ERROR -> TraceMemoryState.ERROR;
            default -> throw new AssertionError();
        };
    }

    protected static TraceObject.ConflictResolution toResolution(TraceRmi.Resolution resolution) {
        return switch (resolution) {
            case TraceRmi.Resolution.CR_DENY -> TraceObject.ConflictResolution.DENY;
            case TraceRmi.Resolution.CR_TRUNCATE -> TraceObject.ConflictResolution.TRUNCATE;
            case TraceRmi.Resolution.CR_ADJUST -> TraceObject.ConflictResolution.ADJUST;
            default -> throw new AssertionError();
        };
    }

    protected static TraceRmi.ObjSpec makeObjSpec(TraceObject object) {
        return TraceRmi.ObjSpec.newBuilder().setId(object.getKey()).build();
    }

    protected static TraceRmi.ObjPath makeObjPath(TraceObjectKeyPath path) {
        return TraceRmi.ObjPath.newBuilder().setPath(path.toString()).build();
    }

    protected static TraceRmi.ObjDesc makeObjDesc(TraceObject object) {
        return TraceRmi.ObjDesc.newBuilder().setId(object.getKey()).setPath(TraceRmiHandler.makeObjPath(object.getCanonicalPath())).build();
    }

    protected static TraceRmi.ValDesc makeValDesc(TraceObjectValue value) {
        return TraceRmi.ValDesc.newBuilder().setParent(TraceRmiHandler.makeObjDesc(value.getParent())).setSpan(TraceRmiHandler.makeSpan(value.getLifespan())).setKey(value.getEntryKey()).setValue(TraceRmiHandler.makeValue(value.getValue())).build();
    }

    protected static TraceRmi.ValDesc makeValDesc(TraceObjectValPath valPath) {
        return TraceRmiHandler.makeValDesc(valPath.getLastEntry());
    }

    protected static TraceRmi.Span makeSpan(Lifespan lifespan) {
        if (lifespan.isEmpty()) {
            return TraceRmi.Span.newBuilder().setMin(0L).setMax(-1L).build();
        }
        return TraceRmi.Span.newBuilder().setMin(lifespan.lmin()).setMax(lifespan.lmax()).build();
    }

    protected static TraceRmi.Addr makeAddr(Address address) {
        return TraceRmi.Addr.newBuilder().setSpace(address.getAddressSpace().getName()).setOffset(address.getOffset()).build();
    }

    protected static TraceRmi.AddrRange makeAddrRange(AddressRange range) {
        return TraceRmi.AddrRange.newBuilder().setSpace(range.getAddressSpace().getName()).setOffset(range.getMinAddress().getOffset()).setExtend(range.getLength() - 1L).build();
    }

    protected static TraceRmi.Value makeValue(Object value) {
        if (value instanceof Void) {
            return TraceRmi.Value.newBuilder().setNullValue(TraceRmi.Null.getDefaultInstance()).build();
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return TraceRmi.Value.newBuilder().setBoolValue(b).build();
        }
        if (value instanceof Byte) {
            Byte b = (Byte)value;
            return TraceRmi.Value.newBuilder().setByteValue(b.byteValue()).build();
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return TraceRmi.Value.newBuilder().setCharValue(c.charValue()).build();
        }
        if (value instanceof Short) {
            Short s2 = (Short)value;
            return TraceRmi.Value.newBuilder().setShortValue(s2.shortValue()).build();
        }
        if (value instanceof Integer) {
            Integer i2 = (Integer)value;
            return TraceRmi.Value.newBuilder().setIntValue(i2).build();
        }
        if (value instanceof Long) {
            Long l2 = (Long)value;
            return TraceRmi.Value.newBuilder().setLongValue(l2).build();
        }
        if (value instanceof String) {
            String s3 = (String)value;
            return TraceRmi.Value.newBuilder().setStringValue(s3).build();
        }
        if (value instanceof boolean[]) {
            boolean[] ba = (boolean[])value;
            return TraceRmi.Value.newBuilder().setBoolArrValue(TraceRmi.BoolArr.newBuilder().addAllArr(Arrays.asList(ArrayUtils.toObject((boolean[])ba)))).build();
        }
        if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            return TraceRmi.Value.newBuilder().setBytesValue(ByteString.copyFrom((byte[])ba)).build();
        }
        if (value instanceof char[]) {
            char[] ca = (char[])value;
            return TraceRmi.Value.newBuilder().setCharArrValue(new String(ca)).build();
        }
        if (value instanceof short[]) {
            short[] sa = (short[])value;
            return TraceRmi.Value.newBuilder().setShortArrValue(TraceRmi.ShortArr.newBuilder().addAllArr(Stream.of(ArrayUtils.toObject((short[])sa)).map(s -> (int)s).toList())).build();
        }
        if (value instanceof int[]) {
            int[] ia = (int[])value;
            return TraceRmi.Value.newBuilder().setIntArrValue(TraceRmi.IntArr.newBuilder().addAllArr(IntStream.of(ia).mapToObj(i -> i).toList())).build();
        }
        if (value instanceof long[]) {
            long[] la = (long[])value;
            return TraceRmi.Value.newBuilder().setLongArrValue(TraceRmi.LongArr.newBuilder().addAllArr(LongStream.of(la).mapToObj(l -> l).toList())).build();
        }
        if (value instanceof String[]) {
            String[] sa = (String[])value;
            return TraceRmi.Value.newBuilder().setStringArrValue(TraceRmi.StringArr.newBuilder().addAllArr(List.of(sa))).build();
        }
        if (value instanceof Address) {
            Address a = (Address)value;
            return TraceRmi.Value.newBuilder().setAddressValue(TraceRmiHandler.makeAddr(a)).build();
        }
        if (value instanceof AddressRange) {
            AddressRange r = (AddressRange)value;
            return TraceRmi.Value.newBuilder().setRangeValue(TraceRmiHandler.makeAddrRange(r)).build();
        }
        if (value instanceof TraceObject) {
            TraceObject o = (TraceObject)value;
            return TraceRmi.Value.newBuilder().setChildDesc(TraceRmiHandler.makeObjDesc(o)).build();
        }
        throw new AssertionError((Object)("Cannot encode value: " + value + "(type=" + value.getClass() + ")"));
    }

    protected static TraceRmi.MethodArgument makeArgument(String name, Object value) {
        return TraceRmi.MethodArgument.newBuilder().setName(name).setValue(TraceRmiHandler.makeValue(value)).build();
    }

    protected static TraceRmi.MethodArgument makeArgument(Map.Entry<String, Object> ent) {
        return TraceRmiHandler.makeArgument(ent.getKey(), ent.getValue());
    }

    protected TraceRmi.ReplyActivate handleActivate(TraceRmi.RequestActivate req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        TraceObject object = open.getObject(req.getObject(), true);
        DebuggerCoordinates coords = this.traceManager.getCurrent();
        coords = coords.object(object);
        if (open.lastSnapshot != null) {
            coords = coords.snap(open.lastSnapshot.getKey());
        }
        if (!this.traceManager.getOpenTraces().contains(open.trace)) {
            this.traceManager.openTrace(open.trace);
            this.traceManager.activate(coords);
        } else {
            Trace currentTrace = this.traceManager.getCurrentTrace();
            if (currentTrace == null || currentTrace == open.trace) {
                this.traceManager.activate(coords);
            }
        }
        return TraceRmi.ReplyActivate.getDefaultInstance();
    }

    protected TraceRmi.ReplyCloseTrace handleCloseTrace(TraceRmi.RequestCloseTrace req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        this.openTraces.removeById(open.doId);
        open.trace.release((Object)this);
        return TraceRmi.ReplyCloseTrace.getDefaultInstance();
    }

    protected TraceRmi.ReplyCreateObject handleCreateObject(TraceRmi.RequestCreateObject req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        TraceObject object = open.trace.getObjectManager().createObject(TraceRmiHandler.toKeyPath(req.getPath()));
        return TraceRmi.ReplyCreateObject.newBuilder().setObject(TraceRmiHandler.makeObjSpec(object)).build();
    }

    protected TraceRmi.ReplyCreateOverlaySpace handleCreateOverlay(TraceRmi.RequestCreateOverlaySpace req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        AddressSpace base = open.getSpace(req.getBaseSpace(), true);
        open.trace.getMemoryManager().getOrCreateOverlayAddressSpace(req.getName(), base);
        return TraceRmi.ReplyCreateOverlaySpace.getDefaultInstance();
    }

    protected TraceRmi.ReplyCreateObject handleCreateRootObject(TraceRmi.RequestCreateRootObject req) {
        XmlSchemaContext ctx;
        OpenTrace open = this.requireOpenTrace(req.getOid());
        try {
            ctx = XmlSchemaContext.deserialize((String)req.getSchemaContext());
        }
        catch (Exception e) {
            throw new InvalidSchemaError(e);
        }
        TraceObjectValue value = open.trace.getObjectManager().createRootObject(ctx.getSchema(new TargetObjectSchema.SchemaName(req.getRootSchema())));
        return TraceRmi.ReplyCreateObject.newBuilder().setObject(TraceRmiHandler.makeObjSpec(value.getChild())).build();
    }

    protected TraceRmi.ReplyCreateTrace handleCreateTrace(TraceRmi.RequestCreateTrace req) throws InvalidNameException, IOException, CancelledException {
        DomainFolder traces = this.getOrCreateNewTracesFolder();
        Path path = Paths.get(req.getPath().getPath(), new String[0]);
        DomainFolder folder = this.createFolders(traces, path.getParent());
        CompilerSpec cs = this.requireCompilerSpec(req.getLanguage(), req.getCompiler());
        DBTrace trace = new DBTrace(path.getFileName().toString(), cs, (Object)this);
        DoId doId = this.requireAvailableDoId(req.getOid());
        this.openTraces.put(new OpenTrace(doId, (Trace)trace));
        this.createDeconflictedFile(folder, (DomainObject)trace);
        return TraceRmi.ReplyCreateTrace.getDefaultInstance();
    }

    protected TraceRmi.ReplyDeleteBytes handleDeleteBytes(TraceRmi.RequestDeleteBytes req) throws AddressOverflowException {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        long snap = req.getSnap().getSnap();
        AddressRange range = open.toRange(req.getRange(), false);
        if (range == null) {
            return TraceRmi.ReplyDeleteBytes.getDefaultInstance();
        }
        open.trace.getMemoryManager().removeBytes(snap, range.getMinAddress(), (int)range.getLength());
        return TraceRmi.ReplyDeleteBytes.getDefaultInstance();
    }

    protected TraceRmi.ReplyDeleteRegisterValue handleDeleteRegisterValue(TraceRmi.RequestDeleteRegisterValue req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        long snap = req.getSnap().getSnap();
        AddressSpace space = open.trace.getBaseAddressFactory().getAddressSpace(req.getSpace());
        if (space == null) {
            return TraceRmi.ReplyDeleteRegisterValue.getDefaultInstance();
        }
        TraceMemorySpace ms = open.trace.getMemoryManager().getMemorySpace(space, false);
        if (ms == null) {
            return TraceRmi.ReplyDeleteRegisterValue.getDefaultInstance();
        }
        for (String name : req.getNamesList()) {
            Register register = open.getRegister(name, false);
            if (register == null) continue;
            ms.removeValue(snap, register);
        }
        return TraceRmi.ReplyDeleteRegisterValue.getDefaultInstance();
    }

    protected TraceRmi.ReplyDisassemble handleDisassemble(TraceRmi.RequestDisassemble req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        long snap = req.getSnap().getSnap();
        TraceMemoryManager memoryManager = open.trace.getMemoryManager();
        AddressSetView readOnly = memoryManager.getRegionsAddressSetWith(snap, r -> !r.isWrite());
        AddressSetView everKnown = memoryManager.getAddressesWithState(Lifespan.since((long)snap), s -> s == TraceMemoryState.KNOWN);
        IntersectionAddressSetView roEverKnown = new IntersectionAddressSetView(readOnly, everKnown);
        AddressSetView known = memoryManager.getAddressesWithState(snap, s -> s == TraceMemoryState.KNOWN);
        AddressSet disassemblable = new AddressSet((AddressSetView)new UnionAddressSetView(new AddressSetView[]{known, roEverKnown}));
        Address start = open.toAddress(req.getStart(), true);
        TracePlatform host = open.trace.getPlatformManager().getHostPlatform();
        TraceDisassembleCommand dis = new TraceDisassembleCommand(host, start, (AddressSetView)disassemblable);
        dis.setInitialContext(DebuggerDisassemblerPlugin.deriveAlternativeDefaultContext((Language)host.getLanguage(), (LanguageID)host.getLanguage().getLanguageID(), (Address)start));
        TaskMonitor monitor = this.plugin.getTaskMonitor();
        dis.applyToTyped(open.trace.getFixedProgramView(snap), monitor);
        return TraceRmi.ReplyDisassemble.newBuilder().setLength(dis.getDisassembledAddressSet().getNumAddresses()).build();
    }

    protected TraceRmi.ReplyEndTx handleEndTx(TraceRmi.RequestEndTx req) {
        OpenTx tx = this.openTxes.remove(new Tid(new DoId(req.getOid()), req.getTxid().getId()));
        if (tx == null) {
            throw new InvalidTxIdError(req.getTxid().getId());
        }
        if (req.getAbort()) {
            Msg.error((Object)this, (Object)"Back-end debugger aborted a transaction!");
            tx.tx.abortOnClose();
        }
        tx.tx.close();
        if (!tx.undoable) {
            this.requireOpenTrace((DoId)tx.txId.doId).trace.clearUndo();
        }
        return TraceRmi.ReplyEndTx.getDefaultInstance();
    }

    protected TraceRmi.ReplyGetObject handleGetObject(TraceRmi.RequestGetObject req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        TraceObject object = open.getObject(req.getObject(), true);
        return TraceRmi.ReplyGetObject.newBuilder().setObject(TraceRmiHandler.makeObjDesc(object)).build();
    }

    protected TraceRmi.ReplyGetValues handleGetValues(TraceRmi.RequestGetValues req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        return TraceRmi.ReplyGetValues.newBuilder().addAllValues(open.trace.getObjectManager().getValuePaths(TraceRmiHandler.toLifespan(req.getSpan()), (PathPredicates)TraceRmiHandler.toPathPattern(req.getPattern())).map(TraceRmiHandler::makeValDesc).toList()).build();
    }

    protected TraceRmi.ReplyGetValues handleGetValuesIntersecting(TraceRmi.RequestGetValuesIntersecting req) throws AddressOverflowException {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        AddressRange range = open.toRange(req.getBox().getRange(), false);
        List col = range == null ? List.of() : open.trace.getObjectManager().getValuesIntersecting(TraceRmiHandler.toLifespan(req.getBox().getSpan()), range);
        return TraceRmi.ReplyGetValues.newBuilder().addAllValues(col.stream().map(TraceRmiHandler::makeValDesc).toList()).build();
    }

    protected TraceRmi.ReplyInsertObject handleInsertObject(TraceRmi.RequestInsertObject req) {
        TraceObject obj = this.requireOpenTrace(req.getOid()).getObject(req.getObject(), true);
        TraceObjectValPath val = obj.insert(TraceRmiHandler.toLifespan(req.getSpan()), TraceRmiHandler.toResolution(req.getResolution()));
        Lifespan span = val.getEntryList().stream().map(TraceObjectValue::getLifespan).reduce((Lifespan)Lifespan.ALL, Span::intersect);
        return TraceRmi.ReplyInsertObject.newBuilder().setSpan(TraceRmiHandler.makeSpan(span)).build();
    }

    protected TraceRmi.ReplyNegotiate handleNegotiate(TraceRmi.RequestNegotiate req) {
        if (!VERSION.equals(req.getVersion())) {
            VersionMismatchError error = new VersionMismatchError(req.getVersion());
            this.negotiate.completeExceptionally(error);
            throw error;
        }
        for (TraceRmi.Method m : req.getMethodsList()) {
            RemoteMethod.RecordRemoteMethod rm = new RemoteMethod.RecordRemoteMethod(this, m.getName(), new RemoteMethod.Action(m.getAction()), m.getDescription(), m.getParametersList().stream().collect(Collectors.toMap(TraceRmi.MethodParameter::getName, TraceRmiHandler::makeParameter)), new TargetObjectSchema.SchemaName(m.getReturnType().getName()));
            this.methodRegistry.add(rm);
        }
        this.negotiate.complete(null);
        return TraceRmi.ReplyNegotiate.getDefaultInstance();
    }

    protected TraceRmi.ReplyPutBytes handlePutBytes(TraceRmi.RequestPutBytes req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        long snap = req.getSnap().getSnap();
        Address start = open.toAddress(req.getStart(), true);
        int written = open.trace.getMemoryManager().putBytes(snap, start, req.getData().asReadOnlyByteBuffer());
        return TraceRmi.ReplyPutBytes.newBuilder().setWritten(written).build();
    }

    protected TraceRmi.ReplyPutRegisterValue handlePutRegisterValue(TraceRmi.RequestPutRegisterValue req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        long snap = req.getSnap().getSnap();
        AddressSpace space = open.getSpace(req.getSpace(), true);
        TraceMemorySpace ms = open.trace.getMemoryManager().getMemorySpace(space, true);
        TraceRmi.ReplyPutRegisterValue.Builder rep = TraceRmi.ReplyPutRegisterValue.newBuilder();
        for (TraceRmi.RegVal rv : req.getValuesList()) {
            Register register = open.getRegister(rv.getName(), false);
            if (register == null) {
                Msg.warn((Object)this, (Object)("Ignoring unrecognized register: " + rv.getName()));
                rep.addSkippedNames(rv.getName());
                continue;
            }
            BigInteger value = new BigInteger(1, rv.getValue().toByteArray());
            ms.setValue(snap, new RegisterValue(register, value));
        }
        return TraceRmi.ReplyPutRegisterValue.getDefaultInstance();
    }

    protected static RemoteParameter makeParameter(TraceRmi.MethodParameter mp) {
        return new RemoteParameter(mp.getName(), new TargetObjectSchema.SchemaName(mp.getType().getName()), mp.getRequired(), ot -> ot.toValue(mp.getDefaultValue()), mp.getDisplay(), mp.getDescription());
    }

    protected TraceRmi.ReplyRemoveObject handleRemoveObject(TraceRmi.RequestRemoveObject req) {
        TraceObject object = this.requireOpenTrace(req.getOid()).getObject(req.getObject(), false);
        if (object == null) {
            return TraceRmi.ReplyRemoveObject.getDefaultInstance();
        }
        Lifespan lifespan = TraceRmiHandler.toLifespan(req.getSpan());
        if (req.getTree()) {
            object.removeTree(lifespan);
        } else {
            object.remove(lifespan);
        }
        return TraceRmi.ReplyRemoveObject.getDefaultInstance();
    }

    protected TraceRmi.ReplyRetainValues handleRetainValues(TraceRmi.RequestRetainValues req) {
        TraceObject object = this.requireOpenTrace(req.getOid()).getObject(req.getObject(), false);
        if (object == null) {
            return TraceRmi.ReplyRetainValues.getDefaultInstance();
        }
        Collection values = switch (req.getKinds()) {
            case TraceRmi.ValueKinds.VK_ELEMENTS -> object.getElements();
            case TraceRmi.ValueKinds.VK_ATTRIBUTES -> object.getAttributes();
            case TraceRmi.ValueKinds.VK_BOTH -> object.getValues();
            default -> throw new TraceRmiError("Protocol error: Invalid value kinds");
        };
        Lifespan span = TraceRmiHandler.toLifespan(req.getSpan());
        Set keysToKeep = Set.copyOf(req.getKeysList());
        List<String> keysToDelete = values.stream().filter(v -> v.getLifespan().intersects((Span)span)).map(v -> v.getEntryKey()).filter(k -> !keysToKeep.contains(k)).distinct().toList();
        for (String key : keysToDelete) {
            object.setValue(span, key, null, TraceObject.ConflictResolution.TRUNCATE);
        }
        return TraceRmi.ReplyRetainValues.getDefaultInstance();
    }

    protected TraceRmi.ReplySaveTrace handleSaveTrace(TraceRmi.RequestSaveTrace req) throws CancelledException, IOException {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        open.trace.save("TraceRMI", this.plugin.getTaskMonitor());
        return TraceRmi.ReplySaveTrace.getDefaultInstance();
    }

    protected TraceRmi.ReplySetMemoryState handleSetMemoryState(TraceRmi.RequestSetMemoryState req) throws AddressOverflowException {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        long snap = req.getSnap().getSnap();
        AddressRange range = open.toRange(req.getRange(), true);
        TraceMemoryState state = TraceRmiHandler.toMemoryState(req.getState());
        open.trace.getMemoryManager().setState(snap, range, state);
        return TraceRmi.ReplySetMemoryState.getDefaultInstance();
    }

    protected TraceRmi.ReplySetValue handleSetValue(TraceRmi.RequestSetValue req) throws AddressOverflowException {
        TraceRmi.ValSpec value = req.getValue();
        OpenTrace open = this.requireOpenTrace(req.getOid());
        Object objVal = open.toValue(value.getValue());
        TraceObject object = open.getObject(value.getParent(), objVal != null);
        if (object == null) {
            return TraceRmi.ReplySetValue.newBuilder().setSpan(TraceRmiHandler.makeSpan((Lifespan)Lifespan.EMPTY)).build();
        }
        TraceObjectValue val = object.setValue(TraceRmiHandler.toLifespan(value.getSpan()), value.getKey(), objVal, TraceRmiHandler.toResolution(req.getResolution()));
        return TraceRmi.ReplySetValue.newBuilder().setSpan(TraceRmiHandler.makeSpan((Lifespan)(val == null ? Lifespan.EMPTY : val.getLifespan()))).build();
    }

    protected TraceRmi.ReplySnapshot handleSnapshot(TraceRmi.RequestSnapshot req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        TraceSnapshot snapshot = open.createSnapshot(req.getSnap(), req.getDescription());
        if (!"".equals(req.getDatetime())) {
            Instant instant = DateTimeFormatter.ISO_INSTANT.parse(req.getDatetime()).query(Instant::from);
            snapshot.setRealTime(instant.toEpochMilli());
        }
        return TraceRmi.ReplySnapshot.getDefaultInstance();
    }

    protected TraceRmi.ReplyStartTx handleStartTx(TraceRmi.RequestStartTx req) {
        OpenTrace open = this.requireOpenTrace(req.getOid());
        Tid tid = this.requireAvailableTid(open, req.getTxid());
        OpenTx tx = new OpenTx(tid, open.trace.openTransaction(req.getDescription()), req.getUndoable());
        this.openTxes.put(tx.txId, tx);
        return TraceRmi.ReplyStartTx.getDefaultInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TraceRmi.RootMessage.Builder handleXInvokeMethod(TraceRmi.XReplyInvokeMethod xrep) {
        RemoteAsyncResult result;
        String error = xrep.getError();
        Deque<RemoteAsyncResult> deque = this.xReqQueue;
        synchronized (deque) {
            result = this.xReqQueue.poll();
        }
        if (error.isEmpty()) {
            try {
                result.complete(result.decoder.toValue(xrep.getReturnValue()));
            }
            catch (Throwable e) {
                result.completeExceptionally(e);
            }
        } else {
            result.completeExceptionally(new TraceRmiError(error));
        }
        return null;
    }

    public SocketAddress getRemoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public RemoteMethodRegistry getMethods() {
        return this.methodRegistry;
    }

    protected OpenTrace getOpenTrace(Trace trace) {
        if (trace == null) {
            return null;
        }
        OpenTrace open = this.openTraces.getByTrace(trace);
        if (open == null) {
            throw new NoSuchElementException();
        }
        return open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteAsyncResult invoke(OpenTrace open, String methodName, Map<String, Object> arguments) {
        RemoteAsyncResult result;
        TraceRmi.RootMessage.Builder req = TraceRmi.RootMessage.newBuilder();
        TraceRmi.XRequestInvokeMethod.Builder invoke = TraceRmi.XRequestInvokeMethod.newBuilder().setName(methodName).addAllArguments(arguments.entrySet().stream().map(TraceRmiHandler::makeArgument).toList());
        if (open != null) {
            result = new RemoteAsyncResult(open);
            invoke.setOid(open.doId.toDomObjId());
        } else {
            result = new RemoteAsyncResult();
        }
        req.setXrequestInvokeMethod(invoke);
        Deque<RemoteAsyncResult> deque = this.xReqQueue;
        synchronized (deque) {
            this.xReqQueue.offer(result);
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                try {
                    TraceRmiHandler.sendDelimited(this.out, req.build(), this.dbgSeq++);
                }
                catch (IOException e) {
                    throw new TraceRmiError("Could not send request", e);
                }
            }
            return result;
        }
    }

    @Internal
    public long getLastSnapshot(Trace trace) {
        TraceSnapshot lastSnapshot = this.openTraces.getByTrace((Trace)trace).lastSnapshot;
        if (lastSnapshot == null) {
            return 0L;
        }
        return lastSnapshot.getKey();
    }

    protected static class OpenTraceMap {
        private final Map<DoId, OpenTrace> byId = new HashMap<DoId, OpenTrace>();
        private final Map<Trace, OpenTrace> byTrace = new HashMap<Trace, OpenTrace>();

        protected OpenTraceMap() {
        }

        public synchronized boolean isEmpty() {
            return this.byId.isEmpty();
        }

        public synchronized Set<DoId> idSet() {
            return Set.copyOf(this.byId.keySet());
        }

        public synchronized OpenTrace removeById(DoId id) {
            OpenTrace removed = this.byId.remove(id);
            if (removed == null) {
                return null;
            }
            this.byTrace.remove(removed.trace);
            return removed;
        }

        public synchronized OpenTrace getById(DoId doId) {
            return this.byId.get(doId);
        }

        public synchronized OpenTrace getByTrace(Trace trace) {
            return this.byTrace.get(trace);
        }

        public synchronized void put(OpenTrace openTrace) {
            this.byId.put(openTrace.doId, openTrace);
            this.byTrace.put(openTrace.trace, openTrace);
        }
    }

    private static interface Dispatcher {
        public TraceRmi.RootMessage.Builder dispatch(TraceRmi.RootMessage var1, TraceRmi.RootMessage.Builder var2) throws Exception;

        default public TraceRmi.RootMessage handle(TraceRmi.RootMessage req) {
            String desc = this.toString(req);
            if (desc != null) {
                TimedMsg.debug((Object)this, (String)("HANDLING: " + desc));
            }
            TraceRmi.RootMessage.Builder rep = TraceRmi.RootMessage.newBuilder();
            try {
                rep = this.dispatch(req, rep);
                return rep == null ? null : rep.build();
            }
            catch (Throwable e) {
                return rep.setError(TraceRmi.ReplyError.newBuilder().setMessage(e.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)e))).build();
            }
        }

        default public String toString(TraceRmi.RootMessage req) {
            return switch (req.getMsgCase()) {
                case TraceRmi.RootMessage.MsgCase.REQUEST_ACTIVATE -> "activate(%d, %d, %s)".formatted(req.getRequestActivate().getOid().getId(), req.getRequestActivate().getObject().getId(), req.getRequestActivate().getObject().getPath().getPath());
                case TraceRmi.RootMessage.MsgCase.REQUEST_END_TX -> "endTx(%d)".formatted(req.getRequestEndTx().getTxid().getId());
                case TraceRmi.RootMessage.MsgCase.REQUEST_START_TX -> "startTx(%d)".formatted(req.getRequestStartTx().getTxid().getId());
                default -> null;
            };
        }
    }

    protected record Tid(DoId doId, int txId) {
    }

    protected record OpenTx(Tid txId, Transaction tx, boolean undoable) {
    }

    protected record DoId(int domObjId) {
        public DoId(TraceRmi.DomObjId oid) {
            this(oid.getId());
        }

        public TraceRmi.DomObjId toDomObjId() {
            return TraceRmi.DomObjId.newBuilder().setId(this.domObjId).build();
        }
    }

    protected static class InvalidDomObjIdError
    extends TraceRmiError {
        protected InvalidDomObjIdError() {
        }
    }

    protected static class DomObjIdInUseError
    extends TraceRmiError {
        protected DomObjIdInUseError() {
        }
    }

    protected static class TxIdInUseError
    extends TraceRmiError {
        protected TxIdInUseError() {
        }
    }

    protected static class InvalidSchemaError
    extends TraceRmiError {
        public InvalidSchemaError(Throwable cause) {
            super(cause);
        }
    }

    protected static class InvalidTxIdError
    extends TraceRmiError {
        public InvalidTxIdError(int id) {
            super("txid=" + id);
        }
    }

    protected static class VersionMismatchError
    extends TraceRmiError {
        public VersionMismatchError(String remote) {
            super("Mismatched versions: Front-end: %s, back-end: %s.".formatted(TraceRmiHandler.VERSION, remote));
        }
    }

    protected static class InvalidRequestError
    extends TraceRmiError {
        public InvalidRequestError(TraceRmi.RootMessage req) {
            super("Unrecognized or out-of-sequence request: " + req);
        }
    }

    protected static class InvalidRegisterError
    extends TraceRmiError {
        public InvalidRegisterError(String name) {
            super("Invalid register: " + name);
        }
    }

    protected static class NoSuchAddressSpaceError
    extends TraceRmiError {
        protected NoSuchAddressSpaceError() {
        }
    }

    protected static class InvalidObjPathError
    extends TraceRmiError {
        protected InvalidObjPathError() {
        }
    }

    protected static class InvalidObjIdError
    extends TraceRmiError {
        protected InvalidObjIdError() {
        }
    }
}

